/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jsf.model.jam;

import com.intellij.ide.presentation.Presentation;
import com.intellij.jam.JamElement;
import com.intellij.jam.JamPomTarget;
import com.intellij.jam.JamService;
import com.intellij.jam.JamStringAttributeElement;
import com.intellij.jam.annotations.JamPsiConnector;
import com.intellij.jam.annotations.JamPsiValidity;
import com.intellij.jam.reflect.JamAnnotationMeta;
import com.intellij.jam.reflect.JamAttributeMeta;
import com.intellij.jam.reflect.JamChildrenQuery;
import com.intellij.jam.reflect.JamClassMeta;
import com.intellij.jam.reflect.JamStringAttributeMeta;
import com.intellij.jsf.model.jam.JsfJamManagedProperty;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.pom.PomTarget;
import com.intellij.pom.references.PomService;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementRef;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiTarget;
import com.intellij.psi.targets.AliasingPsiTarget;
import com.intellij.psi.targets.AliasingPsiTargetUtil;
import com.intellij.semantic.SemKey;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Presentation(typeName="Managed Bean")
public abstract class JsfJamManagedBean
implements JamElement {
    public static final SemKey<JsfJamManagedBean> JAM_KEY = JamService.JAM_ALIASING_ELEMENT_KEY.subKey("JsfJamManagedBean", new SemKey[0]);
    public static final JamClassMeta<JsfJamManagedBean> META = new JamClassMeta(null, JsfJamManagedBean.class, JAM_KEY).addPomTargetProducer((managedBean, consumer) -> consumer.consume((Object)managedBean.getPsiTarget()));
    private final JamAnnotationMeta myMeta = new JamAnnotationMeta("javax.faces.bean.ManagedBean");
    public static final JamStringAttributeMeta.Single<String> NAME_VALUE_META = JamAttributeMeta.singleString((String)"name");
    private static final JamChildrenQuery<JsfJamManagedProperty> MANAGED_PROPERTIES_QUERY = JamChildrenQuery.annotatedFields((JamAnnotationMeta)JsfJamManagedProperty.META, JsfJamManagedProperty.class);
    protected final PsiClass myClass;

    public JsfJamManagedBean(PsiClass psiClass) {
        this.myClass = psiClass;
    }

    @NotNull
    public String getName() {
        String nameValue = this.getNamedStringAttributeElement().getStringValue();
        String string = StringUtil.isEmptyOrSpaces((String)nameValue) ? this.getDefaultName() : nameValue;
        if (string == null) {
            JsfJamManagedBean.$$$reportNull$$$0(0);
        }
        return string;
    }

    public List<JsfJamManagedProperty> getManagedProperties() {
        return MANAGED_PROPERTIES_QUERY.findChildren(PsiElementRef.real((PsiElement)this.getPsiElement()));
    }

    @NotNull
    private JamStringAttributeElement<String> getNamedStringAttributeElement() {
        JamStringAttributeElement jamStringAttributeElement = (JamStringAttributeElement)this.myMeta.getAttribute((PsiModifierListOwner)this.myClass, NAME_VALUE_META);
        if (jamStringAttributeElement == null) {
            JsfJamManagedBean.$$$reportNull$$$0(1);
        }
        return jamStringAttributeElement;
    }

    public String getDefaultName() {
        return JsfJamManagedBean.decapitalize(this.myClass.getName());
    }

    private static String decapitalize(String name) {
        if (name == null || name.length() == 0) {
            return name;
        }
        char[] chars = name.toCharArray();
        chars[0] = Character.toLowerCase(chars[0]);
        return new String(chars);
    }

    public PsiNamedElement getIdentifyingPsiElement() {
        return (PsiNamedElement)PomService.convertToPsi((Project)this.getProject(), (PomTarget)this.getPsiTarget());
    }

    private Project getProject() {
        return this.myClass.getProject();
    }

    public PsiTarget getPsiTarget() {
        JamStringAttributeElement<String> namedAttributeValue = this.getNamedStringAttributeElement();
        if (StringUtil.isEmptyOrSpaces((String)namedAttributeValue.getStringValue())) {
            return this.getAliasingPsiTarget();
        }
        return new JamPomTarget((JamElement)this, namedAttributeValue);
    }

    private PsiTarget getAliasingPsiTarget() {
        return new AliasingPsiTarget((PsiNamedElement)this.getPsiElement()){

            public String getNameAlias(@Nullable String delegatePsiTargetName) {
                return JsfJamManagedBean.decapitalize(delegatePsiTargetName);
            }

            @NotNull
            public AliasingPsiTarget setAliasName(@NotNull String newAliasName) {
                if (newAliasName == null) {
                    1.$$$reportNull$$$0(0);
                }
                AliasingPsiTargetUtil.renameTargets((AliasingPsiTarget)this, (String)StringUtil.capitalize((String)newAliasName));
                AliasingPsiTarget aliasingPsiTarget = super.setAliasName(newAliasName);
                if (aliasingPsiTarget == null) {
                    1.$$$reportNull$$$0(1);
                }
                return aliasingPsiTarget;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 1: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 1: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "newAliasName";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/jsf/model/jam/JsfJamManagedBean$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/jsf/model/jam/JsfJamManagedBean$1";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "setAliasName";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "setAliasName";
                        break;
                    }
                    case 1: {
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 1: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        };
    }

    @JamPsiConnector
    @NotNull
    public abstract PsiClass getPsiElement();

    @JamPsiValidity
    public abstract boolean isPsiValid();

    @Nullable
    public PsiAnnotation getAnnotation() {
        return this.myMeta.getAnnotation((PsiModifierListOwner)this.getPsiElement());
    }

    public PsiElementRef<PsiAnnotation> getAnnoRef() {
        return this.myMeta.getAnnotationRef((PsiModifierListOwner)this.getPsiElement());
    }

    static {
        META.addChildrenQuery(MANAGED_PROPERTIES_QUERY);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/jsf/model/jam/JsfJamManagedBean";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getNamedStringAttributeElement";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

