/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.ant.config.explorer;

import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.RunManager;
import com.intellij.execution.RunManagerListener;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.impl.RunDialog;
import com.intellij.icons.AllIcons;
import com.intellij.ide.CommonActionsManager;
import com.intellij.ide.DataManager;
import com.intellij.ide.TreeExpander;
import com.intellij.ide.dnd.FileCopyPasteUtil;
import com.intellij.lang.ant.AntBundle;
import com.intellij.lang.ant.config.AntBuildFile;
import com.intellij.lang.ant.config.AntBuildFileBase;
import com.intellij.lang.ant.config.AntBuildListener;
import com.intellij.lang.ant.config.AntBuildModel;
import com.intellij.lang.ant.config.AntBuildTarget;
import com.intellij.lang.ant.config.AntBuildTargetBase;
import com.intellij.lang.ant.config.AntConfiguration;
import com.intellij.lang.ant.config.AntConfigurationBase;
import com.intellij.lang.ant.config.AntNoFileException;
import com.intellij.lang.ant.config.ExecutionEvent;
import com.intellij.lang.ant.config.actions.AntBuildFilePropertiesAction;
import com.intellij.lang.ant.config.actions.RemoveBuildFileAction;
import com.intellij.lang.ant.config.execution.AntRunConfiguration;
import com.intellij.lang.ant.config.execution.AntRunConfigurationType;
import com.intellij.lang.ant.config.execution.ExecutionHandler;
import com.intellij.lang.ant.config.explorer.AntBuildFileNodeDescriptor;
import com.intellij.lang.ant.config.explorer.AntExecuteBeforeRunDialog;
import com.intellij.lang.ant.config.explorer.AntExplorerTreeBuilder;
import com.intellij.lang.ant.config.explorer.AntNodeDescriptor;
import com.intellij.lang.ant.config.explorer.AntTargetNodeDescriptor;
import com.intellij.lang.ant.config.explorer.SaveMetaTargetDialog;
import com.intellij.lang.ant.config.impl.ExecuteAfterCompilationEvent;
import com.intellij.lang.ant.config.impl.ExecuteBeforeCompilationEvent;
import com.intellij.lang.ant.config.impl.ExecuteCompositeTargetEvent;
import com.intellij.lang.ant.config.impl.MetaTarget;
import com.intellij.lang.ant.config.impl.configuration.BuildFilePropertiesPanel;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionPopupMenu;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.CommonShortcuts;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.keymap.Keymap;
import com.intellij.openapi.keymap.KeymapManagerListener;
import com.intellij.openapi.keymap.ex.KeymapManagerEx;
import com.intellij.openapi.keymap.impl.ui.EditKeymapsDialog;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.SimpleToolWindowPanel;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.ui.ColoredTreeCellRenderer;
import com.intellij.ui.PopupHandler;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.TreeSpeedSearch;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.util.ArrayUtil;
import com.intellij.util.EditSourceOnDoubleClickHandler;
import com.intellij.util.Function;
import com.intellij.util.IconUtil;
import com.intellij.util.StringBuilderSpinAllocator;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.tree.TreeUtil;
import com.intellij.util.xml.DomEventListener;
import com.intellij.util.xml.DomManager;
import com.intellij.util.xml.events.DomEvent;
import icons.AntIcons;
import java.awt.Component;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.ToolTipManager;
import javax.swing.TransferHandler;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AntExplorer
extends SimpleToolWindowPanel
implements DataProvider,
Disposable {
    private Project myProject;
    private AntExplorerTreeBuilder myBuilder;
    private Tree myTree;
    private KeymapListener myKeymapListener;
    private final AntBuildFilePropertiesAction myAntBuildFilePropertiesAction;
    private AntConfiguration myConfig;
    private final TreeExpander myTreeExpander;

    public AntExplorer(@NotNull Project project) {
        if (project == null) {
            AntExplorer.$$$reportNull$$$0(0);
        }
        super(true, true);
        this.myTreeExpander = new TreeExpander(){

            public void expandAll() {
                AntExplorer.this.myBuilder.expandAll();
            }

            public boolean canExpand() {
                AntConfiguration config = AntExplorer.this.myConfig;
                return config != null && !config.getBuildFileList().isEmpty();
            }

            public void collapseAll() {
                AntExplorer.this.myBuilder.collapseAll();
            }

            public boolean canCollapse() {
                return this.canExpand();
            }
        };
        this.setTransferHandler(new MyTransferHandler());
        this.myProject = project;
        this.myConfig = AntConfiguration.getInstance(project);
        DefaultTreeModel model = new DefaultTreeModel(new DefaultMutableTreeNode());
        this.myTree = new Tree((TreeModel)model);
        this.myTree.setRootVisible(false);
        this.myTree.setShowsRootHandles(true);
        this.myTree.setCellRenderer((TreeCellRenderer)((Object)new NodeRenderer()));
        this.myBuilder = new AntExplorerTreeBuilder(project, (JTree)this.myTree, model);
        this.myBuilder.setTargetsFiltered(AntConfigurationBase.getInstance(project).isFilterTargets());
        TreeUtil.installActions((JTree)this.myTree);
        new TreeSpeedSearch((JTree)this.myTree);
        this.myTree.addMouseListener((MouseListener)new PopupHandler(){

            public void invokePopup(Component comp, int x, int y) {
                AntExplorer.this.popupInvoked(comp, x, y);
            }
        });
        new EditSourceOnDoubleClickHandler.TreeMouseListener((JTree)this.myTree, null){

            protected void processDoubleClick(@NotNull MouseEvent e, @NotNull DataContext dataContext, @NotNull TreePath treePath) {
                if (e == null) {
                    3.$$$reportNull$$$0(0);
                }
                if (dataContext == null) {
                    3.$$$reportNull$$$0(1);
                }
                if (treePath == null) {
                    3.$$$reportNull$$$0(2);
                }
                AntExplorer.this.runSelection(DataManager.getInstance().getDataContext((Component)AntExplorer.this.myTree));
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "e";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "dataContext";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[0] = "treePath";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/lang/ant/config/explorer/AntExplorer$3";
                objectArray[2] = "processDoubleClick";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }.installOn((Component)this.myTree);
        this.myTree.registerKeyboardAction((ActionListener)new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AntExplorer.this.runSelection(DataManager.getInstance().getDataContext((Component)AntExplorer.this.myTree));
            }
        }, KeyStroke.getKeyStroke(10, 0), 0);
        this.myTree.setLineStyleAngled();
        this.myAntBuildFilePropertiesAction = new AntBuildFilePropertiesAction(this);
        this.setToolbar(this.createToolbarPanel());
        this.setContent(ScrollPaneFactory.createScrollPane((Component)this.myTree));
        ToolTipManager.sharedInstance().registerComponent((JComponent)this.myTree);
        this.myKeymapListener = new KeymapListener();
        DomManager.getDomManager((Project)project).addDomEventListener(new DomEventListener(){

            public void eventOccured(DomEvent event) {
                AntExplorer.this.myBuilder.queueUpdate();
            }
        }, (Disposable)this);
        project.getMessageBus().connect((Disposable)this).subscribe(RunManagerListener.TOPIC, (Object)new RunManagerListener(){

            public void beforeRunTasksChanged() {
                AntExplorer.this.myBuilder.queueUpdate();
            }
        });
    }

    public void dispose() {
        Tree tree;
        AntExplorerTreeBuilder builder;
        KeymapListener listener = this.myKeymapListener;
        if (listener != null) {
            this.myKeymapListener = null;
            listener.stopListen();
        }
        if ((builder = this.myBuilder) != null) {
            Disposer.dispose((Disposable)builder);
            this.myBuilder = null;
        }
        if ((tree = this.myTree) != null) {
            ToolTipManager.sharedInstance().unregisterComponent((JComponent)tree);
            for (KeyStroke keyStroke : tree.getRegisteredKeyStrokes()) {
                tree.unregisterKeyboardAction(keyStroke);
            }
            this.myTree = null;
        }
        this.myProject = null;
        this.myConfig = null;
    }

    private JPanel createToolbarPanel() {
        DefaultActionGroup group = new DefaultActionGroup();
        group.add((AnAction)new AddAction());
        group.add((AnAction)new RemoveAction());
        group.add((AnAction)new RunAction());
        group.add((AnAction)new ShowAllTargetsAction());
        AnAction action = CommonActionsManager.getInstance().createExpandAllAction(this.myTreeExpander, (JComponent)((Object)this));
        action.getTemplatePresentation().setDescription(AntBundle.message("ant.explorer.expand.all.nodes.action.description", new Object[0]));
        group.add(action);
        action = CommonActionsManager.getInstance().createCollapseAllAction(this.myTreeExpander, (JComponent)((Object)this));
        action.getTemplatePresentation().setDescription(AntBundle.message("ant.explorer.collapse.all.nodes.action.description", new Object[0]));
        group.add(action);
        group.add((AnAction)this.myAntBuildFilePropertiesAction);
        ActionToolbar actionToolBar = ActionManager.getInstance().createActionToolbar("AntExplorerToolbar", (ActionGroup)group, true);
        return JBUI.Panels.simplePanel((Component)actionToolBar.getComponent());
    }

    private void addBuildFile() {
        FileChooserDescriptor descriptor = AntExplorer.createXmlDescriptor();
        descriptor.setTitle(AntBundle.message("select.ant.build.file.dialog.title", new Object[0]));
        descriptor.setDescription(AntBundle.message("select.ant.build.file.dialog.description", new Object[0]));
        VirtualFile[] files = FileChooser.chooseFiles((FileChooserDescriptor)descriptor, (Project)this.myProject, null);
        this.addBuildFile(files);
    }

    private void addBuildFile(VirtualFile[] files) {
        if (files.length == 0) {
            return;
        }
        ApplicationManager.getApplication().invokeLater(() -> {
            AntConfiguration antConfiguration = this.myConfig;
            if (antConfiguration == null) {
                return;
            }
            ArrayList<VirtualFile> ignoredFiles = new ArrayList<VirtualFile>();
            for (VirtualFile file : files) {
                try {
                    antConfiguration.addBuildFile(file);
                }
                catch (AntNoFileException e) {
                    ignoredFiles.add(e.getFile());
                }
            }
            if (ignoredFiles.size() != 0) {
                String messageText;
                StringBuilder message = StringBuilderSpinAllocator.alloc();
                try {
                    String separator = "";
                    for (VirtualFile virtualFile : ignoredFiles) {
                        message.append(separator);
                        message.append(virtualFile.getPresentableUrl());
                        separator = "\n";
                    }
                    messageText = message.toString();
                }
                finally {
                    StringBuilderSpinAllocator.dispose((StringBuilder)message);
                }
                Messages.showWarningDialog((Project)this.myProject, (String)messageText, (String)AntBundle.message("cannot.add.ant.files.dialog.title", new Object[0]));
            }
        });
    }

    public void removeBuildFile() {
        AntBuildFileBase buildFile = this.getCurrentBuildFile();
        if (buildFile == null) {
            return;
        }
        String fileName = buildFile.getPresentableUrl();
        int result = Messages.showYesNoDialog((Project)this.myProject, (String)AntBundle.message("remove.the.reference.to.file.confirmation.text", fileName), (String)AntBundle.message("confirm.remove.dialog.title", new Object[0]), (Icon)Messages.getQuestionIcon());
        if (result != 0) {
            return;
        }
        this.myConfig.removeBuildFile(buildFile);
    }

    public void setBuildFileProperties() {
        AntBuildFileBase buildFile = this.getCurrentBuildFile();
        if (buildFile != null && BuildFilePropertiesPanel.editBuildFile(buildFile, this.myProject)) {
            this.myConfig.updateBuildFile(buildFile);
            this.myBuilder.queueUpdate();
            this.myTree.repaint();
        }
    }

    private void runSelection(DataContext dataContext) {
        if (!this.canRunSelection()) {
            return;
        }
        AntBuildFileBase buildFile = this.getCurrentBuildFile();
        if (buildFile != null) {
            TreePath[] paths = this.myTree.getSelectionPaths();
            String[] targets = AntExplorer.getTargetNamesFromPaths(paths);
            ExecutionHandler.runBuild(buildFile, targets, null, dataContext, Collections.emptyList(), AntBuildListener.NULL);
        }
    }

    private boolean canRunSelection() {
        if (this.myTree == null) {
            return false;
        }
        TreePath[] paths = this.myTree.getSelectionPaths();
        if (paths == null) {
            return false;
        }
        AntBuildFileBase buildFile = this.getCurrentBuildFile();
        if (buildFile == null || !buildFile.exists()) {
            return false;
        }
        for (TreePath path : paths) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)path.getLastPathComponent();
            Object userObject = node.getUserObject();
            AntBuildFileNodeDescriptor buildFileNodeDescriptor = userObject instanceof AntTargetNodeDescriptor ? (AntBuildFileNodeDescriptor)((Object)((DefaultMutableTreeNode)node.getParent()).getUserObject()) : (userObject instanceof AntBuildFileNodeDescriptor ? (AntBuildFileNodeDescriptor)((Object)userObject) : null);
            if (buildFileNodeDescriptor != null && buildFileNodeDescriptor.getBuildFile() == buildFile) continue;
            return false;
        }
        return true;
    }

    private static String[] getTargetNamesFromPaths(TreePath[] paths) {
        ArrayList<String> targets = new ArrayList<String>();
        for (TreePath path : paths) {
            Object userObject = ((DefaultMutableTreeNode)path.getLastPathComponent()).getUserObject();
            if (!(userObject instanceof AntTargetNodeDescriptor)) continue;
            AntBuildTargetBase target = ((AntTargetNodeDescriptor)((Object)userObject)).getTarget();
            if (target instanceof MetaTarget) {
                ContainerUtil.addAll(targets, (Object[])((MetaTarget)target).getTargetNames());
                continue;
            }
            targets.add(target.getName());
        }
        return ArrayUtil.toStringArray(targets);
    }

    private static AntBuildTarget[] getTargetObjectsFromPaths(TreePath[] paths) {
        return (AntBuildTarget[])Arrays.stream(paths).map(path -> ((DefaultMutableTreeNode)path.getLastPathComponent()).getUserObject()).filter(userObject -> userObject instanceof AntTargetNodeDescriptor).map(userObject -> ((AntTargetNodeDescriptor)((Object)((Object)userObject))).getTarget()).toArray(AntBuildTarget[]::new);
    }

    public boolean isBuildFileSelected() {
        if (this.myProject == null) {
            return false;
        }
        AntBuildFileBase file = this.getCurrentBuildFile();
        return file != null && file.exists();
    }

    @Nullable
    private AntBuildFileBase getCurrentBuildFile() {
        AntBuildFileNodeDescriptor descriptor = this.getCurrentBuildFileNodeDescriptor();
        return (AntBuildFileBase)(descriptor == null ? null : descriptor.getBuildFile());
    }

    @Nullable
    private AntBuildFileNodeDescriptor getCurrentBuildFileNodeDescriptor() {
        if (this.myTree == null) {
            return null;
        }
        TreePath path = this.myTree.getSelectionPath();
        if (path == null) {
            return null;
        }
        for (DefaultMutableTreeNode node = (DefaultMutableTreeNode)path.getLastPathComponent(); node != null; node = (DefaultMutableTreeNode)node.getParent()) {
            Object userObject = node.getUserObject();
            if (!(userObject instanceof AntBuildFileNodeDescriptor)) continue;
            return (AntBuildFileNodeDescriptor)((Object)userObject);
        }
        return null;
    }

    private void popupInvoked(Component comp, int x, int y) {
        DefaultMutableTreeNode node;
        Object userObject = null;
        TreePath path = this.myTree.getSelectionPath();
        if (path != null && (node = (DefaultMutableTreeNode)path.getLastPathComponent()) != null) {
            userObject = node.getUserObject();
        }
        DefaultActionGroup group = new DefaultActionGroup();
        group.add((AnAction)new RunAction());
        group.add((AnAction)new CreateMetaTargetAction());
        group.add((AnAction)new MakeAntRunConfigurationAction());
        group.add((AnAction)new RemoveMetaTargetsOrBuildFileAction());
        group.add(ActionManager.getInstance().getAction("EditSource"));
        if (userObject instanceof AntBuildFileNodeDescriptor) {
            group.add((AnAction)new RemoveBuildFileAction(this));
        }
        if (userObject instanceof AntTargetNodeDescriptor) {
            AntBuildTargetBase target = ((AntTargetNodeDescriptor)((Object)userObject)).getTarget();
            DefaultActionGroup executeOnGroup = new DefaultActionGroup(AntBundle.message("ant.explorer.execute.on.action.group.name", new Object[0]), true);
            executeOnGroup.add((AnAction)new ExecuteOnEventAction(target, ExecuteBeforeCompilationEvent.getInstance()));
            executeOnGroup.add((AnAction)new ExecuteOnEventAction(target, ExecuteAfterCompilationEvent.getInstance()));
            executeOnGroup.addSeparator();
            executeOnGroup.add((AnAction)new ExecuteBeforeRunAction(target));
            group.add((AnAction)executeOnGroup);
            group.add((AnAction)new AssignShortcutAction(target.getActionId()));
        }
        group.add((AnAction)this.myAntBuildFilePropertiesAction);
        ActionPopupMenu popupMenu = ActionManager.getInstance().createActionPopupMenu("AntExplorerPopup", (ActionGroup)group);
        popupMenu.getComponent().show(comp, x, y);
    }

    @Nullable
    public Object getData(@NonNls String dataId) {
        if (CommonDataKeys.NAVIGATABLE.is(dataId)) {
            VirtualFile descriptorFile;
            AntTargetNodeDescriptor targetNodeDescriptor;
            AntBuildTargetBase buildTarget;
            OpenFileDescriptor descriptor;
            AntBuildFileBase buildFile2 = this.getCurrentBuildFile();
            if (buildFile2 == null) {
                return null;
            }
            VirtualFile file = buildFile2.getVirtualFile();
            if (file == null) {
                return null;
            }
            TreePath treePath = this.myTree.getLeadSelectionPath();
            if (treePath == null) {
                return null;
            }
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)treePath.getLastPathComponent();
            if (node == null) {
                return null;
            }
            if (node.getUserObject() instanceof AntTargetNodeDescriptor && (descriptor = (buildTarget = (targetNodeDescriptor = (AntTargetNodeDescriptor)((Object)node.getUserObject())).getTarget()).getOpenFileDescriptor()) != null && (descriptorFile = descriptor.getFile()).isValid()) {
                return descriptor;
            }
            if (file.isValid()) {
                return new OpenFileDescriptor(this.myProject, file);
            }
        } else {
            if (PlatformDataKeys.HELP_ID.is(dataId)) {
                return "ant.antToolWindow";
            }
            if (PlatformDataKeys.TREE_EXPANDER.is(dataId)) {
                return this.myProject != null ? this.myTreeExpander : null;
            }
            if (CommonDataKeys.VIRTUAL_FILE_ARRAY.is(dataId)) {
                List<VirtualFile> virtualFiles = this.collectAntFiles(buildFile -> {
                    VirtualFile virtualFile = buildFile.getVirtualFile();
                    if (virtualFile != null && virtualFile.isValid()) {
                        return virtualFile;
                    }
                    return null;
                });
                return virtualFiles == null ? null : virtualFiles.toArray(VirtualFile.EMPTY_ARRAY);
            }
            if (LangDataKeys.PSI_ELEMENT_ARRAY.is(dataId)) {
                List<PsiElement> elements = this.collectAntFiles(AntBuildFile::getAntFile);
                return elements == null ? null : elements.toArray(PsiElement.EMPTY_ARRAY);
            }
        }
        return super.getData(dataId);
    }

    private <T> List<T> collectAntFiles(Function<AntBuildFile, T> function) {
        TreePath[] paths = this.myTree.getSelectionPaths();
        if (paths == null) {
            return null;
        }
        LinkedHashSet<AntBuildFile> antFiles = new LinkedHashSet<AntBuildFile>();
        block0: for (TreePath path : paths) {
            for (DefaultMutableTreeNode node = (DefaultMutableTreeNode)path.getLastPathComponent(); node != null; node = (DefaultMutableTreeNode)node.getParent()) {
                Object userObject = node.getUserObject();
                if (!(userObject instanceof AntBuildFileNodeDescriptor)) continue;
                AntBuildFile buildFile = ((AntBuildFileNodeDescriptor)((Object)userObject)).getBuildFile();
                if (buildFile == null) continue block0;
                antFiles.add(buildFile);
                continue block0;
            }
        }
        ArrayList result = new ArrayList();
        ContainerUtil.addAllNotNull(result, (Iterable)ContainerUtil.map(antFiles, function));
        return result.isEmpty() ? null : result;
    }

    public static FileChooserDescriptor createXmlDescriptor() {
        return new FileChooserDescriptor(true, false, false, false, false, true){

            public boolean isFileVisible(VirtualFile file, boolean showHiddenFiles) {
                boolean b = super.isFileVisible(file, showHiddenFiles);
                if (!file.isDirectory()) {
                    b &= StdFileTypes.XML.equals(file.getFileType());
                }
                return b;
            }
        };
    }

    private void setTargetsFiltered(boolean value) {
        this.myBuilder.setTargetsFiltered(value);
        AntConfigurationBase.getInstance(this.myProject).setFilterTargets(value);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/ant/config/explorer/AntExplorer", "<init>"));
    }

    private final class MyTransferHandler
    extends TransferHandler {
        private MyTransferHandler() {
        }

        @Override
        public boolean importData(TransferHandler.TransferSupport support) {
            if (this.canImport(support)) {
                AntExplorer.this.addBuildFile(this.getAntFiles(support));
                return true;
            }
            return false;
        }

        @Override
        public boolean canImport(TransferHandler.TransferSupport support) {
            return FileCopyPasteUtil.isFileListFlavorAvailable((DataFlavor[])support.getDataFlavors());
        }

        private VirtualFile[] getAntFiles(TransferHandler.TransferSupport support) {
            ArrayList virtualFileList = new ArrayList();
            List fileList = FileCopyPasteUtil.getFileList((Transferable)support.getTransferable());
            if (fileList != null) {
                for (File file : fileList) {
                    ContainerUtil.addIfNotNull(virtualFileList, (Object)VfsUtil.findFileByIoFile((File)file, (boolean)true));
                }
            }
            return VfsUtilCore.toVirtualFileArray(virtualFileList);
        }
    }

    private class KeymapListener
    implements KeymapManagerListener,
    Keymap.Listener {
        private Keymap myCurrentKeymap = null;

        public KeymapListener() {
            KeymapManagerEx keymapManager = KeymapManagerEx.getInstanceEx();
            Keymap activeKeymap = keymapManager.getActiveKeymap();
            this.listenTo(activeKeymap);
            keymapManager.addKeymapManagerListener((KeymapManagerListener)this, (Disposable)AntExplorer.this);
        }

        public void activeKeymapChanged(Keymap keymap) {
            this.listenTo(keymap);
            this.updateTree();
        }

        private void listenTo(Keymap keymap) {
            if (this.myCurrentKeymap != null) {
                this.myCurrentKeymap.removeShortcutChangeListener((Keymap.Listener)this);
            }
            this.myCurrentKeymap = keymap;
            if (this.myCurrentKeymap != null) {
                this.myCurrentKeymap.addShortcutChangeListener((Keymap.Listener)this);
            }
        }

        private void updateTree() {
            AntExplorer.this.myBuilder.updateFromRoot();
        }

        public void onShortcutChanged(String actionId) {
            this.updateTree();
        }

        public void stopListen() {
            this.listenTo(null);
        }
    }

    private final class AssignShortcutAction
    extends AnAction {
        private final String myActionId;

        public AssignShortcutAction(String actionId) {
            super(AntBundle.message("ant.explorer.assign.shortcut.action.name", new Object[0]));
            this.myActionId = actionId;
        }

        public void actionPerformed(AnActionEvent e) {
            new EditKeymapsDialog(AntExplorer.this.myProject, this.myActionId).show();
        }

        public void update(AnActionEvent e) {
            e.getPresentation().setEnabled(this.myActionId != null && ActionManager.getInstance().getAction(this.myActionId) != null);
        }
    }

    private final class RemoveMetaTargetsOrBuildFileAction
    extends AnAction {
        public RemoveMetaTargetsOrBuildFileAction() {
            super(AntBundle.message("remove.meta.targets.action.name", new Object[0]), AntBundle.message("remove.meta.targets.action.description", new Object[0]), null);
            this.registerCustomShortcutSet(CommonShortcuts.getDelete(), (JComponent)AntExplorer.this.myTree);
            Disposer.register((Disposable)AntExplorer.this, (Disposable)new Disposable(){

                public void dispose() {
                    RemoveMetaTargetsOrBuildFileAction.this.unregisterCustomShortcutSet((JComponent)AntExplorer.this.myTree);
                }
            });
            AntExplorer.this.myTree.registerKeyboardAction((ActionListener)new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    RemoveMetaTargetsOrBuildFileAction.this.doAction();
                }
            }, KeyStroke.getKeyStroke(127, 0), 1);
        }

        public void actionPerformed(AnActionEvent e) {
            this.doAction();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void doAction() {
            TreePath[] paths = AntExplorer.this.myTree.getSelectionPaths();
            if (paths == null) {
                return;
            }
            try {
                AntBuildFileNodeDescriptor descriptor;
                DefaultMutableTreeNode node;
                if (paths.length == 1 && (node = (DefaultMutableTreeNode)paths[0].getLastPathComponent()).getUserObject() instanceof AntBuildFileNodeDescriptor && (descriptor = (AntBuildFileNodeDescriptor)((Object)node.getUserObject())).getBuildFile().equals(AntExplorer.this.getCurrentBuildFile())) {
                    AntExplorer.this.removeBuildFile();
                    return;
                }
                AntBuildTarget[] targets = AntExplorer.getTargetObjectsFromPaths(paths);
                AntConfigurationBase antConfiguration = AntConfigurationBase.getInstance(AntExplorer.this.myProject);
                for (AntBuildTarget buildTarget : targets) {
                    if (!(buildTarget instanceof MetaTarget)) continue;
                    for (ExecutionEvent event : antConfiguration.getEventsForTarget(buildTarget)) {
                        if (!(event instanceof ExecuteCompositeTargetEvent)) continue;
                        antConfiguration.clearTargetForEvent(event);
                    }
                }
            }
            finally {
                AntExplorer.this.myBuilder.queueUpdate();
                AntExplorer.this.myTree.repaint();
            }
        }

        public void update(AnActionEvent e) {
            Presentation presentation = e.getPresentation();
            TreePath[] paths = AntExplorer.this.myTree.getSelectionPaths();
            if (paths == null) {
                presentation.setEnabled(false);
                return;
            }
            if (paths.length == 1) {
                AntTargetNodeDescriptor descr;
                AntBuildTargetBase target;
                String text = AntBundle.message("remove.meta.target.action.name", new Object[0]);
                boolean enabled = false;
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)paths[0].getLastPathComponent();
                if (node.getUserObject() instanceof AntBuildFileNodeDescriptor) {
                    AntBuildFileNodeDescriptor descriptor = (AntBuildFileNodeDescriptor)((Object)node.getUserObject());
                    if (descriptor.getBuildFile().equals(AntExplorer.this.getCurrentBuildFile())) {
                        text = AntBundle.message("remove.selected.build.file.action.name", new Object[0]);
                        enabled = true;
                    }
                } else if (node.getUserObject() instanceof AntTargetNodeDescriptor && (target = (descr = (AntTargetNodeDescriptor)((Object)node.getUserObject())).getTarget()) instanceof MetaTarget) {
                    enabled = true;
                }
                presentation.setText(text);
                presentation.setEnabled(enabled);
            } else {
                presentation.setText(AntBundle.message("remove.selected.meta.targets.action.name", new Object[0]));
                AntBuildTarget[] targets = AntExplorer.getTargetObjectsFromPaths(paths);
                boolean enabled = targets.length > 0;
                for (AntBuildTarget buildTarget : targets) {
                    if (buildTarget instanceof MetaTarget) continue;
                    enabled = false;
                    break;
                }
                presentation.setEnabled(enabled);
            }
        }
    }

    private final class CreateMetaTargetAction
    extends AnAction {
        public CreateMetaTargetAction() {
            super(AntBundle.message("ant.create.meta.target.action.name", new Object[0]), AntBundle.message("ant.create.meta.target.action.description", new Object[0]), null);
        }

        public void actionPerformed(AnActionEvent e) {
            AntBuildFileBase buildFile = AntExplorer.this.getCurrentBuildFile();
            String[] targets = AntExplorer.getTargetNamesFromPaths(AntExplorer.this.myTree.getSelectionPaths());
            ExecuteCompositeTargetEvent event = new ExecuteCompositeTargetEvent(targets);
            SaveMetaTargetDialog dialog = new SaveMetaTargetDialog((Component)AntExplorer.this.myTree, event, AntConfigurationBase.getInstance(AntExplorer.this.myProject), buildFile);
            dialog.setTitle(e.getPresentation().getText());
            if (dialog.showAndGet()) {
                AntExplorer.this.myBuilder.queueUpdate();
                AntExplorer.this.myTree.repaint();
            }
        }

        public void update(AnActionEvent e) {
            TreePath[] paths = AntExplorer.this.myTree.getSelectionPaths();
            e.getPresentation().setEnabled(paths != null && paths.length > 1 && AntExplorer.this.canRunSelection());
        }
    }

    private final class ExecuteBeforeRunAction
    extends AnAction {
        private final AntBuildTarget myTarget;

        public ExecuteBeforeRunAction(AntBuildTarget target) {
            super(AntBundle.message("executes.before.run.debug.acton.name", new Object[0]));
            this.myTarget = target;
        }

        public void actionPerformed(AnActionEvent e) {
            AntExecuteBeforeRunDialog dialog = new AntExecuteBeforeRunDialog(AntExplorer.this.myProject, this.myTarget);
            dialog.show();
        }

        public void update(AnActionEvent e) {
            e.getPresentation().setEnabled(this.myTarget.getModel().getBuildFile().exists());
        }
    }

    private final class ExecuteOnEventAction
    extends ToggleAction {
        private final AntBuildTargetBase myTarget;
        private final ExecutionEvent myExecutionEvent;

        public ExecuteOnEventAction(AntBuildTargetBase target, ExecutionEvent executionEvent) {
            super(executionEvent.getPresentableName());
            this.myTarget = target;
            this.myExecutionEvent = executionEvent;
        }

        public boolean isSelected(AnActionEvent e) {
            return this.myTarget.equals(AntConfigurationBase.getInstance(AntExplorer.this.myProject).getTargetForEvent(this.myExecutionEvent));
        }

        public void setSelected(AnActionEvent event, boolean state) {
            AntConfigurationBase antConfiguration = AntConfigurationBase.getInstance(AntExplorer.this.myProject);
            if (state) {
                AntBuildFileBase buildFile = (AntBuildFileBase)(this.myTarget instanceof MetaTarget ? ((MetaTarget)this.myTarget).getBuildFile() : this.myTarget.getModel().getBuildFile());
                antConfiguration.setTargetForEvent(buildFile, this.myTarget.getName(), this.myExecutionEvent);
            } else {
                antConfiguration.clearTargetForEvent(this.myExecutionEvent);
            }
            AntExplorer.this.myBuilder.queueUpdate();
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                ExecuteOnEventAction.$$$reportNull$$$0(0);
            }
            super.update(e);
            AntBuildFile buildFile = this.myTarget.getModel().getBuildFile();
            e.getPresentation().setEnabled(buildFile != null && buildFile.exists());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/lang/ant/config/explorer/AntExplorer$ExecuteOnEventAction", "update"));
        }
    }

    private final class ShowAllTargetsAction
    extends ToggleAction {
        public ShowAllTargetsAction() {
            super(AntBundle.message("filter.ant.targets.action.name", new Object[0]), AntBundle.message("filter.ant.targets.action.description", new Object[0]), AllIcons.General.Filter);
        }

        public boolean isSelected(AnActionEvent event) {
            Project project = AntExplorer.this.myProject;
            return project != null && AntConfigurationBase.getInstance(project).isFilterTargets();
        }

        public void setSelected(AnActionEvent event, boolean flag) {
            AntExplorer.this.setTargetsFiltered(flag);
        }
    }

    private final class MakeAntRunConfigurationAction
    extends AnAction {
        public MakeAntRunConfigurationAction() {
            super(AntBundle.message("make.ant.runconfiguration.name", new Object[0]), null, AntIcons.Build);
        }

        public void update(AnActionEvent e) {
            super.update(e);
            Presentation presentation = e.getPresentation();
            presentation.setEnabled(AntExplorer.this.myTree.getSelectionCount() == 1 && AntExplorer.this.canRunSelection());
        }

        public void actionPerformed(AnActionEvent e) {
            String name;
            AntBuildFileBase buildFile = AntExplorer.this.getCurrentBuildFile();
            if (buildFile == null || !buildFile.exists()) {
                return;
            }
            TreePath selectionPath = AntExplorer.this.myTree.getSelectionPath();
            if (selectionPath == null) {
                return;
            }
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)selectionPath.getLastPathComponent();
            Object userObject = node.getUserObject();
            AntBuildTarget target = null;
            if (userObject instanceof AntTargetNodeDescriptor) {
                AntTargetNodeDescriptor targetNodeDescriptor = (AntTargetNodeDescriptor)((Object)userObject);
                target = targetNodeDescriptor.getTarget();
            } else if (userObject instanceof AntBuildFileNodeDescriptor) {
                AntBuildModel model = ((AntBuildFileNodeDescriptor)((Object)userObject)).getBuildFile().getModel();
                target = model.findTarget(model.getDefaultTargetName());
            }
            String string = name = target != null ? target.getDisplayName() : null;
            if (target == null || name == null) {
                return;
            }
            RunManager runManager = RunManager.getInstance((Project)AntExplorer.this.myProject);
            RunnerAndConfigurationSettings settings = runManager.createRunConfiguration(name, AntRunConfigurationType.getInstance().getFactory());
            AntRunConfiguration configuration = (AntRunConfiguration)settings.getConfiguration();
            configuration.acceptSettings(target);
            if (RunDialog.editConfiguration((Project)e.getProject(), (RunnerAndConfigurationSettings)settings, (String)ExecutionBundle.message((String)"create.run.configuration.for.item.dialog.title", (Object[])new Object[]{configuration.getName()}))) {
                runManager.addConfiguration(settings);
                runManager.setSelectedConfiguration(settings);
            }
        }
    }

    private final class RunAction
    extends AnAction {
        public RunAction() {
            super(AntBundle.message("run.ant.file.or.target.action.name", new Object[0]), AntBundle.message("run.ant.file.or.target.action.description", new Object[0]), AllIcons.Actions.Execute);
        }

        public void actionPerformed(AnActionEvent e) {
            AntExplorer.this.runSelection(e.getDataContext());
        }

        public void update(AnActionEvent event) {
            Presentation presentation = event.getPresentation();
            String place = event.getPlace();
            if ("AntExplorerToolbar".equals(place)) {
                presentation.setText(AntBundle.message("run.ant.file.or.target.action.name", new Object[0]));
            } else {
                TreePath[] paths = AntExplorer.this.myTree.getSelectionPaths();
                if (paths != null && paths.length == 1 && ((DefaultMutableTreeNode)paths[0].getLastPathComponent()).getUserObject() instanceof AntBuildFileNodeDescriptor) {
                    presentation.setText(AntBundle.message("run.ant.build.action.name", new Object[0]));
                } else if (paths == null || paths.length == 1) {
                    presentation.setText(AntBundle.message("run.ant.target.action.name", new Object[0]));
                } else {
                    presentation.setText(AntBundle.message("run.ant.targets.action.name", new Object[0]));
                }
            }
            presentation.setEnabled(AntExplorer.this.canRunSelection());
        }
    }

    private final class RemoveAction
    extends AnAction {
        public RemoveAction() {
            super(AntBundle.message("remove.ant.file.action.name", new Object[0]), AntBundle.message("remove.ant.file.action.description", new Object[0]), IconUtil.getRemoveIcon());
        }

        public void actionPerformed(AnActionEvent e) {
            AntExplorer.this.removeBuildFile();
        }

        public void update(AnActionEvent event) {
            event.getPresentation().setEnabled(AntExplorer.this.getCurrentBuildFile() != null);
        }
    }

    private final class AddAction
    extends AnAction {
        public AddAction() {
            super(AntBundle.message("add.ant.file.action.name", new Object[0]), AntBundle.message("add.ant.file.action.description", new Object[0]), IconUtil.getAddIcon());
        }

        public void actionPerformed(AnActionEvent e) {
            AntExplorer.this.addBuildFile();
        }
    }

    private static final class NodeRenderer
    extends ColoredTreeCellRenderer {
        private NodeRenderer() {
        }

        public void customizeCellRenderer(@NotNull JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            Object userObject;
            if (tree == null) {
                NodeRenderer.$$$reportNull$$$0(0);
            }
            if ((userObject = ((DefaultMutableTreeNode)value).getUserObject()) instanceof AntNodeDescriptor) {
                AntNodeDescriptor descriptor = (AntNodeDescriptor)((Object)userObject);
                descriptor.customize((SimpleColoredComponent)this);
            } else {
                this.append(tree.convertValueToText(value, selected, expanded, leaf, row, hasFocus), SimpleTextAttributes.REGULAR_ATTRIBUTES);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tree", "com/intellij/lang/ant/config/explorer/AntExplorer$NodeRenderer", "customizeCellRenderer"));
        }
    }
}

