/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.integration.diagram;

import com.intellij.diagram.DiagramBuilder;
import com.intellij.diagram.DiagramNode;
import com.intellij.diagram.actions.DiagramAddElementAction;
import com.intellij.diagram.extras.providers.DiagramDnDProvider;
import com.intellij.diagram.presentation.DiagramState;
import com.intellij.openapi.graph.GraphManager;
import com.intellij.openapi.graph.layout.LayoutOrientation;
import com.intellij.openapi.graph.layout.Layouter;
import com.intellij.openapi.graph.layout.NodeLabelModel;
import com.intellij.openapi.graph.layout.hierarchic.IncrementalHierarchicLayouter;
import com.intellij.openapi.graph.settings.GraphSettings;
import com.intellij.openapi.graph.view.NodeLabel;
import com.intellij.openapi.graph.view.NodeRealizer;
import com.intellij.openapi.graph.view.SmartNodeLabelModel;
import com.intellij.openapi.project.Project;
import com.intellij.spring.integration.diagram.SpringIntegrationDiagramNodeContentManager;
import com.intellij.spring.model.SpringBeanPointer;
import com.intellij.spring.perspectives.diagrams.SpringDiagramExtras;
import com.intellij.spring.perspectives.diagrams.beans.SpringElementWrapper;
import com.intellij.ui.JBColor;
import java.awt.Point;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;

public class SpringIntegrationDiagramExtras
extends SpringDiagramExtras {
    public Layouter getCustomLayouter(GraphSettings settings, Project project) {
        IncrementalHierarchicLayouter layouter = GraphManager.getGraphManager().createIncrementalHierarchicLayouter();
        layouter.setConsiderNodeLabelsEnabled(true);
        layouter.setIntegratedEdgeLabelingEnabled(true);
        layouter.setOrthogonallyRouted(false);
        layouter.setEdgeToEdgeDistance(30.0);
        layouter.setBackloopRoutingEnabled(false);
        layouter.setLayoutOrientation(LayoutOrientation.LEFT_TO_RIGHT);
        return layouter;
    }

    @NotNull
    public JComponent createNodeComponent(DiagramNode<SpringElementWrapper> node, DiagramBuilder builder, Point basePoint, JPanel wrapper) {
        JComponent component = super.createNodeComponent(node, builder, basePoint, wrapper);
        NodeRealizer realizer = builder.getGraph().getRealizer(builder.getNode(node));
        Object wrapped = ((SpringElementWrapper)node.getIdentifyingElement()).getWrapped();
        if (wrapped instanceof SpringBeanPointer && SpringIntegrationDiagramExtras.isShowLabels(builder)) {
            String name = ((SpringBeanPointer)wrapped).getName();
            if (name != null) {
                NodeLabel label = GraphManager.getGraphManager().createNodeLabel();
                SmartNodeLabelModel labelModel = GraphManager.getGraphManager().createSmartNodeLabelModel();
                label.setLabelModel((NodeLabelModel)labelModel, labelModel.createDiscreteModelParameter(SmartNodeLabelModel.POSITION_SOUTH));
                label.setText(name);
                label.setTextColor(JBColor.foreground());
                realizer.setLabel(label);
            }
        } else if (realizer.labelCount() > 0) {
            realizer.removeLabel(0);
        }
        JComponent jComponent = component;
        if (jComponent == null) {
            SpringIntegrationDiagramExtras.$$$reportNull$$$0(0);
        }
        return jComponent;
    }

    private static boolean isShowLabels(DiagramBuilder builder) {
        DiagramState diagramState = builder.getPresentation();
        return diagramState.isCategoryEnabled(SpringIntegrationDiagramNodeContentManager.SHOW_LABELS);
    }

    public DiagramAddElementAction getAddElementHandler() {
        return null;
    }

    public DiagramDnDProvider<SpringElementWrapper> getDnDProvider() {
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/integration/diagram/SpringIntegrationDiagramExtras", "createNodeComponent"));
    }
}

