/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.annotator.intentions.elements;

import com.intellij.codeInsight.CodeInsightUtilCore;
import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInsight.daemon.impl.quickfix.CreateFromUsageBaseFix;
import com.intellij.codeInsight.daemon.impl.quickfix.EmptyExpression;
import com.intellij.codeInsight.template.Expression;
import com.intellij.codeInsight.template.Template;
import com.intellij.codeInsight.template.TemplateBuilderImpl;
import com.intellij.lang.jvm.actions.CreateEnumConstantActionGroup;
import com.intellij.lang.jvm.actions.CreateFieldRequest;
import com.intellij.lang.jvm.actions.JvmActionGroup;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.annotator.intentions.elements.CreateEnumConstantActionKt;
import org.jetbrains.plugins.groovy.annotator.intentions.elements.CreateFieldActionBase;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrArgumentList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinition;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrEnumConstant;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\t\u001a\u00020\nH\u0016J\b\u0010\u000b\u001a\u00020\fH\u0016J%\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u0096\u0002R\u0014\u0010\u0004\u001a\u00020\u0005X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/plugins/groovy/annotator/intentions/elements/CreateEnumConstantAction;", "Lorg/jetbrains/plugins/groovy/annotator/intentions/elements/CreateFieldActionBase;", "target", "Lorg/jetbrains/plugins/groovy/lang/psi/api/statements/typedef/GrTypeDefinition;", "request", "Lcom/intellij/lang/jvm/actions/CreateFieldRequest;", "(Lorg/jetbrains/plugins/groovy/lang/psi/api/statements/typedef/GrTypeDefinition;Lcom/intellij/lang/jvm/actions/CreateFieldRequest;)V", "getRequest", "()Lcom/intellij/lang/jvm/actions/CreateFieldRequest;", "getActionGroup", "Lcom/intellij/lang/jvm/actions/JvmActionGroup;", "getText", "", "invoke", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "file", "Lcom/intellij/psi/PsiFile;", "intellij.groovy"})
public final class CreateEnumConstantAction
extends CreateFieldActionBase {
    @NotNull
    private final CreateFieldRequest request;

    @NotNull
    public JvmActionGroup getActionGroup() {
        return (JvmActionGroup)CreateEnumConstantActionGroup.INSTANCE;
    }

    @NotNull
    public String getText() {
        String string = QuickFixBundle.message((String)"create.enum.constant.from.usage.text", (Object[])new Object[]{this.getRequest().getFieldName()});
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"QuickFixBundle.message(\"\u2026text\", request.fieldName)");
        return string;
    }

    public void invoke(@NotNull Project project, @Nullable Editor editor, @Nullable PsiFile file) {
        GrArgumentList argumentList;
        String text;
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        String name = this.getRequest().getFieldName();
        GrTypeDefinition targetClass = this.getTarget();
        String parameters = CreateEnumConstantActionKt.renderParameters(targetClass);
        CharSequence charSequence = parameters;
        String string = text = charSequence.length() == 0 ? name : "" + name + '(' + parameters + ')';
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"text");
        GrEnumConstant enumConstant = CreateEnumConstantActionKt.renderConstant(project, string);
        PsiElement psiElement = targetClass.add(enumConstant);
        if (psiElement == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrEnumConstant");
        }
        enumConstant = (GrEnumConstant)psiElement;
        CharSequence charSequence2 = parameters;
        if (charSequence2.length() == 0) {
            return;
        }
        TemplateBuilderImpl builder = new TemplateBuilderImpl((PsiElement)enumConstant);
        GrArgumentList grArgumentList = enumConstant.getArgumentList();
        if (grArgumentList == null) {
            Intrinsics.throwNpe();
        }
        GrArgumentList grArgumentList2 = argumentList = grArgumentList;
        Intrinsics.checkExpressionValueIsNotNull((Object)grArgumentList2, (String)"argumentList");
        for (GrExpression expression : grArgumentList2.getExpressionArguments()) {
            builder.replaceElement((PsiElement)expression, (Expression)new EmptyExpression());
        }
        PsiElement psiElement2 = CodeInsightUtilCore.forcePsiPostprocessAndRestoreElement((PsiElement)enumConstant);
        Intrinsics.checkExpressionValueIsNotNull((Object)psiElement2, (String)"forcePsiPostprocessAndRestoreElement(enumConstant)");
        enumConstant = (GrEnumConstant)psiElement2;
        Template template = builder.buildTemplate();
        Editor editor2 = CreateFromUsageBaseFix.positionCursor((Project)project, (PsiFile)targetClass.getContainingFile(), (PsiElement)enumConstant);
        if (editor2 == null) {
            return;
        }
        Editor newEditor = editor2;
        TextRange range = enumConstant.getTextRange();
        Editor editor3 = newEditor;
        Intrinsics.checkExpressionValueIsNotNull((Object)editor3, (String)"newEditor");
        Document document = editor3.getDocument();
        TextRange textRange = range;
        Intrinsics.checkExpressionValueIsNotNull((Object)textRange, (String)"range");
        document.deleteString(textRange.getStartOffset(), range.getEndOffset());
        CreateFromUsageBaseFix.startTemplate((Editor)newEditor, (Template)template, (Project)project);
    }

    @Override
    @NotNull
    protected CreateFieldRequest getRequest() {
        return this.request;
    }

    public CreateEnumConstantAction(@NotNull GrTypeDefinition target, @NotNull CreateFieldRequest request) {
        Intrinsics.checkParameterIsNotNull((Object)target, (String)"target");
        Intrinsics.checkParameterIsNotNull((Object)request, (String)"request");
        super(target, request);
        this.request = request;
    }
}

