/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.editor;

import com.intellij.codeInsight.editorActions.StringLiteralCopyPasteProcessor;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RawText;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.LineTokenizer;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.tree.IElementType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;
import org.jetbrains.plugins.groovy.lang.lexer.TokenSets;
import org.jetbrains.plugins.groovy.lang.parser.GroovyElementTypes;
import org.jetbrains.plugins.groovy.lang.psi.util.GrStringUtil;
import org.jetbrains.plugins.groovy.lang.resolve.GroovyStringLiteralManipulator;

public class GroovyLiteralCopyPasteProcessor
extends StringLiteralCopyPasteProcessor {
    private static final Logger LOG = Logger.getInstance(GroovyLiteralCopyPasteProcessor.class);

    protected boolean isCharLiteral(@NotNull PsiElement token) {
        if (token == null) {
            GroovyLiteralCopyPasteProcessor.$$$reportNull$$$0(0);
        }
        return false;
    }

    protected boolean isStringLiteral(@NotNull PsiElement token) {
        ASTNode node;
        if (token == null) {
            GroovyLiteralCopyPasteProcessor.$$$reportNull$$$0(1);
        }
        return (node = token.getNode()) != null && (TokenSets.STRING_LITERALS.contains(node.getElementType()) || node.getElementType() == GroovyElementTypes.GSTRING_INJECTION || node.getElementType() == GroovyElementTypes.GSTRING_CONTENT);
    }

    @Nullable
    protected TextRange getEscapedRange(@NotNull PsiElement token) {
        ASTNode node;
        if (token == null) {
            GroovyLiteralCopyPasteProcessor.$$$reportNull$$$0(2);
        }
        if ((node = token.getNode()) == null) {
            return null;
        }
        IElementType tokenType = node.getElementType();
        if (tokenType == GroovyTokenTypes.mSTRING_LITERAL || tokenType == GroovyTokenTypes.mGSTRING_LITERAL) {
            String text = token.getText();
            if (text == null) {
                return null;
            }
            return GroovyStringLiteralManipulator.getLiteralRange(text);
        }
        if (tokenType == GroovyTokenTypes.mREGEX_CONTENT) {
            return token.getTextRange();
        }
        return null;
    }

    @Nullable
    protected PsiElement findLiteralTokenType(PsiFile file, int selectionStart, int selectionEnd) {
        PsiElement elementAtSelectionStart = file.findElementAt(selectionStart);
        if (elementAtSelectionStart == null) {
            return null;
        }
        IElementType elementType = elementAtSelectionStart.getNode().getElementType();
        if ((elementType == GroovyTokenTypes.mREGEX_END || elementType == GroovyTokenTypes.mDOLLAR_SLASH_REGEX_END || elementType == GroovyTokenTypes.mGSTRING_END) && elementAtSelectionStart.getTextOffset() == selectionStart) {
            if ((elementAtSelectionStart = elementAtSelectionStart.getPrevSibling()) == null) {
                return null;
            }
            elementType = elementAtSelectionStart.getNode().getElementType();
        }
        if (elementType == GroovyTokenTypes.mDOLLAR) {
            elementAtSelectionStart = elementAtSelectionStart.getParent();
            elementType = elementAtSelectionStart.getNode().getElementType();
        }
        if (!this.isStringLiteral(elementAtSelectionStart)) {
            return null;
        }
        if (elementAtSelectionStart.getTextRange().getEndOffset() < selectionEnd) {
            PsiElement elementAtSelectionEnd = file.findElementAt(selectionEnd);
            if (elementAtSelectionEnd == null) {
                return null;
            }
            if (elementAtSelectionEnd.getNode().getElementType() == elementType && elementAtSelectionEnd.getTextRange().getStartOffset() < selectionEnd) {
                return elementAtSelectionStart;
            }
        }
        TextRange textRange = elementAtSelectionStart.getTextRange();
        if (elementType == GroovyTokenTypes.mREGEX_CONTENT || elementType == GroovyTokenTypes.mGSTRING_CONTENT || elementType == GroovyTokenTypes.mDOLLAR_SLASH_REGEX_CONTENT || elementType == GroovyElementTypes.GSTRING_INJECTION) {
            ++selectionStart;
            --selectionEnd;
        }
        if (textRange.getLength() > 0 && (selectionStart <= textRange.getStartOffset() || selectionEnd >= textRange.getEndOffset())) {
            return null;
        }
        if (elementType == GroovyElementTypes.GSTRING_CONTENT) {
            elementAtSelectionStart = elementAtSelectionStart.getFirstChild();
        }
        return elementAtSelectionStart;
    }

    protected String getLineBreaker(@NotNull PsiElement token) {
        PsiElement parent;
        String text;
        if (token == null) {
            GroovyLiteralCopyPasteProcessor.$$$reportNull$$$0(3);
        }
        if ((text = (parent = GrStringUtil.findContainingLiteral(token)).getText()).contains("'''") || text.contains("\"\"\"")) {
            return "\n";
        }
        IElementType type = token.getNode().getElementType();
        if (type == GroovyTokenTypes.mGSTRING_LITERAL || type == GroovyTokenTypes.mGSTRING_CONTENT) {
            return super.getLineBreaker(token);
        }
        if (type == GroovyTokenTypes.mSTRING_LITERAL) {
            return super.getLineBreaker(token).replace('\"', '\'');
        }
        return "\n";
    }

    @NotNull
    public String preprocessOnPaste(Project project, PsiFile file, Editor editor, String text, RawText rawText) {
        Document document = editor.getDocument();
        PsiDocumentManager.getInstance((Project)project).commitDocument(document);
        SelectionModel selectionModel = editor.getSelectionModel();
        int selectionStart = selectionModel.getSelectionStart();
        int selectionEnd = selectionModel.getSelectionEnd();
        PsiElement token = this.findLiteralTokenType(file, selectionStart, selectionEnd);
        if (token == null) {
            String string = text;
            if (string == null) {
                GroovyLiteralCopyPasteProcessor.$$$reportNull$$$0(4);
            }
            return string;
        }
        if (this.isStringLiteral(token)) {
            StringBuilder buffer = new StringBuilder(text.length());
            String breaker = this.getLineBreaker(token);
            String[] lines = LineTokenizer.tokenize((char[])text.toCharArray(), (boolean)false, (boolean)true);
            for (int i = 0; i < lines.length; ++i) {
                buffer.append(this.escapeCharCharacters(lines[i], token));
                if (i == lines.length - 1 && (!"\n".equals(breaker) || !text.endsWith("\n"))) continue;
                buffer.append(breaker);
            }
            text = buffer.toString();
        }
        String string = text;
        if (string == null) {
            GroovyLiteralCopyPasteProcessor.$$$reportNull$$$0(5);
        }
        return string;
    }

    @NotNull
    protected String escapeCharCharacters(@NotNull String s, @NotNull PsiElement token) {
        if (s == null) {
            GroovyLiteralCopyPasteProcessor.$$$reportNull$$$0(6);
        }
        if (token == null) {
            GroovyLiteralCopyPasteProcessor.$$$reportNull$$$0(7);
        }
        if (s.isEmpty()) {
            String string = s;
            if (string == null) {
                GroovyLiteralCopyPasteProcessor.$$$reportNull$$$0(8);
            }
            return string;
        }
        IElementType tokenType = token.getNode().getElementType();
        if (tokenType == GroovyTokenTypes.mREGEX_CONTENT || tokenType == GroovyTokenTypes.mREGEX_LITERAL) {
            String string = GrStringUtil.escapeSymbolsForSlashyStrings(s);
            if (string == null) {
                GroovyLiteralCopyPasteProcessor.$$$reportNull$$$0(9);
            }
            return string;
        }
        if (tokenType == GroovyTokenTypes.mDOLLAR_SLASH_REGEX_CONTENT || tokenType == GroovyTokenTypes.mDOLLAR_SLASH_REGEX_LITERAL) {
            String string = GrStringUtil.escapeSymbolsForDollarSlashyStrings(s);
            if (string == null) {
                GroovyLiteralCopyPasteProcessor.$$$reportNull$$$0(10);
            }
            return string;
        }
        if (tokenType == GroovyTokenTypes.mGSTRING_CONTENT || tokenType == GroovyTokenTypes.mGSTRING_LITERAL || tokenType == GroovyElementTypes.GSTRING_INJECTION) {
            boolean singleLine = !GrStringUtil.findContainingLiteral(token).getText().contains("\"\"\"");
            StringBuilder b = new StringBuilder();
            GrStringUtil.escapeStringCharacters(s.length(), s, singleLine ? "\"" : "", singleLine, true, b);
            GrStringUtil.unescapeCharacters(b, singleLine ? "'" : "'\"", true);
            LOG.assertTrue(b.length() > 0, (Object)("s=" + s));
            for (int i = b.length() - 2; i >= 0; --i) {
                char next;
                if (b.charAt(i) != '$' || (next = b.charAt(i + 1)) == '{' || Character.isLetter(next)) continue;
                b.insert(i, '\\');
            }
            if (b.charAt(b.length() - 1) == '$') {
                b.insert(b.length() - 1, '\\');
            }
            String string = b.toString();
            if (string == null) {
                GroovyLiteralCopyPasteProcessor.$$$reportNull$$$0(11);
            }
            return string;
        }
        if (tokenType == GroovyTokenTypes.mSTRING_LITERAL) {
            String string = GrStringUtil.escapeSymbolsForString(s, !token.getText().contains("'''"), false);
            if (string == null) {
                GroovyLiteralCopyPasteProcessor.$$$reportNull$$$0(12);
            }
            return string;
        }
        String string = super.escapeCharCharacters(s, token);
        if (string == null) {
            GroovyLiteralCopyPasteProcessor.$$$reportNull$$$0(13);
        }
        return string;
    }

    @NotNull
    protected String unescape(String s, PsiElement token) {
        IElementType tokenType = token.getNode().getElementType();
        if (tokenType == GroovyTokenTypes.mREGEX_CONTENT || tokenType == GroovyTokenTypes.mREGEX_LITERAL) {
            String string = GrStringUtil.unescapeSlashyString(s);
            if (string == null) {
                GroovyLiteralCopyPasteProcessor.$$$reportNull$$$0(14);
            }
            return string;
        }
        if (tokenType == GroovyTokenTypes.mDOLLAR_SLASH_REGEX_CONTENT || tokenType == GroovyTokenTypes.mDOLLAR_SLASH_REGEX_LITERAL) {
            String string = GrStringUtil.unescapeDollarSlashyString(s);
            if (string == null) {
                GroovyLiteralCopyPasteProcessor.$$$reportNull$$$0(15);
            }
            return string;
        }
        if (tokenType == GroovyTokenTypes.mGSTRING_CONTENT || tokenType == GroovyTokenTypes.mGSTRING_LITERAL) {
            String string = GrStringUtil.unescapeString(s);
            if (string == null) {
                GroovyLiteralCopyPasteProcessor.$$$reportNull$$$0(16);
            }
            return string;
        }
        if (tokenType == GroovyTokenTypes.mSTRING_LITERAL) {
            String string = GrStringUtil.unescapeString(s);
            if (string == null) {
                GroovyLiteralCopyPasteProcessor.$$$reportNull$$$0(17);
            }
            return string;
        }
        String string = super.unescape(s, token);
        if (string == null) {
            GroovyLiteralCopyPasteProcessor.$$$reportNull$$$0(18);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "token";
                break;
            }
            case 4: 
            case 5: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/groovy/editor/GroovyLiteralCopyPasteProcessor";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/groovy/editor/GroovyLiteralCopyPasteProcessor";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "preprocessOnPaste";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "escapeCharCharacters";
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "unescape";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isCharLiteral";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isStringLiteral";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getEscapedRange";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getLineBreaker";
                break;
            }
            case 4: 
            case 5: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "escapeCharCharacters";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

