/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.intentions.closure;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNamedElement;
import com.intellij.refactoring.rename.inplace.VariableInplaceRenamer;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import java.util.HashSet;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.intentions.base.Intention;
import org.jetbrains.plugins.groovy.intentions.base.PsiElementPredicate;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementFactory;
import org.jetbrains.plugins.groovy.lang.psi.GroovyRecursiveElementVisitor;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrForStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrLabeledStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariable;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrWhileStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrArgumentList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrClosableBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.branch.GrReturnStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.clauses.GrForClause;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.path.GrMethodCallExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.params.GrParameter;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.params.GrParameterList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrAnonymousClassDefinition;
import org.jetbrains.plugins.groovy.lang.psi.impl.PsiImplUtil;

public class EachToForIntention
extends Intention {
    @NonNls
    public static final String OUTER = "Outer";
    @NonNls
    public static final String HINT = "Replace with For-In";

    @Override
    @NotNull
    protected PsiElementPredicate getElementPredicate() {
        EachToForPredicate eachToForPredicate = new EachToForPredicate();
        if (eachToForPredicate == null) {
            EachToForIntention.$$$reportNull$$$0(0);
        }
        return eachToForPredicate;
    }

    @Override
    protected void processIntention(@NotNull PsiElement element, @NotNull Project project, Editor editor) throws IncorrectOperationException {
        int index;
        String var;
        GrMethodCallExpression expression;
        GrClosableBlock block;
        GrParameterList parameterList;
        GrParameter[] parameters;
        if (element == null) {
            EachToForIntention.$$$reportNull$$$0(1);
        }
        if (project == null) {
            EachToForIntention.$$$reportNull$$$0(2);
        }
        if ((parameters = (parameterList = (block = (expression = (GrMethodCallExpression)element).getClosureArguments()[0]).getParameterList()).getParameters()).length == 1) {
            var = parameters[0].getText();
            var = StringUtil.replace((String)var, (String)"def", (String)"");
        } else {
            var = "it";
        }
        GrExpression invokedExpression = expression.getInvokedExpression();
        GrExpression qualifier = ((GrReferenceExpression)invokedExpression).getQualifierExpression();
        GroovyPsiElementFactory elementFactory = GroovyPsiElementFactory.getInstance(element.getProject());
        if (qualifier == null) {
            qualifier = elementFactory.createExpressionFromText("this");
        }
        StringBuilder builder = new StringBuilder();
        builder.append("for (").append(var).append(" in ").append(qualifier.getText()).append(") {\n");
        String text = block.getText();
        PsiElement blockArrow = block.getArrow();
        for (index = blockArrow != null ? blockArrow.getStartOffsetInParent() + blockArrow.getTextLength() : 1; index < text.length() && Character.isWhitespace(text.charAt(index)); ++index) {
        }
        text = text.substring(index, text.length() - 1);
        builder.append(text);
        builder.append("}");
        GrStatement statement = elementFactory.createStatementFromText(builder.toString());
        GrForStatement forStatement = (GrForStatement)expression.replaceWithStatement(statement);
        GrForClause clause = forStatement.getClause();
        GrVariable variable = clause.getDeclaredVariable();
        forStatement = EachToForIntention.updateReturnStatements(forStatement);
        if (variable == null) {
            return;
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return;
        }
        PsiDocumentManager documentManager = PsiDocumentManager.getInstance((Project)project);
        Document doc = documentManager.getDocument(element.getContainingFile());
        if (doc == null) {
            return;
        }
        documentManager.doPostponedOperationsAndUnblockDocument(doc);
        editor.getCaretModel().moveToOffset(variable.getTextOffset());
        new VariableInplaceRenamer((PsiNamedElement)variable, editor).performInplaceRename();
    }

    private static GrForStatement updateReturnStatements(GrForStatement forStatement) {
        String continueText;
        GrStatement body = forStatement.getBody();
        assert (body != null);
        final HashSet usedLabels = ContainerUtil.newHashSet();
        final Ref needLabel = Ref.create((Object)false);
        body.accept(new GroovyRecursiveElementVisitor(){
            private int myLoops = 0;

            @Override
            public void visitReturnStatement(@NotNull GrReturnStatement returnStatement) {
                if (returnStatement == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (returnStatement.getReturnValue() != null) {
                    return;
                }
                if (this.myLoops > 0) {
                    needLabel.set((Object)true);
                }
            }

            @Override
            public void visitLabeledStatement(@NotNull GrLabeledStatement labeledStatement) {
                if (labeledStatement == null) {
                    1.$$$reportNull$$$0(1);
                }
                super.visitLabeledStatement(labeledStatement);
                usedLabels.add(labeledStatement.getName());
            }

            @Override
            public void visitForStatement(@NotNull GrForStatement forStatement) {
                if (forStatement == null) {
                    1.$$$reportNull$$$0(2);
                }
                ++this.myLoops;
                super.visitForStatement(forStatement);
                --this.myLoops;
            }

            @Override
            public void visitWhileStatement(@NotNull GrWhileStatement whileStatement) {
                if (whileStatement == null) {
                    1.$$$reportNull$$$0(3);
                }
                ++this.myLoops;
                super.visitWhileStatement(whileStatement);
                --this.myLoops;
            }

            @Override
            public void visitClosure(@NotNull GrClosableBlock closure) {
                if (closure == null) {
                    1.$$$reportNull$$$0(4);
                }
            }

            @Override
            public void visitAnonymousClassDefinition(@NotNull GrAnonymousClassDefinition anonymousClassDefinition) {
                if (anonymousClassDefinition == null) {
                    1.$$$reportNull$$$0(5);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "returnStatement";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "labeledStatement";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "forStatement";
                        break;
                    }
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "whileStatement";
                        break;
                    }
                    case 4: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "closure";
                        break;
                    }
                    case 5: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "anonymousClassDefinition";
                        break;
                    }
                }
                objectArray2[1] = "org/jetbrains/plugins/groovy/intentions/closure/EachToForIntention$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitReturnStatement";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitLabeledStatement";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitForStatement";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitWhileStatement";
                        break;
                    }
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitClosure";
                        break;
                    }
                    case 5: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitAnonymousClassDefinition";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        GroovyPsiElementFactory factory = GroovyPsiElementFactory.getInstance(forStatement.getProject());
        if (((Boolean)needLabel.get()).booleanValue()) {
            int i = 0;
            String label = OUTER;
            while (usedLabels.contains(label)) {
                label = OUTER + i;
                ++i;
            }
            continueText = "continue " + label;
            GrLabeledStatement labeled = (GrLabeledStatement)factory.createStatementFromText(label + ": while (true){}");
            labeled.getStatement().replaceWithStatement(forStatement);
            labeled = (GrLabeledStatement)forStatement.replaceWithStatement(labeled);
            forStatement = (GrForStatement)labeled.getStatement();
            body = forStatement.getBody();
            assert (body != null);
        } else {
            continueText = "continue";
        }
        final GrStatement continueStatement = factory.createStatementFromText(continueText);
        body.accept(new GroovyRecursiveElementVisitor(){

            @Override
            public void visitReturnStatement(@NotNull GrReturnStatement returnStatement) {
                if (returnStatement == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (returnStatement.getReturnValue() == null) {
                    returnStatement.replaceWithStatement(continueStatement);
                }
            }

            @Override
            public void visitClosure(@NotNull GrClosableBlock closure) {
                if (closure == null) {
                    2.$$$reportNull$$$0(1);
                }
            }

            @Override
            public void visitAnonymousClassDefinition(@NotNull GrAnonymousClassDefinition anonymousClassDefinition) {
                if (anonymousClassDefinition == null) {
                    2.$$$reportNull$$$0(2);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "returnStatement";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "closure";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "anonymousClassDefinition";
                        break;
                    }
                }
                objectArray2[1] = "org/jetbrains/plugins/groovy/intentions/closure/EachToForIntention$2";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitReturnStatement";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitClosure";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitAnonymousClassDefinition";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        return forStatement;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/groovy/intentions/closure/EachToForIntention";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getElementPredicate";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/groovy/intentions/closure/EachToForIntention";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "processIntention";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class EachToForPredicate
    implements PsiElementPredicate {
        private EachToForPredicate() {
        }

        @Override
        public boolean satisfiedBy(@NotNull PsiElement element) {
            GrReferenceExpression referenceExpression;
            GrMethodCallExpression expression;
            GrExpression invokedExpression;
            if (element == null) {
                EachToForPredicate.$$$reportNull$$$0(0);
            }
            if (element instanceof GrMethodCallExpression && (invokedExpression = (expression = (GrMethodCallExpression)element).getInvokedExpression()) instanceof GrReferenceExpression && "each".equals((referenceExpression = (GrReferenceExpression)invokedExpression).getReferenceName())) {
                GrArgumentList argumentList = expression.getArgumentList();
                if (PsiImplUtil.hasExpressionArguments(argumentList)) {
                    return false;
                }
                if (PsiImplUtil.hasNamedArguments(argumentList)) {
                    return false;
                }
                GrClosableBlock[] closureArguments = expression.getClosureArguments();
                if (closureArguments.length != 1) {
                    return false;
                }
                GrParameter[] parameters = closureArguments[0].getParameterList().getParameters();
                return parameters.length <= 1;
            }
            return false;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/plugins/groovy/intentions/closure/EachToForIntention$EachToForPredicate", "satisfiedBy"));
        }
    }
}

