/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.refactoring.introduce.parameter;

import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Splitter;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.ui.VerticalFlowLayout;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiType;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.BaseRefactoringProcessor;
import com.intellij.refactoring.JavaRefactoringSettings;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.ui.NameSuggestionsField;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.components.JBRadioButton;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.GridBag;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import gnu.trove.TIntArrayList;
import gnu.trove.TObjectIntHashMap;
import gnu.trove.TObjectIntProcedure;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.LayoutManager;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import javax.swing.AbstractButton;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.GroovyFileType;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrParametersOwner;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariable;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrClosableBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.params.GrParameter;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMethod;
import org.jetbrains.plugins.groovy.lang.psi.impl.GroovyNamesUtil;
import org.jetbrains.plugins.groovy.refactoring.GrRefactoringError;
import org.jetbrains.plugins.groovy.refactoring.GroovyRefactoringBundle;
import org.jetbrains.plugins.groovy.refactoring.extract.ExtractUtil;
import org.jetbrains.plugins.groovy.refactoring.extract.GrParameterTablePanel;
import org.jetbrains.plugins.groovy.refactoring.extract.ParameterInfo;
import org.jetbrains.plugins.groovy.refactoring.extract.closure.ExtractClosureFromClosureProcessor;
import org.jetbrains.plugins.groovy.refactoring.extract.closure.ExtractClosureFromMethodProcessor;
import org.jetbrains.plugins.groovy.refactoring.extract.closure.ExtractClosureHelperImpl;
import org.jetbrains.plugins.groovy.refactoring.extract.closure.ExtractClosureProcessorBase;
import org.jetbrains.plugins.groovy.refactoring.introduce.StringPartInfo;
import org.jetbrains.plugins.groovy.refactoring.introduce.parameter.GrIntroduceClosureParameterProcessor;
import org.jetbrains.plugins.groovy.refactoring.introduce.parameter.GrIntroduceExpressionSettingsImpl;
import org.jetbrains.plugins.groovy.refactoring.introduce.parameter.GrIntroduceParameterProcessor;
import org.jetbrains.plugins.groovy.refactoring.introduce.parameter.GroovyIntroduceParameterUtil;
import org.jetbrains.plugins.groovy.refactoring.introduce.parameter.IntroduceParameterInfo;
import org.jetbrains.plugins.groovy.refactoring.ui.GrMethodSignatureComponent;
import org.jetbrains.plugins.groovy.refactoring.ui.GrTypeComboBox;
import org.jetbrains.plugins.groovy.settings.GroovyApplicationSettings;

public class GrIntroduceParameterDialog
extends DialogWrapper {
    private GrTypeComboBox myTypeComboBox;
    private NameSuggestionsField myNameSuggestionsField;
    private JCheckBox myDeclareFinalCheckBox;
    private JCheckBox myDelegateViaOverloadingMethodCheckBox;
    private JBRadioButton myDoNotReplaceRadioButton;
    private JBRadioButton myReplaceFieldsInaccessibleInRadioButton;
    private JBRadioButton myReplaceAllFieldsRadioButton;
    private JPanel myGetterPanel;
    private final IntroduceParameterInfo myInfo;
    private final TObjectIntHashMap<JCheckBox> toRemoveCBs;
    private GrMethodSignatureComponent mySignature;
    private GrParameterTablePanel myTable;
    private JPanel mySignaturePanel;
    private JCheckBox myForceReturnCheckBox;
    private final Project myProject;
    private final boolean myCanIntroduceSimpleParameter;

    public GrIntroduceParameterDialog(IntroduceParameterInfo info) {
        super(info.getProject(), true);
        this.myInfo = info;
        this.myProject = info.getProject();
        this.myCanIntroduceSimpleParameter = GroovyIntroduceParameterUtil.findExpr(this.myInfo) != null || GroovyIntroduceParameterUtil.findVar(this.myInfo) != null || this.findStringPart() != null;
        TObjectIntHashMap<GrParameter> parametersToRemove = GroovyIntroduceParameterUtil.findParametersToRemove(info);
        this.toRemoveCBs = new TObjectIntHashMap(parametersToRemove.size());
        for (Object p : parametersToRemove.keys()) {
            JCheckBox cb = new JCheckBox(GroovyRefactoringBundle.message("remove.parameter.0.no.longer.used", ((GrParameter)p).getName()));
            this.toRemoveCBs.put((Object)cb, parametersToRemove.get((Object)((GrParameter)p)));
            cb.setSelected(true);
        }
        this.init();
    }

    protected void init() {
        PsiType closureReturnType;
        super.init();
        JavaRefactoringSettings settings = JavaRefactoringSettings.getInstance();
        this.initReplaceFieldsWithGetters(settings);
        this.myDeclareFinalCheckBox.setSelected(this.hasFinalModifier());
        this.myDelegateViaOverloadingMethodCheckBox.setVisible(this.myInfo.getToSearchFor() != null);
        this.setTitle(RefactoringBundle.message((String)"introduce.parameter.title"));
        this.myTable.init(this.myInfo);
        final GrParameter[] parameters = this.myInfo.getToReplaceIn().getParameters();
        this.toRemoveCBs.forEachEntry((TObjectIntProcedure)new TObjectIntProcedure<JCheckBox>(){

            public boolean execute(JCheckBox checkbox, int index) {
                checkbox.setSelected(true);
                GrParameter param = parameters[index];
                ParameterInfo pinfo = GrIntroduceParameterDialog.this.findParamByOldName(param.getName());
                if (pinfo != null) {
                    pinfo.passAsParameter = false;
                }
                return true;
            }
        });
        this.updateSignature();
        if (this.myCanIntroduceSimpleParameter) {
            this.mySignaturePanel.setVisible(false);
            this.myTypeComboBox.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    GrIntroduceParameterDialog.this.mySignaturePanel.setVisible(GrIntroduceParameterDialog.this.myTypeComboBox.isClosureSelected());
                    GrIntroduceParameterDialog.this.pack();
                }
            });
        }
        if (PsiType.VOID.equals((Object)(closureReturnType = this.inferClosureReturnType()))) {
            this.myForceReturnCheckBox.setEnabled(false);
            this.myForceReturnCheckBox.setSelected(false);
        } else {
            this.myForceReturnCheckBox.setSelected(GrIntroduceParameterDialog.isForceReturn());
        }
        if (this.myInfo.getToReplaceIn() instanceof GrClosableBlock) {
            this.myDelegateViaOverloadingMethodCheckBox.setEnabled(false);
            this.myDelegateViaOverloadingMethodCheckBox.setToolTipText("Delegating is not allowed in closure context");
        }
        this.pack();
    }

    private static boolean isForceReturn() {
        return GroovyApplicationSettings.getInstance().FORCE_RETURN;
    }

    protected JComponent createCenterPanel() {
        JPanel north = new JPanel();
        north.setLayout((LayoutManager)new VerticalFlowLayout(0, 0, 0, true, true));
        JPanel namePanel = this.createNamePanel();
        namePanel.setAlignmentX(0.0f);
        north.add(namePanel);
        this.createCheckBoxes(north);
        this.myGetterPanel = this.createFieldPanel();
        this.myGetterPanel.setAlignmentX(0.0f);
        north.add(this.myGetterPanel);
        JPanel root = new JPanel(new BorderLayout());
        this.mySignaturePanel = this.createSignaturePanel();
        root.add((Component)this.mySignaturePanel, "Center");
        root.add((Component)north, "North");
        return root;
    }

    private JPanel createSignaturePanel() {
        this.mySignature = new GrMethodSignatureComponent("", this.myProject);
        this.myTable = new GrParameterTablePanel(){

            protected void updateSignature() {
                GrIntroduceParameterDialog.this.updateSignature();
            }

            protected void doEnterAction() {
                GrIntroduceParameterDialog.this.clickDefaultButton();
            }

            protected void doCancelAction() {
                GrIntroduceParameterDialog.this.doCancelAction();
            }
        };
        this.mySignature.setBorder((Border)IdeBorderFactory.createTitledBorder((String)GroovyRefactoringBundle.message("signature.preview.border.title", new Object[0]), (boolean)false));
        Splitter splitter = new Splitter(true);
        splitter.setFirstComponent((JComponent)((Object)this.myTable));
        splitter.setSecondComponent((JComponent)((Object)this.mySignature));
        this.mySignature.setPreferredSize((Dimension)JBUI.size((int)500, (int)100));
        this.mySignature.setSize((Dimension)JBUI.size((int)500, (int)100));
        splitter.setShowDividerIcon(false);
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)splitter, "Center");
        this.myForceReturnCheckBox = new JCheckBox(UIUtil.replaceMnemonicAmpersand((String)"Use e&xplicit return statement"));
        panel.add((Component)this.myForceReturnCheckBox, "North");
        return panel;
    }

    private JPanel createFieldPanel() {
        this.myDoNotReplaceRadioButton = new JBRadioButton(UIUtil.replaceMnemonicAmpersand((String)"Do n&ot replace"));
        this.myReplaceFieldsInaccessibleInRadioButton = new JBRadioButton(UIUtil.replaceMnemonicAmpersand((String)"Replace fields &inaccessible in usage context"));
        this.myReplaceAllFieldsRadioButton = new JBRadioButton(UIUtil.replaceMnemonicAmpersand((String)"&Replace all fields"));
        this.myDoNotReplaceRadioButton.setFocusable(false);
        this.myReplaceFieldsInaccessibleInRadioButton.setFocusable(false);
        this.myReplaceAllFieldsRadioButton.setFocusable(false);
        ButtonGroup group = new ButtonGroup();
        group.add((AbstractButton)this.myDoNotReplaceRadioButton);
        group.add((AbstractButton)this.myReplaceFieldsInaccessibleInRadioButton);
        group.add((AbstractButton)this.myReplaceAllFieldsRadioButton);
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 1));
        panel.add((Component)this.myDoNotReplaceRadioButton);
        panel.add((Component)this.myReplaceFieldsInaccessibleInRadioButton);
        panel.add((Component)this.myReplaceAllFieldsRadioButton);
        panel.setBorder((Border)IdeBorderFactory.createTitledBorder((String)"Replace fields used in expression with their getters", (boolean)true));
        return panel;
    }

    private JPanel createNamePanel() {
        GridBag c = new GridBag().setDefaultAnchor(17).setDefaultInsets(1, 1, 1, 1);
        JPanel namePanel = new JPanel(new GridBagLayout());
        JLabel typeLabel = new JLabel(UIUtil.replaceMnemonicAmpersand((String)"&Type:"));
        c.nextLine().next().weightx(0.0).fillCellNone();
        namePanel.add((Component)typeLabel, c);
        this.myTypeComboBox = this.createTypeComboBox(GroovyIntroduceParameterUtil.findVar(this.myInfo), GroovyIntroduceParameterUtil.findExpr(this.myInfo), this.findStringPart());
        c.next().weightx(1.0).fillCellHorizontally();
        namePanel.add((Component)((Object)this.myTypeComboBox), c);
        typeLabel.setLabelFor((Component)((Object)this.myTypeComboBox));
        JLabel nameLabel = new JLabel(UIUtil.replaceMnemonicAmpersand((String)"&Name:"));
        c.nextLine().next().weightx(0.0).fillCellNone();
        namePanel.add((Component)nameLabel, c);
        this.myNameSuggestionsField = this.createNameField(GroovyIntroduceParameterUtil.findVar(this.myInfo));
        c.next().weightx(1.0).fillCellHorizontally();
        namePanel.add((Component)this.myNameSuggestionsField, c);
        nameLabel.setLabelFor((Component)this.myNameSuggestionsField);
        GrTypeComboBox.registerUpDownHint((JComponent)this.myNameSuggestionsField, this.myTypeComboBox);
        return namePanel;
    }

    private void createCheckBoxes(JPanel panel) {
        this.myDeclareFinalCheckBox = new JCheckBox(UIUtil.replaceMnemonicAmpersand((String)"Declare &final"));
        this.myDeclareFinalCheckBox.setFocusable(false);
        panel.add(this.myDeclareFinalCheckBox);
        this.myDelegateViaOverloadingMethodCheckBox = new JCheckBox(UIUtil.replaceMnemonicAmpersand((String)"De&legate via overloading method"));
        this.myDelegateViaOverloadingMethodCheckBox.setFocusable(false);
        panel.add(this.myDelegateViaOverloadingMethodCheckBox);
        for (Object o : this.toRemoveCBs.keys()) {
            JCheckBox cb = (JCheckBox)o;
            cb.setFocusable(false);
            panel.add(cb);
        }
    }

    private GrTypeComboBox createTypeComboBox(GrVariable var, GrExpression expr, StringPartInfo stringPartInfo) {
        GrTypeComboBox box = var != null ? GrTypeComboBox.createTypeComboBoxWithDefType(var.getDeclaredType(), var) : (expr != null ? GrTypeComboBox.createTypeComboBoxFromExpression(expr) : (stringPartInfo != null ? GrTypeComboBox.createTypeComboBoxFromExpression(stringPartInfo.getLiteral()) : GrTypeComboBox.createEmptyTypeComboBox()));
        box.addClosureTypesFrom(this.inferClosureReturnType(), this.myInfo.getContext());
        if (expr == null && var == null && stringPartInfo == null) {
            box.setSelectedIndex(box.getItemCount() - 1);
        }
        return box;
    }

    @Nullable
    private PsiType inferClosureReturnType() {
        ExtractClosureHelperImpl mockHelper = new ExtractClosureHelperImpl(this.myInfo, "__test___n_", false, new TIntArrayList(), false, 0, false, false, false);
        return (PsiType)WriteAction.compute(() -> ExtractClosureProcessorBase.generateClosure(mockHelper).getReturnType());
    }

    private NameSuggestionsField createNameField(GrVariable var) {
        ArrayList<String> names2 = new ArrayList<String>();
        if (var != null) {
            names2.add(var.getName());
        }
        ContainerUtil.addAll(names2, this.suggestNames());
        return new NameSuggestionsField(ArrayUtil.toStringArray(names2), this.myProject, (FileType)GroovyFileType.GROOVY_FILE_TYPE);
    }

    private void initReplaceFieldsWithGetters(JavaRefactoringSettings settings) {
        PsiField[] usedFields = GroovyIntroduceParameterUtil.findUsedFieldsWithGetters(this.myInfo.getStatements(), this.getContainingClass());
        this.myGetterPanel.setVisible(usedFields.length > 0);
        switch (settings.INTRODUCE_PARAMETER_REPLACE_FIELDS_WITH_GETTERS) {
            case 2: {
                this.myReplaceAllFieldsRadioButton.setSelected(true);
                break;
            }
            case 1: {
                this.myReplaceFieldsInaccessibleInRadioButton.setSelected(true);
                break;
            }
            case 0: {
                this.myDoNotReplaceRadioButton.setSelected(true);
            }
        }
    }

    private void updateSignature() {
        StringBuilder b = new StringBuilder();
        b.append("{ ");
        String[] params = ExtractUtil.getParameterString(this.myInfo, false);
        for (int i = 0; i < params.length; ++i) {
            if (i > 0) {
                b.append("  ");
            }
            b.append(params[i]);
            b.append('\n');
        }
        b.append(" ->\n}");
        this.mySignature.setSignature(b.toString());
    }

    protected ValidationInfo doValidate() {
        String text = this.getEnteredName();
        if (!GroovyNamesUtil.isIdentifier(text)) {
            return new ValidationInfo(GroovyRefactoringBundle.message("name.is.wrong", text), (JComponent)this.myNameSuggestionsField);
        }
        if (this.myTypeComboBox.isClosureSelected()) {
            final Ref info = new Ref();
            this.toRemoveCBs.forEachEntry((TObjectIntProcedure)new TObjectIntProcedure<JCheckBox>(){

                public boolean execute(JCheckBox checkbox, int index) {
                    if (!checkbox.isSelected()) {
                        return true;
                    }
                    GrParameter param = GrIntroduceParameterDialog.this.myInfo.getToReplaceIn().getParameters()[index];
                    ParameterInfo pinfo = GrIntroduceParameterDialog.this.findParamByOldName(param.getName());
                    if (pinfo == null || !pinfo.passAsParameter) {
                        return true;
                    }
                    String message = GroovyRefactoringBundle.message("you.cannot.pass.as.parameter.0.because.you.remove.1.from.base.method", pinfo.getName(), param.getName());
                    info.set((Object)new ValidationInfo(message));
                    return false;
                }
            });
            if (info.get() != null) {
                return (ValidationInfo)info.get();
            }
        }
        return null;
    }

    @Nullable
    private ParameterInfo findParamByOldName(String name) {
        for (ParameterInfo info : this.myInfo.getParameterInfos()) {
            if (!name.equals(info.getOriginalName())) continue;
            return info;
        }
        return null;
    }

    @Nullable
    private PsiClass getContainingClass() {
        GrParametersOwner toReplaceIn = this.myInfo.getToReplaceIn();
        if (toReplaceIn instanceof GrMethod) {
            return ((GrMethod)toReplaceIn).getContainingClass();
        }
        return (PsiClass)PsiTreeUtil.getContextOfType((PsiElement)toReplaceIn, (Class[])new Class[]{PsiClass.class});
    }

    private boolean hasFinalModifier() {
        Boolean createFinals = JavaRefactoringSettings.getInstance().INTRODUCE_PARAMETER_CREATE_FINALS;
        return createFinals == null ? CodeStyleSettingsManager.getSettings((Project)this.myProject).GENERATE_FINAL_PARAMETERS : createFinals;
    }

    public void doOKAction() {
        this.saveSettings();
        super.doOKAction();
        GrParametersOwner toReplaceIn = this.myInfo.getToReplaceIn();
        GrExpression expr = GroovyIntroduceParameterUtil.findExpr(this.myInfo);
        GrVariable var = GroovyIntroduceParameterUtil.findVar(this.myInfo);
        StringPartInfo stringPart = this.findStringPart();
        if (this.myTypeComboBox.isClosureSelected() || expr == null && var == null && stringPart == null) {
            ExtractClosureHelperImpl settings = new ExtractClosureHelperImpl(this.myInfo, this.getEnteredName(), this.myDeclareFinalCheckBox.isSelected(), this.getParametersToRemove(), this.myDelegateViaOverloadingMethodCheckBox.isSelected(), this.getReplaceFieldsWithGetter(), this.myForceReturnCheckBox.isSelected(), false, this.myTypeComboBox.getSelectedType() == null);
            if (toReplaceIn instanceof GrMethod) {
                this.invokeRefactoring(new ExtractClosureFromMethodProcessor(settings));
            } else {
                this.invokeRefactoring(new ExtractClosureFromClosureProcessor(settings));
            }
        } else {
            GrIntroduceExpressionSettingsImpl settings = new GrIntroduceExpressionSettingsImpl(this.myInfo, this.getEnteredName(), this.myDeclareFinalCheckBox.isSelected(), this.getParametersToRemove(), this.myDelegateViaOverloadingMethodCheckBox.isSelected(), this.getReplaceFieldsWithGetter(), expr, var, this.myTypeComboBox.getSelectedType(), var != null, true, this.myForceReturnCheckBox.isSelected());
            if (toReplaceIn instanceof GrMethod) {
                this.invokeRefactoring(new GrIntroduceParameterProcessor(settings));
            } else {
                this.invokeRefactoring(new GrIntroduceClosureParameterProcessor(settings));
            }
        }
    }

    private String getEnteredName() {
        return this.myNameSuggestionsField.getEnteredName();
    }

    private void saveSettings() {
        JavaRefactoringSettings settings = JavaRefactoringSettings.getInstance();
        settings.INTRODUCE_PARAMETER_CREATE_FINALS = this.myDeclareFinalCheckBox.isSelected();
        if (this.myGetterPanel.isVisible()) {
            settings.INTRODUCE_PARAMETER_REPLACE_FIELDS_WITH_GETTERS = this.getReplaceFieldsWithGetter();
        }
        if (this.myForceReturnCheckBox.isEnabled() && this.mySignaturePanel.isVisible()) {
            GroovyApplicationSettings.getInstance().FORCE_RETURN = this.myForceReturnCheckBox.isSelected();
        }
    }

    protected void invokeRefactoring(BaseRefactoringProcessor processor) {
        Runnable prepareSuccessfulCallback = () -> this.close(0);
        processor.setPrepareSuccessfulSwingThreadCallback(prepareSuccessfulCallback);
        processor.setPreviewUsages(false);
        processor.run();
    }

    @NotNull
    public LinkedHashSet<String> suggestNames() {
        GrVariable var = GroovyIntroduceParameterUtil.findVar(this.myInfo);
        GrExpression expr = GroovyIntroduceParameterUtil.findExpr(this.myInfo);
        StringPartInfo stringPart = this.findStringPart();
        LinkedHashSet<String> linkedHashSet = GroovyIntroduceParameterUtil.suggestNames(var, expr, stringPart, this.myInfo.getToReplaceIn(), this.myProject);
        if (linkedHashSet == null) {
            GrIntroduceParameterDialog.$$$reportNull$$$0(0);
        }
        return linkedHashSet;
    }

    private int getReplaceFieldsWithGetter() {
        if (this.myDoNotReplaceRadioButton.isSelected()) {
            return 0;
        }
        if (this.myReplaceFieldsInaccessibleInRadioButton.isSelected()) {
            return 1;
        }
        if (this.myReplaceAllFieldsRadioButton.isSelected()) {
            return 2;
        }
        throw new GrRefactoringError("no check box selected");
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myNameSuggestionsField;
    }

    protected String getHelpId() {
        return "refactoring.introduceParameter.groovy";
    }

    private TIntArrayList getParametersToRemove() {
        TIntArrayList list = new TIntArrayList();
        for (Object o : this.toRemoveCBs.keys()) {
            if (!((JCheckBox)o).isSelected()) continue;
            list.add(this.toRemoveCBs.get((Object)((JCheckBox)o)));
        }
        return list;
    }

    private StringPartInfo findStringPart() {
        return this.myInfo.getStringPartInfo();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/refactoring/introduce/parameter/GrIntroduceParameterDialog", "suggestNames"));
    }
}

