/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.refactoring.introduce.parameter;

import com.intellij.lang.findUsages.DescriptiveNameUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiType;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.MethodReferencesSearch;
import com.intellij.psi.search.searches.OverridingMethodsSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilBase;
import com.intellij.refactoring.BaseRefactoringProcessor;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.introduceParameter.ChangedMethodCallInfo;
import com.intellij.refactoring.introduceParameter.ExternalUsageInfo;
import com.intellij.refactoring.introduceParameter.InternalUsageInfo;
import com.intellij.refactoring.introduceParameter.IntroduceParameterData;
import com.intellij.refactoring.introduceParameter.IntroduceParameterMethodUsagesProcessor;
import com.intellij.refactoring.introduceParameter.IntroduceParameterUtil;
import com.intellij.refactoring.ui.UsageViewDescriptorAdapter;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.refactoring.util.usageInfo.DefaultConstructorImplicitUsageInfo;
import com.intellij.refactoring.util.usageInfo.NoConstructorClassUsageInfo;
import com.intellij.usageView.UsageInfo;
import com.intellij.usageView.UsageViewDescriptor;
import com.intellij.usageView.UsageViewUtil;
import com.intellij.util.containers.MultiMap;
import gnu.trove.TIntArrayList;
import java.util.ArrayList;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementFactory;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariable;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrOpenBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.literals.GrLiteral;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrAnonymousClassDefinition;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMethod;
import org.jetbrains.plugins.groovy.refactoring.introduce.GrIntroduceHandlerBase;
import org.jetbrains.plugins.groovy.refactoring.introduce.StringPartInfo;
import org.jetbrains.plugins.groovy.refactoring.introduce.parameter.FieldConflictsResolver;
import org.jetbrains.plugins.groovy.refactoring.introduce.parameter.GrExpressionWrapper;
import org.jetbrains.plugins.groovy.refactoring.introduce.parameter.GrIntroduceParameterSettings;
import org.jetbrains.plugins.groovy.refactoring.introduce.parameter.GroovyIntroduceParameterUtil;
import org.jetbrains.plugins.groovy.refactoring.util.AnySupers;

public class GrIntroduceParameterProcessor
extends BaseRefactoringProcessor
implements IntroduceParameterData {
    private static final Logger LOG = Logger.getInstance((String)"#org.jetbrains.plugins.groovy.refactoring.introduce.parameter.GrIntroduceParameterProcessor");
    private final GrIntroduceParameterSettings mySettings;
    private final IntroduceParameterData.ExpressionWrapper myParameterInitializer;

    public GrIntroduceParameterProcessor(GrIntroduceParameterSettings settings) {
        this(settings, GrIntroduceParameterProcessor.createExpressionWrapper(settings));
    }

    public GrIntroduceParameterProcessor(GrIntroduceParameterSettings settings, GrExpressionWrapper expr) {
        super(settings.getProject());
        this.mySettings = settings;
        this.myParameterInitializer = expr;
    }

    private static GrExpressionWrapper createExpressionWrapper(GrIntroduceParameterSettings settings) {
        LOG.assertTrue(settings.getToReplaceIn() instanceof GrMethod);
        LOG.assertTrue(settings.getToSearchFor() instanceof PsiMethod);
        StringPartInfo stringPartInfo = settings.getStringPartInfo();
        GrVariable var = settings.getVar();
        GrLiteral expression = stringPartInfo != null ? stringPartInfo.createLiteralFromSelected() : (var != null ? var.getInitializerGroovy() : settings.getExpression());
        return new GrExpressionWrapper(expression);
    }

    @NotNull
    protected UsageViewDescriptor createUsageViewDescriptor(@NotNull UsageInfo[] usages) {
        if (usages == null) {
            GrIntroduceParameterProcessor.$$$reportNull$$$0(0);
        }
        UsageViewDescriptorAdapter usageViewDescriptorAdapter = new UsageViewDescriptorAdapter(){

            @NotNull
            public PsiElement[] getElements() {
                PsiElement[] psiElementArray = new PsiElement[]{GrIntroduceParameterProcessor.this.mySettings.getToSearchFor()};
                if (psiElementArray == null) {
                    1.$$$reportNull$$$0(0);
                }
                return psiElementArray;
            }

            public String getProcessedElementsHeader() {
                return RefactoringBundle.message((String)"introduce.parameter.elements.header");
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/refactoring/introduce/parameter/GrIntroduceParameterProcessor$1", "getElements"));
            }
        };
        if (usageViewDescriptorAdapter == null) {
            GrIntroduceParameterProcessor.$$$reportNull$$$0(1);
        }
        return usageViewDescriptorAdapter;
    }

    protected boolean preprocessUsages(@NotNull Ref<UsageInfo[]> refUsages) {
        if (refUsages == null) {
            GrIntroduceParameterProcessor.$$$reportNull$$$0(2);
        }
        UsageInfo[] usagesIn = (UsageInfo[])refUsages.get();
        MultiMap conflicts = new MultiMap();
        if (!this.mySettings.generateDelegate()) {
            GroovyIntroduceParameterUtil.detectAccessibilityConflicts(this.mySettings.getExpression(), usagesIn, (MultiMap<PsiElement, String>)conflicts, this.mySettings.replaceFieldsWithGetters() != 0, this.myProject);
        }
        GrMethod toReplaceIn = (GrMethod)this.mySettings.getToReplaceIn();
        if (this.mySettings.getExpression() != null && !toReplaceIn.hasModifierProperty("private")) {
            AnySupers anySupers = new AnySupers();
            this.mySettings.getExpression().accept(anySupers);
            if (anySupers.containsSupers()) {
                UsageInfo[] usageInfoArray = usagesIn;
                int n = usageInfoArray.length;
                for (int i = 0; i < n; ++i) {
                    UsageInfo usageInfo = usageInfoArray[i];
                    if (usageInfo.getElement() instanceof PsiMethod || usageInfo instanceof InternalUsageInfo || PsiTreeUtil.isAncestor((PsiElement)toReplaceIn.getContainingClass(), (PsiElement)usageInfo.getElement(), (boolean)false)) continue;
                    conflicts.putValue((Object)this.mySettings.getExpression(), (Object)RefactoringBundle.message((String)"parameter.initializer.contains.0.but.not.all.calls.to.method.are.in.its.class", (Object[])new Object[]{CommonRefactoringUtil.htmlEmphasize((String)"super")}));
                    break;
                }
            }
        }
        for (IntroduceParameterMethodUsagesProcessor processor : (IntroduceParameterMethodUsagesProcessor[])IntroduceParameterMethodUsagesProcessor.EP_NAME.getExtensions()) {
            processor.findConflicts((IntroduceParameterData)this, (UsageInfo[])refUsages.get(), conflicts);
        }
        return this.showConflicts(conflicts, usagesIn);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    protected UsageInfo[] findUsages() {
        PsiElement[] refs;
        ArrayList<Object> result = new ArrayList<Object>();
        PsiMethod toSearchFor = (PsiMethod)this.mySettings.getToSearchFor();
        if (!this.mySettings.generateDelegate()) {
            refs = MethodReferencesSearch.search((PsiMethod)toSearchFor, (SearchScope)GlobalSearchScope.projectScope((Project)this.myProject), (boolean)true).findAll();
            for (PsiReference psiReference : refs) {
                PsiElement ref = psiReference.getElement();
                if (ref instanceof PsiMethod && ((PsiMethod)ref).isConstructor()) {
                    DefaultConstructorImplicitUsageInfo implicitUsageInfo = new DefaultConstructorImplicitUsageInfo((PsiMethod)ref, ((PsiMethod)ref).getContainingClass(), toSearchFor);
                    result.add(implicitUsageInfo);
                    continue;
                }
                if (ref instanceof PsiClass) {
                    if (ref instanceof GrAnonymousClassDefinition) {
                        result.add(new ExternalUsageInfo((PsiElement)((GrAnonymousClassDefinition)ref).getBaseClassReferenceGroovy()));
                        continue;
                    }
                    if (ref instanceof PsiAnonymousClass) {
                        result.add(new ExternalUsageInfo((PsiElement)((PsiAnonymousClass)ref).getBaseClassReference()));
                        continue;
                    }
                    result.add(new NoConstructorClassUsageInfo((PsiClass)ref));
                    continue;
                }
                if (!PsiTreeUtil.isAncestor((PsiElement)this.mySettings.getToReplaceIn(), (PsiElement)ref, (boolean)false)) {
                    result.add(new ExternalUsageInfo(ref));
                    continue;
                }
                result.add(new ChangedMethodCallInfo(ref));
            }
        }
        if (this.mySettings.replaceAllOccurrences()) {
            if (this.mySettings.getVar() != null) {
                void var5_9;
                refs = GrIntroduceHandlerBase.collectVariableUsages(this.mySettings.getVar(), this.mySettings.getToReplaceIn());
                int n = refs.length;
                boolean bl = false;
                while (var5_9 < n) {
                    PsiElement element = refs[var5_9];
                    result.add(new InternalUsageInfo(element));
                    ++var5_9;
                }
            } else {
                PsiElement[] exprs;
                for (PsiElement expr : exprs = GroovyIntroduceParameterUtil.getOccurrences(this.mySettings)) {
                    result.add(new InternalUsageInfo(expr));
                }
            }
        } else if (this.mySettings.getExpression() != null) {
            result.add(new InternalUsageInfo((PsiElement)this.mySettings.getExpression()));
        }
        Collection overridingMethods = OverridingMethodsSearch.search((PsiMethod)toSearchFor).findAll();
        for (PsiMethod psiMethod : overridingMethods) {
            result.add(new UsageInfo((PsiElement)psiMethod));
        }
        UsageInfo[] usageInfos = result.toArray(UsageInfo.EMPTY_ARRAY);
        UsageInfo[] usageInfoArray = UsageViewUtil.removeDuplicatedUsages((UsageInfo[])usageInfos);
        if (usageInfoArray == null) {
            GrIntroduceParameterProcessor.$$$reportNull$$$0(3);
        }
        return usageInfoArray;
    }

    protected void performRefactoring(@NotNull UsageInfo[] usages) {
        boolean methodsToProcessAreDifferent;
        if (usages == null) {
            GrIntroduceParameterProcessor.$$$reportNull$$$0(4);
        }
        GroovyPsiElementFactory factory = GroovyPsiElementFactory.getInstance(this.myProject);
        IntroduceParameterUtil.processUsages((UsageInfo[])usages, (IntroduceParameterData)this);
        GrMethod toReplaceIn = (GrMethod)this.mySettings.getToReplaceIn();
        PsiMethod toSearchFor = (PsiMethod)this.mySettings.getToSearchFor();
        boolean bl = methodsToProcessAreDifferent = toReplaceIn != toSearchFor;
        if (this.mySettings.generateDelegate()) {
            this.generateDelegate(toReplaceIn, toSearchFor, methodsToProcessAreDifferent);
        }
        FieldConflictsResolver fieldConflictsResolver = new FieldConflictsResolver(this.mySettings.getName(), toReplaceIn.getBlock());
        this.processMethodSignature(usages, toReplaceIn, toSearchFor, methodsToProcessAreDifferent);
        this.processUsages(usages, factory);
        this.processStringPart();
        this.processVar();
        fieldConflictsResolver.fix();
    }

    private void processVar() {
        GrVariable var = this.mySettings.getVar();
        if (var != null && this.mySettings.removeLocalVariable()) {
            var.delete();
        }
    }

    private void processStringPart() {
        GrExpression expr;
        Editor editor;
        StringPartInfo stringPartInfo = this.mySettings.getStringPartInfo();
        if (stringPartInfo != null && (editor = PsiUtilBase.findEditor((PsiElement)(expr = this.mySettings.getStringPartInfo().replaceLiteralWithConcatenation(this.mySettings.getName())))) != null) {
            editor.getSelectionModel().removeSelection();
            editor.getCaretModel().moveToOffset(expr.getTextRange().getEndOffset());
        }
    }

    private void processUsages(UsageInfo[] usages, GroovyPsiElementFactory factory) {
        for (UsageInfo usage : usages) {
            PsiElement element;
            if (usage instanceof ChangedMethodCallInfo) {
                element = usage.getElement();
                GroovyIntroduceParameterUtil.processChangedMethodCall(element, this.mySettings, this.myProject);
                continue;
            }
            if (!(usage instanceof InternalUsageInfo) || (element = usage.getElement()) == null) continue;
            GrExpression newExpr = factory.createExpressionFromText(this.mySettings.getName());
            if (element instanceof GrExpression) {
                ((GrExpression)element).replaceWithExpression(newExpr, true);
                continue;
            }
            element.replace((PsiElement)newExpr);
        }
    }

    private void processMethodSignature(UsageInfo[] usages, GrMethod toReplaceIn, PsiMethod toSearchFor, boolean methodsToProcessAreDifferent) {
        IntroduceParameterUtil.changeMethodSignatureAndResolveFieldConflicts((UsageInfo)new UsageInfo((PsiElement)toReplaceIn), (UsageInfo[])usages, (IntroduceParameterData)this);
        if (methodsToProcessAreDifferent) {
            IntroduceParameterUtil.changeMethodSignatureAndResolveFieldConflicts((UsageInfo)new UsageInfo((PsiElement)toSearchFor), (UsageInfo[])usages, (IntroduceParameterData)this);
        }
    }

    private void generateDelegate(GrMethod toReplaceIn, PsiMethod toSearchFor, boolean methodsToProcessAreDifferent) {
        GrOpenBlock block;
        GrMethod method;
        PsiClass containingClass;
        GroovyIntroduceParameterUtil.generateDelegate(toReplaceIn, this.myParameterInitializer, this.myProject);
        if (methodsToProcessAreDifferent && (containingClass = (method = GroovyIntroduceParameterUtil.generateDelegate(toSearchFor, this.myParameterInitializer, this.myProject)).getContainingClass()) != null && containingClass.isInterface() && (block = method.getBlock()) != null) {
            block.delete();
        }
    }

    @NotNull
    protected String getCommandName() {
        String string = RefactoringBundle.message((String)"introduce.parameter.command", (Object[])new Object[]{DescriptiveNameUtil.getDescriptiveName((PsiElement)this.mySettings.getToReplaceIn())});
        if (string == null) {
            GrIntroduceParameterProcessor.$$$reportNull$$$0(5);
        }
        return string;
    }

    @NotNull
    public Project getProject() {
        Project project = this.mySettings.getProject();
        if (project == null) {
            GrIntroduceParameterProcessor.$$$reportNull$$$0(6);
        }
        return project;
    }

    public PsiMethod getMethodToReplaceIn() {
        return (PsiMethod)this.mySettings.getToReplaceIn();
    }

    @NotNull
    public PsiMethod getMethodToSearchFor() {
        PsiMethod psiMethod = (PsiMethod)this.mySettings.getToSearchFor();
        if (psiMethod == null) {
            GrIntroduceParameterProcessor.$$$reportNull$$$0(7);
        }
        return psiMethod;
    }

    public IntroduceParameterData.ExpressionWrapper getParameterInitializer() {
        return this.myParameterInitializer;
    }

    @NotNull
    public String getParameterName() {
        String string = this.mySettings.getName();
        if (string == null) {
            GrIntroduceParameterProcessor.$$$reportNull$$$0(8);
        }
        return string;
    }

    public int getReplaceFieldsWithGetters() {
        return this.mySettings.replaceFieldsWithGetters();
    }

    public boolean isDeclareFinal() {
        return this.mySettings.declareFinal();
    }

    public boolean isGenerateDelegate() {
        return this.mySettings.generateDelegate();
    }

    @NotNull
    public PsiType getForcedType() {
        PsiType selectedType = this.mySettings.getSelectedType();
        if (selectedType != null) {
            PsiType psiType = selectedType;
            if (psiType == null) {
                GrIntroduceParameterProcessor.$$$reportNull$$$0(9);
            }
            return psiType;
        }
        PsiManager manager = PsiManager.getInstance((Project)this.myProject);
        GlobalSearchScope resolveScope = this.mySettings.getToReplaceIn().getResolveScope();
        PsiClassType psiClassType = PsiType.getJavaLangObject((PsiManager)manager, (GlobalSearchScope)resolveScope);
        if (psiClassType == null) {
            GrIntroduceParameterProcessor.$$$reportNull$$$0(10);
        }
        return psiClassType;
    }

    @NotNull
    public TIntArrayList getParametersToRemove() {
        TIntArrayList tIntArrayList = this.mySettings.parametersToRemove();
        if (tIntArrayList == null) {
            GrIntroduceParameterProcessor.$$$reportNull$$$0(11);
        }
        return tIntArrayList;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usages";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/groovy/refactoring/introduce/parameter/GrIntroduceParameterProcessor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refUsages";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/groovy/refactoring/introduce/parameter/GrIntroduceParameterProcessor";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createUsageViewDescriptor";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "findUsages";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommandName";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getMethodToSearchFor";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getParameterName";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getForcedType";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getParametersToRemove";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createUsageViewDescriptor";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "preprocessUsages";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "performRefactoring";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

