/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.transformations.indexedProperty;

import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.psi.PsiAnnotationOwner;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiType;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.annotator.checkers.CustomAnnotationChecker;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.GrModifierList;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.annotation.GrAnnotation;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrField;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariable;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariableDeclaration;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrTypeElement;
import org.jetbrains.plugins.groovy.transformations.indexedProperty.ImplKt;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\t"}, d2={"Lorg/jetbrains/plugins/groovy/transformations/indexedProperty/IndexedPropertyAnnotationChecker;", "Lorg/jetbrains/plugins/groovy/annotator/checkers/CustomAnnotationChecker;", "()V", "checkApplicability", "", "holder", "Lcom/intellij/lang/annotation/AnnotationHolder;", "annotation", "Lorg/jetbrains/plugins/groovy/lang/psi/api/auxiliary/modifiers/annotation/GrAnnotation;", "intellij.groovy.psi"})
public final class IndexedPropertyAnnotationChecker
extends CustomAnnotationChecker {
    @Override
    public boolean checkApplicability(@NotNull AnnotationHolder holder, @NotNull GrAnnotation annotation) {
        Intrinsics.checkParameterIsNotNull((Object)holder, (String)"holder");
        Intrinsics.checkParameterIsNotNull((Object)annotation, (String)"annotation");
        if (Intrinsics.areEqual((Object)annotation.getQualifiedName(), (Object)ImplKt.getIndexedPropertyFqn()) ^ true) {
            return false;
        }
        PsiAnnotationOwner psiAnnotationOwner = annotation.getOwner();
        if (!(psiAnnotationOwner instanceof GrModifierList)) {
            psiAnnotationOwner = null;
        }
        GrModifierList grModifierList = (GrModifierList)psiAnnotationOwner;
        if (grModifierList == null) {
            return true;
        }
        GrModifierList modifierList = grModifierList;
        PsiElement psiElement = modifierList.getParent();
        if (!(psiElement instanceof GrVariableDeclaration)) {
            psiElement = null;
        }
        GrVariableDeclaration grVariableDeclaration = (GrVariableDeclaration)psiElement;
        if (grVariableDeclaration == null) {
            return true;
        }
        GrVariableDeclaration parent = grVariableDeclaration;
        GrVariable[] grVariableArray = parent.getVariables();
        Intrinsics.checkExpressionValueIsNotNull((Object)grVariableArray, (String)"parent.variables");
        Object object = ArraysKt.singleOrNull((Object[])grVariableArray);
        if (!(object instanceof GrField)) {
            object = null;
        }
        GrField grField = (GrField)object;
        if (grField == null) {
            return true;
        }
        GrField field = grField;
        if (!field.isProperty()) {
            holder.createErrorAnnotation((PsiElement)annotation, "@IndexedProperty is applicable to properties only");
            return true;
        }
        if (ImplKt.getIndexedComponentType(field) == null) {
            PsiElement psiElement2;
            GrTypeElement grTypeElement = field.getTypeElementGroovy();
            if (grTypeElement != null) {
                psiElement2 = grTypeElement;
            } else {
                PsiElement psiElement3 = field.getNameIdentifierGroovy();
                psiElement2 = psiElement3;
                Intrinsics.checkExpressionValueIsNotNull((Object)psiElement3, (String)"field.nameIdentifierGroovy");
            }
            PsiElement elementToHighlight = psiElement2;
            StringBuilder stringBuilder = new StringBuilder().append("Property is not indexable. Type must be array or list but found ");
            PsiType psiType = field.getType();
            Intrinsics.checkExpressionValueIsNotNull((Object)psiType, (String)"field.type");
            String message = stringBuilder.append(psiType.getPresentableText()).toString();
            holder.createErrorAnnotation(elementToHighlight, message);
        }
        return true;
    }
}

