/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.capitalization;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInspection.AbstractBaseJavaLocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.lang.properties.psi.Property;
import com.intellij.lang.properties.references.PropertyReference;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.ReadonlyStatusHandler;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PropertyUtilBase;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TitleCapitalizationInspection
extends AbstractBaseJavaLocalInspectionTool {
    @NotNull
    public String getShortName() {
        if ("DialogTitleCapitalization" == null) {
            TitleCapitalizationInspection.$$$reportNull$$$0(0);
        }
        return "DialogTitleCapitalization";
    }

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            TitleCapitalizationInspection.$$$reportNull$$$0(1);
        }
        JavaElementVisitor javaElementVisitor = new JavaElementVisitor(){

            public void visitMethod(PsiMethod method) {
                PsiType type = method.getReturnType();
                if (!InheritanceUtil.isInheritor((PsiType)type, (String)"java.lang.String")) {
                    return;
                }
                Collection statements = PsiTreeUtil.findChildrenOfType((PsiElement)method, PsiReturnStatement.class);
                for (PsiReturnStatement returnStatement : statements) {
                    PsiExpression expression = returnStatement.getReturnValue();
                    String value = TitleCapitalizationInspection.getTitleValue(expression, new HashSet());
                    if (value == null) continue;
                    Nls.Capitalization capitalization = TitleCapitalizationInspection.this.getCapitalizationFromAnno((PsiModifierListOwner)method);
                    TitleCapitalizationInspection.checkCapitalization(expression, holder, capitalization);
                }
            }

            public void visitCallExpression(PsiCallExpression expression) {
                PsiExpressionList argumentList;
                PsiMethod psiMethod = expression.resolveMethod();
                if (psiMethod != null && (argumentList = expression.getArgumentList()) != null) {
                    PsiExpression[] args = argumentList.getExpressions();
                    PsiParameter[] parameters = psiMethod.getParameterList().getParameters();
                    for (int i = 0; i < Math.min(parameters.length, args.length); ++i) {
                        PsiParameter parameter = parameters[i];
                        Nls.Capitalization capitalization = TitleCapitalizationInspection.this.getCapitalizationFromAnno((PsiModifierListOwner)parameter);
                        TitleCapitalizationInspection.checkCapitalization(args[i], holder, capitalization);
                    }
                }
            }
        };
        if (javaElementVisitor == null) {
            TitleCapitalizationInspection.$$$reportNull$$$0(2);
        }
        return javaElementVisitor;
    }

    public Nls.Capitalization getCapitalizationFromAnno(PsiModifierListOwner modifierListOwner) {
        PsiAnnotation nls = AnnotationUtil.findAnnotationInHierarchy((PsiModifierListOwner)modifierListOwner, Collections.singleton(Nls.class.getName()));
        if (nls == null) {
            return Nls.Capitalization.NotSpecified;
        }
        PsiAnnotationMemberValue capitalization = nls.findAttributeValue("capitalization");
        Object cap = JavaPsiFacade.getInstance((Project)modifierListOwner.getProject()).getConstantEvaluationHelper().computeConstantExpression((PsiElement)capitalization);
        return cap instanceof Nls.Capitalization ? (Nls.Capitalization)cap : Nls.Capitalization.NotSpecified;
    }

    private static void checkCapitalization(PsiExpression element, @NotNull ProblemsHolder holder, Nls.Capitalization capitalization) {
        if (holder == null) {
            TitleCapitalizationInspection.$$$reportNull$$$0(3);
        }
        if (capitalization == Nls.Capitalization.NotSpecified) {
            return;
        }
        String titleValue = TitleCapitalizationInspection.getTitleValue(element, new HashSet<PsiElement>());
        if (!TitleCapitalizationInspection.checkCapitalization(titleValue, capitalization)) {
            holder.registerProblem((PsiElement)element, "String '" + titleValue + "' is not properly capitalized. It should have " + StringUtil.toLowerCase((String)capitalization.toString()) + " capitalization", ProblemHighlightType.GENERIC_ERROR_OR_WARNING, new LocalQuickFix[]{new TitleCapitalizationFix(titleValue, capitalization)});
        }
    }

    @Nullable
    private static String getTitleValue(@Nullable PsiExpression arg, Set<PsiElement> processed) {
        PsiExpression initializer;
        PsiElement result;
        Object value;
        if (arg instanceof PsiLiteralExpression && (value = ((PsiLiteralExpression)arg).getValue()) instanceof String) {
            return (String)value;
        }
        if (arg instanceof PsiMethodCallExpression) {
            PsiMethod psiMethod = ((PsiMethodCallExpression)arg).resolveMethod();
            PsiExpression returnValue = PropertyUtilBase.getGetterReturnExpression((PsiMethod)psiMethod);
            if (arg == returnValue) {
                return null;
            }
            if (returnValue != null && processed.add((PsiElement)returnValue)) {
                return TitleCapitalizationInspection.getTitleValue(returnValue, processed);
            }
            Property propertyArgument = TitleCapitalizationInspection.getPropertyArgument((PsiMethodCallExpression)arg);
            if (propertyArgument != null) {
                return propertyArgument.getUnescapedValue();
            }
        }
        if (arg instanceof PsiReferenceExpression && (result = ((PsiReferenceExpression)arg).resolve()) instanceof PsiVariable && ((PsiVariable)result).hasModifierProperty("final") && processed.add((PsiElement)(initializer = ((PsiVariable)result).getInitializer()))) {
            return TitleCapitalizationInspection.getTitleValue(initializer, processed);
        }
        return null;
    }

    @Nullable
    private static Property getPropertyArgument(PsiMethodCallExpression arg) {
        PsiExpression[] args = arg.getArgumentList().getExpressions();
        if (args.length > 0) {
            PsiReference[] references;
            for (PsiReference reference : references = args[0].getReferences()) {
                PsiElement element;
                ResolveResult[] resolveResults;
                if (!(reference instanceof PropertyReference) || (resolveResults = ((PropertyReference)reference).multiResolve(false)).length != 1 || !resolveResults[0].isValidResult() || !((element = resolveResults[0].getElement()) instanceof Property)) continue;
                return (Property)element;
            }
        }
        return null;
    }

    public static boolean checkCapitalization(String value, Nls.Capitalization capitalization) {
        if (StringUtil.isEmpty((String)value) || capitalization == Nls.Capitalization.NotSpecified) {
            return true;
        }
        value = value.replace("&", "");
        return capitalization == Nls.Capitalization.Title ? StringUtil.wordsToBeginFromUpperCase((String)value).equals(value) : TitleCapitalizationInspection.checkSentenceCapitalization(value);
    }

    private static boolean checkSentenceCapitalization(@NotNull String value) {
        List words;
        if (value == null) {
            TitleCapitalizationInspection.$$$reportNull$$$0(4);
        }
        if ((words = StringUtil.split((String)value, (String)" ")).size() == 0) {
            return true;
        }
        if (Character.isLetter(((String)words.get(0)).charAt(0)) && !TitleCapitalizationInspection.isCapitalizedWord((String)words.get(0))) {
            return false;
        }
        if (words.size() == 1) {
            return true;
        }
        int capitalized = 1;
        int size = words.size();
        for (int i = 1; i < size; ++i) {
            String word = (String)words.get(i);
            if (!TitleCapitalizationInspection.isCapitalizedWord(word) || word.length() == 1 || !Character.isLowerCase(word.charAt(1))) continue;
            ++capitalized;
        }
        return (double)(capitalized / words.size()) < 0.2;
    }

    private static boolean isCapitalizedWord(String word) {
        return word.length() > 0 && Character.isLetter(word.charAt(0)) && Character.isUpperCase(word.charAt(0));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/capitalization/TitleCapitalizationInspection";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getShortName";
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/capitalization/TitleCapitalizationInspection";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "buildVisitor";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "checkCapitalization";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "checkSentenceCapitalization";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class TitleCapitalizationFix
    implements LocalQuickFix {
        private final String myTitleValue;
        private final Nls.Capitalization myCapitalization;

        public TitleCapitalizationFix(String titleValue, Nls.Capitalization capitalization) {
            this.myTitleValue = titleValue;
            this.myCapitalization = capitalization;
        }

        @NotNull
        public String getName() {
            String string = "Properly capitalize '" + this.myTitleValue + '\'';
            if (string == null) {
                TitleCapitalizationFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        public final void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            PsiElement problemElement;
            if (project == null) {
                TitleCapitalizationFix.$$$reportNull$$$0(1);
            }
            if (descriptor == null) {
                TitleCapitalizationFix.$$$reportNull$$$0(2);
            }
            if ((problemElement = descriptor.getPsiElement()) == null || !problemElement.isValid()) {
                return;
            }
            if (TitleCapitalizationFix.isQuickFixOnReadOnlyFile(problemElement)) {
                return;
            }
            try {
                this.doFix(project, problemElement);
            }
            catch (IncorrectOperationException e) {
                Class<?> aClass = this.getClass();
                String className = aClass.getName();
                Logger logger = Logger.getInstance((String)className);
                logger.error((Throwable)e);
            }
        }

        protected void doFix(Project project, PsiElement element) throws IncorrectOperationException {
            if (element instanceof PsiLiteralExpression) {
                PsiLiteralExpression literalExpression = (PsiLiteralExpression)element;
                Object value = literalExpression.getValue();
                if (!(value instanceof String)) {
                    return;
                }
                String string = (String)value;
                PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)project);
                PsiExpression newExpression = factory.createExpressionFromText('\"' + this.fixValue(string) + '\"', element);
                literalExpression.replace((PsiElement)newExpression);
            } else if (element instanceof PsiMethodCallExpression) {
                Property property;
                PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)element;
                PsiMethod method = methodCallExpression.resolveMethod();
                PsiExpression returnValue = PropertyUtilBase.getGetterReturnExpression((PsiMethod)method);
                if (returnValue != null) {
                    this.doFix(project, (PsiElement)returnValue);
                }
                if ((property = TitleCapitalizationInspection.getPropertyArgument(methodCallExpression)) == null) {
                    return;
                }
                String value = property.getUnescapedValue();
                if (value == null) {
                    return;
                }
                property.setValue(this.fixValue(value));
            } else if (element instanceof PsiReferenceExpression) {
                PsiReferenceExpression referenceExpression = (PsiReferenceExpression)element;
                PsiElement target = referenceExpression.resolve();
                if (!(target instanceof PsiVariable)) {
                    return;
                }
                PsiVariable variable = (PsiVariable)target;
                if (variable.hasModifierProperty("final")) {
                    this.doFix(project, (PsiElement)variable.getInitializer());
                }
            }
        }

        @NotNull
        private String fixValue(String string) {
            String string2 = this.myCapitalization == Nls.Capitalization.Title ? StringUtil.wordsToBeginFromUpperCase((String)string) : StringUtil.capitalize((String)StringUtil.wordsToBeginFromLowerCase((String)string));
            if (string2 == null) {
                TitleCapitalizationFix.$$$reportNull$$$0(3);
            }
            return string2;
        }

        protected static boolean isQuickFixOnReadOnlyFile(PsiElement problemElement) {
            PsiFile containingPsiFile = problemElement.getContainingFile();
            if (containingPsiFile == null) {
                return false;
            }
            VirtualFile virtualFile = containingPsiFile.getVirtualFile();
            if (virtualFile == null) {
                return false;
            }
            Project project = problemElement.getProject();
            ReadonlyStatusHandler handler = ReadonlyStatusHandler.getInstance((Project)project);
            ReadonlyStatusHandler.OperationStatus status = handler.ensureFilesWritable(new VirtualFile[]{virtualFile});
            return status.hasReadonlyFiles();
        }

        @NotNull
        public String getFamilyName() {
            if ("Properly capitalize" == null) {
                TitleCapitalizationFix.$$$reportNull$$$0(4);
            }
            return "Properly capitalize";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInspection/capitalization/TitleCapitalizationInspection$TitleCapitalizationFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInspection/capitalization/TitleCapitalizationInspection$TitleCapitalizationFix";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "fixValue";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

