/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.duplicateStringLiteral;

import com.intellij.codeInsight.daemon.GroupNames;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.LocalQuickFixAndIntentionActionOnPsiElement;
import com.intellij.codeInspection.LocalQuickFixOnPsiElement;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.SuppressManager;
import com.intellij.codeInspection.ex.BaseLocalInspectionTool;
import com.intellij.codeInspection.i18n.JavaI18nUtil;
import com.intellij.find.findUsages.PsiElement2UsageTargetAdapter;
import com.intellij.lang.Language;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.impl.search.LowLevelSearchUtil;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.PsiSearchHelper;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiFormatUtil;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.introduceField.IntroduceConstantHandler;
import com.intellij.refactoring.util.occurrences.BaseOccurrenceManager;
import com.intellij.refactoring.util.occurrences.OccurrenceManager;
import com.intellij.ui.DocumentAdapter;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.usageView.UsageInfo;
import com.intellij.usages.Usage;
import com.intellij.usages.UsageInfo2UsageAdapter;
import com.intellij.usages.UsageTarget;
import com.intellij.usages.UsageView;
import com.intellij.usages.UsageViewManager;
import com.intellij.usages.UsageViewPresentation;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.Processor;
import com.intellij.util.Processors;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ConcurrentFactoryMap;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.StringSearcher;
import com.siyeh.ig.style.UnnecessarilyQualifiedStaticUsageInspection;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Stream;
import javax.swing.AbstractButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DuplicateStringLiteralInspection
extends BaseLocalInspectionTool {
    public int MIN_STRING_LENGTH = 5;
    public boolean IGNORE_PROPERTY_KEYS;
    @NonNls
    private static final String BR = "<br>";

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, final boolean isOnTheFly) {
        if (holder == null) {
            DuplicateStringLiteralInspection.$$$reportNull$$$0(0);
        }
        JavaElementVisitor javaElementVisitor = new JavaElementVisitor(){

            public void visitReferenceExpression(PsiReferenceExpression expression) {
                this.visitExpression((PsiExpression)expression);
            }

            public void visitLiteralExpression(PsiLiteralExpression expression) {
                DuplicateStringLiteralInspection.this.checkStringLiteralExpression(expression, holder, isOnTheFly);
            }
        };
        if (javaElementVisitor == null) {
            DuplicateStringLiteralInspection.$$$reportNull$$$0(1);
        }
        return javaElementVisitor;
    }

    @NotNull
    public String getDisplayName() {
        String string = InspectionsBundle.message((String)"inspection.duplicates.display.name", (Object[])new Object[0]);
        if (string == null) {
            DuplicateStringLiteralInspection.$$$reportNull$$$0(2);
        }
        return string;
    }

    @NotNull
    public String getGroupDisplayName() {
        String string = GroupNames.INTERNATIONALIZATION_GROUP_NAME;
        if (string == null) {
            DuplicateStringLiteralInspection.$$$reportNull$$$0(3);
        }
        return string;
    }

    @NotNull
    public String getShortName() {
        if ("DuplicateStringLiteralInspection" == null) {
            DuplicateStringLiteralInspection.$$$reportNull$$$0(4);
        }
        return "DuplicateStringLiteralInspection";
    }

    @NotNull
    private Set<PsiFile> getCandidateFiles(@NotNull String stringToFind, @NotNull Project project) {
        if (stringToFind == null) {
            DuplicateStringLiteralInspection.$$$reportNull$$$0(5);
        }
        if (project == null) {
            DuplicateStringLiteralInspection.$$$reportNull$$$0(6);
        }
        GlobalSearchScope scope = GlobalSearchScope.projectScope((Project)project);
        PsiSearchHelper searchHelper = PsiSearchHelper.SERVICE.getInstance((Project)project);
        List words = StringUtil.getWordsInStringLongestFirst((String)stringToFind);
        if (words.isEmpty()) {
            Set<PsiFile> set = Collections.emptySet();
            if (set == null) {
                DuplicateStringLiteralInspection.$$$reportNull$$$0(7);
            }
            return set;
        }
        THashSet resultFiles = null;
        for (String word : words) {
            if (word.length() < this.MIN_STRING_LENGTH) continue;
            ProgressManager.checkCanceled();
            THashSet files = new THashSet();
            Processor processor = Processors.cancelableCollectProcessor((Collection)files);
            searchHelper.processAllFilesWithWordInLiterals(word, scope, processor);
            if (resultFiles == null) {
                resultFiles = files;
            } else {
                resultFiles.retainAll((Collection<?>)files);
            }
            if (!resultFiles.isEmpty()) continue;
            Set<PsiFile> set = Collections.emptySet();
            if (set == null) {
                DuplicateStringLiteralInspection.$$$reportNull$$$0(8);
            }
            return set;
        }
        THashSet tHashSet = resultFiles != null ? resultFiles : Collections.emptySet();
        if (tHashSet == null) {
            DuplicateStringLiteralInspection.$$$reportNull$$$0(9);
        }
        return tHashSet;
    }

    @NotNull
    private List<PsiLiteralExpression> findDuplicateLiterals(@NotNull String stringToFind, @NotNull Project project) {
        Set<PsiFile> resultFiles;
        if (stringToFind == null) {
            DuplicateStringLiteralInspection.$$$reportNull$$$0(10);
        }
        if (project == null) {
            DuplicateStringLiteralInspection.$$$reportNull$$$0(11);
        }
        if ((resultFiles = this.getCandidateFiles(stringToFind, project)).isEmpty()) {
            List<PsiLiteralExpression> list = Collections.emptyList();
            if (list == null) {
                DuplicateStringLiteralInspection.$$$reportNull$$$0(12);
            }
            return list;
        }
        ArrayList<PsiLiteralExpression> foundExpr = new ArrayList<PsiLiteralExpression>();
        for (PsiFile file : resultFiles) {
            ProgressManager.checkCanceled();
            FileViewProvider viewProvider = file.getViewProvider();
            if (viewProvider.getPsi((Language)JavaLanguage.INSTANCE) == null) continue;
            CharSequence text = viewProvider.getContents();
            StringSearcher searcher = new StringSearcher(stringToFind, true, true);
            LowLevelSearchUtil.processTextOccurrences((CharSequence)text, (int)0, (int)text.length(), (StringSearcher)searcher, (ProgressIndicator)ProgressManager.getInstance().getProgressIndicator(), offset -> {
                PsiElement element;
                if (stringToFind == null) {
                    DuplicateStringLiteralInspection.$$$reportNull$$$0(34);
                }
                if ((element = file.findElementAt(offset)) == null || !(element.getParent() instanceof PsiLiteralExpression)) {
                    return true;
                }
                PsiLiteralExpression expression = (PsiLiteralExpression)element.getParent();
                if (Comparing.equal((Object)stringToFind, (Object)expression.getValue()) && this.shouldCheck(expression)) {
                    foundExpr.add(expression);
                }
                return true;
            });
        }
        ArrayList<PsiLiteralExpression> arrayList = foundExpr;
        if (arrayList == null) {
            DuplicateStringLiteralInspection.$$$reportNull$$$0(13);
        }
        return arrayList;
    }

    /*
     * WARNING - void declaration
     */
    private void checkStringLiteralExpression(@NotNull PsiLiteralExpression originalExpression, @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        void var7_14;
        List<PsiLiteralExpression> foundExpr;
        if (originalExpression == null) {
            DuplicateStringLiteralInspection.$$$reportNull$$$0(14);
        }
        if (holder == null) {
            DuplicateStringLiteralInspection.$$$reportNull$$$0(15);
        }
        if ((foundExpr = this.getDuplicateLiterals(holder.getProject(), originalExpression)).isEmpty()) {
            return;
        }
        THashSet classes = new THashSet();
        for (PsiElement psiElement : foundExpr) {
            void var7_9;
            PsiElement psiElement2;
            ProgressManager.checkCanceled();
            while ((psiElement2 = PsiTreeUtil.getParentOfType((PsiElement)var7_9, PsiClass.class)) != null && ((PsiClass)psiElement2).getQualifiedName() == null) {
            }
            if (psiElement2 == null) continue;
            classes.add((PsiClass)psiElement2);
        }
        if (classes.isEmpty()) {
            return;
        }
        List<PsiClass> tenClassesMost = Arrays.asList(classes.toArray(PsiClass.EMPTY_ARRAY));
        if (tenClassesMost.size() > 10) {
            tenClassesMost = tenClassesMost.subList(0, 10);
        }
        if (isOnTheFly) {
            String string = StringUtil.join(tenClassesMost, aClass -> {
                if (originalExpression == null) {
                    DuplicateStringLiteralInspection.$$$reportNull$$$0(33);
                }
                boolean thisFile = aClass.getContainingFile() == originalExpression.getContainingFile();
                return "&nbsp;&nbsp;&nbsp;'<b>" + aClass.getQualifiedName() + "</b>'" + (thisFile ? " " + InspectionsBundle.message((String)"inspection.duplicates.message.in.this.file", (Object[])new Object[0]) : "");
            }, (String)", <br>");
        } else {
            String string = StringUtil.join(tenClassesMost, aClass -> "'" + aClass.getQualifiedName() + "'", (String)", ");
        }
        if (classes.size() > tenClassesMost.size()) {
            void var7_12;
            String string = (String)var7_12 + BR + InspectionsBundle.message((String)"inspection.duplicates.message.more", (Object[])new Object[]{classes.size() - 10});
        }
        String msg = InspectionsBundle.message((String)"inspection.duplicates.message", (Object[])new Object[]{var7_14});
        SmartList fixes = new SmartList();
        if (isOnTheFly) {
            fixes.add(DuplicateStringLiteralInspection.createIntroduceConstFix(foundExpr, originalExpression));
            fixes.add(new NavigateToOccurrencesFix(originalExpression));
        }
        DuplicateStringLiteralInspection.createReplaceFixes(foundExpr, originalExpression, (Collection<LocalQuickFix>)fixes);
        LocalQuickFix[] array = fixes.toArray(LocalQuickFix.EMPTY_ARRAY);
        holder.registerProblem((PsiElement)originalExpression, msg, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, array);
    }

    @NotNull
    private List<PsiLiteralExpression> getDuplicateLiterals(@NotNull Project project, @NotNull PsiLiteralExpression place) {
        Object value;
        if (project == null) {
            DuplicateStringLiteralInspection.$$$reportNull$$$0(16);
        }
        if (place == null) {
            DuplicateStringLiteralInspection.$$$reportNull$$$0(17);
        }
        if (!((value = place.getValue()) instanceof String)) {
            List<PsiLiteralExpression> list = Collections.emptyList();
            if (list == null) {
                DuplicateStringLiteralInspection.$$$reportNull$$$0(18);
            }
            return list;
        }
        if (!this.shouldCheck(place)) {
            List<PsiLiteralExpression> list = Collections.emptyList();
            if (list == null) {
                DuplicateStringLiteralInspection.$$$reportNull$$$0(19);
            }
            return list;
        }
        String stringToFind = (String)value;
        if (stringToFind.isEmpty()) {
            List<PsiLiteralExpression> list = Collections.emptyList();
            if (list == null) {
                DuplicateStringLiteralInspection.$$$reportNull$$$0(20);
            }
            return list;
        }
        Map map = (Map)CachedValuesManager.getManager((Project)project).getCachedValue((UserDataHolder)project, () -> {
            if (project == null) {
                DuplicateStringLiteralInspection.$$$reportNull$$$0(31);
            }
            ConcurrentMap duplicates = ConcurrentFactoryMap.createMap(s -> {
                if (project == null) {
                    DuplicateStringLiteralInspection.$$$reportNull$$$0(32);
                }
                return Collections.unmodifiableList(this.findDuplicateLiterals((String)s, project));
            });
            return CachedValueProvider.Result.create((Object)duplicates, (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT});
        });
        List list = ContainerUtil.filter((Collection)((Collection)map.get(stringToFind)), literal -> {
            if (place == null) {
                DuplicateStringLiteralInspection.$$$reportNull$$$0(30);
            }
            return literal != place;
        });
        if (list == null) {
            DuplicateStringLiteralInspection.$$$reportNull$$$0(21);
        }
        return list;
    }

    private boolean shouldCheck(@NotNull PsiLiteralExpression expression) {
        if (expression == null) {
            DuplicateStringLiteralInspection.$$$reportNull$$$0(22);
        }
        if (this.IGNORE_PROPERTY_KEYS && JavaI18nUtil.mustBePropertyKey((PsiExpression)expression, (Map<String, Object>)new THashMap())) {
            return false;
        }
        return !SuppressManager.isSuppressedInspectionName((PsiLiteralExpression)expression);
    }

    private static void createReplaceFixes(@NotNull List<PsiLiteralExpression> foundExpr, @NotNull PsiLiteralExpression originalExpression, @NotNull Collection<LocalQuickFix> fixes) {
        if (foundExpr == null) {
            DuplicateStringLiteralInspection.$$$reportNull$$$0(23);
        }
        if (originalExpression == null) {
            DuplicateStringLiteralInspection.$$$reportNull$$$0(24);
        }
        if (fixes == null) {
            DuplicateStringLiteralInspection.$$$reportNull$$$0(25);
        }
        THashSet constants = new THashSet();
        Iterator<PsiLiteralExpression> iterator = foundExpr.iterator();
        while (iterator.hasNext()) {
            PsiField field;
            PsiExpression expression1 = (PsiExpression)iterator.next();
            PsiElement parent = expression1.getParent();
            if (!(parent instanceof PsiField) || (field = (PsiField)parent).getInitializer() != expression1 || !field.hasModifierProperty("static")) continue;
            constants.add(field);
            iterator.remove();
        }
        for (PsiField constant : constants) {
            boolean isAccessible;
            PsiClass containingClass = constant.getContainingClass();
            if (containingClass == null || !(isAccessible = JavaPsiFacade.getInstance((Project)constant.getProject()).getResolveHelper().isAccessible((PsiMember)constant, (PsiElement)originalExpression, containingClass)) && containingClass.getQualifiedName() == null) continue;
            ReplaceFix replaceQuickFix = new ReplaceFix(constant, originalExpression);
            fixes.add((LocalQuickFix)replaceQuickFix);
        }
    }

    @NotNull
    private static LocalQuickFix createIntroduceConstFix(@NotNull List<PsiLiteralExpression> foundExpr, @NotNull PsiLiteralExpression originalExpression) {
        if (foundExpr == null) {
            DuplicateStringLiteralInspection.$$$reportNull$$$0(26);
        }
        if (originalExpression == null) {
            DuplicateStringLiteralInspection.$$$reportNull$$$0(27);
        }
        PsiLiteralExpression[] expressions = foundExpr.toArray(new PsiLiteralExpression[foundExpr.size() + 1]);
        expressions[foundExpr.size()] = originalExpression;
        IntroduceLiteralConstantFix introduceLiteralConstantFix = new IntroduceLiteralConstantFix(expressions);
        if (introduceLiteralConstantFix == null) {
            DuplicateStringLiteralInspection.$$$reportNull$$$0(28);
        }
        return introduceLiteralConstantFix;
    }

    @Nullable
    private static PsiReferenceExpression createReferenceTo(@NotNull PsiField constant) throws IncorrectOperationException {
        if (constant == null) {
            DuplicateStringLiteralInspection.$$$reportNull$$$0(29);
        }
        PsiElementFactory factory = JavaPsiFacade.getInstance((Project)constant.getProject()).getElementFactory();
        PsiReferenceExpression reference = (PsiReferenceExpression)factory.createExpressionFromText("XXX." + constant.getName(), null);
        PsiReferenceExpression classQualifier = (PsiReferenceExpression)reference.getQualifierExpression();
        PsiClass containingClass = constant.getContainingClass();
        if (containingClass.getQualifiedName() == null) {
            return null;
        }
        classQualifier.bindToElement((PsiElement)containingClass);
        if (reference.isReferenceTo((PsiElement)constant)) {
            return reference;
        }
        return null;
    }

    public boolean isEnabledByDefault() {
        return false;
    }

    public JComponent createOptionsPanel() {
        final OptionsPanel optionsPanel = new OptionsPanel();
        optionsPanel.myIgnorePropertyKeyExpressions.addActionListener(e -> {
            this.IGNORE_PROPERTY_KEYS = optionsPanel.myIgnorePropertyKeyExpressions.isSelected();
        });
        optionsPanel.myMinStringLengthField.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(DocumentEvent e) {
                try {
                    DuplicateStringLiteralInspection.this.MIN_STRING_LENGTH = Integer.parseInt(optionsPanel.myMinStringLengthField.getText());
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        });
        optionsPanel.myIgnorePropertyKeyExpressions.setSelected(this.IGNORE_PROPERTY_KEYS);
        optionsPanel.myMinStringLengthField.setText(Integer.toString(this.MIN_STRING_LENGTH));
        return optionsPanel.myPanel;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 7: 
            case 8: 
            case 9: 
            case 12: 
            case 13: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 28: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 7: 
            case 8: 
            case 9: 
            case 12: 
            case 13: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 28: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 7: 
            case 8: 
            case 9: 
            case 12: 
            case 13: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/duplicateStringLiteral/DuplicateStringLiteralInspection";
                break;
            }
            case 5: 
            case 10: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stringToFind";
                break;
            }
            case 6: 
            case 11: 
            case 16: 
            case 31: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 14: 
            case 24: 
            case 27: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "originalExpression";
                break;
            }
            case 17: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 23: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "foundExpr";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fixes";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "constant";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/duplicateStringLiteral/DuplicateStringLiteralInspection";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildVisitor";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getGroupDisplayName";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getShortName";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getCandidateFiles";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "findDuplicateLiterals";
                break;
            }
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getDuplicateLiterals";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "createIntroduceConstFix";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 7: 
            case 8: 
            case 9: 
            case 12: 
            case 13: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 28: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getCandidateFiles";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "findDuplicateLiterals";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "checkStringLiteralExpression";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getDuplicateLiterals";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "shouldCheck";
                break;
            }
            case 23: 
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "createReplaceFixes";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "createIntroduceConstFix";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "createReferenceTo";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getDuplicateLiterals$5";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getDuplicateLiterals$4";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "lambda$null$3";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "lambda$checkStringLiteralExpression$1";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "lambda$findDuplicateLiterals$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 7: 
            case 8: 
            case 9: 
            case 12: 
            case 13: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 28: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class NavigateToOccurrencesFix
    extends LocalQuickFixOnPsiElement {
        NavigateToOccurrencesFix(PsiLiteralExpression representative) {
            super((PsiElement)representative);
        }

        public boolean startInWriteAction() {
            return false;
        }

        public void invoke(@NotNull Project project, @NotNull PsiFile file, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
            if (project == null) {
                NavigateToOccurrencesFix.$$$reportNull$$$0(0);
            }
            if (file == null) {
                NavigateToOccurrencesFix.$$$reportNull$$$0(1);
            }
            if (startElement == null) {
                NavigateToOccurrencesFix.$$$reportNull$$$0(2);
            }
            if (endElement == null) {
                NavigateToOccurrencesFix.$$$reportNull$$$0(3);
            }
            if (!(startElement instanceof PsiLiteralExpression)) {
                return;
            }
            final PsiLiteralExpression literal = (PsiLiteralExpression)startElement;
            List duplicates = DuplicateStringLiteralInspection.this.getDuplicateLiterals(file.getProject(), literal);
            PsiLiteralExpression[] literalExpressions = (PsiLiteralExpression[])Stream.concat(duplicates.stream(), Stream.of(literal)).toArray(PsiLiteralExpression[]::new);
            Usage[] usages = (Usage[])Stream.of(literalExpressions).map(UsageInfo::new).map(UsageInfo2UsageAdapter::new).toArray(Usage[]::new);
            UsageViewPresentation presentation = new UsageViewPresentation();
            String title = InspectionsBundle.message((String)"inspection.duplicates.occurrences.view.title", (Object[])new Object[]{literal.getValue()});
            presentation.setUsagesString(title);
            presentation.setTabName(title);
            presentation.setTabText(title);
            presentation.setShowCancelButton(true);
            UsageView view = UsageViewManager.getInstance((Project)project).showUsages(new UsageTarget[]{new PsiElement2UsageTargetAdapter((PsiElement)literal){

                public String getPresentableText() {
                    return "String literal: '" + literal.getValue() + "'";
                }
            }}, usages, presentation);
            view.addButtonToLowerPane(() -> {
                if (project == null) {
                    NavigateToOccurrencesFix.$$$reportNull$$$0(6);
                }
                new IntroduceLiteralConstantFix(literalExpressions).applyFix(project);
                view.close();
            }, InspectionsBundle.message((String)"introduce.constant.across.the.project", (Object[])new Object[0]));
        }

        @NotNull
        public String getText() {
            String string = this.getFamilyName();
            if (string == null) {
                NavigateToOccurrencesFix.$$$reportNull$$$0(4);
            }
            return string;
        }

        @Nls
        @NotNull
        public String getFamilyName() {
            String string = InspectionsBundle.message((String)"inspection.duplicates.navigate.to.occurrences", (Object[])new Object[0]);
            if (string == null) {
                NavigateToOccurrencesFix.$$$reportNull$$$0(5);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 4: 
                case 5: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 4: 
                case 5: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "startElement";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "endElement";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInspection/duplicateStringLiteral/DuplicateStringLiteralInspection$NavigateToOccurrencesFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInspection/duplicateStringLiteral/DuplicateStringLiteralInspection$NavigateToOccurrencesFix";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getText";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "invoke";
                    break;
                }
                case 4: 
                case 5: {
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "lambda$invoke$2";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 4: 
                case 5: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class ReplaceFix
    extends LocalQuickFixAndIntentionActionOnPsiElement {
        private final String myText;
        private final SmartPsiElementPointer<PsiField> myConst;

        private ReplaceFix(PsiField constant, PsiLiteralExpression originalExpression) {
            super((PsiElement)originalExpression);
            this.myText = InspectionsBundle.message((String)"inspection.duplicates.replace.quickfix", (Object[])new Object[]{PsiFormatUtil.formatVariable((PsiVariable)constant, (int)6145, (PsiSubstitutor)PsiSubstitutor.EMPTY)});
            this.myConst = SmartPointerManager.getInstance((Project)constant.getProject()).createSmartPsiElementPointer((PsiElement)constant);
        }

        @NotNull
        public String getText() {
            String string = this.myText;
            if (string == null) {
                ReplaceFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        public void invoke(@NotNull Project project, @NotNull PsiFile file, @Nullable(value="is null when called from inspection") Editor editor, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
            if (project == null) {
                ReplaceFix.$$$reportNull$$$0(1);
            }
            if (file == null) {
                ReplaceFix.$$$reportNull$$$0(2);
            }
            if (startElement == null) {
                ReplaceFix.$$$reportNull$$$0(3);
            }
            if (endElement == null) {
                ReplaceFix.$$$reportNull$$$0(4);
            }
            PsiLiteralExpression myOriginalExpression = (PsiLiteralExpression)startElement;
            PsiField myConstant = (PsiField)this.myConst.getElement();
            if (myConstant == null) {
                return;
            }
            PsiExpression initializer = myConstant.getInitializer();
            if (!(initializer instanceof PsiLiteralExpression)) {
                return;
            }
            try {
                PsiReferenceExpression newReference;
                PsiReferenceExpression reference = DuplicateStringLiteralInspection.createReferenceTo(myConstant);
                if (reference != null && UnnecessarilyQualifiedStaticUsageInspection.isUnnecessarilyQualifiedAccess((PsiJavaCodeReferenceElement)(newReference = (PsiReferenceExpression)myOriginalExpression.replace((PsiElement)reference)), (boolean)false, (boolean)false, (boolean)true)) {
                    newReference.getChildren()[0].delete();
                }
            }
            catch (IncorrectOperationException e) {
                LOG.error((Throwable)e);
            }
        }

        @NotNull
        public String getFamilyName() {
            String string = InspectionsBundle.message((String)"inspection.duplicates.replace.family.quickfix", (Object[])new Object[0]);
            if (string == null) {
                ReplaceFix.$$$reportNull$$$0(5);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInspection/duplicateStringLiteral/DuplicateStringLiteralInspection$ReplaceFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "startElement";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "endElement";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getText";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInspection/duplicateStringLiteral/DuplicateStringLiteralInspection$ReplaceFix";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "invoke";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class IntroduceLiteralConstantFix
    implements LocalQuickFix {
        private final SmartPsiElementPointer[] myExpressions;

        IntroduceLiteralConstantFix(PsiLiteralExpression[] expressions) {
            this.myExpressions = new SmartPsiElementPointer[expressions.length];
            for (int i = 0; i < expressions.length; ++i) {
                PsiLiteralExpression expression = expressions[i];
                this.myExpressions[i] = SmartPointerManager.getInstance((Project)expression.getProject()).createSmartPsiElementPointer((PsiElement)expression);
            }
        }

        @NotNull
        public String getFamilyName() {
            String string = InspectionsBundle.message((String)"introduce.constant.across.the.project", (Object[])new Object[0]);
            if (string == null) {
                IntroduceLiteralConstantFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        public boolean startInWriteAction() {
            return false;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            if (project == null) {
                IntroduceLiteralConstantFix.$$$reportNull$$$0(1);
            }
            if (descriptor == null) {
                IntroduceLiteralConstantFix.$$$reportNull$$$0(2);
            }
            this.applyFix(project);
        }

        private void applyFix(@NotNull Project project) {
            if (project == null) {
                IntroduceLiteralConstantFix.$$$reportNull$$$0(3);
            }
            ArrayList<PsiExpression> expressions = new ArrayList<PsiExpression>();
            for (SmartPsiElementPointer ptr : this.myExpressions) {
                PsiElement element = ptr.getElement();
                if (element == null) continue;
                expressions.add((PsiExpression)element);
            }
            final PsiExpression[] expressionArray = expressions.toArray(PsiExpression.EMPTY_ARRAY);
            IntroduceConstantHandler handler = new IntroduceConstantHandler(){

                protected OccurrenceManager createOccurrenceManager(PsiExpression selectedExpr, PsiClass parentClass) {
                    return new BaseOccurrenceManager(occurrence -> true){

                        protected PsiExpression[] defaultOccurrences() {
                            return expressionArray;
                        }

                        protected PsiExpression[] findOccurrences() {
                            return expressionArray;
                        }
                    };
                }
            };
            handler.invoke(project, expressionArray);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInspection/duplicateStringLiteral/DuplicateStringLiteralInspection$IntroduceLiteralConstantFix";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInspection/duplicateStringLiteral/DuplicateStringLiteralInspection$IntroduceLiteralConstantFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static class OptionsPanel {
        private JTextField myMinStringLengthField;
        private JPanel myPanel;
        private JCheckBox myIgnorePropertyKeyExpressions;

        public OptionsPanel() {
            this.$$$setupUI$$$();
        }

        private /* synthetic */ void $$$setupUI$$$() {
            JCheckBox jCheckBox;
            JTextField jTextField;
            JPanel jPanel;
            this.myPanel = jPanel = new JPanel();
            jPanel.setLayout((LayoutManager)new GridLayoutManager(3, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
            this.myMinStringLengthField = jTextField = new JTextField();
            jTextField.setColumns(3);
            jPanel.add((Component)jTextField, new GridConstraints(0, 1, 1, 1, 8, 1, 0, 0, null, new Dimension(40, -1), null));
            JLabel jLabel = new JLabel();
            this.$$$loadLabelText$$$(jLabel, ResourceBundle.getBundle("messages/InspectionsBundle").getString("inspection.duplicates.option"));
            jPanel.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
            this.myIgnorePropertyKeyExpressions = jCheckBox = new JCheckBox();
            this.$$$loadButtonText$$$(jCheckBox, ResourceBundle.getBundle("messages/InspectionsBundle").getString("inspection.duplicates.option.report.propertykey.expressions"));
            jPanel.add((Component)jCheckBox, new GridConstraints(1, 0, 1, 3, 8, 0, 3, 0, null, null, null));
            Spacer spacer = new Spacer();
            jPanel.add((Component)spacer, new GridConstraints(2, 0, 1, 3, 0, 2, 1, 6, null, null, null));
            Spacer spacer2 = new Spacer();
            jPanel.add((Component)spacer2, new GridConstraints(0, 2, 1, 1, 0, 1, 6, 1, null, null, null));
            jLabel.setLabelFor(jTextField);
        }

        public /* synthetic */ JComponent $$$getRootComponent$$$() {
            return this.myPanel;
        }

        private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
            StringBuffer stringBuffer = new StringBuffer();
            boolean bl = false;
            char c = '\u0000';
            int n = -1;
            for (int i = 0; i < string.length(); ++i) {
                if (string.charAt(i) == '&') {
                    if (++i == string.length()) break;
                    if (!bl && string.charAt(i) != '&') {
                        bl = true;
                        c = string.charAt(i);
                        n = stringBuffer.length();
                    }
                }
                stringBuffer.append(string.charAt(i));
            }
            jLabel.setText(stringBuffer.toString());
            if (bl) {
                jLabel.setDisplayedMnemonic(c);
                jLabel.setDisplayedMnemonicIndex(n);
            }
        }

        private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
            StringBuffer stringBuffer = new StringBuffer();
            boolean bl = false;
            char c = '\u0000';
            int n = -1;
            for (int i = 0; i < string.length(); ++i) {
                if (string.charAt(i) == '&') {
                    if (++i == string.length()) break;
                    if (!bl && string.charAt(i) != '&') {
                        bl = true;
                        c = string.charAt(i);
                        n = stringBuffer.length();
                    }
                }
                stringBuffer.append(string.charAt(i));
            }
            abstractButton.setText(stringBuffer.toString());
            if (bl) {
                abstractButton.setMnemonic(c);
                abstractButton.setDisplayedMnemonicIndex(n);
            }
        }
    }
}

