/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.dom.model.completion;

import com.google.common.collect.Sets;
import com.intellij.codeInsight.completion.CompletionContributor;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.CompletionService;
import com.intellij.codeInsight.completion.CompletionType;
import com.intellij.codeInsight.completion.impl.NegatingComparable;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.codeInsight.lookup.LookupElementWeigher;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlText;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomManager;
import com.intellij.util.xml.GenericDomValue;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.dom.MavenVersionComparable;
import org.jetbrains.idea.maven.dom.converters.MavenArtifactCoordinatesVersionConverter;
import org.jetbrains.idea.maven.dom.model.MavenDomArtifactCoordinates;
import org.jetbrains.idea.maven.dom.model.MavenDomPlugin;
import org.jetbrains.idea.maven.indices.MavenProjectIndicesManager;
import org.jetbrains.idea.maven.utils.MavenArtifactUtil;

public class MavenVersionCompletionContributor
extends CompletionContributor {
    public void fillCompletionVariants(@NotNull CompletionParameters parameters, @NotNull CompletionResultSet result) {
        if (parameters == null) {
            MavenVersionCompletionContributor.$$$reportNull$$$0(0);
        }
        if (result == null) {
            MavenVersionCompletionContributor.$$$reportNull$$$0(1);
        }
        if (parameters.getCompletionType() != CompletionType.BASIC) {
            return;
        }
        PsiElement element = parameters.getPosition();
        PsiElement xmlText = element.getParent();
        if (!(xmlText instanceof XmlText)) {
            return;
        }
        PsiElement tagElement = xmlText.getParent();
        if (!(tagElement instanceof XmlTag)) {
            return;
        }
        XmlTag tag = (XmlTag)tagElement;
        Project project = element.getProject();
        DomElement domElement = DomManager.getDomManager((Project)project).getDomElement(tag);
        if (!(domElement instanceof GenericDomValue)) {
            return;
        }
        DomElement parent = domElement.getParent();
        if (parent instanceof MavenDomArtifactCoordinates && ((GenericDomValue)domElement).getConverter() instanceof MavenArtifactCoordinatesVersionConverter) {
            Sets.SetView versions;
            MavenDomArtifactCoordinates coordinates = (MavenDomArtifactCoordinates)parent;
            String groupId = coordinates.getGroupId().getStringValue();
            String artifactId = coordinates.getArtifactId().getStringValue();
            if (StringUtil.isEmptyOrSpaces((String)artifactId)) {
                return;
            }
            CompletionResultSet newResultSet = result.withRelevanceSorter(CompletionService.getCompletionService().emptySorter().weigh(new LookupElementWeigher("mavenVersionWeigher"){

                @Nullable
                public Comparable weigh(@NotNull LookupElement element) {
                    if (element == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    return new NegatingComparable((Comparable)new MavenVersionComparable(element.getLookupString()));
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/idea/maven/dom/model/completion/MavenVersionCompletionContributor$1", "weigh"));
                }
            }));
            MavenProjectIndicesManager indicesManager = MavenProjectIndicesManager.getInstance(project);
            if (StringUtil.isEmptyOrSpaces((String)groupId)) {
                if (!(coordinates instanceof MavenDomPlugin)) {
                    return;
                }
                versions = indicesManager.getVersions(MavenArtifactUtil.DEFAULT_GROUPS[0], artifactId);
                for (int i = 0; i < MavenArtifactUtil.DEFAULT_GROUPS.length; ++i) {
                    versions = Sets.union(versions, indicesManager.getVersions(MavenArtifactUtil.DEFAULT_GROUPS[i], artifactId));
                }
            } else {
                versions = indicesManager.getVersions(groupId, artifactId);
            }
            for (String version : versions) {
                newResultSet.addElement((LookupElement)LookupElementBuilder.create((String)version));
            }
            newResultSet.addElement((LookupElement)LookupElementBuilder.create((String)"RELEASE"));
            newResultSet.addElement((LookupElement)LookupElementBuilder.create((String)"LATEST"));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "parameters";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "result";
                break;
            }
        }
        objectArray[1] = "org/jetbrains/idea/maven/dom/model/completion/MavenVersionCompletionContributor";
        objectArray[2] = "fillCompletionVariants";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

