/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.structuralsearch.impl.matcher;

import com.intellij.dupLocator.iterators.ArrayBackedNodeIterator;
import com.intellij.dupLocator.iterators.NodeIterator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiAnnotationParameterList;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiArrayAccessExpression;
import com.intellij.psi.PsiArrayInitializerExpression;
import com.intellij.psi.PsiArrayInitializerMemberValue;
import com.intellij.psi.PsiAssertStatement;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiBlockStatement;
import com.intellij.psi.PsiBreakStatement;
import com.intellij.psi.PsiCatchSection;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassInitializer;
import com.intellij.psi.PsiClassObjectAccessExpression;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiContinueStatement;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiDiamondType;
import com.intellij.psi.PsiDisjunctionType;
import com.intellij.psi.PsiDoWhileStatement;
import com.intellij.psi.PsiDocCommentOwner;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiForStatement;
import com.intellij.psi.PsiForeachStatement;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiInstanceOfExpression;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaReference;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiKeyword;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiMethodReferenceExpression;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNameValuePair;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiPostfixExpression;
import com.intellij.psi.PsiPrefixExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.PsiReferenceParameterList;
import com.intellij.psi.PsiResourceList;
import com.intellij.psi.PsiResourceListElement;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiSuperExpression;
import com.intellij.psi.PsiSwitchLabelStatement;
import com.intellij.psi.PsiSwitchStatement;
import com.intellij.psi.PsiSynchronizedStatement;
import com.intellij.psi.PsiThisExpression;
import com.intellij.psi.PsiThrowStatement;
import com.intellij.psi.PsiTryStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeParameterList;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.PsiWhileStatement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.javadoc.PsiDocComment;
import com.intellij.psi.javadoc.PsiDocTag;
import com.intellij.psi.javadoc.PsiDocTagValue;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.structuralsearch.MatchResult;
import com.intellij.structuralsearch.impl.matcher.CompiledPattern;
import com.intellij.structuralsearch.impl.matcher.GlobalMatchingVisitor;
import com.intellij.structuralsearch.impl.matcher.JavaCompiledPattern;
import com.intellij.structuralsearch.impl.matcher.MatchContext;
import com.intellij.structuralsearch.impl.matcher.MatchResultImpl;
import com.intellij.structuralsearch.impl.matcher.MatchUtils;
import com.intellij.structuralsearch.impl.matcher.handlers.MatchingHandler;
import com.intellij.structuralsearch.impl.matcher.handlers.SubstitutionHandler;
import com.intellij.structuralsearch.impl.matcher.iterators.DocValuesIterator;
import com.intellij.structuralsearch.impl.matcher.iterators.HierarchyNodeIterator;
import com.intellij.structuralsearch.impl.matcher.predicates.MatchPredicate;
import com.intellij.structuralsearch.impl.matcher.predicates.NotPredicate;
import com.intellij.structuralsearch.impl.matcher.predicates.RegExpPredicate;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public class JavaMatchingVisitor
extends JavaElementVisitor {
    public static final String[] MODIFIERS = new String[]{"public", "protected", "private", "static", "abstract", "final", "native", "synchronized", "strictfp", "transient", "volatile", "default"};
    private final GlobalMatchingVisitor myMatchingVisitor;
    private PsiClass myClazz;

    public JavaMatchingVisitor(GlobalMatchingVisitor matchingVisitor) {
        this.myMatchingVisitor = matchingVisitor;
    }

    public void visitComment(PsiComment comment) {
        PsiComment comment2 = null;
        if (!(this.myMatchingVisitor.getElement() instanceof PsiComment)) {
            PsiElement[] children;
            if (this.myMatchingVisitor.getElement() instanceof PsiMember && (children = this.myMatchingVisitor.getElement().getChildren())[0] instanceof PsiComment) {
                comment2 = (PsiComment)children[0];
            }
        } else {
            comment2 = (PsiComment)this.myMatchingVisitor.getElement();
        }
        if (comment2 == null) {
            this.myMatchingVisitor.setResult(false);
            return;
        }
        Object userData = comment.getUserData(CompiledPattern.HANDLER_KEY);
        if (userData instanceof String) {
            String str = (String)userData;
            int end = comment2.getTextLength();
            if (comment2.getTokenType() == JavaTokenType.C_STYLE_COMMENT) {
                end -= 2;
            }
            this.myMatchingVisitor.setResult(((SubstitutionHandler)this.myMatchingVisitor.getMatchContext().getPattern().getHandler(str)).handle((PsiElement)comment2, 2, end, this.myMatchingVisitor.getMatchContext()));
        } else if (userData instanceof MatchingHandler) {
            this.myMatchingVisitor.setResult(((MatchingHandler)userData).match((PsiElement)comment, (PsiElement)comment2, this.myMatchingVisitor.getMatchContext()));
        } else {
            this.myMatchingVisitor.setResult(this.myMatchingVisitor.matchText((PsiElement)comment, (PsiElement)comment2));
        }
    }

    public final void visitModifierList(PsiModifierList list) {
        PsiModifierList list2 = (PsiModifierList)this.myMatchingVisitor.getElement();
        for (String modifier : MODIFIERS) {
            if (!list.hasModifierProperty(modifier) || list2.hasModifierProperty(modifier)) continue;
            this.myMatchingVisitor.setResult(false);
            return;
        }
        PsiAnnotation[] annotations = list.getAnnotations();
        if (annotations.length > 0) {
            HashSet<PsiAnnotation> set = new HashSet<PsiAnnotation>(Arrays.asList(annotations));
            for (PsiAnnotation annotation : annotations) {
                PsiNameValuePair[] attributes;
                PsiJavaCodeReferenceElement nameReferenceElement = annotation.getNameReferenceElement();
                if (nameReferenceElement == null || !"Modifier".equals(nameReferenceElement.getText())) continue;
                PsiAnnotationParameterList parameterList = annotation.getParameterList();
                for (PsiNameValuePair pair : attributes = parameterList.getAttributes()) {
                    PsiAnnotationMemberValue value = pair.getValue();
                    if (value == null) continue;
                    if (value instanceof PsiArrayInitializerMemberValue) {
                        boolean matchedOne = false;
                        for (PsiAnnotationMemberValue v : ((PsiArrayInitializerMemberValue)value).getInitializers()) {
                            if (!JavaMatchingVisitor.annotationValueMatchesModifierList(list2, v)) continue;
                            matchedOne = true;
                            break;
                        }
                        if (matchedOne) continue;
                        this.myMatchingVisitor.setResult(false);
                        return;
                    }
                    if (JavaMatchingVisitor.annotationValueMatchesModifierList(list2, value)) continue;
                    this.myMatchingVisitor.setResult(false);
                    return;
                }
                set.remove(annotation);
            }
            this.myMatchingVisitor.setResult(set.isEmpty() || this.myMatchingVisitor.matchInAnyOrder((PsiElement[])set.toArray(PsiAnnotation.EMPTY_ARRAY), (PsiElement[])list2.getAnnotations()));
        } else {
            this.myMatchingVisitor.setResult(true);
        }
    }

    private static boolean annotationValueMatchesModifierList(PsiModifierList list2, PsiAnnotationMemberValue value) {
        String name = StringUtil.unquoteString((String)value.getText());
        if ("Instance".equals(name)) {
            return !list2.hasModifierProperty("static") && !list2.hasModifierProperty("abstract") && list2.getParent() instanceof PsiMember;
        }
        return list2.hasModifierProperty(name) && (!"packageLocal".equals(name) || list2.getParent() instanceof PsiMember);
    }

    public void visitDocTag(PsiDocTag tag) {
        PsiDocTag tag2 = (PsiDocTag)this.myMatchingVisitor.getElement();
        boolean isTypedVar = this.myMatchingVisitor.getMatchContext().getPattern().isTypedVar(tag.getNameElement());
        if (!this.myMatchingVisitor.setResult(isTypedVar || tag.getName().equals(tag2.getName()))) {
            return;
        }
        PsiDocTagValue psiDocTagValue = tag.getValueElement();
        boolean isTypedValue = false;
        if (psiDocTagValue != null) {
            PsiElement[] children = psiDocTagValue.getChildren();
            if (children.length == 1) {
                psiDocTagValue = children[0];
            }
            if ((isTypedValue = this.myMatchingVisitor.getMatchContext().getPattern().isTypedVar((PsiElement)psiDocTagValue)) && (tag2.getValueElement() != null ? !this.myMatchingVisitor.setResult(this.myMatchingVisitor.handleTypedElement((PsiElement)psiDocTagValue, (PsiElement)tag2.getValueElement())) : !this.myMatchingVisitor.setResult(this.myMatchingVisitor.allowsAbsenceOfMatch((PsiElement)psiDocTagValue)))) {
                return;
            }
        }
        if (!isTypedValue && !this.myMatchingVisitor.setResult(this.myMatchingVisitor.matchInAnyOrder(new DocValuesIterator(tag.getFirstChild()), new DocValuesIterator(tag2.getFirstChild())))) {
            return;
        }
        if (isTypedVar) {
            this.myMatchingVisitor.setResult(this.myMatchingVisitor.handleTypedElement(tag.getNameElement(), tag2.getNameElement()));
        }
    }

    public void visitDocComment(PsiDocComment comment) {
        PsiDocComment comment2;
        if (this.myMatchingVisitor.getElement() instanceof PsiDocCommentOwner) {
            comment2 = ((PsiDocCommentOwner)this.myMatchingVisitor.getElement()).getDocComment();
            if (comment2 == null) {
                this.myMatchingVisitor.setResult(false);
                return;
            }
        } else {
            comment2 = (PsiDocComment)this.myMatchingVisitor.getElement();
            if (this.myMatchingVisitor.getElement().getParent() instanceof PsiDocCommentOwner) {
                this.myMatchingVisitor.setResult(false);
                return;
            }
        }
        if (comment.getTags().length > 0) {
            this.myMatchingVisitor.setResult(this.myMatchingVisitor.matchInAnyOrder((PsiElement[])comment.getTags(), (PsiElement[])comment2.getTags()));
        } else {
            this.visitComment((PsiComment)comment);
        }
    }

    public void visitElement(PsiElement el) {
        this.myMatchingVisitor.setResult(this.myMatchingVisitor.matchText(el, this.myMatchingVisitor.getElement()));
    }

    public void visitArrayInitializerExpression(PsiArrayInitializerExpression expression) {
        PsiArrayInitializerExpression other = this.getExpression(PsiArrayInitializerExpression.class);
        if (other == null) {
            return;
        }
        this.myMatchingVisitor.setResult(this.myMatchingVisitor.matchSequentially(new ArrayBackedNodeIterator((PsiElement[])expression.getInitializers()), new ArrayBackedNodeIterator((PsiElement[])other.getInitializers())));
    }

    public void visitClassInitializer(PsiClassInitializer initializer) {
        PsiClassInitializer initializer2 = (PsiClassInitializer)this.myMatchingVisitor.getElement();
        this.myMatchingVisitor.setResult(this.myMatchingVisitor.match((PsiElement)initializer.getModifierList(), (PsiElement)initializer2.getModifierList()) && this.myMatchingVisitor.matchSons((PsiElement)initializer.getBody(), (PsiElement)initializer2.getBody()));
    }

    public void visitCodeBlock(PsiCodeBlock block) {
        this.myMatchingVisitor.setResult(this.myMatchingVisitor.matchSons((PsiElement)block, this.myMatchingVisitor.getElement()));
    }

    public void visitJavaToken(PsiJavaToken token) {
        PsiElement element = this.myMatchingVisitor.getElement();
        if (!(element instanceof PsiJavaToken)) {
            this.myMatchingVisitor.setResult(this.myMatchingVisitor.matchText((PsiElement)token, element));
        } else {
            PsiJavaToken anotherToken = (PsiJavaToken)element;
            this.myMatchingVisitor.setResult(token.getTokenType() == anotherToken.getTokenType() && this.myMatchingVisitor.matchText((PsiElement)token, (PsiElement)anotherToken));
        }
    }

    public void visitAnnotation(PsiAnnotation annotation) {
        PsiAnnotation other = (PsiAnnotation)this.myMatchingVisitor.getElement();
        this.myMatchingVisitor.setResult(this.myMatchingVisitor.match((PsiElement)annotation.getNameReferenceElement(), (PsiElement)other.getNameReferenceElement()) && this.myMatchingVisitor.matchInAnyOrder((PsiElement[])annotation.getParameterList().getAttributes(), (PsiElement[])other.getParameterList().getAttributes()));
    }

    public void visitNameValuePair(PsiNameValuePair pair) {
        PsiIdentifier nameIdentifier;
        PsiNameValuePair elementNameValuePair = (PsiNameValuePair)this.myMatchingVisitor.getElement();
        PsiAnnotationMemberValue value = pair.getValue();
        if (this.myMatchingVisitor.setResult(this.myMatchingVisitor.match((PsiElement)value, (PsiElement)elementNameValuePair.getValue())) && (nameIdentifier = pair.getNameIdentifier()) != null) {
            PsiIdentifier otherIdentifier = elementNameValuePair.getNameIdentifier();
            MatchingHandler handler = this.myMatchingVisitor.getMatchContext().getPattern().getHandler((PsiElement)nameIdentifier);
            if (handler instanceof SubstitutionHandler) {
                this.myMatchingVisitor.setResult(((SubstitutionHandler)handler).handle((PsiElement)otherIdentifier, this.myMatchingVisitor.getMatchContext()));
            } else {
                this.myMatchingVisitor.setResult("value".equals(nameIdentifier.getText()) && otherIdentifier == null || this.myMatchingVisitor.match((PsiElement)nameIdentifier, (PsiElement)otherIdentifier));
            }
        }
    }

    public void visitAnnotationArrayInitializer(PsiArrayInitializerMemberValue initializer) {
        PsiArrayInitializerMemberValue otherInitializer = (PsiArrayInitializerMemberValue)this.myMatchingVisitor.getElement();
        PsiAnnotationMemberValue[] initializers = initializer.getInitializers();
        this.myMatchingVisitor.setResult(this.myMatchingVisitor.matchSequentially((PsiElement[])initializers, (PsiElement[])otherInitializer.getInitializers()));
    }

    private boolean checkHierarchy(PsiMember element, PsiMember patternElement) {
        MatchingHandler handler = this.myMatchingVisitor.getMatchContext().getPattern().getHandler((PsiElement)patternElement);
        if (handler instanceof SubstitutionHandler) {
            SubstitutionHandler handler2 = (SubstitutionHandler)handler;
            if (!handler2.isSubtype()) {
                if (handler2.isStrictSubtype()) {
                    return element.getContainingClass() != this.myClazz;
                }
            } else {
                return true;
            }
        }
        return this.myClazz == null || element.getContainingClass() == this.myClazz;
    }

    public void visitField(PsiField psiField) {
        PsiDocComment comment = psiField.getDocComment();
        PsiField other = (PsiField)this.myMatchingVisitor.getElement();
        if (comment != null && !this.myMatchingVisitor.setResult(this.myMatchingVisitor.match((PsiElement)comment, (PsiElement)other))) {
            return;
        }
        if (!this.myMatchingVisitor.setResult(this.checkHierarchy((PsiMember)other, (PsiMember)psiField))) {
            return;
        }
        super.visitField(psiField);
    }

    public void visitAnonymousClass(PsiAnonymousClass clazz) {
        PsiAnonymousClass clazz2 = (PsiAnonymousClass)this.myMatchingVisitor.getElement();
        PsiJavaCodeReferenceElement classReference = clazz.getBaseClassReference();
        boolean isTypedVar = this.myMatchingVisitor.getMatchContext().getPattern().isTypedVar((PsiElement)classReference);
        if (this.myMatchingVisitor.setResult((this.myMatchingVisitor.match((PsiElement)clazz.getBaseClassReference(), (PsiElement)clazz2.getBaseClassReference()) || isTypedVar) && this.myMatchingVisitor.matchSons((PsiElement)clazz.getArgumentList(), (PsiElement)clazz2.getArgumentList()) && this.compareClasses((PsiClass)clazz, (PsiClass)clazz2)) && isTypedVar) {
            this.myMatchingVisitor.setResult(this.matchType((PsiElement)classReference, (PsiElement)clazz2.getBaseClassReference()));
        }
    }

    public void visitLambdaExpression(PsiLambdaExpression expression) {
        PsiLambdaExpression other = this.getExpression(PsiLambdaExpression.class);
        if (other == null) {
            return;
        }
        PsiParameterList parameterList1 = expression.getParameterList();
        if (!this.myMatchingVisitor.setResult(parameterList1.isEmpty() || this.myMatchingVisitor.matchSons((PsiElement)parameterList1, (PsiElement)other.getParameterList()))) {
            return;
        }
        PsiElement body1 = JavaMatchingVisitor.getElementToMatch(expression.getBody());
        this.myMatchingVisitor.setResult(body1 == null || this.myMatchingVisitor.matchSequentially(body1, JavaMatchingVisitor.getElementToMatch(other.getBody())));
    }

    private static PsiElement getElementToMatch(PsiElement element) {
        if (element instanceof PsiCodeBlock) {
            element = PsiTreeUtil.getChildOfAnyType((PsiElement)element, (Class[])new Class[]{PsiStatement.class, PsiComment.class});
        }
        if (element instanceof PsiExpressionStatement) {
            element = ((PsiExpressionStatement)element).getExpression();
        }
        if (element instanceof PsiReturnStatement) {
            element = ((PsiReturnStatement)element).getReturnValue();
        }
        return element;
    }

    private boolean matchInAnyOrder(PsiReferenceList elements, PsiReferenceList elements2) {
        if (elements == null && this.myMatchingVisitor.isLeftLooseMatching() || elements == elements2) {
            return true;
        }
        return this.myMatchingVisitor.matchInAnyOrder((PsiElement[])elements.getReferenceElements(), (PsiElement[])(elements2 != null ? elements2.getReferenceElements() : PsiElement.EMPTY_ARRAY));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean compareClasses(PsiClass clazz, PsiClass clazz2) {
        PsiClass saveClazz = this.myClazz;
        this.myClazz = clazz2;
        JavaCompiledPattern javaPattern = (JavaCompiledPattern)this.myMatchingVisitor.getMatchContext().getPattern();
        THashSet matchedElements = new THashSet();
        MatchContext.MatchedElementsListener oldListener = this.myMatchingVisitor.getMatchContext().getMatchedElementsListener();
        this.myMatchingVisitor.getMatchContext().setMatchedElementsListener(arg_0 -> JavaMatchingVisitor.lambda$compareClasses$0((Set)matchedElements, arg_0));
        try {
            PsiClassInitializer[] initializers2;
            PsiClassInitializer[] initializers;
            PsiClass[] nestedClasses;
            PsiMethod[] methods;
            PsiField[] fields;
            boolean accepted;
            boolean templateIsInterface = clazz.isInterface();
            if (templateIsInterface && !clazz2.isInterface()) {
                boolean bl = false;
                return bl;
            }
            if (templateIsInterface && clazz.isAnnotationType() && !clazz2.isAnnotationType()) {
                boolean bl = false;
                return bl;
            }
            if (clazz.isEnum() && !clazz2.isEnum()) {
                boolean bl = false;
                return bl;
            }
            if (clazz instanceof PsiTypeParameter != clazz2 instanceof PsiTypeParameter) {
                boolean bl = false;
                return bl;
            }
            if (!this.matchInAnyOrder(clazz.getExtendsList(), clazz2.getExtendsList())) {
                boolean bl = false;
                return bl;
            }
            PsiReferenceList implementsList = clazz.getImplementsList();
            if (implementsList != null && !this.matchInAnyOrder(implementsList, clazz2.getImplementsList())) {
                PsiReferenceList anotherExtendsList = clazz2.getExtendsList();
                PsiJavaCodeReferenceElement[] referenceElements = implementsList.getReferenceElements();
                accepted = false;
                if (referenceElements.length > 0 && anotherExtendsList != null) {
                    HierarchyNodeIterator iterator = new HierarchyNodeIterator((PsiElement)clazz2, true, true, false);
                    accepted = this.myMatchingVisitor.matchInAnyOrder(new ArrayBackedNodeIterator((PsiElement[])referenceElements), iterator);
                }
                if (!accepted) {
                    boolean iterator = false;
                    return iterator;
                }
            }
            if ((fields = clazz.getFields()).length > 0) {
                PsiField[] fields2;
                PsiField[] psiFieldArray = fields2 = javaPattern.isRequestsSuperFields() ? clazz2.getAllFields() : clazz2.getFields();
                if (!this.myMatchingVisitor.matchInAnyOrder((PsiElement[])fields, (PsiElement[])fields2)) {
                    accepted = false;
                    return accepted;
                }
            }
            if ((methods = clazz.getMethods()).length > 0) {
                PsiMethod[] methods2;
                PsiMethod[] psiMethodArray = methods2 = javaPattern.isRequestsSuperMethods() ? clazz2.getAllMethods() : clazz2.getMethods();
                if (!this.myMatchingVisitor.matchInAnyOrder((PsiElement[])methods, (PsiElement[])methods2)) {
                    boolean iterator = false;
                    return iterator;
                }
            }
            if ((nestedClasses = clazz.getInnerClasses()).length > 0) {
                PsiClass[] nestedClasses2;
                PsiClass[] psiClassArray = nestedClasses2 = javaPattern.isRequestsSuperInners() ? clazz2.getAllInnerClasses() : clazz2.getInnerClasses();
                if (!this.myMatchingVisitor.matchInAnyOrder((PsiElement[])nestedClasses, (PsiElement[])nestedClasses2)) {
                    boolean bl = false;
                    return bl;
                }
            }
            if ((initializers = clazz.getInitializers()).length > 0 && !this.myMatchingVisitor.matchInAnyOrder((PsiElement[])initializers, (PsiElement[])(initializers2 = clazz2.getInitializers()))) {
                boolean bl = false;
                return bl;
            }
            SmartList unmatchedElements = new SmartList((Collection)PsiTreeUtil.getChildrenOfTypeAsList((PsiElement)clazz2, PsiMember.class));
            unmatchedElements.removeAll((Collection<?>)matchedElements);
            MatchingHandler unmatchedSubstitutionHandler = null;
            for (PsiElement element = clazz.getFirstChild(); element != null; element = element.getNextSibling()) {
                if (!(element instanceof PsiTypeElement) || !(element.getNextSibling() instanceof PsiErrorElement)) continue;
                unmatchedSubstitutionHandler = this.myMatchingVisitor.getMatchContext().getPattern().getHandler(element);
                break;
            }
            if (unmatchedSubstitutionHandler instanceof SubstitutionHandler) {
                SubstitutionHandler handler = (SubstitutionHandler)unmatchedSubstitutionHandler;
                for (PsiElement element : unmatchedElements) {
                    handler.handle(element, this.myMatchingVisitor.getMatchContext());
                }
            } else {
                clazz2.putUserData(GlobalMatchingVisitor.UNMATCHED_ELEMENTS_KEY, (Object)unmatchedElements);
            }
            boolean bl = true;
            return bl;
        }
        finally {
            this.myClazz = saveClazz;
            this.myMatchingVisitor.getMatchContext().setMatchedElementsListener(oldListener);
        }
    }

    private boolean matchBody(PsiElement patternElement, PsiElement matchElement) {
        if (this.myMatchingVisitor.getMatchContext().getOptions().isLooseMatching()) {
            if (matchElement instanceof PsiBlockStatement) {
                PsiCodeBlock codeBlock = ((PsiBlockStatement)matchElement).getCodeBlock();
                if (patternElement instanceof PsiBlockStatement || codeBlock.getStatementCount() == 1) {
                    matchElement = codeBlock.getFirstChild();
                }
            }
            if (patternElement instanceof PsiBlockStatement) {
                patternElement = ((PsiBlockStatement)patternElement).getCodeBlock().getFirstChild();
            }
        }
        return this.myMatchingVisitor.matchSequentially(patternElement, matchElement);
    }

    public void visitArrayAccessExpression(PsiArrayAccessExpression slice) {
        PsiArrayAccessExpression other = this.getExpression(PsiArrayAccessExpression.class);
        if (other != null) {
            this.myMatchingVisitor.setResult(this.myMatchingVisitor.match((PsiElement)slice.getArrayExpression(), (PsiElement)other.getArrayExpression()) && this.myMatchingVisitor.match((PsiElement)slice.getIndexExpression(), (PsiElement)other.getIndexExpression()));
        }
    }

    public void visitMethodReferenceExpression(PsiMethodReferenceExpression expression) {
        if (this.getExpression(PsiMethodReferenceExpression.class) == null) {
            return;
        }
        super.visitMethodReferenceExpression(expression);
    }

    public void visitReferenceExpression(PsiReferenceExpression reference) {
        PsiElement target;
        boolean multiMatch;
        MatchContext context = this.myMatchingVisitor.getMatchContext();
        CompiledPattern pattern = context.getPattern();
        MatchingHandler _handler = pattern.getHandlerSimple(reference.getReferenceNameElement());
        boolean special = false;
        if (_handler == null) {
            _handler = pattern.getHandlerSimple((PsiElement)reference);
            special = true;
        }
        PsiElement other = this.myMatchingVisitor.getElement();
        PsiExpression qualifier = reference.getQualifierExpression();
        if (_handler instanceof SubstitutionHandler && (qualifier == null || special)) {
            SubstitutionHandler handler = (SubstitutionHandler)_handler;
            if (handler.isSubtype() || handler.isStrictSubtype()) {
                this.myMatchingVisitor.setResult(this.checkMatchWithinHierarchy(other, handler, (PsiElement)reference));
            } else {
                PsiElement deparenthesized = other instanceof PsiExpression && context.getOptions().isLooseMatching() ? PsiUtil.skipParenthesizedExprDown((PsiExpression)((PsiExpression)other)) : other;
                this.myMatchingVisitor.setResult(handler.validate(deparenthesized, 0, -1, context));
                if (this.myMatchingVisitor.getResult()) {
                    handler.addResult(other, 0, -1, context);
                }
            }
            return;
        }
        boolean bl = multiMatch = other != null && reference.getContainingFile() == other.getContainingFile();
        if (!(other instanceof PsiReferenceExpression)) {
            this.myMatchingVisitor.setResult(multiMatch && this.myMatchingVisitor.matchText((PsiElement)reference, other));
            return;
        }
        PsiReferenceExpression reference2 = (PsiReferenceExpression)other;
        PsiExpression qualifier2 = reference2.getQualifierExpression();
        if (multiMatch && (qualifier == null || qualifier instanceof PsiThisExpression || qualifier instanceof PsiSuperExpression) && (qualifier2 == null || qualifier2 instanceof PsiThisExpression || qualifier2 instanceof PsiSuperExpression) && (target = reference.resolve()) != null) {
            this.myMatchingVisitor.setResult(target == reference2.resolve());
            return;
        }
        if (qualifier == null && qualifier2 == null) {
            this.myMatchingVisitor.setResult(this.myMatchingVisitor.matchText(reference.getReferenceNameElement(), reference2.getReferenceNameElement()));
            return;
        }
        if (!(other.getParent() instanceof PsiMethodCallExpression) && qualifier != null) {
            PsiElement referenceElement = reference.getReferenceNameElement();
            PsiElement referenceElement2 = reference2.getReferenceNameElement();
            if (pattern.isTypedVar(referenceElement) ? !this.myMatchingVisitor.setResult(this.myMatchingVisitor.handleTypedElement(referenceElement, referenceElement2)) : !this.myMatchingVisitor.setResult(this.myMatchingVisitor.matchText(referenceElement, referenceElement2))) {
                return;
            }
            if (qualifier2 != null) {
                this.myMatchingVisitor.setResult(this.myMatchingVisitor.match((PsiElement)qualifier, (PsiElement)qualifier2));
            } else {
                PsiElement referencedElement = MatchUtils.getReferencedElement(other);
                if (referencedElement instanceof PsiField) {
                    PsiField field = (PsiField)referencedElement;
                    if (qualifier instanceof PsiThisExpression) {
                        this.myMatchingVisitor.setResult(!field.hasModifierProperty("static"));
                        return;
                    }
                }
                MatchingHandler handler = pattern.getHandler((PsiElement)qualifier);
                this.myMatchingVisitor.setResult(this.matchImplicitQualifier(handler, referencedElement, context));
            }
            return;
        }
        this.myMatchingVisitor.setResult(false);
    }

    private static int getArrayDimensions(PsiElement element) {
        if (element == null) {
            return 0;
        }
        PsiElement parent = element.getParent();
        if (parent instanceof PsiVariable) {
            PsiVariable variable = (PsiVariable)parent;
            PsiType type = variable.getType();
            return type.getArrayDimensions();
        }
        if (parent instanceof PsiMethod) {
            PsiMethod method = (PsiMethod)parent;
            PsiType type = method.getReturnType();
            return type == null ? 0 : type.getArrayDimensions();
        }
        if (element instanceof PsiTypeElement) {
            PsiTypeElement typeElement = (PsiTypeElement)element;
            PsiType type = typeElement.getType();
            return type.getArrayDimensions();
        }
        return 0;
    }

    private static PsiTypeElement getInnermostComponentTypeElement(PsiTypeElement typeElement) {
        PsiElement child = typeElement.getFirstChild();
        while (child instanceof PsiTypeElement) {
            typeElement = (PsiTypeElement)child;
            child = typeElement.getFirstChild();
        }
        return typeElement;
    }

    private static PsiElement getInnermostComponent(PsiElement element) {
        if (!(element instanceof PsiTypeElement)) {
            return element;
        }
        PsiTypeElement typeElement = (PsiTypeElement)element;
        if (typeElement.getType() instanceof PsiDisjunctionType) {
            return typeElement;
        }
        PsiJavaCodeReferenceElement referenceElement = typeElement.getInnermostComponentReferenceElement();
        return referenceElement != null ? referenceElement : JavaMatchingVisitor.getInnermostComponentTypeElement(typeElement);
    }

    private void copyResults(MatchResultImpl ourResult) {
        if (ourResult.hasSons()) {
            for (MatchResult son : ourResult.getAllSons()) {
                this.myMatchingVisitor.getMatchContext().getResult().addSon((MatchResultImpl)son);
            }
        }
    }

    private static PsiTypeElement[] getTypeParameters(PsiJavaCodeReferenceElement referenceElement, boolean replaceDiamondWithExplicitTypes) {
        PsiReferenceParameterList referenceElementParameterList = referenceElement.getParameterList();
        if (referenceElementParameterList == null) {
            return null;
        }
        PsiTypeElement[] typeParameterElements = referenceElementParameterList.getTypeParameterElements();
        if (typeParameterElements.length != 1 || !replaceDiamondWithExplicitTypes) {
            return typeParameterElements;
        }
        PsiType type = typeParameterElements[0].getType();
        if (!(type instanceof PsiDiamondType)) {
            return typeParameterElements;
        }
        PsiDiamondType diamondType = (PsiDiamondType)type;
        PsiDiamondType.DiamondInferenceResult inferenceResult = diamondType.resolveInferredTypes();
        StringBuilder text = new StringBuilder(referenceElement.getQualifiedName());
        text.append('<');
        boolean comma = false;
        for (PsiType inferredType : inferenceResult.getInferredTypes()) {
            if (comma) {
                text.append(',');
            } else {
                comma = true;
            }
            text.append(inferredType.getCanonicalText());
        }
        text.append('>');
        PsiJavaCodeReferenceElement newReferenceElement = JavaPsiFacade.getElementFactory((Project)referenceElement.getProject()).createReferenceFromText(text.toString(), (PsiElement)referenceElement);
        PsiReferenceParameterList newParameterList = newReferenceElement.getParameterList();
        return newParameterList == null ? null : newParameterList.getTypeParameterElements();
    }

    private static boolean hasDiamondTypeParameter(PsiElement element) {
        if (!(element instanceof PsiJavaCodeReferenceElement)) {
            return false;
        }
        PsiJavaCodeReferenceElement javaCodeReferenceElement = (PsiJavaCodeReferenceElement)element;
        PsiReferenceParameterList parameterList = javaCodeReferenceElement.getParameterList();
        if (parameterList == null) {
            return false;
        }
        PsiTypeElement[] elements = parameterList.getTypeParameterElements();
        return elements.length == 1 && elements[0].getType() instanceof PsiDiamondType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean matchType(PsiElement patternType, PsiElement matchedType) {
        boolean caseSensitive;
        String text2;
        String text;
        boolean equalsIgnorePackage;
        PsiElement parent;
        PsiJavaCodeReferenceElement referenceElement;
        PsiElement patternElement = JavaMatchingVisitor.getInnermostComponent(patternType);
        PsiElement matchedElement = JavaMatchingVisitor.getInnermostComponent(matchedType);
        PsiTypeElement[] typeParameters = null;
        if (matchedElement instanceof PsiJavaCodeReferenceElement) {
            referenceElement = (PsiJavaCodeReferenceElement)matchedElement;
            typeParameters = JavaMatchingVisitor.getTypeParameters(referenceElement, !JavaMatchingVisitor.hasDiamondTypeParameter(patternElement));
        } else if (matchedElement instanceof PsiTypeParameter) {
            matchedElement = ((PsiTypeParameter)matchedElement).getNameIdentifier();
        } else if (matchedElement instanceof PsiClass && ((PsiClass)matchedElement).hasTypeParameters()) {
            typeParameters = ((PsiClass)matchedElement).getTypeParameters();
            matchedElement = ((PsiClass)matchedElement).getNameIdentifier();
        } else if (matchedElement instanceof PsiMethod && ((PsiMethod)matchedElement).hasTypeParameters()) {
            typeParameters = ((PsiMethod)matchedType).getTypeParameters();
            matchedElement = ((PsiMethod)matchedType).getNameIdentifier();
        }
        if (patternElement instanceof PsiJavaCodeReferenceElement) {
            PsiTypeElement[] elements;
            referenceElement = (PsiJavaCodeReferenceElement)patternElement;
            PsiReferenceParameterList list = referenceElement.getParameterList();
            if (!(list == null || (elements = list.getTypeParameterElements()).length <= 0 || typeParameters != null && this.myMatchingVisitor.matchSequentially((PsiElement[])elements, (PsiElement[])typeParameters))) {
                return false;
            }
            patternElement = referenceElement.getReferenceNameElement();
        }
        final int matchedArrayDimensions = JavaMatchingVisitor.getArrayDimensions(matchedType);
        int patternArrayDimensions = JavaMatchingVisitor.getArrayDimensions(patternType);
        if (this.myMatchingVisitor.getMatchContext().getPattern().isTypedVar(patternElement)) {
            SubstitutionHandler handler = (SubstitutionHandler)this.myMatchingVisitor.getMatchContext().getPattern().getHandler(patternElement);
            RegExpPredicate regExpPredicate = null;
            if (patternArrayDimensions != 0) {
                if (patternArrayDimensions != matchedArrayDimensions) {
                    return false;
                }
            } else if (matchedArrayDimensions != 0 && (regExpPredicate = handler.findRegExpPredicate()) != null) {
                regExpPredicate.setNodeTextGenerator(new RegExpPredicate.NodeTextGenerator(){

                    @Override
                    public String getText(PsiElement element) {
                        StringBuilder builder = new StringBuilder(RegExpPredicate.getMeaningfulText(element));
                        for (int i = 0; i < matchedArrayDimensions; ++i) {
                            builder.append("[]");
                        }
                        return builder.toString();
                    }
                });
            }
            try {
                if (handler.isSubtype() || handler.isStrictSubtype()) {
                    boolean bl = this.checkMatchWithinHierarchy(matchedElement, handler, patternElement);
                    return bl;
                }
                boolean bl = handler.handle(matchedElement, this.myMatchingVisitor.getMatchContext());
                return bl;
            }
            finally {
                if (regExpPredicate != null) {
                    regExpPredicate.setNodeTextGenerator(null);
                }
            }
        }
        if (matchedArrayDimensions != patternArrayDimensions) {
            return false;
        }
        if (patternElement instanceof PsiIdentifier && (parent = patternElement.getParent()) instanceof PsiJavaCodeReferenceElement) {
            patternElement = parent;
        }
        if (matchedElement instanceof PsiIdentifier && (parent = matchedElement.getParent()) instanceof PsiJavaCodeReferenceElement) {
            matchedElement = parent;
        }
        if ((equalsIgnorePackage = MatchUtils.compareWithNoDifferenceToPackage(text = JavaMatchingVisitor.getText(patternElement), text2 = JavaMatchingVisitor.getText(matchedElement), !(caseSensitive = this.myMatchingVisitor.getMatchContext().getOptions().isCaseSensitiveMatch()))) || !(matchedElement instanceof PsiJavaReference)) {
            return equalsIgnorePackage;
        }
        PsiElement element2 = ((PsiJavaReference)matchedElement).resolve();
        if (!(element2 instanceof PsiClass)) {
            return false;
        }
        String name = ((PsiClass)element2).getQualifiedName();
        return caseSensitive ? text.equals(name) : text.equalsIgnoreCase(name);
    }

    @Contract(pure=true)
    private static String getText(@NotNull PsiElement element) {
        int index;
        String result;
        if (element == null) {
            JavaMatchingVisitor.$$$reportNull$$$0(0);
        }
        if (element instanceof PsiClass) {
            result = ((PsiClass)element).getQualifiedName();
            if (result == null) {
                result = element.getText();
            }
        } else {
            result = element instanceof PsiJavaCodeReferenceElement ? ((PsiJavaCodeReferenceElement)element).getCanonicalText() : element.getText();
        }
        return (index = result.indexOf(60)) == -1 ? result : result.substring(0, index);
    }

    private boolean checkMatchWithinHierarchy(PsiElement matchElement, SubstitutionHandler handler, PsiElement context) {
        PsiElement grandParentContext;
        boolean includeInterfaces = true;
        boolean includeClasses = true;
        PsiElement contextParent = context.getParent();
        if (contextParent instanceof PsiReferenceList && (grandParentContext = contextParent.getParent()) instanceof PsiClass) {
            PsiClass psiClass = (PsiClass)grandParentContext;
            if (contextParent == psiClass.getExtendsList()) {
                includeInterfaces = psiClass.isInterface();
            } else if (contextParent == psiClass.getImplementsList()) {
                includeClasses = false;
            }
        }
        HierarchyNodeIterator node = new HierarchyNodeIterator(matchElement, includeClasses, includeInterfaces);
        if (handler.isStrictSubtype()) {
            ((NodeIterator)node).advance();
        }
        boolean notPredicate = handler.getPredicate() instanceof NotPredicate;
        while (((NodeIterator)node).hasNext() && !handler.validate(((NodeIterator)node).current(), 0, -1, this.myMatchingVisitor.getMatchContext())) {
            if (notPredicate) {
                return false;
            }
            ((NodeIterator)node).advance();
        }
        if (((NodeIterator)node).hasNext()) {
            handler.addResult(matchElement, 0, -1, this.myMatchingVisitor.getMatchContext());
            return true;
        }
        return false;
    }

    public void visitConditionalExpression(PsiConditionalExpression cond) {
        PsiConditionalExpression cond2 = this.getExpression(PsiConditionalExpression.class);
        if (cond2 == null) {
            return;
        }
        this.myMatchingVisitor.setResult(this.myMatchingVisitor.match((PsiElement)cond.getCondition(), (PsiElement)cond2.getCondition()) && this.myMatchingVisitor.matchSons((PsiElement)cond, (PsiElement)cond2));
    }

    public void visitPolyadicExpression(PsiPolyadicExpression expression) {
        PsiPolyadicExpression expr2 = this.getExpression(PsiPolyadicExpression.class);
        if (expr2 == null) {
            return;
        }
        if (this.myMatchingVisitor.setResult(expression.getOperationTokenType().equals(expr2.getOperationTokenType()))) {
            PsiExpression[] operands1 = expression.getOperands();
            PsiExpression[] operands2 = expr2.getOperands();
            this.myMatchingVisitor.setResult(this.myMatchingVisitor.matchSequentially(new ArrayBackedNodeIterator((PsiElement[])operands1), new ArrayBackedNodeIterator((PsiElement[])operands2)));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void visitVariable(PsiVariable var) {
        this.myMatchingVisitor.getMatchContext().pushResult();
        PsiIdentifier nameIdentifier = var.getNameIdentifier();
        boolean isTypedVar = this.myMatchingVisitor.getMatchContext().getPattern().isTypedVar((PsiElement)nameIdentifier);
        PsiVariable var2 = (PsiVariable)this.myMatchingVisitor.getElement();
        try {
            if (!this.myMatchingVisitor.setResult((this.myMatchingVisitor.matchText((PsiElement)var.getNameIdentifier(), (PsiElement)var2.getNameIdentifier()) || isTypedVar) && this.myMatchingVisitor.match((PsiElement)var.getModifierList(), (PsiElement)var2.getModifierList()))) {
                return;
            }
            PsiTypeElement typeElement1 = var.getTypeElement();
            if (typeElement1 != null) {
                PsiTypeElement typeElement2 = var2.getTypeElement();
                if (typeElement2 == null) {
                    typeElement2 = JavaPsiFacade.getElementFactory((Project)var2.getProject()).createTypeElement(var2.getType());
                }
                if (!this.myMatchingVisitor.setResult(this.myMatchingVisitor.match((PsiElement)typeElement1, (PsiElement)typeElement2))) {
                    return;
                }
            }
            PsiExpression initializer = var.getInitializer();
            PsiExpression var2Initializer = var2.getInitializer();
            this.myMatchingVisitor.setResult(this.myMatchingVisitor.match((PsiElement)initializer, (PsiElement)var2Initializer));
        }
        finally {
            this.saveOrDropResult(nameIdentifier, isTypedVar, var2.getNameIdentifier());
        }
    }

    private void matchArrayDims(PsiNewExpression new1, PsiNewExpression new2) {
        PsiExpression[] arrayDims2;
        PsiExpression[] arrayDims = new1.getArrayDimensions();
        if (arrayDims.length == (arrayDims2 = new2.getArrayDimensions()).length && arrayDims.length != 0) {
            for (int i = 0; i < arrayDims.length; ++i) {
                if (this.myMatchingVisitor.setResult(this.myMatchingVisitor.match((PsiElement)arrayDims[i], (PsiElement)arrayDims2[i]))) continue;
                return;
            }
        } else {
            this.myMatchingVisitor.setResult(arrayDims == arrayDims2 && this.myMatchingVisitor.matchSons((PsiElement)new1.getArgumentList(), (PsiElement)new2.getArgumentList()));
        }
    }

    private void saveOrDropResult(PsiIdentifier methodNameNode, boolean typedVar, PsiIdentifier methodNameNode2) {
        MatchResultImpl ourResult = this.myMatchingVisitor.getMatchContext().hasResult() ? this.myMatchingVisitor.getMatchContext().getResult() : null;
        this.myMatchingVisitor.getMatchContext().popResult();
        if (this.myMatchingVisitor.getResult()) {
            if (typedVar) {
                SubstitutionHandler handler = (SubstitutionHandler)this.myMatchingVisitor.getMatchContext().getPattern().getHandler((PsiElement)methodNameNode);
                if (ourResult != null) {
                    ourResult.setScopeMatch(true);
                }
                handler.setNestedResult(ourResult);
                this.myMatchingVisitor.setResult(handler.handle((PsiElement)methodNameNode2, this.myMatchingVisitor.getMatchContext()));
                if (handler.getNestedResult() != null) {
                    handler.setNestedResult(null);
                    this.copyResults(ourResult);
                }
            } else if (ourResult != null) {
                this.copyResults(ourResult);
            }
        }
    }

    private boolean matchImplicitQualifier(MatchingHandler matchingHandler, PsiElement target, MatchContext context) {
        if (!(matchingHandler instanceof SubstitutionHandler)) {
            return false;
        }
        SubstitutionHandler substitutionHandler = (SubstitutionHandler)matchingHandler;
        if (substitutionHandler.getMinOccurs() != 0) {
            return false;
        }
        MatchPredicate predicate = substitutionHandler.getPredicate();
        if (predicate == null) {
            return true;
        }
        if (target == null) {
            return false;
        }
        if (target instanceof PsiModifierListOwner && ((PsiModifierListOwner)target).hasModifierProperty("static")) {
            return predicate.match(PsiTreeUtil.getParentOfType((PsiElement)target, PsiClass.class), context);
        }
        PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)target.getProject());
        PsiExpression implicitReference = factory.createExpressionFromText("this", target);
        return predicate.match((PsiElement)implicitReference, context);
    }

    public void visitMethodCallExpression(PsiMethodCallExpression mcall) {
        PsiMethodCallExpression mcall2 = this.getExpression(PsiMethodCallExpression.class);
        if (mcall2 == null) {
            return;
        }
        PsiReferenceExpression mcallRef1 = mcall.getMethodExpression();
        PsiReferenceExpression mcallRef2 = mcall2.getMethodExpression();
        PsiElement patternMethodName = mcallRef1.getReferenceNameElement();
        boolean isTypedVar = this.myMatchingVisitor.getMatchContext().getPattern().isTypedVar(patternMethodName);
        if (!isTypedVar && !this.myMatchingVisitor.setResult(this.myMatchingVisitor.matchText(patternMethodName, mcallRef2.getReferenceNameElement()))) {
            return;
        }
        PsiExpression patternQualifier = mcallRef1.getQualifierExpression();
        PsiExpression matchedQualifier = mcallRef2.getQualifierExpression();
        if (patternQualifier != null) {
            if (matchedQualifier != null) {
                if (!this.myMatchingVisitor.setResult(this.myMatchingVisitor.match((PsiElement)patternQualifier, (PsiElement)matchedQualifier))) {
                    return;
                }
            } else {
                PsiMethod method = mcall2.resolveMethod();
                if (method != null && patternQualifier instanceof PsiThisExpression) {
                    this.myMatchingVisitor.setResult(!method.hasModifierProperty("static"));
                    return;
                }
                MatchingHandler handler = this.myMatchingVisitor.getMatchContext().getPattern().getHandler((PsiElement)patternQualifier);
                if (!this.myMatchingVisitor.setResult(this.matchImplicitQualifier(handler, (PsiElement)method, this.myMatchingVisitor.getMatchContext()))) {
                    return;
                }
            }
        }
        if (!this.myMatchingVisitor.setResult(this.myMatchingVisitor.matchSons((PsiElement)mcall.getArgumentList(), (PsiElement)mcall2.getArgumentList()))) {
            return;
        }
        if (!this.myMatchingVisitor.setResult(this.matchTypeParameters((PsiJavaCodeReferenceElement)mcallRef1, (PsiJavaCodeReferenceElement)mcallRef2))) {
            return;
        }
        if (isTypedVar) {
            this.myMatchingVisitor.setResult(this.myMatchingVisitor.handleTypedElement(patternMethodName, mcallRef2.getReferenceNameElement()));
        }
    }

    private boolean matchTypeParameters(PsiJavaCodeReferenceElement mcallRef1, PsiJavaCodeReferenceElement mcallRef2) {
        PsiReferenceParameterList patternParameterList = mcallRef1.getParameterList();
        if (patternParameterList == null) {
            return true;
        }
        PsiTypeElement[] patternTypeElements = patternParameterList.getTypeParameterElements();
        if (patternTypeElements.length == 0) {
            return true;
        }
        PsiReferenceParameterList matchedParameterList = mcallRef2.getParameterList();
        if (matchedParameterList == null) {
            return false;
        }
        if (matchedParameterList.getFirstChild() == null) {
            JavaResolveResult resolveResult = mcallRef2.advancedResolve(false);
            PsiMethod targetMethod = (PsiMethod)resolveResult.getElement();
            if (targetMethod == null) {
                return false;
            }
            PsiTypeParameterList typeParameterList = targetMethod.getTypeParameterList();
            if (typeParameterList == null) {
                return false;
            }
            PsiTypeParameter[] typeParameters = typeParameterList.getTypeParameters();
            PsiSubstitutor substitutor = resolveResult.getSubstitutor();
            matchedParameterList = (PsiReferenceParameterList)matchedParameterList.copy();
            for (PsiTypeParameter typeParameter : typeParameters) {
                PsiType type = substitutor.substitute(typeParameter);
                if (type == null) {
                    return false;
                }
                PsiTypeElement matchedTypeElement = JavaPsiFacade.getElementFactory((Project)mcallRef1.getProject()).createTypeElement(type);
                matchedParameterList.add((PsiElement)matchedTypeElement);
            }
        }
        PsiTypeElement[] matchedTypeElements = matchedParameterList.getTypeParameterElements();
        return this.myMatchingVisitor.matchSequentially((PsiElement[])patternTypeElements, (PsiElement[])matchedTypeElements);
    }

    public void visitExpressionStatement(PsiExpressionStatement expr) {
        PsiElement other = this.myMatchingVisitor.getElement();
        if (this.myMatchingVisitor.setResult(other instanceof PsiExpressionStatement)) {
            PsiExpressionStatement expr2 = (PsiExpressionStatement)other;
            this.myMatchingVisitor.setResult(this.myMatchingVisitor.match((PsiElement)expr.getExpression(), (PsiElement)expr2.getExpression()));
        }
    }

    public void visitLiteralExpression(PsiLiteralExpression const1) {
        PsiLiteralExpression const2 = this.getExpression(PsiLiteralExpression.class);
        if (const2 == null) {
            return;
        }
        MatchingHandler handler = (MatchingHandler)const1.getUserData(CompiledPattern.HANDLER_KEY);
        if (handler instanceof SubstitutionHandler) {
            PsiType type1 = const1.getType();
            if (type1 != null && !type1.equals(const2.getType())) {
                this.myMatchingVisitor.setResult(false);
            } else {
                int offset = 0;
                int length = const2.getTextLength();
                String text = const2.getText();
                if (StringUtil.isQuotedString((String)text)) {
                    --length;
                    ++offset;
                }
                this.myMatchingVisitor.setResult(((SubstitutionHandler)handler).handle((PsiElement)const2, offset, length, this.myMatchingVisitor.getMatchContext()));
            }
        } else if (handler != null) {
            this.myMatchingVisitor.setResult(handler.match((PsiElement)const1, (PsiElement)const2, this.myMatchingVisitor.getMatchContext()));
        } else {
            Object value1 = const1.getValue();
            Object value2 = const2.getValue();
            if ((value1 instanceof String || value1 instanceof Character) && (value2 instanceof String || value2 instanceof Character)) {
                this.myMatchingVisitor.setResult(this.myMatchingVisitor.matchText(value1.toString(), value2.toString()));
            } else if (value1 != null && value2 != null) {
                this.myMatchingVisitor.setResult(value1.equals(value2));
            } else {
                this.myMatchingVisitor.setResult(this.myMatchingVisitor.matchText((PsiElement)const1, (PsiElement)const2));
            }
        }
    }

    public void visitAssignmentExpression(PsiAssignmentExpression assign) {
        PsiAssignmentExpression other = this.getExpression(PsiAssignmentExpression.class);
        if (other != null) {
            this.myMatchingVisitor.setResult(assign.getOperationTokenType().equals(other.getOperationTokenType()) && this.myMatchingVisitor.match((PsiElement)assign.getLExpression(), (PsiElement)other.getLExpression()) && this.myMatchingVisitor.match((PsiElement)assign.getRExpression(), (PsiElement)other.getRExpression()));
        }
    }

    public void visitIfStatement(PsiIfStatement if1) {
        PsiIfStatement if2 = (PsiIfStatement)this.myMatchingVisitor.getElement();
        PsiStatement elseBranch = if1.getElseBranch();
        this.myMatchingVisitor.setResult(this.myMatchingVisitor.match((PsiElement)if1.getCondition(), (PsiElement)if2.getCondition()) && this.matchBody((PsiElement)if1.getThenBranch(), (PsiElement)if2.getThenBranch()) && (elseBranch == null || this.matchBody((PsiElement)elseBranch, (PsiElement)if2.getElseBranch())));
    }

    public void visitSwitchStatement(PsiSwitchStatement switch1) {
        PsiSwitchStatement switch2 = (PsiSwitchStatement)this.myMatchingVisitor.getElement();
        this.myMatchingVisitor.setResult(this.myMatchingVisitor.match((PsiElement)switch1.getExpression(), (PsiElement)switch2.getExpression()) && this.myMatchingVisitor.matchSons((PsiElement)switch1.getBody(), (PsiElement)switch2.getBody()));
    }

    public void visitForStatement(PsiForStatement for1) {
        PsiForStatement for2 = (PsiForStatement)this.myMatchingVisitor.getElement();
        this.myMatchingVisitor.setResult(this.myMatchingVisitor.match((PsiElement)for1.getInitialization(), (PsiElement)for2.getInitialization()) && this.myMatchingVisitor.match((PsiElement)for1.getCondition(), (PsiElement)for2.getCondition()) && this.myMatchingVisitor.match((PsiElement)for1.getUpdate(), (PsiElement)for2.getUpdate()) && this.matchBody((PsiElement)for1.getBody(), (PsiElement)for2.getBody()));
    }

    public void visitForeachStatement(PsiForeachStatement for1) {
        PsiForeachStatement for2 = (PsiForeachStatement)this.myMatchingVisitor.getElement();
        this.myMatchingVisitor.setResult(this.myMatchingVisitor.match((PsiElement)for1.getIterationParameter(), (PsiElement)for2.getIterationParameter()) && this.myMatchingVisitor.match((PsiElement)for1.getIteratedValue(), (PsiElement)for2.getIteratedValue()) && this.matchBody((PsiElement)for1.getBody(), (PsiElement)for2.getBody()));
    }

    public void visitWhileStatement(PsiWhileStatement while1) {
        PsiWhileStatement while2 = (PsiWhileStatement)this.myMatchingVisitor.getElement();
        this.myMatchingVisitor.setResult(this.myMatchingVisitor.match((PsiElement)while1.getCondition(), (PsiElement)while2.getCondition()) && this.matchBody((PsiElement)while1.getBody(), (PsiElement)while2.getBody()));
    }

    public void visitBlockStatement(PsiBlockStatement block) {
        PsiElement other = this.myMatchingVisitor.getElement();
        if (other instanceof PsiCodeBlock) {
            this.myMatchingVisitor.setResult(!(other.getParent() instanceof PsiBlockStatement) && this.myMatchingVisitor.matchSons((PsiElement)block.getCodeBlock(), other));
        } else {
            PsiBlockStatement block2 = (PsiBlockStatement)other;
            this.myMatchingVisitor.setResult(this.myMatchingVisitor.matchSons((PsiElement)block, (PsiElement)block2));
        }
    }

    public void visitDeclarationStatement(PsiDeclarationStatement dcl) {
        PsiDeclarationStatement declaration = (PsiDeclarationStatement)this.myMatchingVisitor.getElement();
        this.myMatchingVisitor.setResult(this.myMatchingVisitor.matchInAnyOrder(dcl.getDeclaredElements(), declaration.getDeclaredElements()));
    }

    public void visitDoWhileStatement(PsiDoWhileStatement while1) {
        PsiDoWhileStatement while2 = (PsiDoWhileStatement)this.myMatchingVisitor.getElement();
        this.myMatchingVisitor.setResult(this.myMatchingVisitor.match((PsiElement)while1.getCondition(), (PsiElement)while2.getCondition()) && this.matchBody((PsiElement)while1.getBody(), (PsiElement)while2.getBody()));
    }

    public void visitReturnStatement(PsiReturnStatement return1) {
        PsiReturnStatement return2 = (PsiReturnStatement)this.myMatchingVisitor.getElement();
        this.myMatchingVisitor.setResult(this.myMatchingVisitor.match((PsiElement)return1.getReturnValue(), (PsiElement)return2.getReturnValue()));
    }

    public void visitPostfixExpression(PsiPostfixExpression postfix) {
        PsiPostfixExpression postfix2 = this.getExpression(PsiPostfixExpression.class);
        if (postfix2 == null) {
            return;
        }
        this.myMatchingVisitor.setResult(postfix.getOperationTokenType().equals(postfix2.getOperationTokenType()) && this.myMatchingVisitor.match((PsiElement)postfix.getOperand(), (PsiElement)postfix2.getOperand()));
    }

    public void visitPrefixExpression(PsiPrefixExpression prefix) {
        PsiPrefixExpression prefix2 = this.getExpression(PsiPrefixExpression.class);
        if (prefix2 == null) {
            return;
        }
        this.myMatchingVisitor.setResult(prefix.getOperationTokenType().equals(prefix2.getOperationTokenType()) && this.myMatchingVisitor.match((PsiElement)prefix.getOperand(), (PsiElement)prefix2.getOperand()));
    }

    public void visitAssertStatement(PsiAssertStatement assert1) {
        PsiAssertStatement assert2 = (PsiAssertStatement)this.myMatchingVisitor.getElement();
        this.myMatchingVisitor.setResult(this.myMatchingVisitor.match((PsiElement)assert1.getAssertCondition(), (PsiElement)assert2.getAssertCondition()) && this.myMatchingVisitor.match((PsiElement)assert1.getAssertDescription(), (PsiElement)assert2.getAssertDescription()));
    }

    public void visitBreakStatement(PsiBreakStatement break1) {
        PsiBreakStatement break2 = (PsiBreakStatement)this.myMatchingVisitor.getElement();
        this.myMatchingVisitor.setResult(this.myMatchingVisitor.match((PsiElement)break1.getLabelIdentifier(), (PsiElement)break2.getLabelIdentifier()));
    }

    public void visitContinueStatement(PsiContinueStatement continue1) {
        PsiContinueStatement continue2 = (PsiContinueStatement)this.myMatchingVisitor.getElement();
        this.myMatchingVisitor.setResult(this.myMatchingVisitor.match((PsiElement)continue1.getLabelIdentifier(), (PsiElement)continue2.getLabelIdentifier()));
    }

    public void visitSuperExpression(PsiSuperExpression super1) {
        this.getExpression(PsiSuperExpression.class);
    }

    public void visitThisExpression(PsiThisExpression this1) {
        this.getExpression(PsiThisExpression.class);
    }

    public void visitSynchronizedStatement(PsiSynchronizedStatement synchronized1) {
        PsiSynchronizedStatement synchronized2 = (PsiSynchronizedStatement)this.myMatchingVisitor.getElement();
        this.myMatchingVisitor.setResult(this.myMatchingVisitor.match((PsiElement)synchronized1.getLockExpression(), (PsiElement)synchronized2.getLockExpression()) && this.myMatchingVisitor.matchSons((PsiElement)synchronized1.getBody(), (PsiElement)synchronized2.getBody()));
    }

    public void visitThrowStatement(PsiThrowStatement throw1) {
        PsiThrowStatement throw2 = (PsiThrowStatement)this.myMatchingVisitor.getElement();
        this.myMatchingVisitor.setResult(this.myMatchingVisitor.match((PsiElement)throw1.getException(), (PsiElement)throw2.getException()));
    }

    public void visitParenthesizedExpression(PsiParenthesizedExpression expr) {
        PsiElement other = this.myMatchingVisitor.getElement();
        if (this.myMatchingVisitor.setResult(other instanceof PsiParenthesizedExpression)) {
            this.myMatchingVisitor.setResult(this.myMatchingVisitor.matchSons((PsiElement)expr, other));
        }
    }

    public void visitCatchSection(PsiCatchSection section) {
        PsiCatchSection section2 = (PsiCatchSection)this.myMatchingVisitor.getElement();
        MatchingHandler handler = this.myMatchingVisitor.getMatchContext().getPattern().getHandler((PsiElement)section);
        this.myMatchingVisitor.setResult(this.myMatchingVisitor.match((PsiElement)section.getParameter(), (PsiElement)section2.getParameter()) && this.myMatchingVisitor.matchSons((PsiElement)section.getCatchBlock(), (PsiElement)section2.getCatchBlock()) && ((SubstitutionHandler)handler).handle((PsiElement)section2, this.myMatchingVisitor.getMatchContext()));
    }

    public void visitTryStatement(PsiTryStatement try1) {
        PsiTryStatement try2 = (PsiTryStatement)this.myMatchingVisitor.getElement();
        if (!this.myMatchingVisitor.setResult(this.myMatchingVisitor.matchSons((PsiElement)try1.getTryBlock(), (PsiElement)try2.getTryBlock()))) {
            return;
        }
        PsiResourceList resourceList1 = try1.getResourceList();
        PsiCatchSection[] catches1 = try1.getCatchSections();
        PsiCodeBlock finally1 = try1.getFinallyBlock();
        PsiResourceList resourceList2 = try2.getResourceList();
        Object[] catches2 = try2.getCatchSections();
        PsiCodeBlock finally2 = try2.getFinallyBlock();
        if (!this.myMatchingVisitor.getMatchContext().getOptions().isLooseMatching() && (catches1.length == 0 && catches2.length != 0 || finally1 == null && finally2 != null || resourceList1 == null && resourceList2 != null) || catches2.length < catches1.length) {
            this.myMatchingVisitor.setResult(false);
        } else {
            SmartList unmatchedElements = new SmartList();
            if (resourceList1 != null) {
                if (resourceList2 == null) {
                    this.myMatchingVisitor.setResult(false);
                    return;
                }
                List resources1 = PsiTreeUtil.getChildrenOfTypeAsList((PsiElement)resourceList1, PsiResourceListElement.class);
                List resources2 = PsiTreeUtil.getChildrenOfTypeAsList((PsiElement)resourceList2, PsiResourceListElement.class);
                if (!this.myMatchingVisitor.setResult(this.myMatchingVisitor.matchInAnyOrder((PsiElement[])resources1.toArray(new PsiResourceListElement[0]), (PsiElement[])resources2.toArray(new PsiResourceListElement[0])))) {
                    return;
                }
            } else if (resourceList2 != null) {
                unmatchedElements.add(resourceList2);
            }
            ContainerUtil.addAll((Collection)unmatchedElements, (Object[])catches2);
            this.myMatchingVisitor.getMatchContext().setMatchedElementsListener(arg_0 -> JavaMatchingVisitor.lambda$visitTryStatement$1((List)unmatchedElements, arg_0));
            this.myMatchingVisitor.setResult(this.myMatchingVisitor.matchInAnyOrder((PsiElement[])catches1, (PsiElement[])catches2));
            if (finally1 != null) {
                this.myMatchingVisitor.setResult(this.myMatchingVisitor.matchSons((PsiElement)finally1, (PsiElement)finally2));
            } else if (finally2 != null) {
                unmatchedElements.add(finally2);
            }
            if (this.myMatchingVisitor.getResult() && !unmatchedElements.isEmpty()) {
                try2.putUserData(GlobalMatchingVisitor.UNMATCHED_ELEMENTS_KEY, (Object)unmatchedElements);
            }
        }
    }

    public void visitSwitchLabelStatement(PsiSwitchLabelStatement case1) {
        PsiSwitchLabelStatement case2 = (PsiSwitchLabelStatement)this.myMatchingVisitor.getElement();
        this.myMatchingVisitor.setResult(case1.isDefaultCase() == case2.isDefaultCase() && this.myMatchingVisitor.match((PsiElement)case1.getCaseValue(), (PsiElement)case2.getCaseValue()));
    }

    public void visitInstanceOfExpression(PsiInstanceOfExpression instanceOf) {
        PsiInstanceOfExpression other = this.getExpression(PsiInstanceOfExpression.class);
        if (other == null) {
            return;
        }
        if (!this.myMatchingVisitor.setResult(this.myMatchingVisitor.match((PsiElement)instanceOf.getOperand(), (PsiElement)other.getOperand()))) {
            return;
        }
        this.myMatchingVisitor.setResult(this.myMatchingVisitor.match((PsiElement)instanceOf.getCheckType(), (PsiElement)other.getCheckType()));
    }

    public void visitNewExpression(PsiNewExpression new1) {
        PsiExpression other = this.getExpression();
        PsiJavaCodeReferenceElement classReference = new1.getClassReference();
        if (other instanceof PsiArrayInitializerExpression && other.getParent() instanceof PsiVariable && new1.getArrayDimensions().length == 0 && new1.getArrayInitializer() != null) {
            MatchContext matchContext = this.myMatchingVisitor.getMatchContext();
            MatchingHandler handler = matchContext.getPattern().getHandler((PsiElement)classReference);
            boolean looseMatching = this.myMatchingVisitor.getMatchContext().getOptions().isLooseMatching();
            if (handler instanceof SubstitutionHandler && ((SubstitutionHandler)handler).getMinOccurs() != 0 || !looseMatching) {
                this.myMatchingVisitor.setResult(false);
                return;
            }
            PsiType otherType = other.getType();
            if (handler instanceof SubstitutionHandler && otherType != null) {
                PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)other.getProject());
                PsiTypeElement otherTypeElement = factory.createTypeElement(otherType.getDeepComponentType());
                SubstitutionHandler substitutionHandler = (SubstitutionHandler)handler;
                MatchPredicate predicate = substitutionHandler.getPredicate();
                this.myMatchingVisitor.setResult(predicate == null || predicate.match((PsiElement)otherTypeElement, matchContext));
            } else {
                PsiType type = new1.getType();
                this.myMatchingVisitor.setResult(type != null && type.equals(otherType));
            }
            if (this.myMatchingVisitor.getResult()) {
                this.myMatchingVisitor.matchSons((PsiElement)new1.getArrayInitializer(), (PsiElement)other);
            }
            return;
        }
        if (!this.myMatchingVisitor.setResult(other instanceof PsiNewExpression)) {
            return;
        }
        PsiNewExpression new2 = (PsiNewExpression)other;
        if (classReference != null) {
            if (new2.getClassReference() != null) {
                if (this.myMatchingVisitor.setResult(this.myMatchingVisitor.match((PsiElement)classReference, (PsiElement)new2.getClassReference()) && this.myMatchingVisitor.matchSons((PsiElement)new1.getArrayInitializer(), (PsiElement)new2.getArrayInitializer()))) {
                    this.matchArrayDims(new1, new2);
                }
                return;
            }
            PsiKeyword newKeyword = (PsiKeyword)PsiTreeUtil.getChildOfType((PsiElement)new2, PsiKeyword.class);
            PsiElement element = PsiTreeUtil.getNextSiblingOfType((PsiElement)newKeyword, PsiWhiteSpace.class);
            if (element != null && element.getNextSibling() instanceof PsiKeyword) {
                if (this.myMatchingVisitor.setResult(this.myMatchingVisitor.match((PsiElement)classReference, element.getNextSibling()) && this.myMatchingVisitor.matchSons((PsiElement)new1.getArrayInitializer(), (PsiElement)new2.getArrayInitializer()))) {
                    this.matchArrayDims(new1, new2);
                }
                return;
            }
        }
        if (classReference == new2.getClassReference()) {
            this.myMatchingVisitor.setResult(this.myMatchingVisitor.matchSons((PsiElement)new1, (PsiElement)new2));
        } else if (new1.getAnonymousClass() == null && classReference != null && new2.getAnonymousClass() != null) {
            this.myMatchingVisitor.setResult(this.myMatchingVisitor.match((PsiElement)classReference, (PsiElement)new2.getAnonymousClass().getBaseClassReference()) && this.myMatchingVisitor.matchSons((PsiElement)new1.getArgumentList(), (PsiElement)new2.getArgumentList()));
        } else {
            this.myMatchingVisitor.setResult(false);
        }
    }

    public void visitKeyword(PsiKeyword keyword) {
        this.myMatchingVisitor.setResult(this.myMatchingVisitor.matchText((PsiElement)keyword, this.myMatchingVisitor.getElement()));
    }

    public void visitTypeCastExpression(PsiTypeCastExpression cast) {
        PsiTypeCastExpression other = this.getExpression(PsiTypeCastExpression.class);
        if (other != null) {
            this.myMatchingVisitor.setResult(this.myMatchingVisitor.match((PsiElement)cast.getCastType(), (PsiElement)other.getCastType()) && this.myMatchingVisitor.match((PsiElement)cast.getOperand(), (PsiElement)other.getOperand()));
        }
    }

    public void visitClassObjectAccessExpression(PsiClassObjectAccessExpression expr) {
        PsiClassObjectAccessExpression other = this.getExpression(PsiClassObjectAccessExpression.class);
        if (other != null) {
            this.myMatchingVisitor.setResult(this.myMatchingVisitor.match((PsiElement)expr.getOperand(), (PsiElement)other.getOperand()));
        }
    }

    public void visitReferenceElement(PsiJavaCodeReferenceElement ref) {
        PsiAnnotation[] otherAnnotations;
        PsiElement other = this.myMatchingVisitor.getElement();
        PsiAnnotation[] annotations = (PsiAnnotation[])PsiTreeUtil.getChildrenOfType((PsiElement)ref, PsiAnnotation.class);
        if (annotations != null && !this.myMatchingVisitor.setResult((otherAnnotations = (PsiAnnotation[])PsiTreeUtil.getChildrenOfType((PsiElement)other, PsiAnnotation.class)) != null && this.myMatchingVisitor.matchInAnyOrder((PsiElement[])annotations, (PsiElement[])otherAnnotations))) {
            return;
        }
        this.myMatchingVisitor.setResult(this.matchType((PsiElement)ref, other));
    }

    public void visitTypeElement(PsiTypeElement typeElement) {
        PsiAnnotation[] annotations2;
        PsiElement other = this.myMatchingVisitor.getElement();
        PsiAnnotation[] annotations = (PsiAnnotation[])PsiTreeUtil.getChildrenOfType((PsiElement)typeElement, PsiAnnotation.class);
        if (annotations != null && !this.myMatchingVisitor.setResult((annotations2 = (PsiAnnotation[])PsiTreeUtil.getChildrenOfType((PsiElement)other, PsiAnnotation.class)) != null && this.myMatchingVisitor.matchInAnyOrder((PsiElement[])annotations, (PsiElement[])annotations2))) {
            return;
        }
        PsiTypeElement[] typeElementChildren = (PsiTypeElement[])PsiTreeUtil.getChildrenOfType((PsiElement)typeElement, PsiTypeElement.class);
        if (typeElementChildren != null && typeElementChildren.length > 1) {
            PsiTypeElement[] typeElementChildren2 = (PsiTypeElement[])PsiTreeUtil.getChildrenOfType((PsiElement)other, PsiTypeElement.class);
            this.myMatchingVisitor.setResult(typeElementChildren2 != null && this.myMatchingVisitor.matchInAnyOrder((PsiElement[])typeElementChildren, (PsiElement[])typeElementChildren2));
        } else {
            this.myMatchingVisitor.setResult(this.matchType((PsiElement)typeElement, other));
        }
    }

    public void visitTypeParameter(PsiTypeParameter psiTypeParameter) {
        PsiTypeParameter parameter = (PsiTypeParameter)this.myMatchingVisitor.getElement();
        PsiIdentifier identifier = psiTypeParameter.getNameIdentifier();
        PsiIdentifier identifier2 = parameter.getNameIdentifier();
        MatchingHandler handler = this.myMatchingVisitor.getMatchContext().getPattern().getHandler((PsiElement)identifier);
        if (handler instanceof SubstitutionHandler ? !this.myMatchingVisitor.setResult(((SubstitutionHandler)handler).handle((PsiElement)identifier2, this.myMatchingVisitor.getMatchContext())) : !this.myMatchingVisitor.setResult(this.myMatchingVisitor.matchText((PsiElement)identifier, (PsiElement)identifier2))) {
            return;
        }
        if (!this.myMatchingVisitor.setResult(this.matchInAnyOrder(psiTypeParameter.getExtendsList(), parameter.getExtendsList()))) {
            return;
        }
        this.myMatchingVisitor.setResult(this.myMatchingVisitor.matchInAnyOrder((PsiElement[])psiTypeParameter.getAnnotations(), (PsiElement[])parameter.getAnnotations()));
    }

    public void visitClass(PsiClass clazz) {
        PsiClass clazz2 = (PsiClass)this.myMatchingVisitor.getElement();
        if (clazz.hasTypeParameters() && !this.myMatchingVisitor.setResult(this.myMatchingVisitor.match((PsiElement)clazz.getTypeParameterList(), (PsiElement)clazz2.getTypeParameterList()))) {
            return;
        }
        PsiDocComment comment = clazz.getDocComment();
        if (comment != null && !this.myMatchingVisitor.setResult(this.myMatchingVisitor.match((PsiElement)comment, (PsiElement)clazz2))) {
            return;
        }
        PsiIdentifier identifier = clazz.getNameIdentifier();
        boolean isTypedVar = this.myMatchingVisitor.getMatchContext().getPattern().isTypedVar((PsiElement)identifier);
        if (clazz.getModifierList().getTextLength() > 0 && !this.myMatchingVisitor.match((PsiElement)clazz.getModifierList(), (PsiElement)clazz2.getModifierList())) {
            this.myMatchingVisitor.setResult(false);
            return;
        }
        if (this.myMatchingVisitor.setResult((isTypedVar || this.myMatchingVisitor.matchText((PsiElement)identifier, (PsiElement)clazz2.getNameIdentifier())) && this.compareClasses(clazz, clazz2)) && isTypedVar) {
            SubstitutionHandler handler;
            PsiIdentifier id = clazz2.getNameIdentifier();
            if (id == null) {
                id = clazz2;
            }
            if ((handler = (SubstitutionHandler)this.myMatchingVisitor.getMatchContext().getPattern().getHandler((PsiElement)identifier)).isSubtype() || handler.isStrictSubtype()) {
                this.myMatchingVisitor.setResult(this.checkMatchWithinHierarchy((PsiElement)id, handler, (PsiElement)identifier));
            } else {
                this.myMatchingVisitor.setResult(this.myMatchingVisitor.handleTypedElement((PsiElement)identifier, (PsiElement)id));
            }
        }
    }

    public void visitTypeParameterList(PsiTypeParameterList psiTypeParameterList) {
        this.myMatchingVisitor.setResult(this.myMatchingVisitor.matchSequentially(psiTypeParameterList.getFirstChild(), this.myMatchingVisitor.getElement().getFirstChild()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void visitMethod(PsiMethod method) {
        PsiIdentifier methodNameNode = method.getNameIdentifier();
        boolean isTypedVar = this.myMatchingVisitor.getMatchContext().getPattern().isTypedVar((PsiElement)methodNameNode);
        PsiMethod method2 = (PsiMethod)this.myMatchingVisitor.getElement();
        this.myMatchingVisitor.getMatchContext().pushResult();
        try {
            PsiDocComment docComment = method.getDocComment();
            if (docComment != null && !this.myMatchingVisitor.setResult(this.myMatchingVisitor.match((PsiElement)docComment, (PsiElement)method2))) {
                return;
            }
            if (method.hasTypeParameters() && !this.myMatchingVisitor.setResult(this.myMatchingVisitor.match((PsiElement)method.getTypeParameterList(), (PsiElement)((PsiMethod)this.myMatchingVisitor.getElement()).getTypeParameterList()))) {
                return;
            }
            if (!this.checkHierarchy((PsiMember)method2, (PsiMember)method)) {
                this.myMatchingVisitor.setResult(false);
                return;
            }
            this.myMatchingVisitor.setResult(method.isConstructor() == method2.isConstructor() && (this.myMatchingVisitor.matchText((PsiElement)method.getNameIdentifier(), (PsiElement)method2.getNameIdentifier()) || isTypedVar) && this.myMatchingVisitor.match((PsiElement)method.getModifierList(), (PsiElement)method2.getModifierList()) && this.myMatchingVisitor.matchSons((PsiElement)method.getParameterList(), (PsiElement)method2.getParameterList()) && this.myMatchingVisitor.match((PsiElement)method.getReturnTypeElement(), (PsiElement)method2.getReturnTypeElement()) && this.matchInAnyOrder(method.getThrowsList(), method2.getThrowsList()) && this.myMatchingVisitor.matchSonsOptionally((PsiElement)method.getBody(), (PsiElement)method2.getBody()));
        }
        finally {
            this.saveOrDropResult(methodNameNode, isTypedVar, method2.getNameIdentifier());
        }
    }

    private <T extends PsiExpression> T getExpression(Class<T> aClass) {
        PsiExpression other = this.getExpression();
        return (T)(this.myMatchingVisitor.setResult(aClass.isInstance(other)) ? other : null);
    }

    private PsiExpression getExpression() {
        PsiElement other = this.myMatchingVisitor.getElement();
        return other instanceof PsiExpression ? PsiUtil.skipParenthesizedExprDown((PsiExpression)((PsiExpression)other)) : null;
    }

    private static /* synthetic */ void lambda$visitTryStatement$1(List unmatchedElements, Collection matchedElements) {
        unmatchedElements.removeAll(matchedElements);
    }

    private static /* synthetic */ void lambda$compareClasses$0(Set matchedElements, Collection es) {
        matchedElements.addAll(es);
    }

    static {
        Arrays.sort(MODIFIERS);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/structuralsearch/impl/matcher/JavaMatchingVisitor", "getText"));
    }
}

