/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.hibernate.util;

import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.hibernate.facet.HibernateVersion;
import com.intellij.hibernate.model.xml.config.Mapping;
import com.intellij.hibernate.model.xml.config.Property;
import com.intellij.hibernate.model.xml.config.SessionFactory;
import com.intellij.hibernate.model.xml.mapping.HbmAttributeVisitorAdapter;
import com.intellij.hibernate.model.xml.mapping.HbmClass;
import com.intellij.hibernate.model.xml.mapping.HbmClassBase;
import com.intellij.hibernate.model.xml.mapping.HbmCompositeId;
import com.intellij.hibernate.model.xml.mapping.HbmEmbeddedAttributeBase;
import com.intellij.hibernate.model.xml.mapping.HbmHibernateMapping;
import com.intellij.hibernate.model.xml.mapping.HbmJoinedSubclass;
import com.intellij.hibernate.model.xml.mapping.HbmSubclass;
import com.intellij.hibernate.model.xml.mapping.HbmUnionSubclass;
import com.intellij.jam.model.util.JamCommonUtil;
import com.intellij.javaee.JavaeeUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.xml.XmlFile;
import com.intellij.util.Consumer;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.StringTokenizer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HibernateUtil {
    private static final List<Pair<HibernateVersion, String>> detectionClasses = Arrays.asList(Pair.create((Object)((Object)HibernateVersion.Hibernate_5_2), (Object)"org.hibernate.query.Query"), Pair.create((Object)((Object)HibernateVersion.Hibernate_5_0), (Object)"org.hibernate.engine.FetchStrategy"), Pair.create((Object)((Object)HibernateVersion.Hibernate_4_X), (Object)"org.hibernate.engine.FetchStyle"), Pair.create((Object)((Object)HibernateVersion.Hibernate_3_X), (Object)"org.hibernate.engine.SessionFactoryImplementor"));

    private HibernateUtil() {
    }

    @NotNull
    public static HibernateVersion getHibernateVersion(@Nullable Module module) {
        if (module == null) {
            HibernateVersion hibernateVersion = HibernateVersion.values()[HibernateVersion.values().length - 1];
            if (hibernateVersion == null) {
                HibernateUtil.$$$reportNull$$$0(0);
            }
            return hibernateVersion;
        }
        JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)module.getProject());
        GlobalSearchScope scope = GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)module);
        for (Pair<HibernateVersion, String> pair : detectionClasses) {
            if (facade.findClass((String)pair.second, scope) == null) continue;
            HibernateVersion hibernateVersion = (HibernateVersion)((Object)pair.first);
            if (hibernateVersion == null) {
                HibernateUtil.$$$reportNull$$$0(1);
            }
            return hibernateVersion;
        }
        HibernateVersion hibernateVersion = HibernateVersion.values()[0];
        if (hibernateVersion == null) {
            HibernateUtil.$$$reportNull$$$0(2);
        }
        return hibernateVersion;
    }

    public static String getFullPropertyName(@NotNull String hibernateProperty) {
        if (hibernateProperty == null) {
            HibernateUtil.$$$reportNull$$$0(3);
        }
        return hibernateProperty.startsWith("hibernate.") ? hibernateProperty : "hibernate." + hibernateProperty;
    }

    public static boolean isHibernateConfig(XmlFile file) {
        String ns = JavaeeUtil.getRootTagNS((PsiFile)file, (String)"hibernate-configuration");
        if (ns == null) {
            return false;
        }
        if (ns.length() == 0) {
            return true;
        }
        if (ns.endsWith("/hibernate-configuration-3.0.dtd")) {
            return true;
        }
        return ns.equals("http://www.hibernate.org/xsd/hibernate-configuration");
    }

    public static boolean isHibernateMapping(XmlFile file) {
        String ns = JavaeeUtil.getRootTagNS((PsiFile)file, (String)"hibernate-mapping");
        if (ns == null) {
            return false;
        }
        if (ns.length() == 0) {
            return true;
        }
        if (ns.endsWith("/hibernate-mapping-3.0.dtd")) {
            return true;
        }
        return ns.equals("http://www.hibernate.org/xsd/hibernate-mapping");
    }

    public static <V, T extends Collection<V>> T getDomMappings(SessionFactory sessionFactory, Class<V> mappingClass, T result) {
        for (Mapping mapping : sessionFactory.getMappings()) {
            PsiFile psiFile = (PsiFile)mapping.getResource().getValue();
            if (psiFile != null || (psiFile = (PsiFile)mapping.getFile().getValue()) != null) {
                ContainerUtil.addIfNotNull(result, (Object)JamCommonUtil.getRootElement((PsiFile)psiFile, mappingClass, (Module)sessionFactory.getModule()));
                continue;
            }
            psiFile = (PsiFile)mapping.getJar().getValue();
            if (psiFile == null) continue;
            PsiManager psiManager = psiFile.getManager();
            Module module = sessionFactory.getModule();
            HibernateUtil.processFilesInJar(psiFile.getVirtualFile(), (Processor<VirtualFile>)((Processor)virtualFile -> {
                PsiFile aFile = psiManager.findFile(virtualFile);
                ContainerUtil.addIfNotNull((Collection)result, (Object)JamCommonUtil.getRootElement((PsiFile)aFile, (Class)mappingClass, (Module)module));
                return true;
            }));
        }
        return result;
    }

    private static void processFilesInJar(VirtualFile virtualFile, Processor<VirtualFile> processor) {
        VirtualFile jarFile = JarFileSystem.getInstance().findFileByPath(virtualFile.getPath() + "!/");
        if (jarFile != null) {
            class Visitor {
                final /* synthetic */ Processor val$processor;

                Visitor(Processor processor) {
                    this.val$processor = processor;
                }

                boolean accept(VirtualFile file) {
                    if (file.isDirectory()) {
                        for (VirtualFile child : file.getChildren()) {
                            if (this.accept(child)) continue;
                            return false;
                        }
                    } else {
                        return this.val$processor.process((Object)file);
                    }
                    return true;
                }
            }
            new Visitor(processor).accept(jarFile);
        }
    }

    public static void consumePersistentObjects(HbmHibernateMapping mappings, Consumer<? super HbmClassBase> classConsumer, final Consumer<? super HbmEmbeddedAttributeBase> componentConsumer) {
        HbmAttributeVisitorAdapter componentVisitor = new HbmAttributeVisitorAdapter(){

            @Override
            public void visitEmbeddedAttributeBase(HbmEmbeddedAttributeBase embeddedAttributeBase) {
                componentConsumer.consume((Object)embeddedAttributeBase);
                embeddedAttributeBase.visitAttributes(this);
            }
        };
        final Consumer consumer = hbmClassBase -> {
            if (classConsumer != null) {
                classConsumer.consume(hbmClassBase);
            }
            if (componentConsumer != null) {
                hbmClassBase.visitAttributes(componentVisitor);
            }
        };
        Processor<HbmSubclass> subclassProcessor = new Processor<HbmSubclass>(){

            public boolean process(HbmSubclass hbmSubclass) {
                consumer.consume((Object)hbmSubclass);
                ContainerUtil.process(hbmSubclass.getSubclasses(), (Processor)this);
                return true;
            }
        };
        Processor<HbmUnionSubclass> unionSubclassProcessor = new Processor<HbmUnionSubclass>(){

            public boolean process(HbmUnionSubclass hbmSubclass) {
                consumer.consume((Object)hbmSubclass);
                ContainerUtil.process(hbmSubclass.getUnionSubclasses(), (Processor)this);
                return true;
            }
        };
        Processor<HbmJoinedSubclass> joinedSubclassProcessor = new Processor<HbmJoinedSubclass>(){

            public boolean process(HbmJoinedSubclass hbmSubclass) {
                consumer.consume((Object)hbmSubclass);
                ContainerUtil.process(hbmSubclass.getJoinedSubclasses(), (Processor)this);
                return true;
            }
        };
        Processor classProcessor = arg_0 -> HibernateUtil.lambda$consumePersistentObjects$2(consumer, (Processor)subclassProcessor, (Processor)joinedSubclassProcessor, (Processor)unionSubclassProcessor, arg_0);
        ContainerUtil.process(mappings.getClasses(), (Processor)classProcessor);
        ContainerUtil.process(mappings.getJoinedSubclasses(), (Processor)joinedSubclassProcessor);
        ContainerUtil.process(mappings.getSubclasses(), (Processor)subclassProcessor);
        ContainerUtil.process(mappings.getUnionSubclasses(), (Processor)unionSubclassProcessor);
    }

    public static boolean isEmbedded(HbmCompositeId compositeId) {
        return StringUtil.isNotEmpty((String)compositeId.getClazz().getStringValue()) && !Boolean.TRUE.equals(compositeId.getMapped().getValue());
    }

    @Nullable
    public static String getPropertyShortName(String name) {
        return name != null && name.startsWith("hibernate.") ? name.substring("hibernate.".length()) : name;
    }

    @Nullable
    public static Property<Object> findSessionFactoryProperty(SessionFactory factory, String propertyName) {
        String propertyShortName = HibernateUtil.getPropertyShortName(propertyName);
        for (Property<Object> property : factory.getProperties()) {
            String name = (String)property.getName().getValue();
            String shortName = HibernateUtil.getPropertyShortName(name);
            if (!StringUtil.isNotEmpty((String)shortName) || !Comparing.strEqual((String)propertyShortName, (String)shortName)) continue;
            return property;
        }
        return null;
    }

    public static Property<Object> setSessionFactoryProperty(SessionFactory factory, String propertyName, String value) {
        Property<Object> property;
        Property<Object> existingProperty = HibernateUtil.findSessionFactoryProperty(factory, propertyName);
        Property<Object> property2 = property = existingProperty == null ? factory.addProperty() : existingProperty;
        if (existingProperty == null) {
            property.getName().setStringValue(propertyName);
        }
        property.setStringValue(value);
        return property;
    }

    public static String getDefaultDialectValue(PsiElement element, String jdbcUrl) {
        StringTokenizer st = new StringTokenizer(jdbcUrl, ":");
        if (!st.hasMoreTokens()) {
            return "";
        }
        st.nextToken();
        if (!st.hasMoreTokens()) {
            return "";
        }
        String token = st.nextToken().toLowerCase();
        ArrayList<String> dialects = new ArrayList<String>();
        for (PsiReference reference : element.getReferences()) {
            Object[] variants;
            for (Object variant : variants = reference.getVariants()) {
                String variantStr;
                Object obj = variant instanceof LookupElement ? ((LookupElement)variant).getObject() : null;
                String string = variantStr = obj instanceof PsiClass ? ((PsiClass)obj).getQualifiedName() : null;
                if (variantStr == null || !variantStr.toLowerCase().contains(token)) continue;
                dialects.add(variantStr);
            }
        }
        if (dialects.isEmpty()) {
            return "";
        }
        Collections.sort(dialects);
        return (String)dialects.get(0);
    }

    private static /* synthetic */ boolean lambda$consumePersistentObjects$2(Consumer consumer, Processor subclassProcessor, Processor joinedSubclassProcessor, Processor unionSubclassProcessor, HbmClass hbmClass) {
        consumer.consume((Object)hbmClass);
        ContainerUtil.process(hbmClass.getSubclasses(), (Processor)subclassProcessor);
        ContainerUtil.process(hbmClass.getJoinedSubclasses(), (Processor)joinedSubclassProcessor);
        ContainerUtil.process(hbmClass.getUnionSubclasses(), (Processor)unionSubclassProcessor);
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 3: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 3: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/hibernate/util/HibernateUtil";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hibernateProperty";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getHibernateVersion";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/hibernate/util/HibernateUtil";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getFullPropertyName";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

