/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.css.impl.util.completion.provider;

import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionProvider;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.CompletionUtil;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.progress.ProgressIndicatorProvider;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.css.CssSelector;
import com.intellij.psi.css.CssSelectorSuffix;
import com.intellij.psi.css.CssSelectorSuffixType;
import com.intellij.psi.css.CssSimpleSelector;
import com.intellij.psi.css.StylesheetFile;
import com.intellij.psi.css.impl.stubs.index.CssIndexUtil;
import com.intellij.psi.css.impl.util.CssUtil;
import com.intellij.psi.css.util.CssCompletionUtil;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.PairProcessor;
import com.intellij.util.ProcessingContext;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.HashSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CssSelectorSuffixCompletionProvider
extends CompletionProvider<CompletionParameters> {
    @NotNull
    private final CssSelectorSuffixType mySelectorSuffixType;
    @Nullable
    private final Condition<String> myFilter;

    public CssSelectorSuffixCompletionProvider(@NotNull CssSelectorSuffixType selectorSuffixType) {
        if (selectorSuffixType == null) {
            CssSelectorSuffixCompletionProvider.$$$reportNull$$$0(0);
        }
        this(selectorSuffixType, null);
    }

    public CssSelectorSuffixCompletionProvider(@NotNull CssSelectorSuffixType selectorSuffixType, @Nullable Condition<String> filter) {
        if (selectorSuffixType == null) {
            CssSelectorSuffixCompletionProvider.$$$reportNull$$$0(1);
        }
        this.mySelectorSuffixType = selectorSuffixType;
        this.myFilter = filter;
    }

    protected void addCompletions(@NotNull CompletionParameters parameters, ProcessingContext context, @NotNull CompletionResultSet result) {
        GlobalSearchScope scope;
        if (parameters == null) {
            CssSelectorSuffixCompletionProvider.$$$reportNull$$$0(2);
        }
        if (result == null) {
            CssSelectorSuffixCompletionProvider.$$$reportNull$$$0(3);
        }
        PsiElement position = parameters.getPosition();
        Project project = position.getProject();
        PsiFile file = InjectedLanguageManager.getInstance((Project)project).getTopLevelFile((PsiElement)parameters.getOriginalFile());
        if (parameters.getInvocationCount() < 2) {
            scope = CssSelectorSuffixCompletionProvider.getCompletionScope(position, parameters.getOriginalFile());
            String shortcutText = KeymapUtil.getFirstKeyboardShortcutText((AnAction)ActionManager.getInstance().getAction("CodeCompletion"));
            result.addLookupAdvertisement("Press " + shortcutText + " again for selectors from all stylesheets");
        } else {
            scope = CssUtil.getCompletionAndResolvingScopeForElement(position);
        }
        CssSelectorSuffix suffix = (CssSelectorSuffix)PsiTreeUtil.getNonStrictParentOfType((PsiElement)position, (Class[])new Class[]{CssSelectorSuffix.class});
        CssSelectorSuffix originalSuffix = suffix != null ? (CssSelectorSuffix)CompletionUtil.getOriginalOrSelf((PsiElement)suffix) : null;
        CssIndexUtil.processAllSelectorSuffixes(this.mySelectorSuffixType, project, scope, (PairProcessor<String, ? super CssSelectorSuffix>)((PairProcessor)(name, selectorSuffix) -> {
            if (result == null) {
                CssSelectorSuffixCompletionProvider.$$$reportNull$$$0(10);
            }
            if (StringUtil.isNotEmpty((String)name) && selectorSuffix != originalSuffix && (this.myFilter == null || this.myFilter.value(name))) {
                result.addElement(CssCompletionUtil.lookupForSelectorSuffix(name, selectorSuffix, (PsiElement)selectorSuffix, file));
            }
            return true;
        }));
        CssIndexUtil.processAmpersandSelectors(project, scope, (Processor<CssSelector>)((Processor)selector -> {
            if (result == null) {
                CssSelectorSuffixCompletionProvider.$$$reportNull$$$0(9);
            }
            for (CssSimpleSelector simpleSelector : selector.getSimpleSelectors()) {
                for (CssSelectorSuffix selectorSuffix : simpleSelector.getSelectorSuffixes()) {
                    ProgressIndicatorProvider.checkCanceled();
                    String suffixName = selectorSuffix.getName();
                    if (!StringUtil.isNotEmpty((String)suffixName) || this.mySelectorSuffixType != selectorSuffix.getType() || this.myFilter != null && !this.myFilter.value((Object)suffixName)) continue;
                    result.addElement(CssCompletionUtil.lookupForSelectorSuffix(suffixName, selectorSuffix, (PsiElement)selector, file));
                }
            }
            return true;
        }));
        GlobalSearchScope htmlScope = CssUtil.getCompletionAndResolvingScopeForElement(position);
        CssIndexUtil.processSelectorNamesFromHtmlAttributes(project, htmlScope, (Processor<String>)((Processor)selectorSuffix -> {
            if (result == null) {
                CssSelectorSuffixCompletionProvider.$$$reportNull$$$0(8);
            }
            if (selectorSuffix.length() < 2 || this.myFilter != null && !this.myFilter.value(selectorSuffix)) {
                return true;
            }
            if (this.mySelectorSuffixType == CssSelectorSuffixType.CLASS && StringUtil.startsWithChar((CharSequence)selectorSuffix, (char)'.') || this.mySelectorSuffixType == CssSelectorSuffixType.ID && StringUtil.startsWithChar((CharSequence)selectorSuffix, (char)'#')) {
                String suffixName = selectorSuffix.substring(1);
                result.addElement(CssCompletionUtil.lookupForSelectorSuffixFromHtml(suffixName, this.mySelectorSuffixType, file, null, project));
            }
            return true;
        }));
    }

    @NotNull
    private static GlobalSearchScope getCompletionScope(@NotNull PsiElement position, @NotNull PsiFile file) {
        VirtualFile virtualFile;
        if (position == null) {
            CssSelectorSuffixCompletionProvider.$$$reportNull$$$0(4);
        }
        if (file == null) {
            CssSelectorSuffixCompletionProvider.$$$reportNull$$$0(5);
        }
        Project project = position.getProject();
        if (file instanceof StylesheetFile && (virtualFile = file.getVirtualFile()) != null) {
            HashSet importedFiles = ContainerUtil.newHashSet((Object[])new VirtualFile[]{virtualFile});
            importedFiles.addAll(CssUtil.getImportedFiles(file, position, false));
            GlobalSearchScope globalSearchScope = GlobalSearchScope.filesScope((Project)project, (Collection)importedFiles);
            if (globalSearchScope == null) {
                CssSelectorSuffixCompletionProvider.$$$reportNull$$$0(6);
            }
            return globalSearchScope;
        }
        GlobalSearchScope globalSearchScope = GlobalSearchScope.fileScope((PsiFile)file);
        if (globalSearchScope == null) {
            CssSelectorSuffixCompletionProvider.$$$reportNull$$$0(7);
        }
        return globalSearchScope;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selectorSuffixType";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 3: 
            case 8: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "position";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/css/impl/util/completion/provider/CssSelectorSuffixCompletionProvider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/css/impl/util/completion/provider/CssSelectorSuffixCompletionProvider";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getCompletionScope";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "addCompletions";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getCompletionScope";
                break;
            }
            case 6: 
            case 7: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "lambda$addCompletions$2";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "lambda$addCompletions$1";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "lambda$addCompletions$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

