/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.jsp;

import com.intellij.lang.StdLanguages;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ProjectComponent;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileEvent;
import com.intellij.openapi.vfs.VirtualFileListener;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.VirtualFileUrlChangeAdapter;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.ResolveState;
import com.intellij.psi.impl.source.jsp.JspContextManager;
import com.intellij.psi.impl.source.jsp.JspFileIndex;
import com.intellij.psi.jsp.BaseJspFile;
import com.intellij.psi.jsp.JspFile;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.scope.util.PsiScopesUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.BidirectionalMap;
import com.intellij.util.xmlb.annotations.Attribute;
import com.intellij.util.xmlb.annotations.Property;
import com.intellij.util.xmlb.annotations.Tag;
import com.intellij.util.xmlb.annotations.XCollection;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="JspContextManager", storages={@Storage(value="$WORKSPACE_FILE$")})
public class JspContextManagerImpl
extends JspContextManager
implements ProjectComponent,
PersistentStateComponent<JspContextManagerState> {
    @NonNls
    public static final String COMPONENT_NAME = "JspContextManager";
    private final PsiManager myPsiManager;
    private final VirtualFileManager myVirtualFileManager;
    private final JspFileIndex myJspFileIndex;
    private final BidirectionalMap<String, String> myFileUrlToContextUrl = new BidirectionalMap();
    private static final ThreadLocal<THashSet<PsiFile>> myProcessedContexts = ThreadLocal.withInitial(() -> new THashSet());

    public JspContextManagerImpl(PsiManager psiManager, VirtualFileManager virtualFileManager, JspFileIndex jspFileIndex) {
        this.myPsiManager = psiManager;
        this.myVirtualFileManager = virtualFileManager;
        this.myJspFileIndex = jspFileIndex;
    }

    public static JspContextManagerImpl getInstance(Project project) {
        JspContextManagerImpl manager = (JspContextManagerImpl)((Object)project.getComponent(JspContextManager.class));
        assert (manager != null);
        return manager;
    }

    public void projectOpened() {
        this.myVirtualFileManager.addVirtualFileListener((VirtualFileListener)new MyVirtualFileListener(), (Disposable)this.myPsiManager.getProject());
    }

    @NotNull
    @NonNls
    public String getComponentName() {
        if (COMPONENT_NAME == null) {
            JspContextManagerImpl.$$$reportNull$$$0(0);
        }
        return COMPONENT_NAME;
    }

    public void clearState() {
        this.myFileUrlToContextUrl.clear();
    }

    public void loadState(@NotNull JspContextManagerState state) {
        if (state == null) {
            JspContextManagerImpl.$$$reportNull$$$0(1);
        }
        for (JspContextMappingState mapping : state.getMappings()) {
            String contextFileUrl;
            String fileUrl = mapping.getAFileUrl();
            if (fileUrl == null || (contextFileUrl = mapping.getContextFileUrl()) == null) continue;
            this.myFileUrlToContextUrl.put((Object)fileUrl, (Object)contextFileUrl);
        }
    }

    public JspContextManagerState getState() {
        JspContextManagerState state = new JspContextManagerState();
        for (Map.Entry entry : this.myFileUrlToContextUrl.entrySet()) {
            String fileUrl = (String)entry.getKey();
            String contextUrl = (String)entry.getValue();
            this.writeFile(state, fileUrl, contextUrl);
        }
        return state;
    }

    private void writeFile(JspContextManagerState state, String fileUrl, @Nullable String contextUrl) {
        if (this.myVirtualFileManager.findFileByUrl(fileUrl) != null && contextUrl != null && this.myVirtualFileManager.findFileByUrl(contextUrl) != null) {
            JspContextMappingState mapping = new JspContextMappingState();
            mapping.setAFileUrl(fileUrl);
            mapping.setContextFileUrl(contextUrl);
            state.getMappings().add(mapping);
        }
    }

    @Nullable
    private BaseJspFile findAndSetFirstSuitableContext(PsiFile file) {
        return this.myJspFileIndex.getFirstIncludingFile(file);
    }

    @Nullable
    public JspFile getConfiguredContextFile(@NotNull PsiFile file) {
        PsiFile psiFile;
        VirtualFile contextVirtualFile;
        String fileUrl;
        String contextUrl;
        VirtualFile virtualFile;
        if (file == null) {
            JspContextManagerImpl.$$$reportNull$$$0(2);
        }
        if ((virtualFile = JspContextManagerImpl.getVirtualFile(file)) != null && (contextUrl = (String)this.myFileUrlToContextUrl.get((Object)(fileUrl = virtualFile.getUrl()))) != null && (contextVirtualFile = this.myVirtualFileManager.findFileByUrl(contextUrl)) != null && (psiFile = this.myPsiManager.findFile(contextVirtualFile)) instanceof JspFile) {
            return (JspFile)psiFile;
        }
        return null;
    }

    @Nullable
    private static VirtualFile getVirtualFile(PsiFile file) {
        return file.getOriginalFile().getVirtualFile();
    }

    public void setContextFile(@NotNull PsiFile file, @Nullable BaseJspFile contextFile) {
        if (file == null) {
            JspContextManagerImpl.$$$reportNull$$$0(3);
        }
        this.setContextInternal(file, contextFile);
        this.myPsiManager.dropPsiCaches();
    }

    private void setContextInternal(@NotNull PsiFile file, @Nullable BaseJspFile contextFile) {
        VirtualFile virtualFile;
        if (file == null) {
            JspContextManagerImpl.$$$reportNull$$$0(4);
        }
        if ((virtualFile = file.getVirtualFile()) != null) {
            String fileUrl = virtualFile.getUrl();
            if (contextFile != null) {
                VirtualFile contextVirtualFile = contextFile.getVirtualFile();
                if (contextVirtualFile != null) {
                    this.myFileUrlToContextUrl.put((Object)fileUrl, (Object)contextVirtualFile.getUrl());
                }
            } else {
                this.myFileUrlToContextUrl.remove((Object)fileUrl);
            }
        }
    }

    @Nullable
    public BaseJspFile getContextFile(@NotNull PsiFile file) {
        JspFile contextFile;
        if (file == null) {
            JspContextManagerImpl.$$$reportNull$$$0(5);
        }
        if ((contextFile = this.getConfiguredContextFile(file)) == null) {
            contextFile = this.findAndSetFirstSuitableContext(file);
        }
        return contextFile;
    }

    public BaseJspFile[] getSuitableContextFiles(@NotNull PsiFile file) {
        Object[] files;
        int index;
        if (file == null) {
            JspContextManagerImpl.$$$reportNull$$$0(6);
        }
        if ((index = ArrayUtil.find((Object[])(files = this.myJspFileIndex.getIncludingFiles(file)), (Object)file)) != -1) {
            return (BaseJspFile[])ArrayUtil.remove((Object[])files, (int)index);
        }
        return files;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean processContextElements(@NotNull FileViewProvider fileViewProvider, PsiScopeProcessor processor) {
        JspFile initialFile;
        if (fileViewProvider == null) {
            JspContextManagerImpl.$$$reportNull$$$0(7);
        }
        if ((initialFile = (JspFile)fileViewProvider.getPsi(fileViewProvider.getBaseLanguage())) == null) {
            return true;
        }
        THashSet<PsiFile> recursionGuard = myProcessedContexts.get();
        if (recursionGuard.contains((Object)initialFile)) {
            return true;
        }
        JspFile realInitialFile = initialFile;
        recursionGuard.add((Object)realInitialFile);
        try {
            BaseJspFile context;
            initialFile = (JspFile)initialFile.getOriginalFile();
            THashSet files = new THashSet(4);
            JspFile currentFile = initialFile;
            do {
                files.add(currentFile);
                context = this.getContextFile((PsiFile)currentFile);
                PsiElement element = this.findFirstIncludeElementForFile(context, (BaseJspFile)currentFile);
                if (element == null && (element = this.findFirstIncludeElementForFile(context = this.getConfiguredContextFile((PsiFile)currentFile), (BaseJspFile)currentFile)) == null) {
                    context = this.findAndSetFirstSuitableContext((PsiFile)currentFile);
                    element = this.findFirstIncludeElementForFile(context, (BaseJspFile)currentFile);
                }
                if (context == null) break;
                if (element == null) {
                    break;
                }
                if (context instanceof JspFile && !PsiScopesUtil.treeWalkUp((PsiScopeProcessor)processor, (PsiElement)element, (PsiElement)((JspFile)context).getJavaClass())) {
                    boolean bl = false;
                    return bl;
                }
                PsiFile javaFile = context.getViewProvider().getPsi(StdLanguages.JAVA);
                if (javaFile == null) continue;
                javaFile.processDeclarations(processor, ResolveState.initial(), (PsiElement)currentFile, element);
            } while (!files.contains(currentFile = context));
        }
        finally {
            recursionGuard.remove((Object)realInitialFile);
        }
        return true;
    }

    @Nullable
    private PsiElement findFirstIncludeElementForFile(@Nullable BaseJspFile file, @NotNull BaseJspFile referencedFile) {
        if (referencedFile == null) {
            JspContextManagerImpl.$$$reportNull$$$0(8);
        }
        if (file == null || !file.isValid()) {
            return null;
        }
        int minOffset = this.myJspFileIndex.getFirstIncludeElementForFile(file, referencedFile);
        if (minOffset == -1) {
            VirtualFile virtualFile = referencedFile.getVirtualFile();
            if (virtualFile != null) {
                minOffset = file.getTextLength() - 1;
            } else {
                return null;
            }
        }
        return file.getViewProvider().findElementAt(minOffset, StdLanguages.JAVA);
    }

    private void changeContext(String oldUrl, String newUrl) {
        List fileUrls;
        String oldContext = (String)this.myFileUrlToContextUrl.get((Object)oldUrl);
        if (oldContext != null) {
            this.myFileUrlToContextUrl.remove((Object)oldUrl);
            this.myFileUrlToContextUrl.put((Object)newUrl, (Object)oldContext);
        }
        if ((fileUrls = this.myFileUrlToContextUrl.getKeysByValue((Object)oldUrl)) != null) {
            String[] urls;
            for (String fileUrl : urls = ArrayUtil.toStringArray((Collection)fileUrls)) {
                this.myFileUrlToContextUrl.put((Object)fileUrl, (Object)newUrl);
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/source/jsp/JspContextManagerImpl";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileViewProvider";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "referencedFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponentName";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/source/jsp/JspContextManagerImpl";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getConfiguredContextFile";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "setContextFile";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "setContextInternal";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getContextFile";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getSuitableContextFiles";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "processContextElements";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "findFirstIncludeElementForFile";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class JspContextManagerState {
        private List<JspContextMappingState> myMappings = new ArrayList<JspContextMappingState>();

        @Property(surroundWithTag=false)
        @XCollection
        public List<JspContextMappingState> getMappings() {
            return this.myMappings;
        }

        public void setMappings(List<JspContextMappingState> mappings) {
            this.myMappings = mappings;
        }
    }

    @Tag(value="jsp-to-context")
    public static class JspContextMappingState {
        private String myAFileUrl;
        private String myContextFileUrl;

        @Attribute(value="jsp-file")
        public String getAFileUrl() {
            return this.myAFileUrl;
        }

        public void setAFileUrl(String AFileUrl) {
            this.myAFileUrl = AFileUrl;
        }

        @Attribute(value="context-file")
        public String getContextFileUrl() {
            return this.myContextFileUrl;
        }

        public void setContextFileUrl(String contextFileUrl) {
            this.myContextFileUrl = contextFileUrl;
        }
    }

    private class MyVirtualFileListener
    extends VirtualFileUrlChangeAdapter {
        private MyVirtualFileListener() {
        }

        public void fileDeleted(@NotNull VirtualFileEvent event) {
            if (event == null) {
                MyVirtualFileListener.$$$reportNull$$$0(0);
            }
            String fileUrl = event.getFile().getUrl();
            JspContextManagerImpl.this.myFileUrlToContextUrl.remove((Object)fileUrl);
            List list = JspContextManagerImpl.this.myFileUrlToContextUrl.getKeysByValue((Object)fileUrl);
            if (list != null) {
                String[] toRemove;
                for (String s : toRemove = ArrayUtil.toStringArray((Collection)list)) {
                    JspContextManagerImpl.this.myFileUrlToContextUrl.remove((Object)s);
                }
            }
        }

        protected void fileUrlChanged(String oldUrl, String newUrl) {
            JspContextManagerImpl.this.changeContext(oldUrl, newUrl);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/psi/impl/source/jsp/JspContextManagerImpl$MyVirtualFileListener", "fileDeleted"));
        }
    }
}

