/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.resolve.reference.impl.providers;

import com.intellij.codeInsight.daemon.EmptyResolveMessageProvider;
import com.intellij.jsp.impl.FunctionDescriptor;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.PsiBundle;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.psi.PsiType;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReference;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReferenceSet;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.JavaClassReference;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.XmlValueReference;
import com.intellij.psi.meta.PsiMetaData;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ProcessingContext;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TaglibReferenceProvider
extends PsiReferenceProvider {
    @NotNull
    public PsiReference[] getReferencesByElement(@NotNull PsiElement element, @NotNull ProcessingContext context) {
        XmlTag tag;
        String localName;
        if (element == null) {
            TaglibReferenceProvider.$$$reportNull$$$0(0);
        }
        if (context == null) {
            TaglibReferenceProvider.$$$reportNull$$$0(1);
        }
        if ("name".equals(localName = (tag = (XmlTag)element).getLocalName())) {
            if (PsiReference.EMPTY_ARRAY == null) {
                TaglibReferenceProvider.$$$reportNull$$$0(2);
            }
            return PsiReference.EMPTY_ARRAY;
        }
        if ("name-given".equals(localName) || "function-name".equals(localName) || "tag-name".equals(localName)) {
            PsiReference[] psiReferenceArray = new PsiReference[]{new NameReference(tag)};
            if (psiReferenceArray == null) {
                TaglibReferenceProvider.$$$reportNull$$$0(3);
            }
            return psiReferenceArray;
        }
        if ("function-signature".equals(localName)) {
            PsiReference[] psiReferenceArray = new PsiReference[]{new MethodReference(tag)};
            if (psiReferenceArray == null) {
                TaglibReferenceProvider.$$$reportNull$$$0(4);
            }
            return psiReferenceArray;
        }
        if ("path".equals(localName) || "source".equals(localName)) {
            TextRange textRangeInTagValue = ElementManipulators.getValueTextRange((PsiElement)tag);
            FileReference[] fileReferenceArray = new FileReferenceSet(tag.getValue().getText().trim(), (PsiElement)tag, textRangeInTagValue.getStartOffset(), (PsiReferenceProvider)this, true).getAllReferences();
            if (fileReferenceArray == null) {
                TaglibReferenceProvider.$$$reportNull$$$0(5);
            }
            return fileReferenceArray;
        }
        if (PsiReference.EMPTY_ARRAY == null) {
            TaglibReferenceProvider.$$$reportNull$$$0(6);
        }
        return PsiReference.EMPTY_ARRAY;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/source/resolve/reference/impl/providers/TaglibReferenceProvider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/source/resolve/reference/impl/providers/TaglibReferenceProvider";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getReferencesByElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getReferencesByElement";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class MethodReference
    extends XmlValueReference
    implements EmptyResolveMessageProvider {
        private String myUnresolvedMessage;

        MethodReference(XmlTag tag) {
            super(tag);
        }

        private JavaClassReference findFunctionClassReference() {
            PsiReference lastReference;
            PsiReference[] references;
            XmlTag tag;
            XmlTag clazzTag;
            PsiElement parent = this.myTag.getParent();
            if (parent instanceof XmlTag && (clazzTag = (tag = (XmlTag)parent).findFirstSubTag("function-class")) != null && (references = clazzTag.getReferences()).length > 0 && (lastReference = references[references.length - 1]) instanceof JavaClassReference) {
                return (JavaClassReference)lastReference;
            }
            return null;
        }

        private PsiClass resolveClass() {
            PsiElement psiElement;
            JavaClassReference lastReference = this.findFunctionClassReference();
            if (lastReference != null && (psiElement = lastReference.resolve()) instanceof PsiClass) {
                return (PsiClass)psiElement;
            }
            return null;
        }

        @Nullable
        public PsiElement resolve() {
            this.myUnresolvedMessage = PsiBundle.message((String)"jsp.taglib.method.reference.error.class.is.not.valid", (Object[])new Object[0]);
            PsiClass clazz = this.resolveClass();
            if (clazz == null) {
                return null;
            }
            if (!clazz.hasModifierProperty("public")) {
                this.myUnresolvedMessage = PsiBundle.message((String)"jsp.taglib.method.reference.error.class.is.not.public", (Object[])new Object[0]);
                return null;
            }
            PsiMetaData metaData = ((XmlTag)this.myTag.getParent()).getMetaData();
            if (metaData instanceof FunctionDescriptor) {
                FunctionDescriptor functionDescriptor = (FunctionDescriptor)metaData;
                PsiMethod[] methodsByName = clazz.findMethodsByName(functionDescriptor.getFunctionName(), false);
                this.myUnresolvedMessage = methodsByName.length == 0 ? PsiBundle.message((String)"jsp.taglib.method.reference.error.no.such.method", (Object[])new Object[0]) : PsiBundle.message((String)"jsp.taglib.method.reference.error.method.should.be.public.or.static", (Object[])new Object[0]);
                for (int i = 0; i < methodsByName.length; ++i) {
                    PsiMethod psiMethod = methodsByName[i];
                    if (!psiMethod.hasModifierProperty("static") || !psiMethod.hasModifierProperty("public")) continue;
                    PsiParameter[] parameters = psiMethod.getParameterList().getParameters();
                    this.myUnresolvedMessage = PsiBundle.message((String)"jsp.taglib.method.reference.error.signature.is.different", (Object[])new Object[0]);
                    if (parameters.length != functionDescriptor.getParameterCount()) continue;
                    boolean matched = true;
                    int j = 0;
                    for (String parameterType : functionDescriptor.getFunctionParameters()) {
                        if (!MethodReference.isSameType(parameterType, parameters[j].getType().getCanonicalText())) {
                            matched = false;
                            break;
                        }
                        ++j;
                    }
                    if (!matched) continue;
                    if (MethodReference.isSameType(functionDescriptor.getFunctionReturnType(), psiMethod.getReturnType().getCanonicalText())) {
                        this.myUnresolvedMessage = "";
                        return psiMethod;
                    }
                    this.myUnresolvedMessage = PsiBundle.message((String)"jsp.taglib.method.reference.error.different.return.type", (Object[])new Object[0]);
                    return null;
                }
            }
            return null;
        }

        private static boolean isSameType(String functionReturnType, String returnTypeText) {
            return functionReturnType.equals(returnTypeText) || returnTypeText.startsWith(functionReturnType) && returnTypeText.charAt(functionReturnType.length()) == '<' && returnTypeText.charAt(returnTypeText.length() - 1) == '>';
        }

        public PsiElement handleElementRename(String newElementName) throws IncorrectOperationException {
            PsiMetaData metaData = ((XmlTag)this.myTag.getParent()).getMetaData();
            if (metaData instanceof FunctionDescriptor) {
                FunctionDescriptor descriptor = (FunctionDescriptor)metaData;
                StringBuffer newsignature = new StringBuffer(descriptor.getFunctionSignature().length());
                newsignature.append(descriptor.getFunctionReturnType()).append(" ").append(newElementName).append('(');
                boolean first = true;
                for (String parameterType : descriptor.getFunctionParameters()) {
                    if (!first) {
                        newsignature.append(',');
                    }
                    first = false;
                    newsignature.append(parameterType);
                }
                newsignature.append(')');
                this.replaceContent(newsignature.toString());
            }
            return null;
        }

        public PsiElement bindToElement(@NotNull PsiElement element) throws IncorrectOperationException {
            JavaClassReference javaClassReference;
            if (element == null) {
                MethodReference.$$$reportNull$$$0(0);
            }
            if ((javaClassReference = this.findFunctionClassReference()) != null) {
                javaClassReference.bindToElement(element.getParent());
            }
            return null;
        }

        @NotNull
        public Object[] getVariants() {
            PsiClass psiClass = this.resolveClass();
            if (psiClass != null && psiClass.hasModifierProperty("public")) {
                PsiMethod[] allMethods = psiClass.getAllMethods();
                ArrayList<String> candidates = new ArrayList<String>(1);
                for (PsiMethod method : allMethods) {
                    if (!method.hasModifierProperty("public") || !method.hasModifierProperty("static")) continue;
                    StringBuffer signature = new StringBuffer();
                    signature.append(MethodReference.buildTypeImage(method.getReturnType()));
                    signature.append(" ");
                    signature.append(method.getName());
                    signature.append("(");
                    boolean first = true;
                    for (PsiParameter parameter : method.getParameterList().getParameters()) {
                        if (!first) {
                            signature.append(",");
                        }
                        signature.append(MethodReference.buildTypeImage(parameter.getType()));
                        first = false;
                    }
                    signature.append(")");
                    candidates.add(signature.toString());
                }
                Object[] objectArray = ArrayUtil.toStringArray(candidates);
                if (objectArray == null) {
                    MethodReference.$$$reportNull$$$0(1);
                }
                return objectArray;
            }
            if (ArrayUtil.EMPTY_OBJECT_ARRAY == null) {
                MethodReference.$$$reportNull$$$0(2);
            }
            return ArrayUtil.EMPTY_OBJECT_ARRAY;
        }

        private static String buildTypeImage(PsiType returnType) {
            if (returnType == null) {
                return null;
            }
            String image = returnType.getCanonicalText();
            int gt = image.indexOf(60);
            if (gt != -1) {
                image = image.substring(0, gt);
            }
            return image;
        }

        @NotNull
        public String getUnresolvedMessagePattern() {
            String string = this.myUnresolvedMessage;
            if (string == null) {
                MethodReference.$$$reportNull$$$0(3);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/psi/impl/source/resolve/reference/impl/providers/TaglibReferenceProvider$MethodReference";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/psi/impl/source/resolve/reference/impl/providers/TaglibReferenceProvider$MethodReference";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getVariants";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getUnresolvedMessagePattern";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "bindToElement";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    static class NameReference
    extends XmlValueReference {
        protected NameReference(XmlTag tag) {
            super(tag);
        }

        @Nullable
        public PsiElement resolve() {
            return this.myTag.getParent();
        }

        public PsiElement handleElementRename(String newElementName) throws IncorrectOperationException {
            this.replaceContent(newElementName);
            return null;
        }

        public PsiElement bindToElement(@NotNull PsiElement element) throws IncorrectOperationException {
            if (element == null) {
                NameReference.$$$reportNull$$$0(0);
            }
            return null;
        }

        @NotNull
        public Object[] getVariants() {
            if (ArrayUtil.EMPTY_OBJECT_ARRAY == null) {
                NameReference.$$$reportNull$$$0(1);
            }
            return ArrayUtil.EMPTY_OBJECT_ARRAY;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/psi/impl/source/resolve/reference/impl/providers/TaglibReferenceProvider$NameReference";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/psi/impl/source/resolve/reference/impl/providers/TaglibReferenceProvider$NameReference";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getVariants";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "bindToElement";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

