/*
 * Decompiled with CFR 0.152.
 */
package com.github.markusbernhardt.proxy.search.browser.firefox;

import com.github.markusbernhardt.proxy.search.browser.firefox.FirefoxProfileSource;
import com.github.markusbernhardt.proxy.util.Logger;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Map;
import java.util.Properties;
import org.ini4j.Ini;
import org.ini4j.Profile;

class FirefoxSettingParser {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Properties parseSettings(FirefoxProfileSource source) throws IOException {
        File profileFolder = null;
        File profilesIniFile = source.getProfilesIni();
        if (profilesIniFile.exists()) {
            Ini profilesIni = new Ini(profilesIniFile);
            for (Map.Entry entry : profilesIni.entrySet()) {
                if (!"default".equals(((Profile.Section)entry.getValue()).get((Object)"Name")) || !"1".equals(((Profile.Section)entry.getValue()).get((Object)"IsRelative"))) continue;
                profileFolder = new File(profilesIniFile.getParentFile().getAbsolutePath(), (String)((Profile.Section)entry.getValue()).get((Object)"Path"));
            }
        }
        if (profileFolder != null) {
            Logger.log(this.getClass(), Logger.LogLevel.DEBUG, "Firefox settings folder is {0}", profileFolder);
        } else {
            Logger.log(this.getClass(), Logger.LogLevel.DEBUG, "Firefox settings folder not found!", new Object[0]);
        }
        File settingsFile = new File(profileFolder, "prefs.js");
        BufferedReader fin = new BufferedReader(new InputStreamReader(new FileInputStream(settingsFile)));
        Properties result = new Properties();
        try {
            String line = fin.readLine();
            while (line != null) {
                if ((line = line.trim()).startsWith("user_pref(\"network.proxy")) {
                    String value;
                    int index;
                    String key = (line = line.substring(10, line.length() - 2)).substring(0, index = line.indexOf(",")).trim();
                    if (key.startsWith("\"")) {
                        key = key.substring(1);
                    }
                    if (key.endsWith("\"")) {
                        key = key.substring(0, key.length() - 1);
                    }
                    if ((value = line.substring(index + 1).trim()).startsWith("\"")) {
                        value = value.substring(1);
                    }
                    if (value.endsWith("\"")) {
                        value = value.substring(0, value.length() - 1);
                    }
                    result.put(key, value);
                }
                line = fin.readLine();
            }
        }
        finally {
            fin.close();
        }
        return result;
    }
}

