/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.seam.dependencies;

import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.graph.GraphManager;
import com.intellij.openapi.graph.base.Graph;
import com.intellij.openapi.graph.builder.GraphBuilder;
import com.intellij.openapi.graph.builder.components.SelectionDependenciesPresentationModel;
import com.intellij.openapi.graph.builder.renderer.BasicGraphNodeRenderer;
import com.intellij.openapi.graph.builder.util.GraphViewUtil;
import com.intellij.openapi.graph.layout.LayoutStage;
import com.intellij.openapi.graph.layout.OrientationLayouter;
import com.intellij.openapi.graph.layout.hierarchic.HierarchicGroupLayouter;
import com.intellij.openapi.graph.layout.hierarchic.HierarchicLayouter;
import com.intellij.openapi.graph.settings.GraphSettings;
import com.intellij.openapi.graph.view.Arrow;
import com.intellij.openapi.graph.view.EdgeRealizer;
import com.intellij.openapi.graph.view.EditMode;
import com.intellij.openapi.graph.view.Graph2D;
import com.intellij.openapi.graph.view.Graph2DView;
import com.intellij.openapi.graph.view.LineType;
import com.intellij.openapi.graph.view.NodeCellEditor;
import com.intellij.openapi.graph.view.NodeCellRenderer;
import com.intellij.openapi.graph.view.NodeRealizer;
import com.intellij.openapi.graph.view.PolyLineEdgeRealizer;
import com.intellij.openapi.module.Module;
import com.intellij.pom.Navigatable;
import com.intellij.psi.PsiElement;
import com.intellij.seam.dependencies.beans.SeamComponentNodeInfo;
import com.intellij.seam.dependencies.beans.SeamDependencyInfo;
import com.intellij.seam.dependencies.renderers.DefaultSeamComponentRenderer;
import com.intellij.util.OpenSourceUtil;
import java.awt.Color;
import org.jetbrains.annotations.NotNull;

public class SeamDependenciesPresentationModel
extends SelectionDependenciesPresentationModel<SeamComponentNodeInfo, SeamDependencyInfo> {
    private final Module myProject;
    private BasicGraphNodeRenderer myRenderer;

    public SeamDependenciesPresentationModel(Graph2D graph, Module module) {
        super((Graph)graph);
        this.myProject = module;
        this.setShowEdgeLabels(true);
        SeamDependenciesPresentationModel.customizeDefaultSettings(this.getSettings());
    }

    private static void customizeDefaultSettings(GraphSettings settings) {
        HierarchicGroupLayouter groupLayouter = settings.getGroupLayouter();
        groupLayouter.setOrientationLayouter((LayoutStage)GraphManager.getGraphManager().createOrientationLayouter(OrientationLayouter.TOP_TO_BOTTOM));
        groupLayouter.setMinimalNodeDistance(20.0);
        groupLayouter.setMinimalLayerDistance(50.0);
        groupLayouter.setRoutingStyle(HierarchicLayouter.ROUTE_POLYLINE);
    }

    @NotNull
    public NodeRealizer getNodeRealizer(SeamComponentNodeInfo node) {
        NodeRealizer nodeRealizer = GraphViewUtil.createNodeRealizer((String)"SeamComponentNodeInfoRenderer", (NodeCellRenderer)this.getRenderer());
        if (nodeRealizer == null) {
            SeamDependenciesPresentationModel.$$$reportNull$$$0(0);
        }
        return nodeRealizer;
    }

    public BasicGraphNodeRenderer getRenderer() {
        if (this.myRenderer == null) {
            this.myRenderer = new DefaultSeamComponentRenderer((GraphBuilder<SeamComponentNodeInfo, SeamDependencyInfo>)this.getGraphBuilder());
        }
        return this.myRenderer;
    }

    @NotNull
    public EdgeRealizer getEdgeRealizer(SeamDependencyInfo edge) {
        PolyLineEdgeRealizer edgeRealizer = GraphManager.getGraphManager().createPolyLineEdgeRealizer();
        edgeRealizer.setLineType(LineType.LINE_1);
        edgeRealizer.setLineColor(Color.GRAY);
        edgeRealizer.setArrow(Arrow.STANDARD);
        PolyLineEdgeRealizer polyLineEdgeRealizer = edgeRealizer;
        if (polyLineEdgeRealizer == null) {
            SeamDependenciesPresentationModel.$$$reportNull$$$0(1);
        }
        return polyLineEdgeRealizer;
    }

    public boolean editNode(SeamComponentNodeInfo node) {
        PsiElement psiElement = node.getIdentifyingElement().getIdentifyingPsiElement();
        if (psiElement instanceof Navigatable) {
            OpenSourceUtil.navigate((Navigatable[])new Navigatable[]{(Navigatable)psiElement});
            return true;
        }
        return super.editNode((Object)node);
    }

    public boolean editEdge(SeamDependencyInfo info) {
        PsiElement psiElement = info.getIdentifyingElement().getIdentifyingPsiElement();
        if (psiElement instanceof Navigatable) {
            OpenSourceUtil.navigate((Navigatable[])new Navigatable[]{(Navigatable)psiElement});
            return true;
        }
        return super.editEdge((Object)info);
    }

    public String getNodeTooltip(SeamComponentNodeInfo node) {
        return node.getName();
    }

    public String getEdgeTooltip(SeamDependencyInfo edge) {
        return edge.getName();
    }

    public void customizeSettings(Graph2DView view, EditMode editMode) {
        editMode.allowEdgeCreation(false);
        editMode.allowBendCreation(false);
        view.setFitContentOnResize(false);
        view.fitContent();
    }

    public NodeCellEditor getCustomNodeCellEditor(SeamComponentNodeInfo SeamComponentNodeInfo2) {
        return null;
    }

    public DefaultActionGroup getNodeActionGroup(SeamComponentNodeInfo info) {
        return super.getNodeActionGroup((Object)info);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/seam/dependencies/SeamDependenciesPresentationModel";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getNodeRealizer";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getEdgeRealizer";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

