/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.seam.highlighting.xml;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiType;
import com.intellij.psi.xml.XmlFile;
import com.intellij.seam.model.jam.MergedSeamComponent;
import com.intellij.seam.model.jam.SeamJamComponent;
import com.intellij.seam.model.jam.SeamJamInstall;
import com.intellij.seam.model.jam.SeamJamModel;
import com.intellij.seam.model.xml.SeamDomModel;
import com.intellij.seam.model.xml.SeamDomModelManager;
import com.intellij.seam.model.xml.components.SeamComponents;
import com.intellij.seam.model.xml.components.SeamDomComponent;
import com.intellij.seam.resources.SeamInspectionBundle;
import com.intellij.seam.utils.SeamCommonUtils;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomFileElement;
import com.intellij.util.xml.GenericAttributeValue;
import com.intellij.util.xml.highlighting.BasicDomElementsInspection;
import com.intellij.util.xml.highlighting.DomElementAnnotationHolder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class SeamDomModelInspection
extends BasicDomElementsInspection<SeamComponents> {
    public SeamDomModelInspection() {
        super(SeamComponents.class, new Class[0]);
    }

    public void checkFileElement(DomFileElement<SeamComponents> seamComponents, DomElementAnnotationHolder holder) {
        super.checkFileElement(seamComponents, holder);
        SeamDomModelInspection.checkJamDuplicatedComponents(seamComponents, holder);
    }

    private static void checkJamDuplicatedComponents(DomFileElement<SeamComponents> seamComponents, DomElementAnnotationHolder holder) {
        XmlFile xmlFile = seamComponents.getFile();
        Module module = ModuleUtil.findModuleForPsiElement((PsiElement)xmlFile);
        SeamDomModel model = SeamDomModelManager.getInstance(xmlFile.getProject()).getSeamModel(xmlFile);
        if (model != null && module != null) {
            Map<String, List<SeamJamComponent>> map = SeamDomModelInspection.getJamComponentNames(module);
            for (SeamDomComponent domComponent : model.getSeamComponents()) {
                List<SeamJamComponent> components;
                String name = domComponent.getComponentName();
                PsiType type = domComponent.getComponentType();
                if (name == null || type == null || !map.containsKey(name) || (components = map.get(name)) == null) continue;
                ArrayList<String> duplicatedInFiles = new ArrayList<String>();
                for (SeamJamComponent component : components) {
                    PsiFile containingFile;
                    SeamJamComponent pair;
                    PsiType psiType;
                    if (component instanceof MergedSeamComponent || (psiType = component.getComponentType()) == null || type.isAssignableFrom(psiType) || ((pair = SeamCommonUtils.getPair(domComponent)) != null || !SeamCommonUtils.comparelInstalls(component, domComponent)) && (pair == null || !SeamCommonUtils.comparelInstalls(pair, component)) || (containingFile = component.getContainingFile()) == null) continue;
                    duplicatedInFiles.add(containingFile.getName());
                }
                if (duplicatedInFiles.size() <= 0) continue;
                GenericAttributeValue value = domComponent.getName();
                holder.createProblem((DomElement)(value.getXmlAttribute() == null ? domComponent : value), SeamInspectionBundle.message("jam.duplicated.component.annotation", duplicatedInFiles, duplicatedInFiles.size() > 1 ? "s:" : ""), new LocalQuickFix[0]);
            }
        }
    }

    private static Map<String, List<SeamJamComponent>> getJamComponentNames(Module module) {
        HashMap<String, List<SeamJamComponent>> result = new HashMap<String, List<SeamJamComponent>>();
        Set<SeamJamComponent> jamComponents = SeamJamModel.getModel(module).getSeamComponents(false);
        for (SeamJamComponent jamComponent : jamComponents) {
            if (jamComponent.getPsiElement() instanceof PsiCompiledElement) continue;
            String name = jamComponent.getComponentName();
            PsiFile psiFile = jamComponent.getContainingFile();
            SeamJamInstall install = jamComponent.getInstall();
            if (install != null && !install.isInstall() || StringUtil.isEmptyOrSpaces((String)name) || psiFile == null) continue;
            if (!result.containsKey(name)) {
                result.put(name, new ArrayList());
            }
            ((List)result.get(name)).add(jamComponent);
        }
        return result;
    }

    @NotNull
    public String getGroupDisplayName() {
        String string = SeamInspectionBundle.message("model.inspection.group.name", new Object[0]);
        if (string == null) {
            SeamDomModelInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    public String getDisplayName() {
        String string = SeamInspectionBundle.message("model.inspection.display.name", new Object[0]);
        if (string == null) {
            SeamDomModelInspection.$$$reportNull$$$0(1);
        }
        return string;
    }

    @NotNull
    @NonNls
    public String getShortName() {
        if ("SeamDomModelInspection" == null) {
            SeamDomModelInspection.$$$reportNull$$$0(2);
        }
        return "SeamDomModelInspection";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/seam/highlighting/xml/SeamDomModelInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getGroupDisplayName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getShortName";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

