/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.j2ee.appServerIntegrations;

import com.intellij.j2ee.appServerIntegrations.impl.ApplicationServerImpl;
import com.intellij.javaee.J2EEBundle;
import com.intellij.javaee.appServerIntegrations.AppServerIntegration;
import com.intellij.javaee.appServerIntegrations.ApplicationServer;
import com.intellij.javaee.appServerIntegrations.ApplicationServerHelper;
import com.intellij.javaee.appServerIntegrations.ApplicationServerInfo;
import com.intellij.javaee.appServerIntegrations.ApplicationServerPersistentData;
import com.intellij.javaee.appServerIntegrations.ApplicationServerPersistentDataEditor;
import com.intellij.javaee.appServerIntegrations.CantFindApplicationServerJarsException;
import com.intellij.javaee.serverInstances.ApplicationServersManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.options.BaseConfigurable;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.options.SettingsEditorListener;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.util.Disposer;
import java.awt.Component;
import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.Nullable;

public class ApplicationServersUtil {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.j2ee.appServerIntegrations.ApplicationServersUtil");

    private ApplicationServersUtil() {
    }

    public static ApplicationServerImpl createNewApplicationServer(AppServerIntegration integration, ApplicationServersManager.ApplicationServersManagerModifiableModel modifiableModel, Collection<ApplicationServer> existing, JPanel parent) {
        return ApplicationServersUtil.createNewApplicationServer(integration, modifiableModel, existing, parent, null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ApplicationServerImpl createNewApplicationServer(AppServerIntegration integration, ApplicationServersManager.ApplicationServersManagerModifiableModel modifiableModel, Collection<ApplicationServer> existing, JPanel parent, @Nullable String serverName) {
        ApplicationServerInfo applicationInfo = null;
        ApplicationServerHelper helper = integration == null ? null : integration.getApplicationServerHelper();
        ApplicationServerPersistentData[] persistentData = new ApplicationServerPersistentData[]{null};
        if (helper != null) {
            persistentData[0] = helper.createPersistentDataEmptyInstance();
            ApplicationServerPersistentDataEditor editor = helper.createConfigurable();
            if (editor != null) {
                ApplicationServerConfigurable appServerConfigurable = new ApplicationServerConfigurable(persistentData[0], integration, editor, helper);
                boolean success = ShowSettingsUtil.getInstance().editConfigurable((Component)parent, (Configurable)appServerConfigurable);
                Disposer.dispose((Disposable)editor);
                if (!success) return null;
                applicationInfo = appServerConfigurable.getApplicationServerInfo();
            } else {
                try {
                    applicationInfo = helper.getApplicationServerInfo(persistentData[0]);
                }
                catch (CantFindApplicationServerJarsException e) {
                    LOG.error("Integration does validation without defined configuration UI: " + integration, (Throwable)e);
                    return null;
                }
            }
        }
        if (applicationInfo == null) {
            applicationInfo = new ApplicationServerInfo(new File[0], J2EEBundle.message((String)"generic.application.server.default.name", (Object[])new Object[0]));
        }
        ApplicationServerInfo finalApplicationInfo = applicationInfo;
        ApplicationServerImpl newServer = (ApplicationServerImpl)WriteAction.compute(() -> {
            String name = ApplicationServersUtil.createUniqueName(serverName != null ? serverName : finalApplicationInfo.getDefaultName(), existing);
            return (ApplicationServerImpl)modifiableModel.createNewApplicationServer(name, finalApplicationInfo.getDefaultLibraries(), persistentData[0]);
        });
        if (integration == null) return newServer;
        newServer.setSourceIntegrationName(integration.getPresentableName());
        return newServer;
    }

    private static String createUniqueName(String defName, Collection<ApplicationServer> appServerDKs) {
        HashSet<String> existingNames = new HashSet<String>();
        for (ApplicationServer applicationServer : appServerDKs) {
            existingNames.add(applicationServer.getName());
        }
        if (!existingNames.contains(defName)) {
            return defName;
        }
        int i = 1;
        String newName;
        while (existingNames.contains(newName = defName + i)) {
            ++i;
        }
        return newName;
    }

    public static void sortByName(List<ApplicationServer> servers) {
        Collections.sort(servers, (s1, s2) -> s1.getName().compareTo(s2.getName()));
    }

    private static class ApplicationServerConfigurable
    extends BaseConfigurable {
        private final ApplicationServerPersistentData myPersistentData;
        private final AppServerIntegration myIntegration;
        private final ApplicationServerPersistentDataEditor myEditor;
        private final ApplicationServerHelper myHelper;
        private ApplicationServerInfo myApplicationServerInfo;

        public ApplicationServerConfigurable(ApplicationServerPersistentData persistentData, AppServerIntegration integration, ApplicationServerPersistentDataEditor editor, ApplicationServerHelper helper) {
            this.myPersistentData = persistentData;
            this.myIntegration = integration;
            this.myEditor = editor;
            this.myHelper = helper;
            this.myEditor.addSettingsEditorListener(new SettingsEditorListener(){

                public void stateChanged(SettingsEditor settingsEditor) {
                    this.setModified(true);
                }
            });
        }

        public String getDisplayName() {
            return this.myIntegration.getPresentableName();
        }

        public JComponent createComponent() {
            return this.myEditor.getComponent();
        }

        public void apply() throws ConfigurationException {
            try {
                ApplicationServerPersistentData tempPersistentData = this.myHelper.createPersistentDataEmptyInstance();
                if (tempPersistentData != null) {
                    this.myEditor.applyTo((Object)tempPersistentData);
                }
                this.myApplicationServerInfo = this.myHelper.getApplicationServerInfo(tempPersistentData);
            }
            catch (CantFindApplicationServerJarsException e) {
                throw new ConfigurationException(e.getLocalizedMessage());
            }
            this.myEditor.applyTo((Object)this.myPersistentData);
            try {
                this.myApplicationServerInfo = this.myHelper.getApplicationServerInfo(this.myPersistentData);
                this.setModified(false);
            }
            catch (CantFindApplicationServerJarsException e) {
                this.setModified(true);
                throw new ConfigurationException(e.getLocalizedMessage());
            }
        }

        public void reset() {
            this.myEditor.resetFrom((Object)this.myPersistentData);
            try {
                this.myApplicationServerInfo = this.myHelper.getApplicationServerInfo(this.myPersistentData);
                this.setModified(false);
            }
            catch (CantFindApplicationServerJarsException e) {
                this.setModified(true);
            }
        }

        public ApplicationServerInfo getApplicationServerInfo() {
            return this.myApplicationServerInfo;
        }
    }
}

