/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee;

import com.intellij.jam.model.common.CommonModelElement;
import com.intellij.javaee.JavaeeFieldRefactoringSupport;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.codeStyle.NameUtil;
import com.intellij.psi.impl.light.LightElement;
import com.intellij.psi.search.SearchScope;
import com.intellij.refactoring.rename.RenameDialog;
import com.intellij.refactoring.rename.RenamePsiElementProcessor;
import com.intellij.util.ObjectUtils;
import java.util.Collection;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class JavaeeRenameProcessor<T extends CommonModelElement>
extends RenamePsiElementProcessor {
    private static final Key<PsiElement> ORIGINAL_PSI_ELEMENT = Key.create((String)"ORIGINAL_PSI_ELEMENT");
    private final JavaeeFieldRefactoringSupport<T> myRefactoringSupport;

    protected JavaeeRenameProcessor(JavaeeFieldRefactoringSupport<T> refactoringSupport) {
        this.myRefactoringSupport = refactoringSupport;
    }

    public boolean canProcessElement(@NotNull PsiElement element) {
        if (element == null) {
            JavaeeRenameProcessor.$$$reportNull$$$0(0);
        }
        return this.myRefactoringSupport.getModelElement(element) != null;
    }

    @NotNull
    public RenameDialog createRenameDialog(@NotNull Project project, @NotNull PsiElement element, PsiElement nameSuggestionContext, Editor editor) {
        if (project == null) {
            JavaeeRenameProcessor.$$$reportNull$$$0(1);
        }
        if (element == null) {
            JavaeeRenameProcessor.$$$reportNull$$$0(2);
        }
        PsiElement originalElement = (PsiElement)ObjectUtils.assertNotNull((Object)element.getUserData(ORIGINAL_PSI_ELEMENT));
        CommonModelElement modelElement = (CommonModelElement)ObjectUtils.assertNotNull((Object)this.myRefactoringSupport.getModelElement(element));
        boolean b = this.myRefactoringSupport.askUserIfAccessorsShouldBeTakenIntoAccount(modelElement, originalElement);
        if (!b) {
            RenameDialog renameDialog = super.createRenameDialog(project, originalElement, nameSuggestionContext, editor);
            if (renameDialog == null) {
                JavaeeRenameProcessor.$$$reportNull$$$0(3);
            }
            return renameDialog;
        }
        RenameDialog renameDialog = new RenameDialog(project, element, null, null){

            protected boolean hasHelpAction() {
                return false;
            }

            protected boolean isToSearchInCommentsForRename() {
                return false;
            }

            protected boolean isToSearchForTextOccurrencesForRename() {
                return true;
            }
        };
        if (renameDialog == null) {
            JavaeeRenameProcessor.$$$reportNull$$$0(4);
        }
        return renameDialog;
    }

    public PsiElement substituteElementToRename(@NotNull PsiElement element, @Nullable Editor editor) {
        if (element == null) {
            JavaeeRenameProcessor.$$$reportNull$$$0(5);
        }
        CommonModelElement modelElement = (CommonModelElement)ObjectUtils.assertNotNull((Object)this.myRefactoringSupport.getModelElement(element));
        PsiElement result = (PsiElement)ObjectUtils.assertNotNull((Object)modelElement.getIdentifyingPsiElement());
        result.putUserData(ORIGINAL_PSI_ELEMENT, (Object)element);
        return result;
    }

    public void prepareRenaming(@NotNull PsiElement element, @NotNull String newName, @NotNull Map<PsiElement, String> allRenames, @NotNull SearchScope scope) {
        PsiElement originalElement;
        if (element == null) {
            JavaeeRenameProcessor.$$$reportNull$$$0(6);
        }
        if (newName == null) {
            JavaeeRenameProcessor.$$$reportNull$$$0(7);
        }
        if (allRenames == null) {
            JavaeeRenameProcessor.$$$reportNull$$$0(8);
        }
        if (scope == null) {
            JavaeeRenameProcessor.$$$reportNull$$$0(9);
        }
        if ((originalElement = (PsiElement)element.getUserData(ORIGINAL_PSI_ELEMENT)) == null) {
            return;
        }
        CommonModelElement modelElement = (CommonModelElement)ObjectUtils.assertNotNull((Object)this.myRefactoringSupport.getModelElement(element));
        Collection accessors = this.myRefactoringSupport.getAccessors(modelElement);
        for (PsiElement accessor : accessors) {
            if (accessor instanceof LightElement) continue;
            if (accessor instanceof PsiMethod) {
                PsiMethod method = (PsiMethod)accessor;
                String prefix = NameUtil.nameToWords((String)method.getName())[0];
                allRenames.put(accessor, prefix + StringUtil.capitalize((String)newName));
                continue;
            }
            if (accessor instanceof PsiField) {
                allRenames.put(accessor, newName);
                continue;
            }
            throw new AssertionError((Object)("Invalid accessor: " + element));
        }
    }

    public boolean isInplaceRenameSupported() {
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javaee/JavaeeRenameProcessor";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newName";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "allRenames";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javaee/JavaeeRenameProcessor";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createRenameDialog";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "canProcessElement";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createRenameDialog";
                break;
            }
            case 3: 
            case 4: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "substituteElementToRename";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "prepareRenaming";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

