/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.dataSource;

import com.intellij.CommonBundle;
import com.intellij.database.DatabaseMessages;
import com.intellij.database.dataSource.DataSourceProvider;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dataSource.ServerInstance;
import com.intellij.database.psi.DbPsiFacade;
import com.intellij.database.view.ui.DataSourceManagerDialog;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.javaee.appServerIntegrations.AppServerIntegration;
import com.intellij.javaee.run.execution.JavaeeConsoleView;
import com.intellij.javaee.serverInstances.J2EEServerInstance;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.PerformInBackgroundOption;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.util.JavaeeIcons;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.LinkedHashSet;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public class DataSourceAddFromServerAction
extends AnAction {
    public DataSourceAddFromServerAction() {
        super(DatabaseMessages.message((String)"action.name.import.data.sources", (Object[])new Object[]{"server"}), DatabaseMessages.message((String)"action.description.import.data.sources", (Object[])new Object[]{"server"}), JavaeeIcons.DATASOURCE_REMOTE_INSTANCE);
    }

    public void update(AnActionEvent e) {
        super.update(e);
        JavaeeConsoleView consoleView = (JavaeeConsoleView)e.getData(JavaeeConsoleView.KEY);
        Presentation presentation = e.getPresentation();
        if (consoleView != null) {
            AppServerIntegration integration = consoleView.getIntegration();
            DataSourceProvider sourceProvider = integration.getDataSourceProvider();
            ProcessHandler processHandler = consoleView.getProcessHandler();
            presentation.setVisible(sourceProvider != null);
            presentation.setEnabled(processHandler.isStartNotified() && !processHandler.isProcessTerminating() && !processHandler.isProcessTerminated());
            presentation.setText(DatabaseMessages.message((String)"action.name.import.data.sources", (Object[])new Object[]{integration.getPresentableName()}));
            presentation.setDescription(DatabaseMessages.message((String)"action.description.import.data.sources", (Object[])new Object[]{integration.getPresentableName()}));
        } else {
            presentation.setVisible(false);
            presentation.setEnabled(false);
        }
    }

    public void actionPerformed(AnActionEvent e) {
        JavaeeConsoleView consoleView = (JavaeeConsoleView)e.getData(JavaeeConsoleView.KEY);
        if (consoleView == null) {
            return;
        }
        DataSourceProvider dataSourceProvider = consoleView.getIntegration().getDataSourceProvider();
        if (dataSourceProvider == null) {
            return;
        }
        J2EEServerInstance serverInstance = consoleView.getServerInstance();
        Project project = serverInstance.getCommonModel().getProject();
        if (!serverInstance.isConnected()) {
            Messages.showErrorDialog((Project)project, (String)"Server is not connected", (String)CommonBundle.getErrorTitle());
            return;
        }
        DataSourceAddFromServerAction.importDataSources(project, dataSourceProvider, (ServerInstance)serverInstance);
    }

    public static void importDataSources(final Project project, final DataSourceProvider dataSourceProvider, final ServerInstance serverInstance) {
        final LinkedHashSet dataSources = ContainerUtil.newLinkedHashSet();
        Task.Backgroundable task = new Task.Backgroundable(project, DatabaseMessages.message((String)"message.text.refreshing.data.source", (Object[])new Object[0]), true, PerformInBackgroundOption.DEAF){

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    1.$$$reportNull$$$0(0);
                }
                dataSources.addAll(ContainerUtil.findAll((Collection)dataSourceProvider.loadDataSourcesFromServer(serverInstance), LocalDataSource.class));
                ApplicationManager.getApplication().invokeLater(() -> {
                    if (dataSources.isEmpty()) {
                        Messages.showMessageDialog((Project)project, (String)DatabaseMessages.message((String)"message.no.datasources.to.import.found", (Object[])new Object[0]), (String)DatabaseMessages.message((String)"dialog.title.import.datasources", (Object[])new Object[0]), (Icon)Messages.getWarningIcon());
                    } else {
                        DataSourceManagerDialog.showLocalDataSourcesDialog((DbPsiFacade)DbPsiFacade.getInstance((Project)project), (Collection)dataSources);
                    }
                });
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/javaee/dataSource/DataSourceAddFromServerAction$1", "run"));
            }
        };
        task.queue();
    }
}

