/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.ejb.inspections;

import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInsight.daemon.impl.analysis.annotator.EjbHighlightingMessages;
import com.intellij.codeInsight.intention.QuickFixFactory;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.LocalQuickFixAndIntentionActionOnPsiElement;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.javaee.ejb.EjbUtil;
import com.intellij.javaee.ejb.OldEjbRolesUtil;
import com.intellij.javaee.ejb.inspections.AbstractEjbInspection;
import com.intellij.javaee.ejb.inspections.EjbHighlightUtil;
import com.intellij.javaee.ejb.role.EjbClassRole;
import com.intellij.javaee.ejb.role.EjbClassRoleEnum;
import com.intellij.javaee.ejb.role.EjbMethodRole;
import com.intellij.javaee.model.common.ejb.EjbWithHome;
import com.intellij.javaee.model.common.ejb.EnterpriseBean;
import com.intellij.javaee.model.common.ejb.SessionBean;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class EjbRemoteRequirementsInspection
extends AbstractEjbInspection {
    @Nls
    @NotNull
    public String getDisplayName() {
        String string = EjbHighlightingMessages.message("inspection.name.remote.requirements", new Object[0]);
        if (string == null) {
            EjbRemoteRequirementsInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    public String getShortName() {
        if ("EjbRemoteRequirementsInspection" == null) {
            EjbRemoteRequirementsInspection.$$$reportNull$$$0(1);
        }
        return "EjbRemoteRequirementsInspection";
    }

    @NotNull
    public HighlightDisplayLevel getDefaultLevel() {
        HighlightDisplayLevel highlightDisplayLevel = HighlightDisplayLevel.ERROR;
        if (highlightDisplayLevel == null) {
            EjbRemoteRequirementsInspection.$$$reportNull$$$0(2);
        }
        return highlightDisplayLevel;
    }

    @Override
    protected boolean acceptClass(PsiClass psiClass) {
        EjbClassRole[] roles;
        for (EjbClassRole role : roles = OldEjbRolesUtil.getEjbRoles(psiClass)) {
            EjbClassRoleEnum type = role.getType();
            if (!type.isInterface()) continue;
            return true;
        }
        return false;
    }

    @Override
    protected JavaElementVisitor createJavaVisitor(final @NotNull ProblemsHolder holder, boolean onTheFly) {
        if (holder == null) {
            EjbRemoteRequirementsInspection.$$$reportNull$$$0(3);
        }
        return new JavaElementVisitor(){

            public void visitClass(PsiClass aClass) {
            }

            public void visitField(PsiField field) {
                if (AbstractEjbInspection.getRoleTypes(OldEjbRolesUtil.getEjbRoles(field.getContainingClass())).contains(EjbClassRoleEnum.EJB_CLASS_ROLE_SERVICE_ENDPOINT_INTERFACE)) {
                    holder.registerProblem((PsiElement)field, EjbHighlightingMessages.message("service.endpoint.interface.cannot.have.fields", new Object[0]), new LocalQuickFix[0]);
                }
            }

            public void visitMethod(PsiMethod method) {
                EjbClassRole[] roles = OldEjbRolesUtil.getEjbRoles(method.getContainingClass());
                EjbMethodRole[] methodRoles = OldEjbRolesUtil.getEjbRoles(method);
                boolean checkLocal = false;
                boolean checkRemote = false;
                for (EjbClassRole role : roles) {
                    if (!role.getType().isInterface()) continue;
                    if (role.getType().isRemote()) {
                        checkRemote = true;
                        continue;
                    }
                    checkLocal = true;
                }
                if (checkRemote) {
                    EjbRemoteRequirementsInspection.checkMethodThrowsRemoteException(holder, method, methodRoles);
                    EjbRemoteRequirementsInspection.checkMethodRMICompatible(holder, method);
                    EjbRemoteRequirementsInspection.checkLocalInterfacesNotExposed(holder, method, methodRoles);
                }
                if (checkLocal) {
                    EjbHighlightUtil.checkMethodThrows(holder, method, "java.rmi.RemoteException", false);
                }
                if (AbstractEjbInspection.getRoleTypes(roles).contains(EjbClassRoleEnum.EJB_CLASS_ROLE_SERVICE_ENDPOINT_INTERFACE)) {
                    EjbRemoteRequirementsInspection.this.checkBeanInterfacesNotExposed(holder, method, methodRoles);
                }
            }
        };
    }

    /*
     * WARNING - void declaration
     */
    private static void checkLocalInterfacesNotExposed(ProblemsHolder holder, PsiMethod method, EjbMethodRole[] methodRoles) {
        void var8_10;
        PsiType returnType = method.getReturnType();
        if (returnType == null) {
            return;
        }
        HashSet<Object> interfaces = null;
        String typeQName = returnType.getCanonicalText();
        EjbMethodRole[] ejbMethodRoleArray = methodRoles;
        int n = ejbMethodRoleArray.length;
        boolean bl = false;
        while (var8_10 < n) {
            EjbMethodRole role = ejbMethodRoleArray[var8_10];
            if (role.getClassRole().isRemote() && role.getEnterpriseBean() instanceof EjbWithHome) {
                EjbWithHome ejb = (EjbWithHome)role.getEnterpriseBean();
                if (Comparing.equal((String)ejb.getLocalHome().getStringValue(), (String)typeQName)) {
                    if (interfaces == null) {
                        interfaces = new HashSet<Object>();
                        interfaces.add(ejb.getHome().getValue());
                    } else {
                        interfaces.retainAll(Collections.singleton(ejb.getHome().getValue()));
                    }
                } else {
                    for (PsiClass psiClass : EjbUtil.getComponentInterfaces((EnterpriseBean)ejb, false)) {
                        if (!Comparing.equal((String)psiClass.getQualifiedName(), (String)typeQName)) continue;
                        List<PsiClass> list = EjbUtil.getComponentInterfaces((EnterpriseBean)ejb, true);
                        if (interfaces == null) {
                            interfaces = new HashSet<PsiClass>(list);
                            break;
                        }
                        interfaces.retainAll(list);
                        break;
                    }
                }
            }
            ++var8_10;
        }
        if (interfaces != null) {
            ArrayList<LocalQuickFixAndIntentionActionOnPsiElement> quickFixes = new ArrayList<LocalQuickFixAndIntentionActionOnPsiElement>();
            for (PsiClass psiClass : interfaces) {
                PsiClassType type = JavaPsiFacade.getInstance((Project)method.getProject()).getElementFactory().createType(psiClass);
                quickFixes.add(QuickFixFactory.getInstance().createMethodReturnFix(method, (PsiType)type, false));
            }
            String message = EjbHighlightingMessages.message("ejb.local.interfaces.should.not.be.exposed", typeQName, method.getContainingClass().getName());
            holder.registerProblem((PsiElement)method.getReturnTypeElement(), message, quickFixes.toArray(LocalQuickFix.EMPTY_ARRAY));
        }
    }

    private static void checkMethodThrowsRemoteException(ProblemsHolder holder, PsiMethod method, EjbMethodRole[] methodRoles) {
        boolean extendsRemote = EjbHighlightUtil.isInheritor(holder, method.getContainingClass(), "java.rmi.Remote");
        boolean canSkipRemoteException = true;
        for (EjbMethodRole role : methodRoles) {
            if (!role.getClassRole().isRemote() || role.getClassRole().getType() == EjbClassRoleEnum.EJB_CLASS_ROLE_BUSINESS_REMOTE_INTERFACE) continue;
            canSkipRemoteException = false;
            break;
        }
        if (!canSkipRemoteException || extendsRemote) {
            EjbHighlightUtil.checkMethodThrows(holder, method, "java.rmi.RemoteException", true);
        }
    }

    private static void checkMethodRMICompatible(ProblemsHolder holder, PsiMethod method) {
        PsiParameter[] parameters;
        EjbRemoteRequirementsInspection.checkTypeRMICompatible(holder, method.getReturnTypeElement());
        for (PsiParameter parameter : parameters = method.getParameterList().getParameters()) {
            EjbRemoteRequirementsInspection.checkTypeRMICompatible(holder, parameter.getTypeElement());
        }
    }

    private static void checkTypeRMICompatible(ProblemsHolder holder, PsiTypeElement typeElement) {
        if (typeElement == null) {
            return;
        }
        PsiType type = typeElement.getType();
        if (!EjbUtil.isTypeRMICompatible(type, typeElement.getProject())) {
            holder.registerProblem((PsiElement)typeElement, EjbHighlightingMessages.message("class.is.not.RMI.IIOP.compatible", type.getCanonicalText()), new LocalQuickFix[0]);
        }
    }

    private void checkBeanInterfacesNotExposed(ProblemsHolder holder, PsiMethod method, EjbMethodRole[] methodRoles) {
        PsiType returnType = method.getReturnType();
        if (returnType == null) {
            return;
        }
        boolean error = false;
        String typeQName = returnType.getCanonicalText();
        block0: for (EjbMethodRole role : methodRoles) {
            if (role.getClassRole().getType() != EjbClassRoleEnum.EJB_CLASS_ROLE_SERVICE_ENDPOINT_INTERFACE) continue;
            SessionBean ejb = (SessionBean)role.getEnterpriseBean();
            for (PsiClass psiClass : EjbUtil.getComponentInterfaces((EnterpriseBean)ejb, true)) {
                if (!Comparing.equal((String)psiClass.getQualifiedName(), (String)typeQName)) continue;
                error = true;
                break block0;
            }
        }
        if (error) {
            holder.registerProblem((PsiElement)method.getReturnTypeElement(), EjbHighlightingMessages.message("ejb.interfaces.should.not.be.exposed", typeQName, method.getContainingClass().getName()), new LocalQuickFix[0]);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 3: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 3: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javaee/ejb/inspections/EjbRemoteRequirementsInspection";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getShortName";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultLevel";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javaee/ejb/inspections/EjbRemoteRequirementsInspection";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createJavaVisitor";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

