/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.model.xml.impl;

import com.intellij.jam.model.util.JamCommonUtil;
import com.intellij.javaee.ejb.EjbMethod;
import com.intellij.javaee.ejb.EjbUtil;
import com.intellij.javaee.ejb.facet.EjbFacet;
import com.intellij.javaee.ejb.role.EjbClassRole;
import com.intellij.javaee.ejb.role.EjbDeclMethodRole;
import com.intellij.javaee.ejb.role.EjbMethodRole;
import com.intellij.javaee.ejb.role.EjbMethodRoleImpl;
import com.intellij.javaee.model.EjbMethodResolveConverter;
import com.intellij.javaee.model.common.JavaeeModelElement;
import com.intellij.javaee.model.common.ejb.EnterpriseBean;
import com.intellij.javaee.model.common.ejb.EntityBean;
import com.intellij.javaee.model.enums.MethodIntf;
import com.intellij.javaee.model.enums.TransAttribute;
import com.intellij.javaee.model.xml.JavaeeDomModelElement;
import com.intellij.javaee.model.xml.SecurityRole;
import com.intellij.javaee.model.xml.ejb.AssemblyDescriptor;
import com.intellij.javaee.model.xml.ejb.ContainerTransaction;
import com.intellij.javaee.model.xml.ejb.EjbJar;
import com.intellij.javaee.model.xml.ejb.InitMethod;
import com.intellij.javaee.model.xml.ejb.InterceptorBinding;
import com.intellij.javaee.model.xml.ejb.Method;
import com.intellij.javaee.model.xml.ejb.MethodParams;
import com.intellij.javaee.model.xml.ejb.MethodPermission;
import com.intellij.javaee.model.xml.ejb.NamedMethod;
import com.intellij.javaee.model.xml.ejb.QueryMethod;
import com.intellij.javaee.model.xml.ejb.RemoveMethod;
import com.intellij.javaee.model.xml.ejb.SessionBean;
import com.intellij.javaee.model.xml.impl.GenericValueImpl;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtil;
import com.intellij.openapi.util.Comparing;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.SmartList;
import com.intellij.util.xml.GenericDomValue;
import com.intellij.util.xml.GenericValue;
import com.intellij.util.xml.ModelMergerUtil;
import com.intellij.util.xml.converters.AbstractMethodParams;
import com.intellij.util.xml.converters.AbstractMethodResolveConverter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EjbXmlImplUtil {
    private EjbXmlImplUtil() {
    }

    @Nullable
    public static AssemblyDescriptor getAssemblyDescriptor(JavaeeModelElement element) {
        EjbFacet ejbFacet;
        JavaeeDomModelElement domModelElement = (JavaeeDomModelElement)ModelMergerUtil.getImplementation((Object)element, JavaeeDomModelElement.class);
        EjbJar ejbJar = domModelElement == null ? ((ejbFacet = EjbUtil.getEjbFacet(element)) == null ? null : ejbFacet.getXmlRoot()) : (EjbJar)domModelElement.getParentOfType(EjbJar.class, true);
        return ejbJar == null ? null : ejbJar.getAssemblyDescriptor();
    }

    @NotNull
    static EjbMethodInfo getOrCreateEjbMethodInfo(Map<PsiMethod, EjbMethodInfo> methods, PsiMethod psiMethod) {
        EjbMethodInfo info = methods.get(psiMethod);
        if (info == null) {
            info = new EjbMethodInfo();
            info.psiMethod = psiMethod;
            methods.put(psiMethod, info);
        }
        EjbMethodInfo ejbMethodInfo = info;
        if (ejbMethodInfo == null) {
            EjbXmlImplUtil.$$$reportNull$$$0(0);
        }
        return ejbMethodInfo;
    }

    public static boolean isInSeparateListenerClass(GenericDomValue<PsiClass> interceptorClass, GenericDomValue<PsiClass> currentClass) {
        PsiClass aClass = (PsiClass)interceptorClass.getValue();
        return aClass != null && aClass != currentClass.getValue() || interceptorClass.getXmlTag() != null;
    }

    private static Collection<PsiMethod> findMethodsByName(PsiClass psiClass, String methodName) {
        HashMap<List<PsiType>, PsiMethod> result = new HashMap<List<PsiType>, PsiMethod>();
        for (PsiClass aClass : JamCommonUtil.getSuperClassList((PsiClass)psiClass)) {
            for (PsiMethod psiMethod : aClass.findMethodsByName(methodName, false)) {
                List<PsiType> key = Arrays.asList(psiMethod.getSignature(PsiSubstitutor.EMPTY).getParameterTypes());
                if (result.containsKey(key)) continue;
                result.put(key, psiMethod);
            }
        }
        return result.values();
    }

    public static PsiMethod[] findMethods(PsiClass psiClass, String methodName, MethodParams methodParams) {
        PsiMethod[] psiMethodArray;
        if (methodParams.getXmlTag() == null) {
            return EjbXmlImplUtil.findMethodsByName(psiClass, methodName).toArray(PsiMethod.EMPTY_ARRAY);
        }
        PsiMethod method = AbstractMethodResolveConverter.findMethod((PsiClass)psiClass, (String)methodName, (AbstractMethodParams)methodParams);
        if (method == null) {
            psiMethodArray = PsiMethod.EMPTY_ARRAY;
        } else {
            PsiMethod[] psiMethodArray2 = new PsiMethod[1];
            psiMethodArray = psiMethodArray2;
            psiMethodArray2[0] = method;
        }
        return psiMethodArray;
    }

    public static PsiMethod[] findMethods(EnterpriseBean ejb, Method method, boolean includeEjbClass) {
        return EjbXmlImplUtil.findMethods(ejb, method.getEnterpriseBean().getStringValue(), (MethodIntf)method.getMethodIntf().getValue(), method.getMethod().getStringValue(), method.getMethodParams(), includeEjbClass);
    }

    @Nullable
    public static PsiMethod findMethod(EnterpriseBean ejb, NamedMethod method) {
        return AbstractMethodResolveConverter.findMethod((PsiClass)((PsiClass)ejb.getEjbClass().getValue()), (String)method.getMethod().getStringValue(), (AbstractMethodParams)method.getMethodParams());
    }

    public static PsiMethod[] findMethods(EntityBean ejb, QueryMethod method) {
        PsiMethod first;
        String name = method.getMethodName().getStringValue();
        if (name == null) {
            return PsiMethod.EMPTY_ARRAY;
        }
        PsiMethod second = null;
        if (name.startsWith("find")) {
            first = AbstractMethodResolveConverter.findMethod((PsiClass)((PsiClass)ejb.getHome().getValue()), (String)name, (AbstractMethodParams)method.getMethodParams());
            second = AbstractMethodResolveConverter.findMethod((PsiClass)((PsiClass)ejb.getLocalHome().getValue()), (String)name, (AbstractMethodParams)method.getMethodParams());
        } else {
            first = AbstractMethodResolveConverter.findMethod((PsiClass)((PsiClass)ejb.getEjbClass().getValue()), (String)name, (AbstractMethodParams)method.getMethodParams());
        }
        if (first == null && second == null) {
            return PsiMethod.EMPTY_ARRAY;
        }
        if (first != null && second != null) {
            return new PsiMethod[]{first, second};
        }
        return new PsiMethod[]{first != null ? first : second};
    }

    public static PsiMethod[] findMethods(PsiClass psiClass, NamedMethod namedMethod) {
        return EjbXmlImplUtil.findMethods(psiClass, namedMethod.getMethod().getStringValue(), namedMethod.getMethodParams());
    }

    public static PsiMethod[] findMethods(EnterpriseBean ejb, String ejbName, MethodIntf methodIntf, String methodName, MethodParams methodParams, boolean includeEjbClass) {
        if (methodName == null || ejbName == null || !ejbName.equals(ejb.getEjbName().getValue())) {
            return PsiMethod.EMPTY_ARRAY;
        }
        Collection targetClasses = EjbMethodResolveConverter.getTargetClasses((EnterpriseBean)ejb, (MethodIntf)methodIntf, (boolean)includeEjbClass);
        LinkedHashSet<PsiMethod> methodList = new LinkedHashSet<PsiMethod>();
        if ("*".equals(methodName)) {
            for (PsiClass psiClass : targetClasses) {
                if (psiClass == null) continue;
                boolean isInterface = psiClass.isInterface();
                for (PsiMethod psiMethod : psiClass.getAllMethods()) {
                    if ("java.lang.Object".equals(psiMethod.getContainingClass().getQualifiedName()) || !isInterface && (psiMethod.isConstructor() || !psiMethod.getModifierList().hasExplicitModifier("public") || psiMethod.getModifierList().hasExplicitModifier("static"))) continue;
                    methodList.add(psiMethod);
                }
            }
        } else if (methodParams.getXmlTag() == null) {
            for (PsiClass psiClass : targetClasses) {
                if (psiClass == null) continue;
                boolean isInterface = psiClass.isInterface();
                for (PsiMethod psiMethod : psiClass.findMethodsByName(methodName, true)) {
                    if (!isInterface && (!psiMethod.getModifierList().hasExplicitModifier("public") || psiMethod.getModifierList().hasExplicitModifier("static"))) continue;
                    methodList.add(psiMethod);
                }
            }
        } else {
            for (PsiClass psiClass : targetClasses) {
                PsiMethod psiMethod;
                if (psiClass == null || (psiMethod = AbstractMethodResolveConverter.findMethod((PsiClass)psiClass, (String)methodName, (AbstractMethodParams)methodParams)) == null) continue;
                methodList.add(psiMethod);
            }
        }
        return methodList.toArray(PsiMethod.EMPTY_ARRAY);
    }

    public static List<? extends EjbMethod> getXmlEjbMethods(EnterpriseBean commonEjb) {
        HashMap<PsiMethod, EjbMethodInfo> methods = new HashMap<PsiMethod, EjbMethodInfo>();
        EjbXmlImplUtil.processEjbDefinition(methods, commonEjb);
        EjbXmlImplUtil.processAssemblyDescriptor(methods, commonEjb);
        EjbXmlImplUtil.mergeInterfaceMethodsToClassMethods(methods, commonEjb);
        return new ArrayList<EjbMethodInfo>(methods.values());
    }

    private static void processEjbDefinition(HashMap<PsiMethod, EjbMethodInfo> methods, EnterpriseBean commonEjb) {
        SessionBean sessionBean = (SessionBean)ModelMergerUtil.getImplementation((Object)commonEjb, SessionBean.class);
        if (sessionBean != null) {
            EjbMethodInfo info;
            for (RemoveMethod removeMethod : sessionBean.getRemoveMethods()) {
                Boolean retainIfException = (Boolean)removeMethod.getRetainIfException().getValue();
                PsiMethod psiMethod = EjbXmlImplUtil.findMethod(commonEjb, removeMethod.getBeanMethod());
                if (psiMethod == null) continue;
                info = EjbXmlImplUtil.getOrCreateEjbMethodInfo(methods, psiMethod);
                info.retainIfException.value = retainIfException;
                info.removeMethod.value = Boolean.TRUE;
            }
            for (InitMethod initMethod : sessionBean.getInitMethods()) {
                PsiMethod psiMethod = EjbXmlImplUtil.findMethod(commonEjb, initMethod.getBeanMethod());
                GenericDomValue createMethodName = initMethod.getCreateMethod().getMethod();
                if (psiMethod == null || createMethodName.getValue() == null) continue;
                info = EjbXmlImplUtil.getOrCreateEjbMethodInfo(methods, psiMethod);
                info.init.value = createMethodName.getStringValue();
            }
        }
    }

    private static void processAssemblyDescriptor(Map<PsiMethod, EjbMethodInfo> methods, EnterpriseBean commonEjb) {
        EjbMethodInfo info;
        AssemblyDescriptor assemblyDescriptor = EjbXmlImplUtil.getAssemblyDescriptor((JavaeeModelElement)commonEjb);
        if (assemblyDescriptor == null) {
            return;
        }
        for (Method method : assemblyDescriptor.getExcludeList().getMethods()) {
            for (PsiMethod psiMethod : EjbXmlImplUtil.findMethods(commonEjb, method, false)) {
                EjbMethodInfo info2 = EjbXmlImplUtil.getOrCreateEjbMethodInfo(methods, psiMethod);
                info2.excluded.value = Boolean.TRUE;
            }
        }
        for (ContainerTransaction transaction : assemblyDescriptor.getContainerTransactions()) {
            TransAttribute transactionAttribute = (TransAttribute)transaction.getTransAttribute().getValue();
            if (transactionAttribute == null) continue;
            for (Method method : transaction.getMethods()) {
                for (PsiMethod psiMethod : EjbXmlImplUtil.findMethods(commonEjb, method, true)) {
                    EjbMethodInfo info3 = EjbXmlImplUtil.getOrCreateEjbMethodInfo(methods, psiMethod);
                    info3.transactionAttribute.value = Enum.valueOf(TransAttribute.class, transactionAttribute.name());
                }
            }
        }
        for (MethodPermission methodPermission : assemblyDescriptor.getMethodPermissions()) {
            List roleNames = methodPermission.getRoleNames();
            Boolean unchecked = (Boolean)methodPermission.getUnchecked().getValue();
            for (Method method : methodPermission.getMethods()) {
                for (PsiMethod psiMethod : EjbXmlImplUtil.findMethods(commonEjb, method, false)) {
                    info = EjbXmlImplUtil.getOrCreateEjbMethodInfo(methods, psiMethod);
                    if (info.rolesAllowed == null) {
                        info.rolesAllowed = new ArrayList<GenericDomValue<SecurityRole>>();
                    }
                    info.rolesAllowed.addAll(roleNames);
                    info.permitAll.value = unchecked;
                }
            }
        }
        for (InterceptorBinding binding : assemblyDescriptor.getInterceptorBindings()) {
            PsiMethod[] psiMethodArray;
            NamedMethod namedMethod = binding.getMethod();
            if (namedMethod.getXmlTag() == null) continue;
            Boolean excludeDefaultInterceptors = (Boolean)binding.getExcludeDefaultInterceptors().getValue();
            Boolean excludeClassInterceptors = (Boolean)binding.getExcludeClassInterceptors().getValue();
            for (PsiMethod psiMethod : psiMethodArray = EjbXmlImplUtil.findMethods(commonEjb, binding.getEnterpriseBean().getStringValue(), null, namedMethod.getMethod().getStringValue(), namedMethod.getMethodParams(), true)) {
                info = EjbXmlImplUtil.getOrCreateEjbMethodInfo(methods, psiMethod);
                if (info.methodInterceptors == null) {
                    info.methodInterceptors = new ArrayList<GenericDomValue<PsiClass>>();
                }
                info.methodInterceptors.addAll(binding.getInterceptorClasses());
                info.excludeClassInterceptors.value = excludeClassInterceptors;
                info.excludeDefaultInterceptors.value = excludeDefaultInterceptors;
            }
        }
    }

    private static void mergeInto(EjbMethodInfo to, EjbMethodInfo fro) {
        if (fro.retainIfException.value != null) {
            to.retainIfException.value = fro.retainIfException.value;
        }
        if (fro.removeMethod.value != null) {
            to.removeMethod.value = fro.removeMethod.value;
        }
        if (fro.transactionAttribute.value != null) {
            to.transactionAttribute.value = fro.transactionAttribute.value;
        }
        if (fro.excluded.value != null) {
            to.excluded.value = fro.excluded.value;
        }
        if (fro.timeoutMethod.value != null) {
            to.timeoutMethod.value = fro.timeoutMethod.value;
        }
        if (fro.permitAll.value != null) {
            to.permitAll.value = fro.permitAll.value;
        }
        if (fro.denyAll.value != null) {
            to.denyAll.value = fro.denyAll.value;
        }
        if (fro.rolesAllowed != null) {
            if (to.rolesAllowed == null) {
                to.rolesAllowed = new ArrayList<GenericDomValue<SecurityRole>>();
            }
            EjbXmlImplUtil.addAllUnique(to.rolesAllowed, fro.rolesAllowed);
        }
        if (fro.excludeDefaultInterceptors.value != null) {
            to.excludeDefaultInterceptors.value = fro.excludeDefaultInterceptors.value;
        }
        if (fro.excludeClassInterceptors.value != null) {
            to.excludeClassInterceptors.value = fro.excludeClassInterceptors.value;
        }
        if (fro.methodInterceptors != null) {
            if (to.methodInterceptors == null) {
                to.methodInterceptors = new ArrayList<GenericDomValue<PsiClass>>();
            }
            EjbXmlImplUtil.addAllUnique(to.methodInterceptors, fro.methodInterceptors);
        }
    }

    private static <T> void addAllUnique(Collection<GenericDomValue<T>> to, Collection<GenericDomValue<T>> fro) {
        block0: for (GenericDomValue<T> value : fro) {
            for (GenericDomValue<T> curValue : to) {
                if (!Comparing.equal((String)curValue.getStringValue(), (String)value.getStringValue())) continue;
                continue block0;
            }
            to.add(value);
        }
    }

    private static void mergeInterfaceMethodsToClassMethods(HashMap<PsiMethod, EjbMethodInfo> methods, EnterpriseBean commonEjb) {
        PsiClass ejbClass = (PsiClass)commonEjb.getEjbClass().getValue();
        if (ejbClass != null) {
            for (EjbMethodInfo info : new ArrayList<EjbMethodInfo>(methods.values())) {
                PsiMethod method = info.getPsiMethod();
                for (EjbMethodRole role : EjbXmlImplUtil.computeMethodRole(method, commonEjb)) {
                    if (!(role instanceof EjbDeclMethodRole)) continue;
                    for (PsiMethod ejbClassMethod : ((EjbDeclMethodRole)role).findImplementationsInEjbClass()) {
                        EjbMethodInfo newInfo = EjbXmlImplUtil.getOrCreateEjbMethodInfo(methods, ejbClassMethod);
                        EjbXmlImplUtil.mergeInto(newInfo, info);
                    }
                }
            }
        }
    }

    private static List<EjbMethodRole> computeMethodRole(PsiMethod method, EnterpriseBean commonEjb) {
        List<EjbClassRole> roles = EjbUtil.getEjbClassRolesByClass(method.getContainingClass(), commonEjb);
        if (roles.size() == 0) {
            return Collections.emptyList();
        }
        SmartList list = new SmartList();
        for (EjbClassRole classRole : roles) {
            EjbMethodRoleImpl role = EjbMethodRoleImpl.suggestMethodRole(classRole, method);
            if (role == null) continue;
            list.add((Object)role);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javaee/model/xml/impl/EjbXmlImplUtil", "getOrCreateEjbMethodInfo"));
    }

    static class EjbMethodInfo
    implements EjbMethod {
        @NotNull
        PsiMethod psiMethod;
        GenericValueImpl<Boolean> retainIfException = new GenericValueImpl();
        GenericValueImpl<Boolean> removeMethod = new GenericValueImpl();
        GenericValueImpl<TransAttribute> transactionAttribute = new GenericValueImpl();
        GenericValueImpl<Boolean> excluded = new GenericValueImpl();
        GenericValueImpl<Boolean> timeoutMethod = new GenericValueImpl();
        GenericValueImpl<Boolean> permitAll = new GenericValueImpl();
        GenericValueImpl<Boolean> denyAll = new GenericValueImpl();
        List<GenericDomValue<SecurityRole>> rolesAllowed = null;
        GenericValueImpl<String> init = new GenericValueImpl();
        GenericValueImpl<Boolean> excludeDefaultInterceptors = new GenericValueImpl();
        GenericValueImpl<Boolean> excludeClassInterceptors = new GenericValueImpl();
        List<GenericDomValue<PsiClass>> methodInterceptors = null;

        EjbMethodInfo() {
        }

        public GenericValue<String> getInit() {
            return this.init;
        }

        public GenericValue<Boolean> isRetainIfException() {
            return this.retainIfException;
        }

        public GenericValue<Boolean> isRemoveMethod() {
            return this.removeMethod;
        }

        public GenericValue<TransAttribute> getTransactionAttribute() {
            return this.transactionAttribute;
        }

        public GenericValue<Boolean> isExcluded() {
            return this.excluded;
        }

        public GenericValue<Boolean> isExcludeClassInterceptors() {
            return this.excludeClassInterceptors;
        }

        public GenericValue<Boolean> isExcludeDefaultInterceptors() {
            return this.excludeDefaultInterceptors;
        }

        public List<? extends GenericValue<PsiClass>> getMethodInterceptors() {
            if (this.methodInterceptors == null) {
                return Collections.emptyList();
            }
            return Collections.unmodifiableList(this.methodInterceptors);
        }

        public GenericValue<Boolean> isTimeoutMethod() {
            return this.timeoutMethod;
        }

        public PsiMethod getPsiMethod() {
            return this.psiMethod;
        }

        public GenericValue<Boolean> isPermitAll() {
            return this.permitAll;
        }

        public GenericValue<Boolean> isDenyAll() {
            return this.denyAll;
        }

        public Collection<? extends GenericValue<SecurityRole>> getRolesAllowed() {
            if (this.rolesAllowed == null) {
                return Collections.emptyList();
            }
            return Collections.unmodifiableList(this.rolesAllowed);
        }

        public boolean isValid() {
            return true;
        }

        public XmlTag getXmlTag() {
            return null;
        }

        public PsiManager getPsiManager() {
            return this.psiMethod.getManager();
        }

        public Module getModule() {
            return ModuleUtil.findModuleForPsiElement((PsiElement)this.getPsiMethod());
        }

        @Nullable
        public PsiFile getContainingFile() {
            return this.psiMethod.getContainingFile();
        }

        public PsiElement getIdentifyingPsiElement() {
            return this.getPsiMethod();
        }
    }
}

