/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.module.view;

import com.intellij.ide.util.PackageChooserDialog;
import com.intellij.ide.util.TreeClassChooser;
import com.intellij.ide.util.TreeClassChooserFactory;
import com.intellij.javaee.EjbDataHolder;
import com.intellij.javaee.J2EEBundle;
import com.intellij.openapi.help.HelpManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNameHelper;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.CreateClassUtil;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.FieldPanel;
import com.intellij.util.ui.JBUI;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collection;
import java.util.HashSet;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jetbrains.annotations.NotNull;

public class PKClassDialog
extends DialogWrapper {
    private final Module myModule;
    private FieldPanel myPrimaryKeyClass;
    private final EjbDataHolder myEjbInfo;
    private FieldPanel myPackage;

    public PKClassDialog(Module module, EjbDataHolder ejbInfo) {
        super(module.getProject(), true);
        this.myModule = module;
        this.myEjbInfo = ejbInfo;
        this.init();
        this.setTitle(J2EEBundle.message((String)"dialog.title.primary.key.class", (Object[])new Object[0]));
    }

    @NotNull
    protected Action[] createActions() {
        Action[] actionArray = new Action[]{this.getOKAction(), this.getCancelAction(), this.getHelpAction()};
        if (actionArray == null) {
            PKClassDialog.$$$reportNull$$$0(0);
        }
        return actionArray;
    }

    protected void doHelpAction() {
        HelpManager.getInstance().invokeHelp("newEJBedit_entity");
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myPrimaryKeyClass;
    }

    protected JComponent createCenterPanel() {
        JPanel panel = new JPanel(new BorderLayout());
        return panel;
    }

    private void updateOkButton() {
        PsiNameHelper nameHelper = PsiNameHelper.getInstance((Project)this.getProject());
        this.setOKActionEnabled(nameHelper.isQualifiedName(this.getPKClassName()));
    }

    protected JComponent createNorthPanel() {
        JPanel panel = new JPanel();
        GridBagConstraints pgb = new GridBagConstraints();
        panel.setLayout(new GridBagLayout());
        pgb.fill = 2;
        pgb.anchor = 17;
        pgb.gridy = 0;
        pgb.gridx = 0;
        pgb.insets = JBUI.insets((int)4, (int)8);
        pgb.gridwidth = 0;
        pgb.weightx = 0.0;
        JLabel label = new JLabel(J2EEBundle.message((String)"label.pk.class.dialog.pk.class.cant.contain.compound.primary.key", (Object[])new Object[]{this.myEjbInfo.getPKClassName()}));
        panel.add((Component)label, pgb);
        ++pgb.gridy;
        pgb.gridx = 0;
        pgb.weightx = 0.0;
        pgb.gridwidth = 0;
        this.myPackage = new FieldPanel(J2EEBundle.message((String)"border.pk.class.dialog.primary.key.class.package", (Object[])new Object[0]), null, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PackageChooserDialog dialog = new PackageChooserDialog(J2EEBundle.message((String)"dialog.title.choose.primary.key.class.package", (Object[])new Object[0]), PKClassDialog.this.getProject());
                if (!dialog.showAndGet()) {
                    return;
                }
                PsiPackage aPackage = dialog.getSelectedPackage();
                PKClassDialog.this.myPackage.setText(aPackage.getQualifiedName());
            }
        }, null);
        panel.add((Component)this.myPackage, pgb);
        PsiClass pkClass = this.myEjbInfo.getPKClassName() == null ? null : this.findClassUnderRoot();
        String pkg = pkClass == null || !pkClass.getManager().isInProject((PsiElement)pkClass) ? this.getDefaultPackageName() : CreateClassUtil.extractPackage((String)this.myEjbInfo.getPKClassName());
        this.myPackage.setText(pkg);
        ++pgb.gridy;
        pgb.gridx = 0;
        pgb.weightx = 1.0;
        pgb.gridwidth = 0;
        this.myPrimaryKeyClass = new FieldPanel(J2EEBundle.message((String)"border.pk.class.dialog.primary.key.class.name", (Object[])new Object[0]), null, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TreeClassChooser chooser = TreeClassChooserFactory.getInstance((Project)PKClassDialog.this.getProject()).createProjectScopeChooser(J2EEBundle.message((String)"dialog.title.choose.entity.bean.primary.key.class", (Object[])new Object[0]));
                chooser.showDialog();
                PsiClass aClass = chooser.getSelected();
                if (aClass != null) {
                    PKClassDialog.this.myPrimaryKeyClass.setText(aClass.getQualifiedName());
                }
            }
        }, null);
        panel.add((Component)this.myPrimaryKeyClass, pgb);
        this.myPrimaryKeyClass.setText(this.myEjbInfo.createPrimaryKeyClassName());
        DocumentAdapter listener = new DocumentAdapter(){

            protected void textChanged(DocumentEvent e) {
                PKClassDialog.this.updateOkButton();
            }
        };
        this.myPrimaryKeyClass.getTextField().getDocument().addDocumentListener((DocumentListener)listener);
        this.myPackage.getTextField().getDocument().addDocumentListener((DocumentListener)listener);
        return panel;
    }

    private PsiClass findClassUnderRoot() {
        Project project = this.getProject();
        return JavaPsiFacade.getInstance((Project)project).findClass(this.myEjbInfo.getPKClassName(), GlobalSearchScope.allScope((Project)project));
    }

    private Project getProject() {
        return this.myModule.getProject();
    }

    private String getDefaultPackageName() {
        HashSet<String> availablePackages = new HashSet<String>();
        this.addPackageName(this.myEjbInfo.getPKClassName(), availablePackages);
        this.addPackageName(this.myEjbInfo.getClassName(), availablePackages);
        this.addPackageName(this.myEjbInfo.getLocalHomeInterfaceName(), availablePackages);
        this.addPackageName(this.myEjbInfo.getLocalInterfaceName(), availablePackages);
        this.addPackageName(this.myEjbInfo.getRemoteHomeInterfaceName(), availablePackages);
        this.addPackageName(this.myEjbInfo.getRemoteInterfaceName(), availablePackages);
        if (availablePackages.isEmpty()) {
            return "";
        }
        return (String)availablePackages.iterator().next();
    }

    private void addPackageName(String pkClassName, Collection<String> availablePackages) {
        if (pkClassName == null) {
            return;
        }
        PsiClass existing = JavaPsiFacade.getInstance((Project)this.getProject()).findClass(pkClassName, GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)this.myModule));
        if (existing instanceof PsiCompiledElement) {
            return;
        }
        String packageName = CreateClassUtil.extractPackage((String)pkClassName);
        if (packageName != null && packageName.length() != 0) {
            availablePackages.add(packageName);
        }
    }

    public final String getPKClassName() {
        return CreateClassUtil.makeFQName((String)this.myPackage.getText(), (String)this.myPrimaryKeyClass.getText());
    }

    protected String getDimensionServiceKey() {
        return "#com.intellij.j2ee.ejb.actions.PKClassDialog";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javaee/module/view/PKClassDialog", "createActions"));
    }
}

