/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.module.view.ejb.actions;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.generation.GenerateConstructorHandler;
import com.intellij.codeInsight.generation.PsiMethodMember;
import com.intellij.javaee.J2EEBundle;
import com.intellij.javaee.ejb.EjbHelper;
import com.intellij.javaee.ejb.EjbUtil;
import com.intellij.javaee.model.common.ejb.EnterpriseBean;
import com.intellij.javaee.model.common.ejb.EntityBean;
import com.intellij.javaee.module.view.ejb.CreateEjbUtil;
import com.intellij.javaee.module.view.ejb.CreateTransferObjectDialog;
import com.intellij.javaee.module.view.ejb.actions.EjbAbstractCreateAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataConstants;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaDirectoryService;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiType;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.util.PropertyUtilBase;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.PlatformIcons;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.NonNls;

public class CreateTransferObjectAction
extends EjbAbstractCreateAction {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.javaee.module.view.ejb.CreateTransferObjectAction");
    @NonNls
    protected static final String JAVA_PREFIX = "java";
    @NonNls
    protected static final String GET_PREFIX = "get";

    private CreateTransferObjectAction(String title) {
        super(title, null, PlatformIcons.CLASS_ICON);
    }

    public CreateTransferObjectAction() {
        this(J2EEBundle.message((String)"action.name.create.new.transfer.object", (Object[])new Object[0]));
    }

    private static boolean isActionValid(EnterpriseBean selectedEjb) {
        return selectedEjb instanceof EntityBean && CreateTransferObjectAction.getVOMembers((EntityBean)selectedEjb).size() != 0;
    }

    public void actionPerformed(AnActionEvent e) {
        EntityBean selectedEjb;
        DataContext dataContext = e.getDataContext();
        if (dataContext == null) {
            return;
        }
        Project project = (Project)CommonDataKeys.PROJECT.getData(dataContext);
        if (project == null) {
            return;
        }
        EnterpriseBean ejb = (EnterpriseBean)dataContext.getData("EjbImpl");
        EntityBean entityBean = selectedEjb = ejb instanceof EntityBean ? (EntityBean)ejb : null;
        if (selectedEjb == null) {
            return;
        }
        List<PsiMethod> members = CreateTransferObjectAction.getVOMembers(selectedEjb);
        PsiMethod[] fields = members.toArray(PsiMethod.EMPTY_ARRAY);
        CreateTransferObjectDialog memberChooser = new CreateTransferObjectDialog(project, selectedEjb, fields);
        memberChooser.setCopyJavadocVisible(false);
        if (!memberChooser.showAndGet()) {
            return;
        }
        List selectedElements = memberChooser.getSelectedElements();
        CommandProcessor.getInstance().executeCommand(project, () -> {
            Runnable action = () -> CreateTransferObjectAction.createTransferObject(selectedEjb, selectedElements, memberChooser);
            ApplicationManager.getApplication().runWriteAction(action);
        }, J2EEBundle.message((String)"command.name.create.transfer.object", (Object[])new Object[0]), null);
    }

    /*
     * Enabled aggressive block sorting
     */
    private static List<PsiMethod> getVOMembers(EntityBean ejb) {
        ArrayList<PsiMethod> members = new ArrayList<PsiMethod>();
        PsiClass aClass = (PsiClass)ejb.getEjbClass().getValue();
        if (aClass == null) {
            return members;
        }
        PsiMethod[] methods = aClass.getAllMethods();
        for (PsiMethod method : methods) {
            String className;
            if (!method.hasModifierProperty("public") || method.hasModifierProperty("static") || !PropertyUtilBase.isSimplePropertyAccessor((PsiMethod)method) || (className = method.getContainingClass().getQualifiedName()) == null || className.startsWith(JAVA_PREFIX)) continue;
            members.add(method);
        }
        block1: while (true) {
            Iterator iterator = members.iterator();
            block2: while (true) {
                PsiMethod[] superMethods;
                if (!iterator.hasNext()) {
                    return members;
                }
                Object e = iterator.next();
                PsiMethod method = (PsiMethod)e;
                PsiMethod[] psiMethodArray = superMethods = method.findSuperMethods(true);
                int n = psiMethodArray.length;
                int n2 = 0;
                while (true) {
                    if (n2 >= n) continue block2;
                    PsiMethod superMethod = psiMethodArray[n2];
                    if (members.contains(superMethod)) {
                        members.remove(superMethod);
                        continue block1;
                    }
                    ++n2;
                }
                break;
            }
            break;
        }
    }

    private static void createTransferObject(EntityBean ejb, List<PsiMethodMember> selectedElements, CreateTransferObjectDialog dialog) {
        try {
            PsiMethod interfaces;
            PsiMethod[] constructors;
            PsiClass[] classesToModify;
            for (PsiClass psiClass : classesToModify = new PsiClass[]{(PsiClass)ejb.getEjbClass().getValue(), (PsiClass)ejb.getRemote().getValue(), (PsiClass)ejb.getLocal().getValue()}) {
                if (psiClass == null || FileModificationService.getInstance().preparePsiElementForWrite((PsiElement)psiClass)) continue;
                return;
            }
            PsiDirectory targetDirectory = ((PsiClass)ejb.getEjbClass().getValue()).getContainingFile().getContainingDirectory();
            PsiClass psiClass = JavaDirectoryService.getInstance().createClass(targetDirectory, dialog.getClassName());
            for (PsiMethod constructor : constructors = psiClass.getConstructors()) {
                constructor.delete();
            }
            PsiElementFactory psiElementFactory = JavaPsiFacade.getInstance((Project)psiClass.getProject()).getElementFactory();
            Project project = psiClass.getProject();
            CreateEjbUtil.implementClass(psiClass, "java.io.Serializable");
            ArrayList<PsiField> aFields = new ArrayList<PsiField>();
            for (PsiMethodMember o : selectedElements) {
                PsiMethod method = (PsiMethod)o.getElement();
                String name = EjbUtil.getEjbFieldNameByAccessor(method);
                PsiMethod type = PropertyUtilBase.getPropertyType((PsiMember)method);
                PsiField field = psiElementFactory.createField(name, (PsiType)type);
                PsiUtil.setModifierProperty((PsiModifierListOwner)field, (String)"final", (boolean)true);
                aFields.add(field);
                psiClass.add((PsiElement)field);
                psiClass.add((PsiElement)PropertyUtilBase.generateGetterPrototype((PsiField)field));
            }
            PsiField[] fields = aFields.toArray(PsiField.EMPTY_ARRAY);
            psiClass.add((PsiElement)GenerateConstructorHandler.generateConstructorPrototype((PsiClass)psiClass, null, (boolean)false, (PsiField[])fields));
            CreateTransferObjectAction.openClass(psiClass);
            EjbHelper helper = EjbHelper.getEjbHelper();
            if (dialog.isGenGetter()) {
                String getterName = dialog.getGetterName();
                for (PsiClass anInterface : interfaces = new PsiMethod[]{(PsiClass)ejb.getRemote().getValue(), (PsiClass)ejb.getLocal().getValue()}) {
                    if (anInterface == null) continue;
                    PsiMethod method = psiElementFactory.createMethod(getterName, (PsiType)psiElementFactory.createType(psiClass));
                    method.getBody().delete();
                    EjbUtil.tuneMethodForEjb(helper.getEjbRole(anInterface), method, method);
                    anInterface.add((PsiElement)CreateTransferObjectAction.reformat(project, method));
                }
                String body = "{ return new " + psiClass.getName() + "(";
                for (int i = 0; i < fields.length; ++i) {
                    PsiField field = fields[i];
                    if (i > 0) {
                        body = body + ", ";
                    }
                    body = body + PropertyUtilBase.suggestGetterName((PsiField)field) + "()";
                }
                body = body + "); }";
                PsiMethod method = psiElementFactory.createMethod(getterName, (PsiType)psiElementFactory.createType(psiClass));
                method.getBody().replace((PsiElement)psiElementFactory.createCodeBlockFromText(body, (PsiElement)method));
                EjbUtil.tuneMethodForEjb(helper.getEjbRole((PsiClass)ejb.getEjbClass().getValue()), method, method);
                ((PsiClass)ejb.getEjbClass().getValue()).add((PsiElement)CreateTransferObjectAction.reformat(project, method));
            }
            if (dialog.isGenSetter()) {
                String setterName = dialog.getSetterName();
                interfaces = new PsiClass[]{(PsiClass)ejb.getRemote().getValue(), (PsiClass)ejb.getLocal().getValue()};
                PsiMethod methodTemplate = psiElementFactory.createMethod(setterName, (PsiType)PsiType.VOID);
                methodTemplate.getParameterList().add((PsiElement)psiElementFactory.createParameter("value", (PsiType)psiElementFactory.createType(psiClass)));
                methodTemplate.getBody().delete();
                for (PsiClass anInterface : interfaces) {
                    if (anInterface == null) continue;
                    PsiMethod method = (PsiMethod)methodTemplate.copy();
                    EjbUtil.tuneMethodForEjb(helper.getEjbRole(anInterface), method, method);
                    anInterface.add((PsiElement)CreateTransferObjectAction.reformat(project, method));
                }
                String body = "{ ";
                for (PsiField field : fields) {
                    body = body + PropertyUtilBase.suggestSetterName((PsiField)field) + "(value." + PropertyUtilBase.suggestGetterName((PsiField)field) + "());";
                }
                body = body + " }";
                PsiMethod method = (PsiMethod)methodTemplate.copy();
                method.add((PsiElement)psiElementFactory.createCodeBlockFromText(body, (PsiElement)method));
                EjbUtil.tuneMethodForEjb(helper.getEjbRole((PsiClass)ejb.getEjbClass().getValue()), method, method);
                ((PsiClass)ejb.getEjbClass().getValue()).add((PsiElement)CreateTransferObjectAction.reformat(project, method));
            }
        }
        catch (IncorrectOperationException e) {
            LOG.error((Throwable)e);
        }
    }

    @Override
    protected boolean isActive(AnActionEvent e) {
        DataContext dataContext = e.getDataContext();
        EnterpriseBean ejb = (EnterpriseBean)dataContext.getData("EjbImpl");
        return CreateTransferObjectAction.isActionValid(ejb) && dataContext.getData(DataConstants.PROJECT) != null;
    }

    private static void openClass(PsiClass psiClass) {
        OpenFileDescriptor editSourceDescriptor = new OpenFileDescriptor(psiClass.getProject(), psiClass.getContainingFile().getVirtualFile(), psiClass.getTextOffset());
        FileEditorManager.getInstance((Project)psiClass.getProject()).openTextEditor(editSourceDescriptor, true);
    }

    private static PsiMethod reformat(Project project, PsiMethod result) throws IncorrectOperationException {
        CodeStyleManager formatter = CodeStyleManager.getInstance((Project)project);
        JavaCodeStyleManager styler = JavaCodeStyleManager.getInstance((Project)project);
        result = (PsiMethod)styler.shortenClassReferences((PsiElement)result);
        result = (PsiMethod)formatter.reformat((PsiElement)result);
        return result;
    }
}

