/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.module.view.ejb.nodes;

import com.intellij.ide.DeleteProvider;
import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.jam.view.tree.JamTreeParameters;
import com.intellij.javaee.ejb.OldEjbRolesUtil;
import com.intellij.javaee.ejb.role.EjbClassRoleEnum;
import com.intellij.javaee.ejb.role.EjbClassRoleImpl;
import com.intellij.javaee.ejb.role.EjbMethodRole;
import com.intellij.javaee.ejb.role.EjbMethodRoleEnum;
import com.intellij.javaee.ejb.role.EjbMethodRoleImpl;
import com.intellij.javaee.module.view.ejb.EjbClassDeleteProvider;
import com.intellij.javaee.module.view.nodes.ClassNodeDescriptor;
import com.intellij.javaee.module.view.nodes.JavaeeNodeDescriptor;
import com.intellij.javaee.module.view.nodes.MethodNodeDescriptor;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.impl.ElementPresentationUtil;
import com.intellij.ui.RowIcon;
import com.intellij.util.PlatformIcons;
import java.util.ArrayList;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public class EjbClassNodeDescriptor
extends ClassNodeDescriptor {
    protected final EjbClassRoleEnum myClassRoleEnum;

    public EjbClassNodeDescriptor(EjbClassRoleEnum classRoleEnum, PsiClass aClass, JavaeeNodeDescriptor parentDescriptor, Object parameters) {
        super(aClass, (NodeDescriptor)parentDescriptor, parameters);
        this.myClassRoleEnum = classRoleEnum;
    }

    public JavaeeNodeDescriptor[] getChildren() {
        PsiClass aClass = (PsiClass)this.getElement();
        ArrayList<MethodNodeDescriptor> result = new ArrayList<MethodNodeDescriptor>();
        if (((JamTreeParameters)this.getParameters()).showMembers()) {
            PsiMethod[] methods;
            for (PsiMethod method : methods = aClass.getMethods()) {
                EjbMethodRole[] roles = OldEjbRolesUtil.getEjbRoles(method);
                if (roles.length <= 0) continue;
                result.add(this.createMethodChildDescriptor(method, roles[0].getType(), false));
            }
        }
        return result.toArray(JavaeeNodeDescriptor.EMPTY_ARRAY);
    }

    @Override
    public String getNewNodeText() {
        return ((PsiClass)this.getElement()).getName();
    }

    @Override
    public String getNewTooltip() {
        return EjbClassRoleImpl.getClassRoleTitle(this.myClassRoleEnum);
    }

    @Override
    public DeleteProvider getDeleteProvider() {
        return new EjbClassDeleteProvider(this.myProject, (PsiClass)this.getElement(), null);
    }

    @NotNull
    public Object[] getEqualityObjects() {
        Object[] objectArray = new Object[]{this.getElement(), this.myClassRoleEnum};
        if (objectArray == null) {
            EjbClassNodeDescriptor.$$$reportNull$$$0(0);
        }
        return objectArray;
    }

    @Override
    public Icon getNewIcon() {
        if (this.myClassRoleEnum != null) {
            return EjbClassNodeDescriptor.getEjbClassIcon((PsiClass)this.getElement(), 2, this.myClassRoleEnum);
        }
        return super.getNewIcon();
    }

    public MethodNodeDescriptor createMethodChildDescriptor(PsiMethod method, final EjbMethodRoleEnum roleType, final boolean noDelete) {
        return new MethodNodeDescriptor(method, (NodeDescriptor)this, this.getParameters()){

            @Override
            public Icon getNewIcon() {
                if (roleType != null) {
                    return EjbClassNodeDescriptor.getEjbMethodIcon((PsiMethod)this.getElement(), 2, roleType);
                }
                return super.getNewIcon();
            }

            @Override
            public DeleteProvider getDeleteProvider() {
                return noDelete ? null : super.getDeleteProvider();
            }
        };
    }

    public static Icon getEjbMethodIcon(PsiMethod method, int flags, @NotNull EjbMethodRoleEnum roleType) {
        if (roleType == null) {
            EjbClassNodeDescriptor.$$$reportNull$$$0(1);
        }
        if (method == null || !method.isValid()) {
            return PlatformIcons.METHOD_ICON;
        }
        RowIcon rowIcon = ElementPresentationUtil.createLayeredIcon((Icon)EjbMethodRoleImpl.getIcon(roleType), (PsiModifierListOwner)method, (boolean)false);
        return ElementPresentationUtil.addVisibilityIcon((PsiModifierListOwner)method, (int)flags, (RowIcon)rowIcon);
    }

    public static Icon getEjbClassIcon(PsiClass psiClass, int flags, @NotNull EjbClassRoleEnum roleType) {
        if (roleType == null) {
            EjbClassNodeDescriptor.$$$reportNull$$$0(2);
        }
        if (psiClass == null || !psiClass.isValid()) {
            return PlatformIcons.CLASS_ICON;
        }
        boolean isLocked = (flags & 2) != 0 && !psiClass.isWritable();
        RowIcon icon = ElementPresentationUtil.createLayeredIcon((Icon)EjbClassRoleImpl.getClassRoleIcon(roleType), (PsiModifierListOwner)psiClass, (boolean)isLocked);
        return ElementPresentationUtil.addVisibilityIcon((PsiModifierListOwner)psiClass, (int)flags, (RowIcon)icon);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javaee/module/view/ejb/nodes/EjbClassNodeDescriptor";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "roleType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getEqualityObjects";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javaee/module/view/ejb/nodes/EjbClassNodeDescriptor";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getEjbMethodIcon";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getEjbClassIcon";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

