/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.module.view.ejb.permissions;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.TypePresentationService;
import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.jam.view.JamUserResponse;
import com.intellij.jam.view.tree.JamNodeDescriptor;
import com.intellij.jam.view.treetable.JamTreeTableView;
import com.intellij.javaee.J2EEBundle;
import com.intellij.javaee.UserResponse;
import com.intellij.javaee.ejb.EjbUtil;
import com.intellij.javaee.ejb.facet.EjbFacet;
import com.intellij.javaee.model.common.JavaeeModelElement;
import com.intellij.javaee.model.common.ejb.EjbCommonModelUtil;
import com.intellij.javaee.model.common.ejb.EnterpriseBean;
import com.intellij.javaee.model.xml.SecurityRole;
import com.intellij.javaee.model.xml.ejb.AssemblyDescriptor;
import com.intellij.javaee.model.xml.ejb.EjbJar;
import com.intellij.javaee.model.xml.ejb.Method;
import com.intellij.javaee.model.xml.ejb.MethodContainer;
import com.intellij.javaee.model.xml.ejb.MethodPermission;
import com.intellij.javaee.module.view.ejb.nodes.EjbFacetNodeDescriptor;
import com.intellij.javaee.module.view.ejb.permissions.EditSecurityRoleDialog;
import com.intellij.javaee.module.view.ejb.permissions.EjbMethodPermissionsModuleNodeDescriptor;
import com.intellij.javaee.module.view.ejb.permissions.MethodContainerHelper;
import com.intellij.javaee.module.view.nodes.J2EEModuleParameters;
import com.intellij.javaee.module.view.nodes.JavaeeNodeDescriptor;
import com.intellij.javaee.ui.DefaultUserResponse;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataConstants;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.Comparing;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.ui.BooleanTableCellEditor;
import com.intellij.ui.BooleanTableCellRenderer;
import com.intellij.ui.TreeTableSpeedSearch;
import com.intellij.ui.dualView.TreeTableView;
import com.intellij.ui.treeStructure.treetable.TreeColumnInfo;
import com.intellij.ui.treeStructure.treetable.TreeTable;
import com.intellij.util.ArrayConsumer;
import com.intellij.util.Consumer;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.ColumnInfo;
import com.intellij.util.xml.GenericDomValue;
import com.intellij.util.xml.ui.DomCollectionControl;
import gnu.trove.THashSet;
import java.awt.DefaultFocusTraversalPolicy;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.swing.JTable;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EjbMethodPermissionsView
extends JamTreeTableView {
    private static final BooleanTableCellRenderer ourBooleanTableCellRenderer = new BooleanTableCellRenderer();
    private static final BooleanTableCellEditor ourBooleanTableCellEditor = new BooleanTableCellEditor();
    private final EjbFacet myEjbFacet;
    private final EjbJar myEjbJar;
    private final List<Runnable> myChanges = new ArrayList<Runnable>();
    private final AnAction myAddSecurityRoleAction = new AnAction(J2EEBundle.message((String)"action.text.add.security.role", (Object[])new Object[0]), null, DomCollectionControl.ADD_ICON){

        public void actionPerformed(AnActionEvent e) {
            new EditSecurityRoleDialog(EjbMethodPermissionsView.this.getAssemblyDescriptor(), null, J2EEBundle.message((String)"action.text.add.security.role", (Object[])new Object[0])).show();
            EjbMethodPermissionsView.this.reset();
        }
    };

    public EjbMethodPermissionsView(EjbFacet ejbFacet, EjbJar ejbJar) {
        super(ejbFacet.getModule().getProject(), new EjbMethodPermissionsModuleNodeDescriptor(ejbFacet, (Object)new J2EEModuleParameters(true)));
        this.myEjbFacet = ejbFacet;
        this.myEjbJar = ejbJar;
        this.getComponent().setFocusTraversalPolicy(new DefaultFocusTraversalPolicy());
        this.getComponent().setFocusable(true);
        final TreeTableView table = this.getTreeTableView();
        table.getTableHeader().addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    DefaultActionGroup group = new DefaultActionGroup();
                    group.add(EjbMethodPermissionsView.this.myAddSecurityRoleAction);
                    int i = table.columnAtPoint(e.getPoint());
                    if (i > 0 && i < table.getModel().getColumnCount() - 2) {
                        final SecurityRole role = (SecurityRole)EjbMethodPermissionsView.this.getAssemblyDescriptor().getSecurityRoles().get(i - 1);
                        String roleName = (String)role.getRoleName().getValue();
                        group.add(new AnAction(J2EEBundle.message((String)"action.text.edit.security.role.0", (Object[])new Object[]{roleName}), null, DomCollectionControl.EDIT_ICON){

                            public void actionPerformed(AnActionEvent e) {
                                EjbMethodPermissionsView.this.showEditRoleDialog(role);
                            }
                        });
                        group.add(new AnAction(J2EEBundle.message((String)"action.text.remove.security.role.0", (Object[])new Object[]{roleName}), null, DomCollectionControl.REMOVE_ICON){

                            public void actionPerformed(AnActionEvent e) {
                                EjbMethodPermissionsView.this.deleteRole(role);
                            }
                        });
                    }
                    ActionManager.getInstance().createActionPopupMenu("ProjectViewPopup", (ActionGroup)group).getComponent().show(e.getComponent(), e.getX(), e.getY());
                }
            }
        });
        table.setAutoResizeMode(0);
        this.init();
        new TreeTableSpeedSearch((TreeTable)this.getTreeTableView());
    }

    @Override
    protected ColumnInfo[] createColumnInfos() {
        ArrayList<Object> list = new ArrayList<Object>();
        list.add(new TreeColumnInfo(J2EEBundle.message((String)"column.name.method.permissions.name", (Object[])new Object[0])));
        AssemblyDescriptor descriptor = this.getAssemblyDescriptor();
        for (SecurityRole role : descriptor.getSecurityRoles()) {
            list.add((Object)new SecurityRoleColumnInfo((String)role.getRoleName().getValue(), descriptor));
        }
        list.add((Object)new ExcludedColumnInfo());
        list.add((Object)new UncheckedColumnInfo(descriptor));
        return list.toArray(ColumnInfo.EMPTY_ARRAY);
    }

    @Override
    @Nullable
    protected ActionGroup createToolbarActions() {
        DefaultActionGroup actionGroup = new DefaultActionGroup();
        actionGroup.add(this.myAddSecurityRoleAction);
        actionGroup.add(new AnAction(J2EEBundle.message((String)"action.text.edit.security.role", (Object[])new Object[0]), null, DomCollectionControl.EDIT_ICON){

            public void update(AnActionEvent e) {
                e.getPresentation().setEnabled(!EjbMethodPermissionsView.this.getAssemblyDescriptor().getSecurityRoles().isEmpty());
            }

            public void actionPerformed(AnActionEvent e) {
                EjbMethodPermissionsView.this.showSecurityRolesPopupMenu((Consumer<SecurityRole>)t -> EjbMethodPermissionsView.this.showEditRoleDialog(t), e, J2EEBundle.message((String)"action.text.edit.security.role", (Object[])new Object[0]));
            }
        });
        actionGroup.add(new AnAction(J2EEBundle.message((String)"action.text.remove.security.role", (Object[])new Object[0]), null, DomCollectionControl.REMOVE_ICON){

            public void update(AnActionEvent e) {
                e.getPresentation().setEnabled(!EjbMethodPermissionsView.this.getAssemblyDescriptor().getSecurityRoles().isEmpty());
            }

            public void actionPerformed(AnActionEvent e) {
                EjbMethodPermissionsView.this.showSecurityRolesPopupMenu((Consumer<SecurityRole>)t -> EjbMethodPermissionsView.this.deleteRole(t), e, J2EEBundle.message((String)"action.text.remove.security.role", (Object[])new Object[0]));
            }
        });
        return actionGroup;
    }

    @Override
    protected void setValueAt(ColumnInfo columnInfo, JamNodeDescriptor descriptor, Object aValue) {
        CommandProcessor.getInstance().executeCommand(this.getProject(), () -> this.myChanges.add(() -> columnInfo.setValue((Object)descriptor, aValue)), null, null);
    }

    @Override
    protected void cacheNode(JamNodeDescriptor node) {
    }

    @Override
    public void commit() {
        super.commit();
        this.doCommit();
    }

    @Override
    public void reset() {
        if (this.myChanges.isEmpty()) {
            super.reset();
        }
    }

    private void doCommit() {
        Runnable[] runnables = this.myChanges.toArray(new Runnable[0]);
        this.myChanges.clear();
        for (Runnable runnable : runnables) {
            runnable.run();
        }
    }

    @Override
    protected void cacheValues() {
        super.cacheValues();
        List allRoles = ContainerUtil.map((Collection)this.getAssemblyDescriptor().getSecurityRoles(), s -> (String)s.getRoleName().getValue());
        for (MethodPermission methodPermission : this.getAssemblyDescriptor().getMethodPermissions()) {
            final Set<Integer> columns = EjbMethodPermissionsView.getColumns(methodPermission, allRoles);
            MethodContainerHelper.processMethods(this.myEjbFacet, (MethodContainer)methodPermission, new ArrayConsumer<Object>(){

                public void consume(Object[] url) {
                    EjbMethodPermissionsView.this.setCachedValues(Boolean.TRUE, columns, url);
                }
            });
        }
        final Set<Integer> columns = Collections.singleton(1 + allRoles.size());
        MethodContainerHelper.processMethods(this.myEjbFacet, (MethodContainer)this.getAssemblyDescriptor().getExcludeList(), new ArrayConsumer<Object>(){

            public void consume(Object ... url) {
                EjbMethodPermissionsView.this.setCachedValues(Boolean.TRUE, columns, url);
            }
        });
    }

    @Override
    protected List<Object> getEmptyColumnValues() {
        return Collections.nCopies(this.getColumnInfos().length, Boolean.FALSE);
    }

    private static Set<Integer> getColumns(MethodPermission methodPermission, List<String> allRoles) {
        THashSet columns = new THashSet();
        if (((Boolean)methodPermission.getUnchecked().getValue()).booleanValue()) {
            columns.add(1 + allRoles.size() + 1);
        }
        List iterable = methodPermission.getRoleNames();
        for (GenericDomValue value : iterable) {
            int i = allRoles.indexOf(value.getStringValue());
            if (i < 0) continue;
            columns.add(1 + i);
        }
        return columns;
    }

    private void showEditRoleDialog(SecurityRole role) {
        new EditSecurityRoleDialog(this.getAssemblyDescriptor(), role, J2EEBundle.message((String)"action.text.edit.security.role", (Object[])new Object[0])).show();
        this.reset();
    }

    private void showSecurityRolesPopupMenu(final Consumer<SecurityRole> consumer, AnActionEvent e, String title) {
        AssemblyDescriptor descriptor = this.getAssemblyDescriptor();
        DefaultActionGroup group = new DefaultActionGroup();
        for (final SecurityRole role : descriptor.getSecurityRoles()) {
            group.add(new AnAction((String)role.getRoleName().getValue()){

                public void actionPerformed(AnActionEvent e) {
                    consumer.consume((Object)role);
                }
            });
        }
        JBPopupFactory.getInstance().createActionGroupPopup(title, (ActionGroup)group, e.getDataContext(), JBPopupFactory.ActionSelectionAid.SPEEDSEARCH, true).showUnderneathOf(e.getInputEvent().getComponent());
    }

    private AssemblyDescriptor getAssemblyDescriptor() {
        return this.myEjbJar.getAssemblyDescriptor();
    }

    @Override
    protected boolean isShowTree() {
        return !EjbCommonModelUtil.getAllEjbs((Project)this.getProject(), null, (EjbFacet)this.myEjbFacet).isEmpty() || !this.getAssemblyDescriptor().getSecurityRoles().isEmpty();
    }

    @Override
    @NotNull
    protected String getEmptyPaneText() {
        String string = J2EEBundle.message((String)"message.text.no.ejbs.in.this.module", (Object[])new Object[0]);
        if (string == null) {
            EjbMethodPermissionsView.$$$reportNull$$$0(0);
        }
        return string;
    }

    private void deleteRole(SecurityRole role) {
        EjbUtil.deleteModelElement((JavaeeModelElement)role, (JamUserResponse)new DefaultUserResponse(this.getProject()));
        this.reset();
    }

    @Override
    public Object getData(String dataId) {
        if (DataConstants.HELP_ID.equals(dataId)) {
            return "newEJBedit_module_method";
        }
        return super.getData(dataId);
    }

    @NotNull
    public static List<Method> getObjectAttributes(MethodContainerHelper container, JavaeeNodeDescriptor descriptor) {
        Object element = descriptor.getElement();
        if (element instanceof EnterpriseBean) {
            EnterpriseBean ejb = (EnterpriseBean)element;
            List<Method> list = ejb.isValid() ? container.getEjbAttributes(ejb) : Collections.emptyList();
            if (list == null) {
                EjbMethodPermissionsView.$$$reportNull$$$0(1);
            }
            return list;
        }
        if (element instanceof PsiClass) {
            EnterpriseBean ejb = (EnterpriseBean)descriptor.getParentDescriptor().getElement();
            List<Method> list = ejb.isValid() ? container.getClassAttributes((PsiClass)element, ejb) : Collections.emptyList();
            if (list == null) {
                EjbMethodPermissionsView.$$$reportNull$$$0(2);
            }
            return list;
        }
        if (element instanceof PsiMethod) {
            EnterpriseBean ejb = (EnterpriseBean)descriptor.getParentDescriptor().getParentDescriptor().getElement();
            List<Method> list = ejb.isValid() ? container.getMethodAttributes((PsiMethod)element, (PsiClass)descriptor.getParentDescriptor().getElement(), ejb) : Collections.emptyList();
            if (list == null) {
                EjbMethodPermissionsView.$$$reportNull$$$0(3);
            }
            return list;
        }
        throw new AssertionError((Object)("Unexpected Element: " + element));
    }

    public static void setObjectAttribute(final MethodContainerHelper attributeContainer, final JamNodeDescriptor descriptor, final String roleName, final boolean set, final JamUserResponse response) {
        EnterpriseBean ejb;
        final Object element = descriptor.getElement();
        if (element instanceof EnterpriseBean) {
            ejb = (EnterpriseBean)element;
        } else if (element instanceof PsiClass) {
            ejb = (EnterpriseBean)descriptor.getParentDescriptor().getElement();
        } else if (element instanceof PsiMethod) {
            ejb = (EnterpriseBean)descriptor.getParentDescriptor().getParentDescriptor().getElement();
        } else {
            throw new AssertionError(element);
        }
        EjbFacet facet = (EjbFacet)ObjectUtils.assertNotNull((Object)EjbFacetNodeDescriptor.getEjbFacetForElement((NodeDescriptor)descriptor));
        EjbJar ejbJar = facet.getXmlRoot();
        if (ejbJar == null) {
            return;
        }
        new WriteCommandAction(descriptor.getProject(), new PsiFile[]{ejbJar.getContainingFile()}){

            protected void run(@NotNull Result result) throws Throwable {
                if (result == null) {
                    8.$$$reportNull$$$0(0);
                }
                if (element instanceof EnterpriseBean) {
                    attributeContainer.setEjbAttribute(ejb, roleName, set, response);
                } else if (element instanceof PsiClass) {
                    attributeContainer.setClassAttribute((PsiClass)element, ejb, roleName, set, response);
                } else if (element instanceof PsiMethod) {
                    attributeContainer.setMethodAttribute((PsiMethod)element, (PsiClass)descriptor.getParentDescriptor().getElement(), ejb, roleName, set, response);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/javaee/module/view/ejb/permissions/EjbMethodPermissionsView$8", "run"));
            }
        }.execute();
    }

    public static Boolean getMethodPermission(JavaeeNodeDescriptor descriptor, String roleName, AssemblyDescriptor assemblyDescriptor) {
        List<Method> attributes = EjbMethodPermissionsView.getObjectAttributes(new MethodContainerHelper.MethodPermissionHelper(assemblyDescriptor), descriptor);
        for (Method methodAttribute : attributes) {
            MethodPermission ejbMethodPermission = (MethodPermission)methodAttribute.getParent();
            Boolean unchecked = (Boolean)ejbMethodPermission.getUnchecked().getValue();
            if ((roleName != null || unchecked == null || !unchecked.booleanValue()) && !MethodContainerHelper.containsRoleWithName(ejbMethodPermission, roleName)) continue;
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public static void setMethodPermissions(JavaeeNodeDescriptor descriptor, String roleName, Boolean set, AssemblyDescriptor assemblyDescriptor) {
        EjbMethodPermissionsView.setObjectAttribute(new MethodContainerHelper.MethodPermissionHelper(assemblyDescriptor), (JamNodeDescriptor)descriptor, roleName, set, UserResponse.QUIET);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/javaee/module/view/ejb/permissions/EjbMethodPermissionsView";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getEmptyPaneText";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getObjectAttributes";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private class UncheckedColumnInfo
    extends AbstractBooleanColumnInfo {
        private final AssemblyDescriptor myDescriptor;

        public UncheckedColumnInfo(AssemblyDescriptor descriptor) {
            super(J2EEBundle.message((String)"column.name.method.permissions.unchecked", (Object[])new Object[0]));
            this.myDescriptor = descriptor;
        }

        public Boolean valueOf(JavaeeNodeDescriptor object) {
            return Boolean.FALSE;
        }

        @Override
        public void setValue(JavaeeNodeDescriptor o, Boolean aValue) {
            EjbMethodPermissionsView.setMethodPermissions(o, null, aValue, this.myDescriptor);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            UncheckedColumnInfo that = (UncheckedColumnInfo)((Object)o);
            return !(this.myDescriptor != null ? !this.myDescriptor.equals(that.myDescriptor) : that.myDescriptor != null);
        }

        public int hashCode() {
            int result = super.hashCode();
            result = 31 * result + (this.myDescriptor != null ? this.myDescriptor.hashCode() : 0);
            return result;
        }
    }

    private class ExcludedColumnInfo
    extends AbstractBooleanColumnInfo {
        public ExcludedColumnInfo() {
            super(J2EEBundle.message((String)"column.name.method.permissions.excluded", (Object[])new Object[0]));
        }

        public Boolean valueOf(JavaeeNodeDescriptor object) {
            return Boolean.FALSE;
        }

        @Override
        public void setValue(JavaeeNodeDescriptor o, Boolean aValue) {
            EjbMethodPermissionsView.setObjectAttribute(new MethodContainerHelper.ExcludeListHelper(EjbMethodPermissionsView.this.getAssemblyDescriptor().getExcludeList()), (JamNodeDescriptor)o, null, aValue, UserResponse.QUIET);
        }
    }

    private static class SecurityRoleColumnInfo
    extends AbstractBooleanColumnInfo {
        private final String myName;
        private final AssemblyDescriptor myDescriptor;

        public SecurityRoleColumnInfo(String name, AssemblyDescriptor descriptor) {
            super(name);
            this.myName = name;
            this.myDescriptor = descriptor;
        }

        public String getTooltipText() {
            return this.hasError() ? IdeBundle.message((String)"model.highlighting.identity", (Object[])new Object[]{TypePresentationService.getService().getTypePresentableName(SecurityRole.class)}) : super.getTooltipText();
        }

        public final boolean hasError() {
            List all = ContainerUtil.findAll((Collection)this.myDescriptor.getSecurityRoles(), object -> Comparing.equal((String)((String)object.getRoleName().getValue()), (String)this.myName));
            return all.size() > 1;
        }

        @Override
        public void setValue(JavaeeNodeDescriptor o, Boolean aValue) {
            EjbMethodPermissionsView.setMethodPermissions(o, this.myName, aValue, this.myDescriptor);
        }

        public Boolean valueOf(JavaeeNodeDescriptor object) {
            return Boolean.FALSE;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            SecurityRoleColumnInfo that = (SecurityRoleColumnInfo)((Object)o);
            if (this.myDescriptor != null ? !this.myDescriptor.equals(that.myDescriptor) : that.myDescriptor != null) {
                return false;
            }
            return !(this.myName != null ? !this.myName.equals(that.myName) : that.myName != null);
        }

        public int hashCode() {
            int result = super.hashCode();
            result = 31 * result + this.myName.hashCode();
            result = 31 * result + this.myDescriptor.hashCode();
            return result;
        }
    }

    private static abstract class AbstractBooleanColumnInfo
    extends ColumnInfo<JavaeeNodeDescriptor, Boolean> {
        public AbstractBooleanColumnInfo(String name) {
            super(name);
        }

        public int getWidth(JTable table) {
            return 15;
        }

        public boolean isCellEditable(JavaeeNodeDescriptor o) {
            return true;
        }

        public Class getColumnClass() {
            return Boolean.class;
        }

        public TableCellRenderer getRenderer(JavaeeNodeDescriptor p0) {
            return ourBooleanTableCellRenderer;
        }

        public TableCellEditor getEditor(JavaeeNodeDescriptor item) {
            return ourBooleanTableCellEditor;
        }

        public abstract void setValue(JavaeeNodeDescriptor var1, Boolean var2);
    }
}

