/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.module.view.nodes;

import com.intellij.ide.DeleteProvider;
import com.intellij.ide.IdeView;
import com.intellij.ide.util.DirectoryChooserUtil;
import com.intellij.ide.util.EditorHelper;
import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.javaee.module.view.nodes.FileNodeDescriptor;
import com.intellij.javaee.module.view.nodes.JavaeeNodeDescriptor;
import com.intellij.javaee.module.view.nodes.PsiNamedElementNodeDescriptor;
import com.intellij.javaee.module.view.web.WebView;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.util.ArrayUtil;
import com.intellij.util.PlatformIcons;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public class DirectoryNodeDescriptor
extends PsiNamedElementNodeDescriptor<PsiDirectory> {
    private VirtualFile myVirtualFile;

    public DirectoryNodeDescriptor(@NotNull PsiDirectory directory, NodeDescriptor parentDescriptor, Object parameters) {
        if (directory == null) {
            DirectoryNodeDescriptor.$$$reportNull$$$0(0);
        }
        super(directory, parentDescriptor, parameters);
        this.myVirtualFile = directory.getVirtualFile();
    }

    @Override
    public String getNewNodeText() {
        if (this.myVirtualFile == null || !this.myVirtualFile.isValid()) {
            this.myVirtualFile = null;
            return null;
        }
        return ((PsiDirectory)this.getElement()).getName();
    }

    public JavaeeNodeDescriptor[] getChildren() {
        return DirectoryNodeDescriptor.getChildrenFileDescriptors((PsiDirectory)this.getElement(), this, this.getParameters());
    }

    public static JavaeeNodeDescriptor[] getChildrenFileDescriptors(PsiDirectory rootFile, JavaeeNodeDescriptor parentDescriptor, Object parameters) {
        VirtualFile[] children;
        ArrayList<PsiNamedElementNodeDescriptor> result = new ArrayList<PsiNamedElementNodeDescriptor>();
        if (rootFile == null) {
            return JavaeeNodeDescriptor.EMPTY_ARRAY;
        }
        PsiManager manager = rootFile.getManager();
        for (VirtualFile child : children = rootFile.getVirtualFile().getChildren()) {
            if (child.isDirectory()) {
                PsiDirectory directory = manager.findDirectory(child);
                if (directory == null) continue;
                result.add(new DirectoryNodeDescriptor(directory, (NodeDescriptor)parentDescriptor, parameters));
                continue;
            }
            PsiFile file = manager.findFile(child);
            if (file == null) continue;
            result.add(new FileNodeDescriptor(file, (NodeDescriptor)parentDescriptor, parameters));
        }
        return result.toArray(JavaeeNodeDescriptor.EMPTY_ARRAY);
    }

    public String getNewTooltip() {
        return this.myVirtualFile == null ? null : this.myVirtualFile.getPresentableUrl();
    }

    public DeleteProvider getDeleteProvider() {
        return null;
    }

    @Override
    public Object getData(String dataId) {
        if ("IDEView".equals(dataId)) {
            return new IdeView(){

                public void selectElement(PsiElement element) {
                    Editor editor;
                    boolean isDirectory;
                    ArrayList<Object> path = new ArrayList<Object>();
                    ContainerUtil.addIfNotNull(path, (Object)element);
                    for (DirectoryNodeDescriptor cur = DirectoryNodeDescriptor.this; cur != null; cur = cur.getParent()) {
                        path.add(cur.getElement());
                    }
                    WebView.select(DirectoryNodeDescriptor.this.myProject, ArrayUtil.reverseArray((Object[])path.toArray()), true);
                    if (element != null && !(isDirectory = element instanceof PsiDirectory) && (editor = EditorHelper.openInEditor((PsiElement)element)) != null) {
                        ToolWindowManager.getInstance((Project)DirectoryNodeDescriptor.this.myProject).activateEditorComponent();
                    }
                }

                @NotNull
                public PsiDirectory[] getDirectories() {
                    PsiDirectory[] psiDirectoryArray = new PsiDirectory[]{(PsiDirectory)DirectoryNodeDescriptor.this.getElement()};
                    if (psiDirectoryArray == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    return psiDirectoryArray;
                }

                public PsiDirectory getOrChooseDirectory() {
                    return DirectoryChooserUtil.getOrChooseDirectory((IdeView)this);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javaee/module/view/nodes/DirectoryNodeDescriptor$1", "getDirectories"));
                }
            };
        }
        return super.getData(dataId);
    }

    @Override
    public Icon getNewIcon() {
        return PlatformIcons.DIRECTORY_CLOSED_ICON;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "directory", "com/intellij/javaee/module/view/nodes/DirectoryNodeDescriptor", "<init>"));
    }
}

