/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.oss.server;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.Executor;
import com.intellij.execution.configurations.PredefinedLogFile;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.j2ee.openapi.ex.DeploymentManagerEx;
import com.intellij.javaee.deployment.DeploymentModel;
import com.intellij.javaee.deployment.DeploymentSource;
import com.intellij.javaee.deployment.DeploymentStatus;
import com.intellij.javaee.deployment.JavaeeDeploymentListener;
import com.intellij.javaee.oss.JavaeeBundle;
import com.intellij.javaee.oss.admin.JavaeeAdmin;
import com.intellij.javaee.oss.admin.JavaeeAdminDeployCallback;
import com.intellij.javaee.oss.admin.JavaeeAdminDeployCallbackWrapper;
import com.intellij.javaee.oss.admin.JavaeeAdminStartCallback;
import com.intellij.javaee.oss.server.DeploymentStatusManager;
import com.intellij.javaee.oss.server.JavaeeIntegration;
import com.intellij.javaee.oss.server.JavaeeServerConnector;
import com.intellij.javaee.oss.server.JavaeeServerExtension;
import com.intellij.javaee.oss.server.JavaeeServerInstance;
import com.intellij.javaee.oss.server.JavaeeServerModel;
import com.intellij.javaee.oss.util.RunEnvironmentProvider;
import com.intellij.javaee.process.common.WrappedException;
import com.intellij.javaee.run.configuration.CommonModel;
import com.intellij.javaee.run.localRun.ExecutableObject;
import com.intellij.javaee.util.ILogger;
import com.intellij.javaee.util.LoggerWrapper;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationGroup;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.util.Condition;
import com.intellij.ui.AppUIUtil;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.io.FileOutputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaeeServerInstanceImpl
extends JavaeeServerConnector
implements JavaeeServerInstance {
    private static final Logger LOG = Logger.getInstance(JavaeeServerInstanceImpl.class);
    @NonNls
    private static final String LOCALHOST_IP = "127.0.0.1";
    private final ConnectLogger myConnectLogger;
    private final int myPingPort;
    private final DeploymentStatusManager myDeploymentStatusManager;
    private boolean myForceUpdateDeploymentStatus;
    private JavaeeAdmin myAdmin;

    public static boolean isLocalhost(CommonModel commonModel) {
        String host = commonModel.getHost();
        return "localhost".equals(host) || LOCALHOST_IP.equals(host);
    }

    public static boolean isRemote(DeploymentModel deployment) {
        CommonModel commonModel = deployment.getCommonModel();
        return !commonModel.isLocal() && !JavaeeServerInstanceImpl.isLocalhost(commonModel);
    }

    public JavaeeServerInstanceImpl(@NotNull CommonModel config, DeploymentStatusManager deploymentStatusManager) {
        if (config == null) {
            JavaeeServerInstanceImpl.$$$reportNull$$$0(0);
        }
        super(config);
        this.myConnectLogger = new ConnectLogger();
        this.myPingPort = this.isPingSupported() ? this.getServerModel().getPingPort() : Integer.MAX_VALUE;
        this.myForceUpdateDeploymentStatus = true;
        this.myDeploymentStatusManager = deploymentStatusManager;
    }

    public void setAdmin(@NotNull JavaeeAdmin admin) {
        if (admin == null) {
            JavaeeServerInstanceImpl.$$$reportNull$$$0(1);
        }
        this.myAdmin = admin;
    }

    @Override
    public ProcessHandler getProcessHandler() {
        return super.getProcessHandler();
    }

    public JavaeeServerModel getServerModel() {
        return (JavaeeServerModel)super.getServerModel();
    }

    @Override
    public boolean connect() throws Exception {
        boolean result = super.connect();
        if (!result && !this.getServerModel().isLocal()) {
            this.myConnectLogger.throwError();
        }
        return result;
    }

    @Override
    public void start(final ProcessHandler handler) {
        super.start(handler);
        final JavaeeServerModel serverModel = this.getServerModel();
        if (serverModel.isTruncateLogFile()) {
            for (PredefinedLogFile file : serverModel.getPredefinedLogFiles()) {
                try {
                    new FileOutputStream(serverModel.getOptionsForPredefinedLogFile(file).getPathPattern()).close();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }
        serverModel.initProcessDebug(handler);
        DeploymentManagerEx.getInstanceEx(this.getProject()).addDeploymentListener(this, new JavaeeDeploymentListener(){

            public void deploymentStatusChanged(DeploymentModel deployment, DeploymentStatus status, CommonModel runConfiguration) {
                String deploymentName = deployment.getDeploymentSource().getPresentableName();
                String text = JavaeeBundle.getText("ServerInstance.artifact.status", new Date(), deploymentName, status.getDescription());
                JavaeeServerInstanceImpl.this.getProcessHandler().notifyTextAvailable(text, ProcessOutputTypes.SYSTEM);
            }
        });
        final boolean printLocal = serverModel.isDetectableLocalPort();
        final boolean printServer = serverModel.isDetectableServerPort();
        if (serverModel.isLocal() && (printLocal || printServer)) {
            handler.addProcessListener((ProcessListener)new ProcessAdapter(){

                public void startNotified(@NotNull ProcessEvent event) {
                    if (event == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    if (printServer) {
                        handler.notifyTextAvailable(JavaeeBundle.getText("ServerInstance.detected.server.port", serverModel.getServerPort()), ProcessOutputTypes.SYSTEM);
                    }
                    if (printLocal) {
                        handler.notifyTextAvailable(JavaeeBundle.getText("ServerInstance.detected.local.port", serverModel.getLocalPort()), ProcessOutputTypes.SYSTEM);
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/javaee/oss/server/JavaeeServerInstanceImpl$2", "startNotified"));
                }
            });
        }
    }

    @Override
    protected void initConnect() throws Exception {
        JavaeeServerModel serverModel = this.getServerModel();
        this.myAdmin.start(serverModel.getServerHost(), serverModel.getServerPort(), serverModel.USERNAME, serverModel.PASSWORD, new JavaeeAdminStartCallback(){

            @Override
            public void updateDeploymentStatus() {
                JavaeeServerInstanceImpl.this.fireUpdateDeploymentStatus();
            }

            @Override
            public ILogger getLogger() {
                return JavaeeServerInstanceImpl.this.myConnectLogger;
            }
        });
        this.fireUpdateDeploymentStatus();
    }

    private boolean isPingSupported() {
        return this.getServerModel().isPingSupported();
    }

    @Override
    protected boolean ping() {
        boolean result = !this.isPingSupported() || this.isConnected(this.myPingPort);
        this.myConnectLogger.setPingSuccess(result);
        return result;
    }

    @Override
    protected boolean doConnect() {
        return this.myAdmin.doConnect();
    }

    @Override
    public void disconnect() {
        if (this.isStarting()) {
            this.myConnectLogger.reportError();
        }
        super.disconnect();
    }

    @Override
    protected void doDisconnect() {
        this.myAdmin.doDisconnect();
        this.myAdmin.shutdown();
    }

    @Override
    public JavaeeServerExtension getExtension() {
        return this.myAdmin.getExtension();
    }

    private DeploymentStatusManager getDeploymentStatusManager() {
        return this.myDeploymentStatusManager;
    }

    protected void fireUpdateDeploymentStatus() {
        ApplicationManager.getApplication().invokeLater(() -> {
            if (!this.getProject().isOpen()) {
                return;
            }
            this.myForceUpdateDeploymentStatus = false;
            try {
                this.getDeploymentStatusManager().updateAllDeploymentStatus();
            }
            finally {
                this.myForceUpdateDeploymentStatus = true;
            }
        });
    }

    @Override
    public Project getProject() {
        return this.getCommonModel().getProject();
    }

    public JavaeeIntegration getJavaeeIntegration() {
        return (JavaeeIntegration)this.getIntegration();
    }

    public boolean isStartupScriptTerminatesAfterServerStartup(@NotNull ExecutableObject startupScript) {
        if (startupScript == null) {
            JavaeeServerInstanceImpl.$$$reportNull$$$0(2);
        }
        return this.getJavaeeIntegration().isStartupScriptTerminating(startupScript);
    }

    public void registerServerError(Throwable t) {
        this.getProcessHandler().notifyTextAvailable(ExceptionUtil.getThrowableText((Throwable)t), ProcessOutputTypes.STDERR);
    }

    @Override
    public void deploy(DeploymentModel deployment) {
        new DeployAction(){

            @Override
            protected void doPerform(DeploymentModel deployment, File source) {
                final long startMs = System.currentTimeMillis();
                JavaeeServerInstanceImpl.this.setDeploymentStatus(deployment, DeploymentStatus.ACTIVATING);
                if (((JavaeeServerModel)deployment.getServerModel()).undeployBeforeDeploy(deployment)) {
                    JavaeeServerInstanceImpl.this.myAdmin.startUndeploy(deployment, source, new JavaeeAdminDeployCallbackWrapper(null){

                        @Override
                        protected boolean checkStatus(DeploymentModel deployment, DeploymentStatus status) {
                            return false;
                        }

                        @Override
                        public void showDeploymentMessage(DeploymentModel deployment, String message) {
                        }
                    });
                }
                JavaeeServerInstanceImpl.this.myAdmin.startDeploy(deployment, source, new JavaeeAdminDeployLoudCallback(){

                    @Override
                    public void setDeploymentStatus(DeploymentModel deployment, DeploymentStatus status) {
                        super.setDeploymentStatus(deployment, status);
                        if (status == DeploymentStatus.DEPLOYED) {
                            long finishMs = System.currentTimeMillis();
                            this.showDeploymentMessage(deployment, JavaeeBundle.getText("ServerInstance.deploy.time", finishMs - startMs));
                        }
                    }
                });
            }
        }.perform(deployment);
    }

    @Override
    public void undeploy(DeploymentModel deployment) {
        new DeployAction(){

            @Override
            protected void doPerform(DeploymentModel deployment, File source) {
                JavaeeServerInstanceImpl.this.myAdmin.startUndeploy(deployment, source, new JavaeeAdminDeployLoudCallback());
            }
        }.perform(deployment);
    }

    @Override
    public void updateDeploymentStatus(DeploymentModel deployment) {
        new DeployAction(){

            @Override
            protected void doPerform(DeploymentModel deployment, File source) {
                final boolean forceUpdateDeploymentStatus = JavaeeServerInstanceImpl.this.myForceUpdateDeploymentStatus;
                JavaeeServerInstanceImpl.this.myAdmin.startUpdateDeploymentStatus(deployment, source, new JavaeeAdminDeploySilentCallback(){

                    @Override
                    public void setDeploymentStatus(DeploymentModel deployment, DeploymentStatus status) {
                        if (status != DeploymentStatus.NOT_DEPLOYED || forceUpdateDeploymentStatus || !DeploymentStatus.ACTIVATING.equals((Object)JavaeeServerInstanceImpl.this.getDeploymentStatusManager().getDeploymentStatus(deployment))) {
                            super.setDeploymentStatus(deployment, status);
                        }
                    }
                });
            }
        }.perform(deployment);
    }

    @Nullable
    public File getDeploymentSource(DeploymentModel deployment) {
        DeploymentSource deploymentSource = deployment.getDeploymentSource();
        File source = deploymentSource.getFile();
        if (source == null) {
            String text = JavaeeBundle.getText("ServerInstance.invalid.deployment.source", deploymentSource.getPresentableName());
            this.getProcessHandler().notifyTextAvailable(text, ProcessOutputTypes.STDERR);
            this.setDeploymentStatus(deployment, DeploymentStatus.FAILED);
        }
        return source;
    }

    public void setDeploymentStatus(DeploymentModel deployment, DeploymentStatus status) {
        this.myDeploymentStatusManager.setDeploymentStatus(deployment, status);
    }

    public void updateChangedFiles(Set<String> changedFilesPaths) {
        this.myAdmin.updateChangedFiles(ContainerUtil.collect(changedFilesPaths.iterator()));
        this.getServerModel().updateChangedFiles(changedFilesPaths);
    }

    public void prepare() throws ExecutionException {
        try {
            this.setAdmin(this.getServerModel().createServerAdmin(this));
        }
        catch (ExecutionException e) {
            throw e;
        }
        catch (Exception e) {
            LOG.debug((Throwable)e);
            throw new ExecutionException(e.getMessage(), (Throwable)e);
        }
    }

    protected Notification createConnectErrorNotification(String message) {
        JavaeeServerModel serverModel = this.getServerModel();
        if (!serverModel.isLocal()) {
            return null;
        }
        CommonModel commonModel = serverModel.getCommonModel();
        if (commonModel == null || commonModel.getProject().isDisposed()) {
            return null;
        }
        Executor executor = new RunEnvironmentProvider(this).getExecutor();
        NotificationGroup notificationGroup = executor == null ? NotificationGroup.balloonGroup((String)"JavaEE") : NotificationGroup.toolWindowGroup((String)"JavaEE", (String)executor.getToolWindowId());
        return notificationGroup.createNotification(JavaeeBundle.getText("ServerInstance.not.connection.before.stop", message), MessageType.WARNING);
    }

    protected void handleMessage(String message) {
    }

    @Override
    public void cleanDeployments(List<DeploymentModel> deploymentModels) {
        this.myAdmin.cleanDeployments(deploymentModels);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "config";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "admin";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "startupScript";
                break;
            }
        }
        objectArray2[1] = "com/intellij/javaee/oss/server/JavaeeServerInstanceImpl";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "setAdmin";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "isStartupScriptTerminatesAfterServerStartup";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private class ConnectLogger
    extends LoggerWrapper {
        private boolean myPingSuccess;
        private final List<Exception> myExceptions;
        private final List<String> myMessages;
        private Exception myLastException;
        private String myLastMessage;
        private String myError;
        private final Object myLock;

        public ConnectLogger() {
            super(LOG);
            this.myExceptions = new ArrayList<Exception>();
            this.myMessages = new ArrayList<String>();
            this.myLock = new Object();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setPingSuccess(boolean pingSuccess) {
            Object object = this.myLock;
            synchronized (object) {
                this.myPingSuccess = pingSuccess;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handleError(Exception e) {
            String message = e.toString();
            JavaeeServerInstanceImpl.this.handleMessage(message);
            Object object = this.myLock;
            synchronized (object) {
                if (!this.hasError(this.myExceptions, message)) {
                    this.myExceptions.add(e);
                }
                this.myLastException = e;
                this.myLastMessage = null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handleError(String message) {
            JavaeeServerInstanceImpl.this.handleMessage(message);
            Object object = this.myLock;
            synchronized (object) {
                if (!this.hasError(this.myMessages, message)) {
                    this.myMessages.add(message);
                }
                this.myLastException = null;
                this.myLastMessage = message;
            }
        }

        private String getError() {
            if (!this.myPingSuccess) {
                return JavaeeBundle.getText("ServerInstance.unable.to.ping", JavaeeServerInstanceImpl.this.getHost(), JavaeeServerInstanceImpl.this.myPingPort);
            }
            if (this.myLastException != null) {
                return JavaeeBundle.getText("ServerInstance.exception.message", this.myLastException.getClass().getName(), this.myLastException.getMessage());
            }
            if (this.myLastMessage != null) {
                return this.myLastMessage;
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void reportError() {
            Object object = this.myLock;
            synchronized (object) {
                for (Exception exception : this.myExceptions) {
                    LOG.warn((Throwable)exception);
                }
                for (String message : this.myMessages) {
                    LOG.warn(message);
                }
                this.myError = this.getError();
                if (this.myError != null) {
                    LOG.warn(this.myError);
                    AppUIUtil.invokeOnEdt(() -> {
                        Notification notification = JavaeeServerInstanceImpl.this.createConnectErrorNotification(this.myError);
                        if (notification != null) {
                            notification.notify(JavaeeServerInstanceImpl.this.getProject());
                        }
                    }, (Condition)JavaeeServerInstanceImpl.this.getProject().getDisposed());
                }
            }
        }

        public void throwError() throws ExecutionException {
            Object object = this.myLock;
            synchronized (object) {
                JavaeeServerModel serverModel = JavaeeServerInstanceImpl.this.getServerModel();
                int failPort = this.myPingSuccess ? serverModel.getServerPort() : JavaeeServerInstanceImpl.this.myPingPort;
                String address = serverModel.getServerHost() + ":" + failPort;
                if (!this.myPingSuccess || this.myError == null) {
                    throw new ExecutionException(JavaeeBundle.getText("message.text.unable.to.connect", address));
                }
                if (!JavaeeServerInstanceImpl.this.isPingSupported()) {
                    throw new ExecutionException(this.myError);
                }
                throw new ExecutionException(JavaeeBundle.getText("message.text.unable.to.connect.detailed", address, this.myError));
            }
        }

        @Override
        public void debugEx(Exception e) {
            super.debugEx(e);
            this.handleError(e);
        }

        @Override
        public void errorEx(Exception e) {
            super.errorEx(e);
            this.handleError(e);
        }

        @Override
        public void debug(String message) {
            super.debug(message);
            this.handleError(message);
        }

        @Override
        public void error(String message) {
            super.error(message);
            this.handleError(message);
        }

        @Override
        public void info(String message) {
            super.info(message);
            JavaeeServerInstanceImpl.this.handleMessage(message);
        }

        private boolean hasError(List errors, String message) {
            for (Object error : errors) {
                if (!error.toString().equals(message)) continue;
                return true;
            }
            return false;
        }
    }

    private class JavaeeAdminDeployLoudCallback
    extends JavaeeAdminDeployCallbackBase {
        private JavaeeAdminDeployLoudCallback() {
        }

        @Override
        public void setDeploymentStatus(DeploymentModel deployment, DeploymentStatus status, String message) {
            super.setDeploymentStatus(deployment, status);
            this.showDeploymentMessage(deployment, message);
        }

        @Override
        public void setDeploymentStatus(DeploymentModel deployment, DeploymentStatus status, Exception error) {
            super.setDeploymentStatus(deployment, status);
            Exception reportedError = error;
            String message = error.toString();
            if (error instanceof WrappedException) {
                Throwable originalError = error.getCause();
                if (originalError instanceof Exception) {
                    reportedError = (Exception)originalError;
                    message = originalError.toString();
                } else {
                    message = error.getMessage();
                }
            }
            LOG.info((Throwable)reportedError);
            this.showDeploymentMessage(deployment, message);
        }

        @Override
        public void showDeploymentMessage(DeploymentModel deployment, String message) {
            String deploymentName = deployment.getDeploymentSource().getPresentableName();
            String text = JavaeeBundle.getText("ServerInstance.artifact.status", new Date(), deploymentName, message);
            JavaeeServerInstanceImpl.this.getProcessHandler().notifyTextAvailable(text, ProcessOutputTypes.SYSTEM);
        }
    }

    private class JavaeeAdminDeploySilentCallback
    extends JavaeeAdminDeployCallbackBase {
        private JavaeeAdminDeploySilentCallback() {
        }

        @Override
        public void setDeploymentStatus(DeploymentModel deployment, DeploymentStatus status, Exception error) {
            super.setDeploymentStatus(deployment, status, error);
            LOG.debug((Throwable)error);
        }

        @Override
        public void setDeploymentStatus(DeploymentModel deployment, DeploymentStatus status, String message) {
            super.setDeploymentStatus(deployment, status, message);
            LOG.debug(message);
        }

        @Override
        public void showDeploymentMessage(DeploymentModel deployment, String message) {
            LOG.debug(message);
        }
    }

    public abstract class JavaeeAdminDeployCallbackBase
    implements JavaeeAdminDeployCallback {
        @Override
        public void setDeploymentStatus(DeploymentModel deployment, DeploymentStatus status) {
            JavaeeServerInstanceImpl.this.setDeploymentStatus(deployment, status);
        }

        @Override
        public void setDeploymentStatus(DeploymentModel deployment, DeploymentStatus status, Exception error) {
            this.setDeploymentStatus(deployment, status);
        }

        @Override
        public void setDeploymentStatus(DeploymentModel deployment, DeploymentStatus status, String message) {
            this.setDeploymentStatus(deployment, status);
        }
    }

    private abstract class DeployAction {
        private DeployAction() {
        }

        public void perform(DeploymentModel deployment) {
            File source = JavaeeServerInstanceImpl.this.getDeploymentSource(deployment);
            if (source == null) {
                return;
            }
            if (!JavaeeServerInstanceImpl.this.isRunning()) {
                JavaeeServerInstanceImpl.this.setDeploymentStatus(deployment, DeploymentStatus.DISCONNECTED);
                return;
            }
            this.doPerform(deployment, source);
        }

        protected abstract void doPerform(DeploymentModel var1, File var2);
    }
}

