/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.run.execution;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.ExecutionResult;
import com.intellij.execution.Executor;
import com.intellij.execution.configurations.RemoteConnection;
import com.intellij.execution.configurations.RemoteState;
import com.intellij.execution.runners.ProgramRunner;
import com.intellij.javaee.J2EEBundle;
import com.intellij.javaee.run.configuration.CommonStrategy;
import com.intellij.javaee.run.execution.ExecutionHelper;
import com.intellij.javaee.run.execution.J2EEProcess;
import com.intellij.javaee.run.execution.J2EEProcessHandlerWrapper;
import com.intellij.javaee.run.execution.J2EERemoteProcessHandler;
import com.intellij.javaee.run.execution.J2EERunnableState;
import com.intellij.javaee.serverInstances.J2EEServerInstance;
import com.intellij.openapi.wm.WindowManager;
import org.jetbrains.annotations.NotNull;

public class J2EERemoteState
implements RemoteState,
J2EERunnableState {
    private final RemoteConnection myConnection;
    private final CommonStrategy myConfiguration;
    private final ExecutionHelper myExecutionHelper;

    public J2EERemoteState(CommonStrategy configuration) {
        this.myConfiguration = configuration;
        this.myConnection = new RemoteConnection(true, this.myConfiguration.getSettingsBean().HOST, "", false);
        this.myExecutionHelper = new ExecutionHelper(configuration);
    }

    public ExecutionResult execute(Executor executor, @NotNull ProgramRunner runner) throws ExecutionException {
        if (runner == null) {
            J2EERemoteState.$$$reportNull$$$0(0);
        }
        J2EEServerInstance instance = this.myExecutionHelper.createServerInstance();
        J2EEProcessHandlerWrapper processHandlerWrapper = new J2EEProcessHandlerWrapper(instance, executor, this.myConfiguration, this, true);
        return this.myExecutionHelper.createExecutionResult(processHandlerWrapper, executor);
    }

    @Override
    public J2EEProcess startJ2EEProcess(J2EEProcessHandlerWrapper processHandlerWrapper) throws ExecutionException {
        try {
            J2EERemoteProcessHandler result = new J2EERemoteProcessHandler(processHandlerWrapper.createHelper());
            boolean ok = processHandlerWrapper.connectToProcess();
            if (!ok) {
                String address = this.myConfiguration.getRemoteHost() + ":" + this.myConfiguration.getRemotePort();
                throw new ExecutionException(J2EEBundle.message((String)"message.text.unable.to.connect", (Object[])new Object[]{address}));
            }
            WindowManager.getInstance().getStatusBar(this.myConfiguration.getProject()).setInfo(J2EEBundle.message((String)"message.text.connected.to.the.server", (Object[])new Object[0]));
            return result;
        }
        catch (ExecutionException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ExecutionException(J2EEBundle.message((String)"exception.text.error.connecting.exception.occured.with.message", (Object[])new Object[]{this.myConfiguration.getIntegration().getPresentableName(), e.getClass().getName(), e.getMessage()}));
        }
    }

    public RemoteConnection getRemoteConnection() {
        return this.myConnection;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runner", "com/intellij/javaee/run/execution/J2EERemoteState", "execute"));
    }
}

