/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.toolwindow.view;

import com.intellij.ProjectTopics;
import com.intellij.icons.AllIcons;
import com.intellij.javaee.toolwindow.view.JavaeeViewSettings;
import com.intellij.javaee.toolwindow.view.panels.FrameworksFinderRecursivePanel;
import com.intellij.javaee.toolwindow.view.panels.ModulesPanel;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.ModuleListener;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootEvent;
import com.intellij.openapi.roots.ModuleRootListener;
import com.intellij.openapi.ui.SimpleToolWindowPanel;
import com.intellij.openapi.util.Disposer;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.ui.FinderRecursivePanel;
import com.intellij.util.Function;
import com.intellij.util.messages.MessageBusConnection;
import java.awt.Component;
import java.util.List;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public class JavaeeView
extends SimpleToolWindowPanel {
    private final Project myProject;
    private FinderRecursivePanel myContent;
    private final DefaultActionGroup myActions = new DefaultActionGroup();

    public JavaeeView(Project project) {
        super(false, true);
        this.myProject = project;
        DumbService.getInstance((Project)project).runWhenSmart(() -> {
            this.installToolbar();
            this.installSettingsListener();
            this.installProjectListeners();
            this.refreshContentPanel();
        });
    }

    private void installToolbar() {
        final JavaeeViewSettings settings = JavaeeViewSettings.getInstance(this.myProject);
        DefaultActionGroup frameworkViewGroup = new DefaultActionGroup();
        frameworkViewGroup.add((AnAction)new ToggleAction("Technologies/Frameworks View", null, AllIcons.ObjectBrowser.ShowModules){

            public boolean isSelected(AnActionEvent e) {
                return settings.isFrameworksView();
            }

            public void setSelected(AnActionEvent e, boolean state) {
                settings.setFrameworksView(state);
                settings.fireSettingsChanged(JavaeeViewSettings.ChangeType.FULL);
            }
        });
        DefaultActionGroup showModulesGroup = new DefaultActionGroup();
        showModulesGroup.add((AnAction)new ToggleAction("Show Modules", null, AllIcons.Nodes.Project){

            public boolean isSelected(AnActionEvent e) {
                return settings.isShowModules();
            }

            public void setSelected(AnActionEvent e, boolean state) {
                settings.setShowModules(state);
                settings.fireSettingsChanged(JavaeeViewSettings.ChangeType.FORCE_UPDATE);
            }

            public void update(AnActionEvent e) {
                super.update(e);
                e.getPresentation().setEnabled(JavaeeViewSettings.getInstance(JavaeeView.this.myProject).isFrameworksView());
            }
        });
        this.myActions.add((AnAction)frameworkViewGroup);
        this.myActions.add((AnAction)showModulesGroup);
        this.setToolbar(ActionManager.getInstance().createActionToolbar("JEEView", (ActionGroup)this.myActions, false).getComponent());
    }

    private void installSettingsListener() {
        this.myProject.getMessageBus().connect((Disposable)this.myProject).subscribe(JavaeeViewSettings.TOPIC, (Object)new JavaeeViewSettings.Listener(){

            @Override
            public void settingsChanged(JavaeeViewSettings.ChangeType changeType) {
                if (changeType == JavaeeViewSettings.ChangeType.FULL) {
                    JavaeeView.this.doFullChange();
                } else if (changeType == JavaeeViewSettings.ChangeType.FORCE_UPDATE) {
                    JavaeeView.this.myContent.updateRightComponent(true);
                } else if (changeType == JavaeeViewSettings.ChangeType.UPDATE) {
                    JavaeeView.this.myContent.updatePanel();
                }
            }
        });
    }

    private void installProjectListeners() {
        MessageBusConnection messageBusConnection = this.myProject.getMessageBus().connect((Disposable)this.myProject);
        messageBusConnection.subscribe(ProjectTopics.PROJECT_ROOTS, (Object)new ModuleRootListener(){

            public void rootsChanged(ModuleRootEvent event) {
                JavaeeView.this.doFullChange();
            }
        });
        messageBusConnection.subscribe(ProjectTopics.MODULES, (Object)new ModuleListener(){

            public void moduleAdded(@NotNull Project project, @NotNull Module module) {
                if (project == null) {
                    5.$$$reportNull$$$0(0);
                }
                if (module == null) {
                    5.$$$reportNull$$$0(1);
                }
                JavaeeView.this.doFullChange();
            }

            public void moduleRemoved(@NotNull Project project, @NotNull Module module) {
                if (project == null) {
                    5.$$$reportNull$$$0(2);
                }
                if (module == null) {
                    5.$$$reportNull$$$0(3);
                }
                JavaeeView.this.doFullChange();
            }

            public void modulesRenamed(@NotNull Project project, @NotNull List<Module> modules, @NotNull Function<Module, String> oldNameProvider) {
                if (project == null) {
                    5.$$$reportNull$$$0(4);
                }
                if (modules == null) {
                    5.$$$reportNull$$$0(5);
                }
                if (oldNameProvider == null) {
                    5.$$$reportNull$$$0(6);
                }
                JavaeeView.this.doFullChange();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "project";
                        break;
                    }
                    case 1: 
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "module";
                        break;
                    }
                    case 5: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "modules";
                        break;
                    }
                    case 6: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "oldNameProvider";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/javaee/toolwindow/view/JavaeeView$5";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "moduleAdded";
                        break;
                    }
                    case 2: 
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "moduleRemoved";
                        break;
                    }
                    case 4: 
                    case 5: 
                    case 6: {
                        objectArray = objectArray2;
                        objectArray2[2] = "modulesRenamed";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        messageBusConnection.subscribe(PsiModificationTracker.TOPIC, (Object)new PsiModificationTracker.Listener(){

            public void modificationCountChanged() {
                if (JavaeeView.this.myContent == null) {
                    JavaeeView.this.refreshContentPanel();
                } else {
                    JavaeeView.this.myContent.updateRightComponent(false);
                }
            }
        });
    }

    private void doFullChange() {
        ApplicationManager.getApplication().invokeLater(() -> {
            FinderRecursivePanel oldPanel = this.myContent;
            this.remove((Component)oldPanel);
            Disposer.dispose((Disposable)oldPanel);
            this.refreshContentPanel();
        }, ModalityState.NON_MODAL, this.myProject.getDisposed());
    }

    private void refreshContentPanel() {
        this.myContent = JavaeeViewSettings.getInstance(this.myProject).isFrameworksView() ? new FrameworksFinderRecursivePanel(this.myProject, this.myActions) : new ModulesPanel(this.myProject, this.myActions);
        this.myContent.initPanel();
        this.setContent((JComponent)this.myContent);
        Disposer.register((Disposable)this.myProject, (Disposable)this.myContent);
    }
}

