/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.ui.packaging;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.packaging.artifacts.ArtifactType;
import com.intellij.packaging.elements.ComplexPackagingElement;
import com.intellij.packaging.elements.CompositePackagingElement;
import com.intellij.packaging.elements.PackagingElement;
import com.intellij.packaging.elements.PackagingElementResolvingContext;
import com.intellij.packaging.impl.artifacts.ArtifactUtil;
import com.intellij.packaging.impl.artifacts.PackagingElementPath;
import com.intellij.packaging.impl.artifacts.PackagingElementProcessor;
import com.intellij.packaging.impl.elements.ArchivePackagingElement;
import com.intellij.packaging.impl.elements.DirectoryCopyPackagingElement;
import com.intellij.packaging.impl.elements.FileCopyPackagingElement;
import com.intellij.packaging.impl.elements.LibraryPackagingElement;
import com.intellij.packaging.impl.elements.ModuleOutputPackagingElement;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class LibrariesAndModulesCollector
extends PackagingElementProcessor<PackagingElement<?>> {
    private final Set<Library> myIncludedLibraries = new THashSet();
    private final Set<VirtualFile> myIncludedLibraryFiles = new THashSet();
    private final List<Pair<Module, List<PackagingElement<?>>>> myUsedModules = new ArrayList();
    private final PackagingElementResolvingContext myContext;
    private final ArtifactType myArtifactType;
    private final boolean myProcessJars;

    public LibrariesAndModulesCollector(PackagingElementResolvingContext context, ArtifactType artifactType, boolean processJars) {
        this.myContext = context;
        this.myArtifactType = artifactType;
        this.myProcessJars = processJars;
    }

    public boolean process(@NotNull PackagingElement<?> element, @NotNull PackagingElementPath path) {
        if (element == null) {
            LibrariesAndModulesCollector.$$$reportNull$$$0(0);
        }
        if (path == null) {
            LibrariesAndModulesCollector.$$$reportNull$$$0(1);
        }
        this.processClassesElement(element, path);
        if (element instanceof ArchivePackagingElement && this.myProcessJars) {
            ArchivePackagingElement archiveElement = (ArchivePackagingElement)element;
            PackagingElementPath childPath = path.appendComposite((CompositePackagingElement)archiveElement);
            ArtifactUtil.processElementsWithSubstitutions((List)archiveElement.getChildren(), (PackagingElementResolvingContext)this.myContext, (ArtifactType)this.myArtifactType, (PackagingElementPath)childPath, (PackagingElementProcessor)new PackagingElementProcessor<PackagingElement<?>>(){

                public boolean process(@NotNull PackagingElement<?> element, @NotNull PackagingElementPath path) {
                    if (element == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if (path == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    LibrariesAndModulesCollector.this.processClassesElement(element, path);
                    return true;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[0] = "element";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[0] = "path";
                            break;
                        }
                    }
                    objectArray[1] = "com/intellij/javaee/ui/packaging/LibrariesAndModulesCollector$1";
                    objectArray[2] = "process";
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            });
        }
        return true;
    }

    private void processClassesElement(PackagingElement<?> element, PackagingElementPath path) {
        ModuleOutputPackagingElement moduleOutputElement;
        Module module;
        if (element instanceof FileCopyPackagingElement) {
            ContainerUtil.addIfNotNull(this.myIncludedLibraryFiles, (Object)((FileCopyPackagingElement)element).getLibraryRoot());
        } else if (element instanceof DirectoryCopyPackagingElement) {
            VirtualFile dir = ((DirectoryCopyPackagingElement)element).findFile();
            if (dir != null) {
                if (this.myProcessJars) {
                    for (VirtualFile child : dir.getChildren()) {
                        VirtualFile jarRoot = JarFileSystem.getInstance().getJarRootForLocalFile(child);
                        if (jarRoot == null) continue;
                        this.myIncludedLibraryFiles.add(jarRoot);
                    }
                } else {
                    this.myIncludedLibraryFiles.add(dir);
                }
            }
        } else if (element instanceof LibraryPackagingElement) {
            ContainerUtil.addIfNotNull(this.myIncludedLibraries, (Object)((LibraryPackagingElement)element).findLibrary(this.myContext));
        } else if (element instanceof ModuleOutputPackagingElement && (module = (moduleOutputElement = (ModuleOutputPackagingElement)element).findModule(this.myContext)) != null) {
            ArrayList pathElements = new ArrayList(path.getAllElements());
            Collections.reverse(pathElements);
            pathElements.add(element);
            this.myUsedModules.add(Pair.create((Object)module, pathElements));
        }
    }

    public boolean shouldProcessSubstitution(ComplexPackagingElement<?> element) {
        return !(element instanceof LibraryPackagingElement);
    }

    public List<Pair<Module, List<PackagingElement<?>>>> getUsedModules() {
        return this.myUsedModules;
    }

    public Set<Library> getIncludedLibraries() {
        return this.myIncludedLibraries;
    }

    public Set<VirtualFile> getIncludedLibraryFiles() {
        return this.myIncludedLibraryFiles;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "element";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "path";
                break;
            }
        }
        objectArray[1] = "com/intellij/javaee/ui/packaging/LibrariesAndModulesCollector";
        objectArray[2] = "process";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

