/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.web;

import com.intellij.javaee.JavaeeCodeStyleSettings;
import com.intellij.javaee.NewAbstractDataHolder;
import com.intellij.javaee.model.xml.web.Filter;
import com.intellij.javaee.web.CommonFilter;
import com.intellij.javaee.web.facet.WebFacet;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.codeStyle.JavaCodeStyleSettings;
import com.intellij.psi.util.CreateClassUtil;

public class FilterDataHolder
extends NewAbstractDataHolder {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.javaee.web.FilterDataHolder");
    private final boolean myShouldCreateClasses;

    public FilterDataHolder(WebFacet webFacet) {
        super(webFacet.getModule(), webFacet.getWebModel().getFilters(), null);
        this.setName(this.getUniqueName());
        this.setClassName(this.getName());
        this.myShouldCreateClasses = true;
    }

    public FilterDataHolder(Filter source) {
        super(source.getModule(), source.getParent().getFilters(), (String)source.getFilterName().getValue());
        this.setName((String)source.getFilterName().getValue());
        this.setClassName(source.getFilterClass().getStringValue());
        PsiClass psiClass = (PsiClass)source.getFilterClass().getValue();
        if (psiClass != null) {
            this.setClassDirectory(psiClass.getContainingFile().getContainingDirectory());
        }
        this.myShouldCreateClasses = false;
    }

    public String getNamePrefix(JavaeeCodeStyleSettings settings) {
        return ((JavaCodeStyleSettings)settings.getContainer().getCustomSettings(JavaCodeStyleSettings.class)).FIELD_NAME_PREFIX;
    }

    public String getNameSuffix(JavaeeCodeStyleSettings settings) {
        return ((JavaCodeStyleSettings)settings.getContainer().getCustomSettings(JavaCodeStyleSettings.class)).FIELD_NAME_SUFFIX;
    }

    private boolean shouldCreateClasses() {
        return this.myShouldCreateClasses;
    }

    protected String getDefaultName() {
        return "Filter";
    }

    protected String getObjectName(Object o) {
        return (String)((CommonFilter)o).getFilterName().getValue();
    }

    public void installTo(Filter filter) {
        filter.getFilterName().setValue((Object)this.getName());
        filter.getFilterClass().setStringValue(this.getClassName());
        if (this.shouldCreateClasses()) {
            CreateClassUtil.createClassFromCustomTemplate((PsiDirectory)this.getClassDirectory(), (Module)this.myModule, (String)this.getClassName(), (String)"Filter Class.java");
        }
    }
}

