/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.web.validation;

import com.intellij.analysis.AnalysisScope;
import com.intellij.javaee.web.validation.JasperArtifactValidator;
import com.intellij.javaee.web.validation.WebJspFileIndexFacade;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.compiler.generic.CompileItem;
import com.intellij.openapi.compiler.generic.DummyPersistentState;
import com.intellij.openapi.compiler.generic.VirtualFileWithDependenciesState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.packageDependencies.ForwardDependenciesBuilder;
import com.intellij.psi.PsiFile;
import com.intellij.psi.jsp.BaseJspFile;
import com.intellij.psi.jsp.JspFile;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class JasperValidatorItem
extends CompileItem<String, VirtualFileWithDependenciesState, DummyPersistentState> {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.javaee.web.validation.JasperValidatorItem");
    private final VirtualFile myJspFile;
    private final String myPathFromRoot;
    private final PsiFile myPsiFile;
    private final boolean myExcluded;

    public JasperValidatorItem(VirtualFile jsp, String pathFromRoot, PsiFile psiFile, boolean excluded) {
        this.myJspFile = jsp;
        this.myPathFromRoot = pathFromRoot;
        this.myPsiFile = psiFile;
        this.myExcluded = excluded;
    }

    @NotNull
    public String getKey() {
        String string = this.myJspFile.getUrl();
        if (string == null) {
            JasperValidatorItem.$$$reportNull$$$0(0);
        }
        return string;
    }

    public boolean isExcluded() {
        return this.myExcluded;
    }

    public String getPathFromRoot() {
        return this.myPathFromRoot;
    }

    public VirtualFile getJspFile() {
        return this.myJspFile;
    }

    public boolean isSourceUpToDate(@NotNull VirtualFileWithDependenciesState virtualFileWithDependenciesState) {
        if (virtualFileWithDependenciesState == null) {
            JasperValidatorItem.$$$reportNull$$$0(1);
        }
        return virtualFileWithDependenciesState.isUpToDate(this.myJspFile);
    }

    @NotNull
    public VirtualFileWithDependenciesState computeSourceState() {
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            JasperArtifactValidator.getInstance(this.myPsiFile.getProject()).addFileNameWithComputedDependency(this.myJspFile.getName());
        }
        ForwardDependenciesBuilder builder = new ForwardDependenciesBuilder(this.myPsiFile.getProject(), new AnalysisScope(this.myPsiFile));
        builder.analyze();
        Set dependentFiles = builder.getDependencies().getOrDefault(this.myPsiFile, new HashSet());
        VirtualFileWithDependenciesState state = new VirtualFileWithDependenciesState(this.myJspFile.getTimeStamp());
        if (this.myPsiFile instanceof JspFile) {
            HashSet<BaseJspFile> included = new HashSet<BaseJspFile>();
            JasperValidatorItem.addIncludedFiles((BaseJspFile)((JspFile)this.myPsiFile), included, WebJspFileIndexFacade.getInstance((Project)this.myPsiFile.getProject()));
            dependentFiles.addAll(included);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Computed dependencies of " + this.myJspFile.getPath() + " (" + dependentFiles.size() + "):");
            int max = 20;
            for (PsiFile file : dependentFiles) {
                if (max-- < 0) break;
                LOG.debug("  " + file);
            }
        }
        for (PsiFile dependentFile : dependentFiles) {
            VirtualFile virtualFile = dependentFile.getVirtualFile();
            if (virtualFile == null) continue;
            state.addDependency(virtualFile);
        }
        VirtualFileWithDependenciesState virtualFileWithDependenciesState = state;
        if (virtualFileWithDependenciesState == null) {
            JasperValidatorItem.$$$reportNull$$$0(2);
        }
        return virtualFileWithDependenciesState;
    }

    private static void addIncludedFiles(BaseJspFile psiFile, Set<BaseJspFile> files, WebJspFileIndexFacade jspFileIndex) {
        BaseJspFile[] included;
        if (!files.add(psiFile)) {
            return;
        }
        for (BaseJspFile jspFile : included = jspFileIndex.getIncludedFiles(psiFile)) {
            JasperValidatorItem.addIncludedFiles(jspFile, files, jspFileIndex);
        }
    }

    public boolean isOutputUpToDate(@NotNull DummyPersistentState dummyPersistentState) {
        if (dummyPersistentState == null) {
            JasperValidatorItem.$$$reportNull$$$0(3);
        }
        return true;
    }

    @NotNull
    public DummyPersistentState computeOutputState() {
        DummyPersistentState dummyPersistentState = DummyPersistentState.INSTANCE;
        if (dummyPersistentState == null) {
            JasperValidatorItem.$$$reportNull$$$0(4);
        }
        return dummyPersistentState;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 3: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 3: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javaee/web/validation/JasperValidatorItem";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFileWithDependenciesState";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dummyPersistentState";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getKey";
                break;
            }
            case 1: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javaee/web/validation/JasperValidatorItem";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "computeSourceState";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "computeOutputState";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isSourceUpToDate";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isOutputUpToDate";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 3: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

