/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jpa.highlighting;

import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInsight.daemon.impl.AnnotationHolderImpl;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.AbstractBaseJavaLocalInspectionTool;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.jpa.JpaMessages;
import com.intellij.jpa.highlighting.JpaInspectionUtil;
import com.intellij.jpa.ql.QlFile;
import com.intellij.jpa.ql.psi.QlCompositeElement;
import com.intellij.jpa.ql.psi.QlRecursiveVisitor;
import com.intellij.jpa.ql.psi.QlStatement;
import com.intellij.jpa.ql.psi.QlVisitor;
import com.intellij.lang.annotation.Annotation;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.AnnotationSession;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.ui.SimpleTextAttributes;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractQlInspection
extends AbstractBaseJavaLocalInspectionTool {
    @Nullable
    public ProblemDescriptor[] checkFile(@NotNull PsiFile file, @NotNull InspectionManager manager, boolean isOnTheFly) {
        if (file == null) {
            AbstractQlInspection.$$$reportNull$$$0(0);
        }
        if (manager == null) {
            AbstractQlInspection.$$$reportNull$$$0(1);
        }
        if (file instanceof QlFile) {
            QlFile qlFile = (QlFile)file;
            if (!this.isFileAccepted(qlFile)) {
                return null;
            }
            return AbstractQlInspection.convertAnnotations2ProblemDescriptors(AbstractQlInspection.checkQl(qlFile), manager, qlFile, isOnTheFly, true, true);
        }
        return null;
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    @NotNull
    public HighlightDisplayLevel getDefaultLevel() {
        HighlightDisplayLevel highlightDisplayLevel = HighlightDisplayLevel.ERROR;
        if (highlightDisplayLevel == null) {
            AbstractQlInspection.$$$reportNull$$$0(2);
        }
        return highlightDisplayLevel;
    }

    protected abstract boolean isFileAccepted(QlFile var1);

    @NotNull
    public String getGroupDisplayName() {
        String string = JpaMessages.message((String)"group.names.jpa.issues", (Object[])new Object[0]);
        if (string == null) {
            AbstractQlInspection.$$$reportNull$$$0(3);
        }
        return string;
    }

    public static Annotation addToList(Annotation annotation, List<Annotation> highlights) {
        highlights.add(annotation);
        return annotation;
    }

    public static List<Annotation> checkQl(QlFile qlFile) {
        final ArrayList<Annotation> highlights = new ArrayList<Annotation>();
        AnnotationHolderImpl annotationHolder = new AnnotationHolderImpl(new AnnotationSession((PsiFile)qlFile)){

            public Annotation createErrorAnnotation(@NotNull TextRange range, String message) {
                if (range == null) {
                    1.$$$reportNull$$$0(0);
                }
                return AbstractQlInspection.addToList(super.createErrorAnnotation(range, message), highlights);
            }

            public Annotation createErrorAnnotation(@NotNull PsiElement elt, String message) {
                if (elt == null) {
                    1.$$$reportNull$$$0(1);
                }
                return AbstractQlInspection.addToList(super.createErrorAnnotation(elt, message), highlights);
            }

            public Annotation createInfoAnnotation(@NotNull PsiElement elt, String message) {
                if (elt == null) {
                    1.$$$reportNull$$$0(2);
                }
                return AbstractQlInspection.addToList(super.createInfoAnnotation(elt, message), highlights);
            }

            public Annotation createWarningAnnotation(@NotNull PsiElement elt, String message) {
                if (elt == null) {
                    1.$$$reportNull$$$0(3);
                }
                return AbstractQlInspection.addToList(super.createWarningAnnotation(elt, message), highlights);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "range";
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "elt";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/jpa/highlighting/AbstractQlInspection$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "createErrorAnnotation";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "createInfoAnnotation";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "createWarningAnnotation";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        final QlVisitor qlAnnotationVisitor = qlFile.getQlModel().createAnnotationVisitor((AnnotationHolder)annotationHolder);
        qlFile.accept(new QlRecursiveVisitor(){

            @Override
            public void visitCompositeElement(@NotNull QlCompositeElement element) {
                QlStatement top;
                if (element == null) {
                    2.$$$reportNull$$$0(0);
                }
                boolean errors = (top = (QlStatement)PsiTreeUtil.getParentOfType((PsiElement)element, QlStatement.class, (boolean)false)) != null && PsiTreeUtil.hasErrorElements((PsiElement)top);
                int oldSize = highlights.size();
                super.visitCompositeElement(element);
                if (errors || highlights.size() != oldSize) {
                    return;
                }
                element.accept(qlAnnotationVisitor);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/jpa/highlighting/AbstractQlInspection$2", "visitCompositeElement"));
            }
        });
        return highlights;
    }

    @Nullable
    public static ProblemDescriptor[] convertAnnotations2ProblemDescriptors(List<Annotation> highlights, InspectionManager manager, PsiFile file, boolean onTheFly, boolean reportErrors, boolean reportWarnings) {
        if (highlights.isEmpty()) {
            return null;
        }
        ArrayList<ProblemDescriptor> problems = new ArrayList<ProblemDescriptor>();
        for (Annotation highlight : highlights) {
            PsiElement endElement;
            if (highlight.getStartOffset() == highlight.getEndOffset() || highlight.getSeverity() == HighlightSeverity.INFORMATION || highlight.getSeverity() == HighlightSeverity.WARNING && !reportErrors || highlight.getSeverity() == HighlightSeverity.ERROR && !reportWarnings) continue;
            PsiElement startElement = file.findElementAt(highlight.getStartOffset());
            PsiElement psiElement = endElement = highlight.getStartOffset() == highlight.getEndOffset() ? startElement : file.findElementAt(highlight.getEndOffset() - 1);
            if (startElement == null || endElement == null) continue;
            ArrayList<LocalQuickFix> fixes = new ArrayList<LocalQuickFix>();
            List quickFixes = highlight.getQuickFixes();
            if (quickFixes != null) {
                for (Annotation.QuickFixInfo quickFixInfo : quickFixes) {
                    IntentionAction intentionAction = quickFixInfo.quickFix;
                    LocalQuickFix quickFix = intentionAction instanceof LocalQuickFix ? (LocalQuickFix)intentionAction : JpaInspectionUtil.convertToQuickFix(intentionAction);
                    fixes.add(quickFix);
                }
            }
            ProblemHighlightType highlightType = ProblemHighlightType.GENERIC_ERROR_OR_WARNING;
            if (SimpleTextAttributes.ERROR_ATTRIBUTES.toTextAttributes().equals((Object)highlight.getEnforcedTextAttributes())) {
                highlightType = ProblemHighlightType.LIKE_UNKNOWN_SYMBOL;
            }
            problems.add(manager.createProblemDescriptor(startElement, endElement, highlight.getMessage(), highlightType, onTheFly, fixes.toArray(LocalQuickFix.EMPTY_ARRAY)));
        }
        return problems.isEmpty() ? null : problems.toArray(ProblemDescriptor.EMPTY_ARRAY);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/jpa/highlighting/AbstractQlInspection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/jpa/highlighting/AbstractQlInspection";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultLevel";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getGroupDisplayName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "checkFile";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

