/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rt.coverage.data;

import com.intellij.rt.coverage.util.CoverageIOUtil;
import java.io.BufferedOutputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class TestDiscoveryProjectData {
    public static final String PROJECT_DATA_OWNER = "com/intellij/rt/coverage/data/TestDiscoveryProjectData";
    public static final String TRACE_DIR = "org.jetbrains.instrumentation.trace.dir";
    protected static TestDiscoveryProjectData ourProjectData = new TestDiscoveryProjectData();
    private final String myTraceDir = System.getProperty("org.jetbrains.instrumentation.trace.dir", "");
    private final ConcurrentMap<String, boolean[]> myClassToVisitedMethods = new ConcurrentHashMap<String, boolean[]>();
    private final ConcurrentMap<String, String[]> myClassToMethodNames = new ConcurrentHashMap<String, String[]>();

    public static TestDiscoveryProjectData getProjectData() {
        return ourProjectData;
    }

    public static boolean[] trace(String className, boolean[] methodFlags, String[] methodNames) {
        return ourProjectData.traceLines(className, methodFlags, methodNames);
    }

    private synchronized boolean[] traceLines(String className, boolean[] methodFlags, String[] methodNames) {
        boolean[] previousMethodFlags = this.myClassToVisitedMethods.putIfAbsent(className, methodFlags);
        if (previousMethodFlags != null) {
            String[] previousMethodNames = (String[])this.myClassToMethodNames.get(className);
        } else {
            this.myClassToMethodNames.put(className, methodNames);
        }
        return previousMethodFlags != null ? previousMethodFlags : methodFlags;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void testDiscoveryEnded(String name) {
        new File(this.myTraceDir).mkdirs();
        File traceFile = new File(this.myTraceDir, name + ".tr");
        try {
            if (!traceFile.exists()) {
                traceFile.createNewFile();
            }
            FilterOutputStream os = null;
            try {
                boolean[] used;
                os = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(traceFile), 65536));
                HashMap classToUsedMethods = new HashMap();
                for (Map.Entry o : this.myClassToVisitedMethods.entrySet()) {
                    used = (boolean[])o.getValue();
                    int usedMethodsCount = 0;
                    for (boolean anUsed : used) {
                        if (!anUsed) continue;
                        ++usedMethodsCount;
                    }
                    if (usedMethodsCount <= 0) continue;
                    classToUsedMethods.put(o.getKey(), usedMethodsCount);
                }
                CoverageIOUtil.writeINT((DataOutput)((Object)os), classToUsedMethods.size());
                for (Map.Entry o : this.myClassToVisitedMethods.entrySet()) {
                    used = (boolean[])o.getValue();
                    String className = (String)o.getKey();
                    Integer usedMethodsCount = (Integer)classToUsedMethods.get(className);
                    if (usedMethodsCount == null) continue;
                    CoverageIOUtil.writeUTF((DataOutput)((Object)os), className);
                    CoverageIOUtil.writeINT((DataOutput)((Object)os), usedMethodsCount);
                    String[] methodNames = (String[])this.myClassToMethodNames.get(className);
                    int len = used.length;
                    for (int i = 0; i < len; ++i) {
                        if (!used[i]) continue;
                        Integer n = usedMethodsCount;
                        Integer n2 = usedMethodsCount = Integer.valueOf(usedMethodsCount - 1);
                        if (n <= 0) continue;
                        CoverageIOUtil.writeUTF((DataOutput)((Object)os), methodNames[i]);
                    }
                }
            }
            finally {
                if (os != null) {
                    os.close();
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public synchronized void testDiscoveryStarted(String name) {
        for (Map.Entry e : this.myClassToVisitedMethods.entrySet()) {
            boolean[] used = (boolean[])e.getValue();
            int len = used.length;
            for (int i = 0; i < len; ++i) {
                if (!used[i]) continue;
                used[i] = false;
            }
        }
    }
}

