/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.intelliLang.inject;

import com.intellij.codeInsight.completion.CompletionUtil;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageParserDefinitions;
import com.intellij.lang.ParserDefinition;
import com.intellij.lang.injection.MultiHostRegistrar;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.Trinity;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtil;
import com.intellij.psi.injection.ReferenceInjector;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.Producer;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.CharArrayUtil;
import com.intellij.util.text.StringSearcher;
import gnu.trove.TIntArrayList;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.intellij.plugins.intelliLang.Configuration;
import org.intellij.plugins.intelliLang.inject.InjectedLanguage;
import org.intellij.plugins.intelliLang.inject.LanguageInjectionSupport;
import org.intellij.plugins.intelliLang.inject.config.BaseInjection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InjectorUtils {
    private static final Logger LOG = Logger.getInstance(InjectorUtils.class);
    public static final Comparator<TextRange> RANGE_COMPARATOR = (o1, o2) -> {
        if (o1.intersects(o2)) {
            return 0;
        }
        return o1.getStartOffset() - o2.getStartOffset();
    };
    private static final Map<String, LanguageInjectionSupport> ourSupports = new LinkedHashMap<String, LanguageInjectionSupport>();
    private static final Pattern MAP_ENTRY_PATTERN;

    private InjectorUtils() {
    }

    @Nullable
    public static Language getLanguage(@NotNull BaseInjection injection) {
        if (injection == null) {
            InjectorUtils.$$$reportNull$$$0(0);
        }
        return InjectorUtils.getLanguageByString(injection.getInjectedLanguageId());
    }

    @Nullable
    public static Language getLanguageByString(String languageId) {
        Language language = InjectedLanguage.findLanguageById(languageId);
        if (language != null) {
            return language;
        }
        ReferenceInjector injector = ReferenceInjector.findById((String)languageId);
        if (injector != null) {
            return injector.toLanguage();
        }
        FileType fileType = FileTypeManager.getInstance().getFileTypeByExtension(languageId);
        return fileType instanceof LanguageFileType ? ((LanguageFileType)fileType).getLanguage() : null;
    }

    public static boolean registerInjectionSimple(@NotNull PsiLanguageInjectionHost host, @NotNull BaseInjection injection, @Nullable LanguageInjectionSupport support, @NotNull MultiHostRegistrar registrar) {
        Language language;
        if (host == null) {
            InjectorUtils.$$$reportNull$$$0(1);
        }
        if (injection == null) {
            InjectorUtils.$$$reportNull$$$0(2);
        }
        if (registrar == null) {
            InjectorUtils.$$$reportNull$$$0(3);
        }
        if ((language = InjectorUtils.getLanguage(injection)) == null) {
            return false;
        }
        InjectedLanguage injectedLanguage = InjectedLanguage.create(injection.getInjectedLanguageId(), injection.getPrefix(), injection.getSuffix(), false);
        List<TextRange> ranges = injection.getInjectedArea((PsiElement)host);
        ArrayList list = ContainerUtil.newArrayListWithCapacity((int)ranges.size());
        for (TextRange range : ranges) {
            list.add(Trinity.create((Object)host, (Object)injectedLanguage, (Object)range));
        }
        InjectorUtils.registerInjection(language, list, host.getContainingFile(), registrar);
        if (support != null) {
            InjectorUtils.registerSupport(support, true, (PsiElement)host, language);
        }
        return !ranges.isEmpty();
    }

    public static void registerInjection(Language language, List<Trinity<PsiLanguageInjectionHost, InjectedLanguage, TextRange>> list, PsiFile containingFile, MultiHostRegistrar registrar) {
        if (language == null) {
            return;
        }
        ParserDefinition parser = (ParserDefinition)LanguageParserDefinitions.INSTANCE.forLanguage(language);
        ReferenceInjector injector = ReferenceInjector.findById((String)language.getID());
        if (parser == null && injector != null && list.size() == 1) {
            String prefix = ((InjectedLanguage)list.get((int)0).second).getPrefix();
            String suffix = ((InjectedLanguage)list.get((int)0).second).getSuffix();
            PsiLanguageInjectionHost host = (PsiLanguageInjectionHost)list.get((int)0).first;
            TextRange textRange = (TextRange)list.get((int)0).third;
            InjectedLanguageUtil.injectReference((MultiHostRegistrar)registrar, (Language)language, (String)prefix, (String)suffix, (PsiLanguageInjectionHost)host, (TextRange)textRange);
            return;
        }
        boolean injectionStarted = false;
        for (Trinity<PsiLanguageInjectionHost, InjectedLanguage, TextRange> t : list) {
            PsiLanguageInjectionHost host = (PsiLanguageInjectionHost)t.first;
            if (host.getContainingFile() != containingFile) continue;
            TextRange textRange = (TextRange)t.third;
            InjectedLanguage injectedLanguage = (InjectedLanguage)t.second;
            if (!injectionStarted) {
                if (!StringUtil.equalsIgnoreCase((CharSequence)language.getID(), (CharSequence)((InjectedLanguage)t.second).getID())) {
                    registrar.startInjecting(language, StringUtil.toLowerCase((String)((InjectedLanguage)t.second).getID()));
                } else {
                    registrar.startInjecting(language);
                }
                injectionStarted = true;
            }
            registrar.addPlace(injectedLanguage.getPrefix(), injectedLanguage.getSuffix(), host, textRange);
        }
        if (injectionStarted) {
            registrar.doneInjecting();
        }
    }

    @NotNull
    public static Collection<String> getActiveInjectionSupportIds() {
        Set<String> set = ourSupports.keySet();
        if (set == null) {
            InjectorUtils.$$$reportNull$$$0(4);
        }
        return set;
    }

    public static Collection<LanguageInjectionSupport> getActiveInjectionSupports() {
        return ourSupports.values();
    }

    @Nullable
    public static LanguageInjectionSupport findInjectionSupport(String id) {
        return ourSupports.get(id);
    }

    @NotNull
    public static Class[] getPatternClasses(String supportId) {
        LanguageInjectionSupport support = InjectorUtils.findInjectionSupport(supportId);
        Class[] classArray = support == null ? ArrayUtil.EMPTY_CLASS_ARRAY : support.getPatternClasses();
        if (classArray == null) {
            InjectorUtils.$$$reportNull$$$0(5);
        }
        return classArray;
    }

    @NotNull
    public static LanguageInjectionSupport findNotNullInjectionSupport(String id) {
        LanguageInjectionSupport result = InjectorUtils.findInjectionSupport(id);
        assert (result != null) : id + " injector not found";
        LanguageInjectionSupport languageInjectionSupport = result;
        if (languageInjectionSupport == null) {
            InjectorUtils.$$$reportNull$$$0(6);
        }
        return languageInjectionSupport;
    }

    public static StringBuilder appendStringPattern(@NotNull StringBuilder sb, @NotNull String prefix, @NotNull String text, @NotNull String suffix) {
        if (sb == null) {
            InjectorUtils.$$$reportNull$$$0(7);
        }
        if (prefix == null) {
            InjectorUtils.$$$reportNull$$$0(8);
        }
        if (text == null) {
            InjectorUtils.$$$reportNull$$$0(9);
        }
        if (suffix == null) {
            InjectorUtils.$$$reportNull$$$0(10);
        }
        sb.append(prefix).append("string().");
        String[] parts = text.split("[,|\\s]+");
        boolean useMatches = false;
        for (String part : parts) {
            if (!InjectorUtils.isRegexp(part)) continue;
            useMatches = true;
            break;
        }
        if (useMatches) {
            sb.append("matches(\"").append(text).append("\")");
        } else if (parts.length > 1) {
            sb.append("oneOf(");
            boolean first = true;
            for (String part : parts) {
                if (first) {
                    first = false;
                } else {
                    sb.append(", ");
                }
                sb.append("\"").append(part).append("\"");
            }
            sb.append(")");
        } else {
            sb.append("equalTo(\"").append(text).append("\")");
        }
        sb.append(suffix);
        return sb;
    }

    public static boolean isRegexp(String s) {
        boolean hasReChars = false;
        int len = s.length();
        for (int i = 0; i < len; ++i) {
            char c = s.charAt(i);
            if (c == ' ' || c == '_' || c == '-' || Character.isLetterOrDigit(c)) continue;
            hasReChars = true;
            break;
        }
        if (hasReChars) {
            try {
                new URL(s);
            }
            catch (MalformedURLException e) {
                return true;
            }
        }
        return false;
    }

    public static void registerSupport(@NotNull LanguageInjectionSupport support, boolean settingsAvailable, @NotNull PsiElement element, @NotNull Language language) {
        if (support == null) {
            InjectorUtils.$$$reportNull$$$0(11);
        }
        if (element == null) {
            InjectorUtils.$$$reportNull$$$0(12);
        }
        if (language == null) {
            InjectorUtils.$$$reportNull$$$0(13);
        }
        InjectorUtils.putInjectedFileUserData(element, language, LanguageInjectionSupport.INJECTOR_SUPPORT, support);
        if (settingsAvailable) {
            InjectorUtils.putInjectedFileUserData(element, language, LanguageInjectionSupport.SETTINGS_EDITOR, support);
        }
    }

    public static void registerSupport(@NotNull LanguageInjectionSupport support, boolean settingsAvailable, @NotNull MultiHostRegistrar registrar) {
        if (support == null) {
            InjectorUtils.$$$reportNull$$$0(14);
        }
        if (registrar == null) {
            InjectorUtils.$$$reportNull$$$0(15);
        }
        LOG.warn("use {@link InjectorUtils#registerSupport(org.intellij.plugins.intelliLang.inject.LanguageInjectionSupport, boolean, com.intellij.psi.PsiElement, com.intellij.lang.Language)} instead");
        InjectorUtils.putInjectedFileUserData(registrar, LanguageInjectionSupport.INJECTOR_SUPPORT, support);
        if (settingsAvailable) {
            InjectorUtils.putInjectedFileUserData(registrar, LanguageInjectionSupport.SETTINGS_EDITOR, support);
        }
    }

    public static <T> void putInjectedFileUserData(@NotNull PsiElement element, @NotNull Language language, Key<T> key, T value) {
        if (element == null) {
            InjectorUtils.$$$reportNull$$$0(16);
        }
        if (language == null) {
            InjectorUtils.$$$reportNull$$$0(17);
        }
        InjectedLanguageUtil.putInjectedFileUserData((PsiElement)element, (Language)language, key, value);
    }

    public static <T> void putInjectedFileUserData(MultiHostRegistrar registrar, Key<T> key, T value) {
        InjectedLanguageUtil.putInjectedFileUserData((MultiHostRegistrar)registrar, key, value);
    }

    public static Configuration getEditableInstance(Project project) {
        return Configuration.getInstance();
    }

    public static boolean canBeRemoved(BaseInjection injection) {
        if (injection.isEnabled()) {
            return false;
        }
        if (StringUtil.isNotEmpty((String)injection.getPrefix()) || StringUtil.isNotEmpty((String)injection.getSuffix())) {
            return false;
        }
        return !StringUtil.isNotEmpty((String)injection.getValuePattern());
    }

    @Nullable
    public static CommentInjectionData findCommentInjectionData(@NotNull PsiElement context, @Nullable Ref<PsiElement> causeRef) {
        if (context == null) {
            InjectorUtils.$$$reportNull$$$0(18);
        }
        return InjectorUtils.findCommentInjectionData(context, true, causeRef);
    }

    @Nullable
    public static CommentInjectionData findCommentInjectionData(@NotNull PsiElement context, boolean treeElementsIncludeComment, @Nullable Ref<PsiElement> causeRef) {
        PsiElement target;
        PsiFile file;
        if (context == null) {
            InjectorUtils.$$$reportNull$$$0(19);
        }
        if ((file = (target = CompletionUtil.getOriginalOrSelf((PsiElement)context)).getContainingFile()) == null) {
            return null;
        }
        TreeMap<TextRange, CommentInjectionData> map = InjectorUtils.getInjectionMap(file);
        if (map == null) {
            return null;
        }
        Map.Entry<TextRange, CommentInjectionData> entry = map.lowerEntry(target.getTextRange());
        if (entry == null) {
            return null;
        }
        PsiComment psiComment = (PsiComment)PsiTreeUtil.findElementOfClassAtOffset((PsiFile)file, (int)entry.getKey().getStartOffset(), PsiComment.class, (boolean)false);
        if (psiComment == null) {
            return null;
        }
        TextRange r0 = psiComment.getTextRange();
        PsiElement commonParent = PsiTreeUtil.findCommonParent((PsiElement)psiComment, (PsiElement)target);
        if (commonParent == null) {
            return null;
        }
        PsiElement topmostElement = target;
        for (PsiElement parent = target; parent != null && (treeElementsIncludeComment ? parent : parent.getParent()) != commonParent; parent = parent.getParent()) {
            topmostElement = parent;
        }
        int off1 = r0.getEndOffset();
        int off2 = topmostElement.getTextRange().getStartOffset();
        if (off2 - off1 > 120) {
            return null;
        }
        if (off2 - off1 > 2) {
            PsiElement e;
            Producer<PsiElement> producer = InjectorUtils.prevWalker(topmostElement, commonParent);
            while ((e = (PsiElement)producer.produce()) != null && e != psiComment) {
                if (!(e instanceof PsiLanguageInjectionHost) || !((PsiLanguageInjectionHost)e).isValidHost() || StringUtil.isEmptyOrSpaces((String)e.getText())) continue;
                return null;
            }
        }
        if (causeRef != null) {
            causeRef.set((Object)psiComment);
        }
        return entry.getValue();
    }

    @Nullable
    public static BaseInjection findCommentInjection(@NotNull PsiElement context, @NotNull String supportId, @Nullable Ref<PsiElement> causeRef) {
        CommentInjectionData data;
        if (context == null) {
            InjectorUtils.$$$reportNull$$$0(20);
        }
        if (supportId == null) {
            InjectorUtils.$$$reportNull$$$0(21);
        }
        if ((data = InjectorUtils.findCommentInjectionData(context, causeRef)) == null) {
            return null;
        }
        BaseInjection injection = new BaseInjection(supportId);
        injection.setPrefix(data.getPrefix());
        injection.setSuffix(data.getSuffix());
        injection.setInjectedLanguageId(data.getInjectedLanguageId());
        injection.setDisplayName(data.getDisplayName());
        return injection;
    }

    @Nullable
    private static TreeMap<TextRange, CommentInjectionData> getInjectionMap(@NotNull PsiFile file) {
        if (file == null) {
            InjectorUtils.$$$reportNull$$$0(22);
        }
        return (TreeMap)CachedValuesManager.getCachedValue((PsiElement)file, () -> {
            TreeMap<TextRange, CommentInjectionData> map;
            if (file == null) {
                InjectorUtils.$$$reportNull$$$0(24);
            }
            return CachedValueProvider.Result.create((map = InjectorUtils.calcInjections(file)).isEmpty() ? null : map, (Object[])new Object[]{file});
        });
    }

    @NotNull
    protected static TreeMap<TextRange, CommentInjectionData> calcInjections(PsiFile file) {
        TreeMap<TextRange, CommentInjectionData> injectionMap = new TreeMap<TextRange, CommentInjectionData>(RANGE_COMPARATOR);
        TIntArrayList ints = new TIntArrayList();
        StringSearcher searcher = new StringSearcher("language=", true, true, false);
        CharSequence contents = file.getViewProvider().getContents();
        char[] contentsArray = CharArrayUtil.fromSequenceWithoutCopying((CharSequence)contents);
        int s0 = 0;
        int s1 = contents.length();
        int idx = searcher.scan(contents, contentsArray, s0, s1);
        while (idx != -1) {
            ints.add(idx);
            PsiComment element = (PsiComment)PsiTreeUtil.findElementOfClassAtOffset((PsiFile)file, (int)idx, PsiComment.class, (boolean)false);
            if (element != null) {
                CommentInjectionData injection;
                String str = ElementManipulators.getValueText((PsiElement)element).trim();
                CommentInjectionData commentInjectionData = injection = str.startsWith("language=") ? new CommentInjectionData(InjectorUtils.decodeMap(str), str) : null;
                if (injection != null) {
                    injectionMap.put(element.getTextRange(), injection);
                }
            }
            idx = searcher.scan(contents, contentsArray, idx + 1, s1);
        }
        TreeMap<TextRange, CommentInjectionData> treeMap = injectionMap;
        if (treeMap == null) {
            InjectorUtils.$$$reportNull$$$0(23);
        }
        return treeMap;
    }

    private static Map<String, String> decodeMap(CharSequence charSequence) {
        if (StringUtil.isEmpty((CharSequence)charSequence)) {
            return Collections.emptyMap();
        }
        Matcher matcher = MAP_ENTRY_PATTERN.matcher(charSequence);
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        while (matcher.find()) {
            map.put(StringUtil.unescapeStringCharacters((String)matcher.group(1)), StringUtil.unescapeStringCharacters((String)StringUtil.unquoteString((String)matcher.group(2))));
        }
        return map;
    }

    private static Producer<PsiElement> prevWalker(final PsiElement element, final PsiElement scope) {
        return new Producer<PsiElement>(){
            PsiElement e;
            {
                this.e = element;
            }

            @Nullable
            public PsiElement produce() {
                if (this.e == null || this.e == scope) {
                    return null;
                }
                PsiElement prev = this.e.getPrevSibling();
                if (prev != null) {
                    this.e = PsiTreeUtil.getDeepestLast((PsiElement)prev);
                    return this.e;
                }
                PsiElement parent = this.e.getParent();
                this.e = parent == scope || parent instanceof PsiFile ? null : parent;
                return this.e;
            }
        };
    }

    static {
        for (LanguageInjectionSupport languageInjectionSupport : Arrays.asList(Extensions.getExtensions(LanguageInjectionSupport.EP_NAME))) {
            ourSupports.put(languageInjectionSupport.getId(), languageInjectionSupport);
        }
        MAP_ENTRY_PATTERN = Pattern.compile("([\\S&&[^=]]+)=(\"(?:[^\"]|\\\\\")*\"|\\S*)");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 23: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 23: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "injection";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "host";
                break;
            }
            case 3: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "registrar";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/intellij/plugins/intelliLang/inject/InjectorUtils";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sb";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prefix";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "suffix";
                break;
            }
            case 11: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "support";
                break;
            }
            case 12: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 13: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "language";
                break;
            }
            case 18: 
            case 19: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "supportId";
                break;
            }
            case 22: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/intellij/plugins/intelliLang/inject/InjectorUtils";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getActiveInjectionSupportIds";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getPatternClasses";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "findNotNullInjectionSupport";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "calcInjections";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getLanguage";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "registerInjectionSimple";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 23: {
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "appendStringPattern";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "registerSupport";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "putInjectedFileUserData";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "findCommentInjectionData";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "findCommentInjection";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "getInjectionMap";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getInjectionMap$1";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 23: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class CommentInjectionData {
        private final String myDisplayName;
        private final Map<String, String> myMap;

        public CommentInjectionData(@NotNull Map<String, String> map, String displayName) {
            if (map == null) {
                CommentInjectionData.$$$reportNull$$$0(0);
            }
            this.myMap = Collections.unmodifiableMap(map);
            this.myDisplayName = displayName;
        }

        @NotNull
        public String getPrefix() {
            String string = (String)ObjectUtils.notNull((Object)this.myMap.get("prefix"), (Object)"");
            if (string == null) {
                CommentInjectionData.$$$reportNull$$$0(1);
            }
            return string;
        }

        @NotNull
        public String getSuffix() {
            String string = (String)ObjectUtils.notNull((Object)this.myMap.get("suffix"), (Object)"");
            if (string == null) {
                CommentInjectionData.$$$reportNull$$$0(2);
            }
            return string;
        }

        @NotNull
        public String getInjectedLanguageId() {
            String string = (String)ObjectUtils.notNull((Object)this.myMap.get("language"), (Object)"");
            if (string == null) {
                CommentInjectionData.$$$reportNull$$$0(3);
            }
            return string;
        }

        public String getDisplayName() {
            return this.myDisplayName;
        }

        public Map<String, String> getValues() {
            return this.myMap;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "map";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/intellij/plugins/intelliLang/inject/InjectorUtils$CommentInjectionData";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/intellij/plugins/intelliLang/inject/InjectorUtils$CommentInjectionData";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPrefix";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getSuffix";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getInjectedLanguageId";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

