/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.velocity.editorActions;

import com.intellij.codeInsight.AutoPopupController;
import com.intellij.codeInsight.CodeInsightSettings;
import com.intellij.codeInsight.completion.CompletionType;
import com.intellij.codeInsight.editorActions.TypedHandlerDelegate;
import com.intellij.lang.Language;
import com.intellij.lang.StdLanguages;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorModificationUtil;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PlatformPatterns;
import com.intellij.patterns.StandardPatterns;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.velocity.editorActions.EditorUtil;
import com.intellij.velocity.psi.VtlCompositeElementTypes;
import com.intellij.velocity.psi.VtlElementTypes;
import com.intellij.velocity.psi.VtlLanguage;
import com.intellij.velocity.psi.files.VtlFileViewProvider;
import com.intellij.velocity.psi.reference.VtlReferenceExpression;
import org.jetbrains.annotations.NotNull;

public class VelocityTypedHandler
extends TypedHandlerDelegate {
    private static final ElementPattern<VtlReferenceExpression> MACRO_NAME_WITH_BODY = PlatformPatterns.psiElement(VtlReferenceExpression.class).withParent((ElementPattern)PlatformPatterns.psiElement(PsiErrorElement.class).withText((ElementPattern)StandardPatterns.string().startsWith("#@")));

    @NotNull
    public TypedHandlerDelegate.Result checkAutoPopup(char charTyped, @NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file) {
        if (project == null) {
            VelocityTypedHandler.$$$reportNull$$$0(0);
        }
        if (editor == null) {
            VelocityTypedHandler.$$$reportNull$$$0(1);
        }
        if (file == null) {
            VelocityTypedHandler.$$$reportNull$$$0(2);
        }
        if (!(file.getViewProvider() instanceof VtlFileViewProvider)) {
            TypedHandlerDelegate.Result result = TypedHandlerDelegate.Result.CONTINUE;
            if (result == null) {
                VelocityTypedHandler.$$$reportNull$$$0(3);
            }
            return result;
        }
        int offset = editor.getCaretModel().getOffset();
        if (charTyped == '#' && (offset == 0 || editor.getDocument().getCharsSequence().charAt(offset - 1) != '#')) {
            AutoPopupController.getInstance((Project)project).scheduleAutoPopup(editor, CompletionType.BASIC, f -> VelocityTypedHandler.isInsideTemplateText(offset, f));
            TypedHandlerDelegate.Result result = TypedHandlerDelegate.Result.STOP;
            if (result == null) {
                VelocityTypedHandler.$$$reportNull$$$0(4);
            }
            return result;
        }
        TypedHandlerDelegate.Result result = super.checkAutoPopup(charTyped, project, editor, file);
        if (result == null) {
            VelocityTypedHandler.$$$reportNull$$$0(5);
        }
        return result;
    }

    public static boolean isInsideTemplateText(int offset, PsiFile f) {
        return PsiUtilCore.getElementType((PsiElement)f.getViewProvider().findElementAt(offset, (Language)VtlLanguage.INSTANCE)) == VtlElementTypes.TEMPLATE_TEXT;
    }

    @NotNull
    public TypedHandlerDelegate.Result beforeCharTyped(char c, @NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file, @NotNull FileType fileType) {
        if (project == null) {
            VelocityTypedHandler.$$$reportNull$$$0(6);
        }
        if (editor == null) {
            VelocityTypedHandler.$$$reportNull$$$0(7);
        }
        if (file == null) {
            VelocityTypedHandler.$$$reportNull$$$0(8);
        }
        if (fileType == null) {
            VelocityTypedHandler.$$$reportNull$$$0(9);
        }
        if (EditorUtil.isNotVtlFile(file, editor)) {
            TypedHandlerDelegate.Result result = TypedHandlerDelegate.Result.CONTINUE;
            if (result == null) {
                VelocityTypedHandler.$$$reportNull$$$0(10);
            }
            return result;
        }
        Document document = editor.getDocument();
        if (c == '(') {
            int offset = editor.getCaretModel().getOffset();
            char charAtOffset = EditorUtil.getCharAt(document, offset);
            if (charAtOffset == '(') {
                EditorModificationUtil.insertStringAtCaret((Editor)editor, (String)"(", (boolean)true, (int)1);
                TypedHandlerDelegate.Result result = TypedHandlerDelegate.Result.STOP;
                if (result == null) {
                    VelocityTypedHandler.$$$reportNull$$$0(11);
                }
                return result;
            }
            if (!CodeInsightSettings.getInstance().AUTOINSERT_PAIR_BRACKET || charAtOffset == ')') {
                TypedHandlerDelegate.Result result = TypedHandlerDelegate.Result.CONTINUE;
                if (result == null) {
                    VelocityTypedHandler.$$$reportNull$$$0(12);
                }
                return result;
            }
            VelocityTypedHandler.closeDirective(editor, file, offset);
            TypedHandlerDelegate.Result result = TypedHandlerDelegate.Result.STOP;
            if (result == null) {
                VelocityTypedHandler.$$$reportNull$$$0(13);
            }
            return result;
        }
        if (c == '}') {
            int offset = editor.getCaretModel().getOffset();
            PsiDocumentManager.getInstance((Project)project).commitDocument(document);
            if (EditorUtil.getCharAt(document, offset) == '}') {
                EditorModificationUtil.moveCaretRelatively((Editor)editor, (int)1);
                TypedHandlerDelegate.Result result = TypedHandlerDelegate.Result.STOP;
                if (result == null) {
                    VelocityTypedHandler.$$$reportNull$$$0(14);
                }
                return result;
            }
        }
        TypedHandlerDelegate.Result result = TypedHandlerDelegate.Result.CONTINUE;
        if (result == null) {
            VelocityTypedHandler.$$$reportNull$$$0(15);
        }
        return result;
    }

    public static void closeDirective(Editor editor, PsiFile file, int offset) {
        String toType;
        Document document = editor.getDocument();
        document.insertString(offset, (CharSequence)"()");
        editor.getCaretModel().moveToOffset(offset + 1);
        Project project = file.getProject();
        PsiDocumentManager.getInstance((Project)project).commitDocument(document);
        PsiElement token = file.findElementAt(offset - 1);
        if (token == null) {
            return;
        }
        String tokenText = token.getText().trim();
        if ("#foreach".equals(tokenText) || "#if".equals(tokenText) || "#macro".equals(tokenText)) {
            toType = "\n#end";
        } else if ("#{foreach}".equals(tokenText) || "#{if}".equals(tokenText) || "#{macro}".equals(tokenText)) {
            toType = "\n#{end}";
        } else if (MACRO_NAME_WITH_BODY.accepts((Object)token.getParent())) {
            toType = " #end";
        } else {
            return;
        }
        document.insertString(offset + 2, (CharSequence)toType);
        if (toType.contains("\n")) {
            PsiDocumentManager.getInstance((Project)project).commitDocument(document);
            CodeStyleManager.getInstance((Project)project).adjustLineIndent(file, new TextRange(offset + 3, offset + 2 + toType.length()));
        }
    }

    @NotNull
    public TypedHandlerDelegate.Result charTyped(char c, @NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file) {
        if (project == null) {
            VelocityTypedHandler.$$$reportNull$$$0(16);
        }
        if (editor == null) {
            VelocityTypedHandler.$$$reportNull$$$0(17);
        }
        if (file == null) {
            VelocityTypedHandler.$$$reportNull$$$0(18);
        }
        if (EditorUtil.isNotVtlFile(file, editor)) {
            TypedHandlerDelegate.Result result = TypedHandlerDelegate.Result.CONTINUE;
            if (result == null) {
                VelocityTypedHandler.$$$reportNull$$$0(19);
            }
            return result;
        }
        PsiDocumentManager documentManager = PsiDocumentManager.getInstance((Project)project);
        Document document = editor.getDocument();
        if (c == '{') {
            int offset = editor.getCaretModel().getOffset();
            documentManager.commitDocument(document);
            PsiElement element = file.findElementAt(offset - 1);
            if (element != null) {
                CharSequence text;
                if (element.getLanguage() == StdLanguages.TEXT) {
                    text = document.getCharsSequence();
                    if (offset >= 2 && text.charAt(offset - 2) == '$' && (offset >= text.length() || text.charAt(offset) != '}')) {
                        document.insertString(offset, (CharSequence)"}");
                        TypedHandlerDelegate.Result result = TypedHandlerDelegate.Result.STOP;
                        if (result == null) {
                            VelocityTypedHandler.$$$reportNull$$$0(20);
                        }
                        return result;
                    }
                }
                if ("${".equals(text = element.getText().trim()) || "$!{".equals(text) || "#{".equals(text)) {
                    char charAtOffset = EditorUtil.getCharAt(document, offset);
                    String textToInsert = charAtOffset == '{' ? "}$" : "}";
                    PsiElement parent = element.getParent();
                    if (EditorUtil.getElementType(parent) == VtlCompositeElementTypes.INTERPOLATION) {
                        if (parent.getText().endsWith("}")) {
                            TypedHandlerDelegate.Result result = TypedHandlerDelegate.Result.STOP;
                            if (result == null) {
                                VelocityTypedHandler.$$$reportNull$$$0(21);
                            }
                            return result;
                        }
                        offset = parent.getTextOffset() + parent.getTextLength();
                    }
                    document.insertString(offset, (CharSequence)textToInsert);
                    TypedHandlerDelegate.Result result = TypedHandlerDelegate.Result.STOP;
                    if (result == null) {
                        VelocityTypedHandler.$$$reportNull$$$0(22);
                    }
                    return result;
                }
            }
        }
        TypedHandlerDelegate.Result result = TypedHandlerDelegate.Result.CONTINUE;
        if (result == null) {
            VelocityTypedHandler.$$$reportNull$$$0(23);
        }
        return result;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 7: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 2: 
            case 8: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/velocity/editorActions/VelocityTypedHandler";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/velocity/editorActions/VelocityTypedHandler";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "checkAutoPopup";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "beforeCharTyped";
                break;
            }
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "charTyped";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "checkAutoPopup";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "beforeCharTyped";
                break;
            }
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "charTyped";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

