/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import javax.swing.ComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ColoredListCellRenderer<T>
extends SimpleColoredComponent
implements ListCellRenderer<T> {
    private final ListCellRenderer myDefaultGtkRenderer = UIUtil.isUnderGTKLookAndFeel() ? new JComboBox().getRenderer() : null;
    protected boolean mySelected;
    protected Color myForeground;
    protected Color mySelectionForeground;
    @Nullable
    private final JComboBox myComboBox;

    public ColoredListCellRenderer() {
        this(null);
    }

    public ColoredListCellRenderer(@Nullable JComboBox comboBox) {
        this.myComboBox = comboBox;
        this.setFocusBorderAroundIcon(true);
        this.getIpad().right = UIUtil.isUnderWin10LookAndFeel() ? 0 : JBUI.scale((int)UIUtil.getListCellHPadding());
        this.getIpad().left = this.getIpad().right;
    }

    @Override
    public Component getListCellRendererComponent(JList<? extends T> list, T value, int index, boolean selected, boolean hasFocus) {
        Component component;
        this.clear();
        if (this.myComboBox != null) {
            this.setEnabled(this.myComboBox.isEnabled());
        }
        this.setFont(list.getFont());
        this.mySelected = selected;
        this.myForeground = this.isEnabled() ? list.getForeground() : UIManager.getColor("Label.disabledForeground");
        this.mySelectionForeground = list.getSelectionForeground();
        if (UIUtil.isWinLafOnVista()) {
            if (index == -1) {
                this.setOpaque(false);
                this.mySelected = false;
            } else {
                this.setOpaque(true);
                this.setBackground(selected ? list.getSelectionBackground() : null);
            }
        } else if (UIUtil.isUnderWin10LookAndFeel()) {
            this.setBackground(selected ? list.getSelectionBackground() : list.getBackground());
        } else {
            this.setBackground(selected ? list.getSelectionBackground() : null);
        }
        this.setPaintFocusBorder(hasFocus);
        this.customizeCellRenderer(list, value, index, selected, hasFocus);
        if (this.myDefaultGtkRenderer != null && list.getModel() instanceof ComboBoxModel && (component = this.myDefaultGtkRenderer.getListCellRendererComponent(list, value, index, selected, hasFocus)) instanceof JLabel) {
            return this.formatToLabel((JLabel)component);
        }
        return this;
    }

    @Override
    public final void append(@NotNull String fragment, @NotNull SimpleTextAttributes attributes, boolean isMainText) {
        if (fragment == null) {
            ColoredListCellRenderer.$$$reportNull$$$0(0);
        }
        if (attributes == null) {
            ColoredListCellRenderer.$$$reportNull$$$0(1);
        }
        if (this.mySelected) {
            super.append(fragment, new SimpleTextAttributes(attributes.getStyle(), this.mySelectionForeground), isMainText);
        } else if (attributes.getFgColor() == null) {
            super.append(fragment, attributes.derive(-1, this.myForeground, null, null), isMainText);
        } else {
            super.append(fragment, attributes, isMainText);
        }
    }

    @Override
    void revalidateAndRepaint() {
    }

    @Override
    @NotNull
    public Dimension getPreferredSize() {
        Font oldFont = this.getFont();
        if (oldFont == null) {
            this.setFont(UIUtil.getListFont());
        }
        Dimension result2 = super.getPreferredSize();
        if (oldFont == null) {
            this.setFont(null);
        }
        Dimension dimension = result2;
        if (dimension == null) {
            ColoredListCellRenderer.$$$reportNull$$$0(2);
        }
        return dimension;
    }

    protected abstract void customizeCellRenderer(@NotNull JList<? extends T> var1, T var2, int var3, boolean var4, boolean var5);

    @Override
    public boolean isOpaque() {
        Color back = this.getBackground();
        Container p = this.getParent();
        if (p != null) {
            p = p.getParent();
        }
        boolean colorMatch = back != null && p != null && back.equals(p.getBackground()) && p.isOpaque();
        return !colorMatch && super.isOpaque();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fragment";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attributes";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ui/ColoredListCellRenderer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ui/ColoredListCellRenderer";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getPreferredSize";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "append";
                break;
            }
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

