/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.lang.xpath.xslt.associations.impl;

import com.intellij.ide.projectView.ProjectViewNode;
import com.intellij.ide.projectView.impl.AbstractProjectTreeStructure;
import com.intellij.ide.projectView.impl.GroupByTypeComparator;
import com.intellij.ide.projectView.impl.ProjectAbstractTreeStructureBase;
import com.intellij.ide.projectView.impl.ProjectTreeBuilder;
import com.intellij.ide.projectView.impl.nodes.PsiFileNode;
import com.intellij.ide.util.PsiElementListCellRenderer;
import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.ide.util.treeView.NodeRenderer;
import com.intellij.ide.util.treeView.TreeState;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.psi.PsiFile;
import com.intellij.ui.AnActionButton;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.JBSplitter;
import com.intellij.ui.LayeredIcon;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.TreeSpeedSearch;
import com.intellij.ui.components.JBList;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.util.IconUtil;
import com.intellij.util.ui.UIUtil;
import icons.XpathIcons;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.swing.AbstractListModel;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.intellij.lang.xpath.xslt.XsltSupport;
import org.intellij.lang.xpath.xslt.associations.FileAssociationsManager;
import org.intellij.lang.xpath.xslt.associations.impl.AddAssociationAction;
import org.intellij.lang.xpath.xslt.associations.impl.FileAssociationsManagerImpl;
import org.intellij.lang.xpath.xslt.associations.impl.TransactionalManager;
import org.jetbrains.annotations.Nullable;

class AssociationsEditor {
    private JPanel myComponent;
    private JBList myList;
    private Tree myTree;
    private JBSplitter mySplitter;
    private final AssociationsModel myListModel;
    private final TransactionalManager myManager;
    private final ProjectTreeBuilder myBuilder;

    public AssociationsEditor(Project project, TreeState oldState) {
        this.myManager = ((FileAssociationsManagerImpl)FileAssociationsManager.getInstance(project)).getTempManager();
        this.initUI();
        DefaultTreeModel treeModel = new DefaultTreeModel(new DefaultMutableTreeNode());
        this.myTree.setModel((TreeModel)treeModel);
        this.myBuilder = new ProjectTreeBuilder(project, (JTree)this.myTree, treeModel, (Comparator)((Object)new MyGroupByTypeComparator()), (ProjectAbstractTreeStructureBase)new MyProjectStructure(project));
        this.myTree.setCellRenderer((TreeCellRenderer)((Object)new MyNodeRenderer(this.myManager)));
        new TreeSpeedSearch((JTree)this.myTree);
        SwingUtilities.invokeLater(() -> ApplicationManager.getApplication().invokeLater(() -> {
            if (oldState == null) {
                this.expandTree(treeModel);
            } else {
                oldState.applyTo((JTree)this.myTree);
            }
        }));
        this.myListModel = new AssociationsModel(this.myTree, this.myManager);
        this.myListModel.addListDataListener(new ListDataListener(){

            @Override
            public void intervalAdded(ListDataEvent listDataEvent) {
                AssociationsEditor.this.myTree.invalidate();
                AssociationsEditor.this.myTree.repaint();
            }

            @Override
            public void intervalRemoved(ListDataEvent listDataEvent) {
                AssociationsEditor.this.myTree.invalidate();
                AssociationsEditor.this.myTree.repaint();
            }

            @Override
            public void contentsChanged(ListDataEvent listDataEvent) {
            }
        });
        this.myList.setModel((ListModel)this.myListModel);
    }

    private void initUI() {
        this.myComponent = new JPanel(new BorderLayout());
        this.mySplitter = new JBSplitter("AssociationsEditor.dividerProportion", 0.3f);
        this.myComponent.add((Component)this.mySplitter, "Center");
        JPanel leftPanel = new JPanel(new BorderLayout());
        leftPanel.setBorder((Border)IdeBorderFactory.createTitledBorder((String)"Project XSLT Files", (boolean)false, (Insets)new Insets(0, 0, 0, 0)));
        this.myTree = new Tree();
        this.myTree.setRootVisible(false);
        this.myTree.setShowsRootHandles(false);
        leftPanel.add((Component)new JBScrollPane((Component)this.myTree), "Center");
        this.mySplitter.setFirstComponent((JComponent)leftPanel);
        this.myList = new JBList();
        this.myList.setCellRenderer((ListCellRenderer)((Object)new MyCellRenderer()));
        this.myList.setMinimumSize(new Dimension(120, 200));
        this.myList.getEmptyText().setText("No associated files");
        JPanel rightPanel = ToolbarDecorator.createDecorator((JList)this.myList).addExtraAction(AnActionButton.fromAction((AnAction)new AddAssociationActionWrapper())).addExtraAction(AnActionButton.fromAction((AnAction)new RemoveAssociationAction())).disableUpDownActions().disableAddAction().disableRemoveAction().createPanel();
        UIUtil.addBorder((JComponent)rightPanel, (Border)IdeBorderFactory.createTitledBorder((String)"Associated Files", (boolean)false, (Insets)new Insets(0, 0, 0, 0)));
        this.mySplitter.setSecondComponent((JComponent)rightPanel);
    }

    private void expandTree(DefaultTreeModel newModel) {
        TreePath rootPath = new TreePath(newModel.getRoot());
        Object element = this.myBuilder.getTreeStructure().getRootElement();
        this.myBuilder.batch(indicator -> {
            this.myBuilder.expand(element, null);
            this.myBuilder.expand(this.myBuilder.getTreeStructure().getChildElements(element), null);
        });
        this.myTree.setSelectionPath(rootPath);
        this.myTree.scrollRectToVisible(new Rectangle(new Point(0, 0)));
    }

    public TreeState getState() {
        return TreeState.createOn((JTree)this.myTree);
    }

    public JPanel getComponent() {
        return this.myComponent;
    }

    @Nullable
    static Object getTreeSelection(JTree tree) {
        TreePath[] selectionPath = tree.getSelectionPaths();
        if (selectionPath == null || selectionPath.length != 1) {
            return null;
        }
        Object component = selectionPath[0].getLastPathComponent();
        return AssociationsEditor.getObject(component);
    }

    @Nullable
    private static Object getObject(Object component) {
        if (!(component instanceof DefaultMutableTreeNode)) {
            return null;
        }
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)component;
        Object userObject = node.getUserObject();
        if (!(userObject instanceof ProjectViewNode)) {
            return null;
        }
        return ((ProjectViewNode)userObject).getValue();
    }

    public boolean isModified() {
        return this.myManager.isModified();
    }

    public void apply() {
        this.myManager.applyChanges();
    }

    public void reset() {
        this.myManager.reset();
        Object selection = AssociationsEditor.getTreeSelection((JTree)this.myTree);
        this.myListModel.update(selection instanceof PsiFile ? (PsiFile)selection : null);
    }

    public void dispose() {
        Disposer.dispose((Disposable)this.myBuilder);
        this.myManager.dispose();
    }

    public void select(PsiFile file) {
        this.myBuilder.getReady((Object)this).doWhenDone(() -> this.myBuilder.select((Object)file, file.getVirtualFile(), true));
    }

    private static class MyCellRenderer
    extends PsiElementListCellRenderer<PsiFile> {
        private MyCellRenderer() {
        }

        public String getElementText(PsiFile file) {
            return file.getName();
        }

        protected String getContainerText(PsiFile psiElement, String string) {
            return "(" + psiElement.getVirtualFile().getParent().getPresentableUrl() + ")";
        }

        protected int getIconFlags() {
            return 0;
        }
    }

    private static class MyNodeRenderer
    extends NodeRenderer {
        private final DefaultMutableTreeNode myTemp = new DefaultMutableTreeNode();
        private final FileAssociationsManager myManager;

        public MyNodeRenderer(FileAssociationsManager manager) {
            this.myManager = manager;
        }

        public void customizeCellRenderer(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            Object object = AssociationsEditor.getObject(value);
            if (object instanceof PsiFile) {
                PsiFile file = (PsiFile)object;
                Object userObject = ((DefaultMutableTreeNode)value).getUserObject();
                if (this.myManager.getAssociationsFor(file).length > 0) {
                    this.myTemp.setUserObject((Object)new MyNodeDescriptor((NodeDescriptor<PsiFileNode>)((NodeDescriptor)userObject)));
                    super.customizeCellRenderer(tree, (Object)this.myTemp, selected, expanded, leaf, row, hasFocus);
                    return;
                }
            }
            super.customizeCellRenderer(tree, value, selected, expanded, leaf, row, hasFocus);
        }

        private static class MyNodeDescriptor
        extends NodeDescriptor<PsiFileNode> {
            private final PsiFileNode myNode;

            public MyNodeDescriptor(NodeDescriptor<PsiFileNode> nodeDescriptor) {
                super(nodeDescriptor.getProject(), null);
                this.myName = nodeDescriptor.toString();
                this.setIcon(LayeredIcon.create((Icon)nodeDescriptor.getIcon(), (Icon)XpathIcons.Association_small));
                this.myColor = nodeDescriptor.getColor();
                this.myNode = (PsiFileNode)nodeDescriptor.getElement();
            }

            public boolean update() {
                return false;
            }

            public PsiFileNode getElement() {
                return this.myNode;
            }
        }
    }

    static class AssociationsModel
    extends AbstractListModel
    implements TreeSelectionListener {
        private final Tree myTree;
        private final FileAssociationsManager myManager;
        private PsiFile[] myFiles;

        public AssociationsModel(Tree tree, FileAssociationsManager manager) {
            this.myTree = tree;
            this.myManager = manager;
            this.myFiles = PsiFile.EMPTY_ARRAY;
            this.myTree.addTreeSelectionListener((TreeSelectionListener)this);
        }

        @Override
        public int getSize() {
            return this.myFiles.length;
        }

        @Override
        public Object getElementAt(int index) {
            return this.myFiles[index];
        }

        @Override
        public void valueChanged(TreeSelectionEvent e) {
            Object selection = AssociationsEditor.getTreeSelection((JTree)this.myTree);
            if (selection instanceof PsiFile) {
                this.update((PsiFile)selection);
            } else {
                this.update(null);
            }
        }

        public void update(@Nullable PsiFile selection) {
            int oldSize = this.myFiles.length;
            this.myFiles = PsiFile.EMPTY_ARRAY;
            if (this.myFiles.length != oldSize) {
                this.fireIntervalRemoved(this, 0, oldSize - 1);
            }
            if (selection != null) {
                this.myFiles = this.myManager.getAssociationsFor(selection);
                if (this.myFiles.length > 0) {
                    this.fireIntervalAdded(this, 0, this.myFiles.length - 1);
                }
            }
        }
    }

    private static class MyProjectStructure
    extends AbstractProjectTreeStructure {
        public MyProjectStructure(Project project) {
            super(project);
        }

        public List getProviders() {
            return Collections.EMPTY_LIST;
        }

        public Object[] getChildElements(Object obj) {
            Object[] childElements = super.getChildElements(obj);
            ArrayList<Object> l = new ArrayList<Object>(childElements.length);
            for (Object o : childElements) {
                if (!(o instanceof ProjectViewNode)) continue;
                ProjectViewNode node = (ProjectViewNode)o;
                Object element = node.getValue();
                if (element instanceof PsiFile) {
                    if (!XsltSupport.isXsltFile((PsiFile)element)) continue;
                    l.add(o);
                    continue;
                }
                l.add(o);
            }
            return l.size() != childElements.length ? l.toArray(new Object[l.size()]) : childElements;
        }

        public boolean isShowMembers() {
            return false;
        }

        public boolean isShowModules() {
            return true;
        }

        public boolean isFlattenPackages() {
            return true;
        }

        public boolean isAbbreviatePackageNames() {
            return false;
        }

        public boolean isHideEmptyMiddlePackages() {
            return true;
        }

        public boolean isShowLibraryContents() {
            return false;
        }
    }

    private static class MyGroupByTypeComparator
    extends GroupByTypeComparator {
        public MyGroupByTypeComparator() {
            super(true);
        }

        protected boolean isSortByType() {
            return false;
        }
    }

    class RemoveAssociationAction
    extends AnAction {
        public RemoveAssociationAction() {
            super("Remove", "Remove Association", IconUtil.getRemoveIcon());
        }

        public void actionPerformed(AnActionEvent e) {
            PsiFile selection = (PsiFile)AssociationsEditor.getTreeSelection((JTree)AssociationsEditor.this.myTree);
            PsiFile listSelection = (PsiFile)this.getListSelection();
            AssociationsEditor.this.myManager.removeAssociation(selection, listSelection);
            AssociationsEditor.this.myListModel.update(selection);
        }

        public void update(AnActionEvent e) {
            e.getPresentation().setEnabled(this.getListSelection() instanceof PsiFile);
        }

        private Object getListSelection() {
            return AssociationsEditor.this.myList.getSelectedValue();
        }
    }

    class AddAssociationActionWrapper
    extends AddAssociationAction {
        public AddAssociationActionWrapper() {
            super(AssociationsEditor.this.myManager);
        }

        @Override
        public void actionPerformed(AnActionEvent e) {
            PsiFile selection = (PsiFile)AssociationsEditor.getTreeSelection((JTree)AssociationsEditor.this.myTree);
            this.addAssociation(selection);
            AssociationsEditor.this.myListModel.update(selection);
        }

        public void update(AnActionEvent e) {
            e.getPresentation().setEnabled(AssociationsEditor.getTreeSelection((JTree)AssociationsEditor.this.myTree) instanceof PsiFile);
        }
    }
}

