/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.database;

import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.xmlb.annotations.MapAnnotation;
import com.intellij.util.xmlb.annotations.Tag;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.android.database.AndroidRemoteDbInfo;
import org.jetbrains.android.util.AndroidUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@com.intellij.openapi.components.State(name="AndroidRemoteDataBaseManager", storages={@Storage(value="androidRemoteDatabases.xml")})
public class AndroidRemoteDataBaseManager
implements PersistentStateComponent<State> {
    private State myState = new State();

    public static synchronized AndroidRemoteDataBaseManager getInstance() {
        return (AndroidRemoteDataBaseManager)ServiceManager.getService(AndroidRemoteDataBaseManager.class);
    }

    @NotNull
    public static String buildLocalDbFileOsPath(@Nullable String deviceId, @Nullable String packageName, @Nullable String databaseName, boolean external) {
        if (deviceId == null || packageName == null || databaseName == null || deviceId.length() == 0 || packageName.length() == 0 || databaseName.length() == 0) {
            if ("" == null) {
                AndroidRemoteDataBaseManager.$$$reportNull$$$0(0);
            }
            return "";
        }
        String string = AndroidUtils.getAndroidSystemDirectoryOsPath() + File.separator + "databases" + File.separator + deviceId + File.separator + packageName + File.separator + (external ? "external" : "internal") + File.separator + databaseName;
        if (string == null) {
            AndroidRemoteDataBaseManager.$$$reportNull$$$0(1);
        }
        return string;
    }

    public synchronized void processRemovedProjects() {
        ArrayList<MyDbKey> keysToRemove = new ArrayList<MyDbKey>();
        for (Map.Entry<MyDbKey, MyDatabaseInfo> entry : this.myState.databases.entrySet()) {
            MyDbKey key = entry.getKey();
            MyDatabaseInfo value = entry.getValue();
            Iterator<String> it = value.referringProjects.iterator();
            while (it.hasNext()) {
                String projectBasePath = it.next();
                if (new File(projectBasePath).exists()) continue;
                it.remove();
                keysToRemove.add(key);
            }
        }
        this.removeUnusedDatabases(keysToRemove);
    }

    public synchronized void updateDbUsagesForProject(@NotNull String projectBasePath, @NotNull Set<AndroidRemoteDbInfo> usedDatabases) {
        if (projectBasePath == null) {
            AndroidRemoteDataBaseManager.$$$reportNull$$$0(2);
        }
        if (usedDatabases == null) {
            AndroidRemoteDataBaseManager.$$$reportNull$$$0(3);
        }
        ArrayList<MyDbKey> keysToRemove = new ArrayList<MyDbKey>();
        for (Map.Entry<MyDbKey, MyDatabaseInfo> entry : this.myState.databases.entrySet()) {
            MyDbKey key = entry.getKey();
            MyDatabaseInfo value = entry.getValue();
            if (!value.referringProjects.contains(projectBasePath) || usedDatabases.contains(new AndroidRemoteDbInfo(key.deviceId, key.packageName, key.databaseName, key.external))) continue;
            value.referringProjects.remove(projectBasePath);
            keysToRemove.add(key);
        }
        this.removeUnusedDatabases(keysToRemove);
    }

    private synchronized void removeUnusedDatabases(@NotNull List<MyDbKey> keysToRemove) {
        if (keysToRemove == null) {
            AndroidRemoteDataBaseManager.$$$reportNull$$$0(4);
        }
        Map<MyDbKey, MyDatabaseInfo> dbMap = this.myState.databases;
        Iterator<MyDbKey> it = keysToRemove.iterator();
        while (it.hasNext()) {
            MyDbKey key = it.next();
            MyDatabaseInfo value = dbMap.get(key);
            if (!value.referringProjects.isEmpty()) continue;
            it.remove();
            String localDbPath = AndroidRemoteDataBaseManager.buildLocalDbFileOsPath(key.deviceId, key.packageName, key.databaseName, key.external);
            File localDbFile = new File(localDbPath);
            if (!localDbFile.exists()) continue;
            FileUtil.delete((File)localDbFile);
        }
    }

    @Nullable
    public synchronized MyDatabaseInfo getDatabaseInfo(@NotNull String deviceId, @NotNull String packageName, @NotNull String databaseName, boolean external) {
        if (deviceId == null) {
            AndroidRemoteDataBaseManager.$$$reportNull$$$0(5);
        }
        if (packageName == null) {
            AndroidRemoteDataBaseManager.$$$reportNull$$$0(6);
        }
        if (databaseName == null) {
            AndroidRemoteDataBaseManager.$$$reportNull$$$0(7);
        }
        return this.myState.databases.get(new MyDbKey(deviceId, packageName, databaseName, external));
    }

    public synchronized void setDatabaseInfo(@NotNull String deviceId, @NotNull String packageName, @NotNull String databaseName, @NotNull MyDatabaseInfo databaseInfo, boolean external) {
        if (deviceId == null) {
            AndroidRemoteDataBaseManager.$$$reportNull$$$0(8);
        }
        if (packageName == null) {
            AndroidRemoteDataBaseManager.$$$reportNull$$$0(9);
        }
        if (databaseName == null) {
            AndroidRemoteDataBaseManager.$$$reportNull$$$0(10);
        }
        if (databaseInfo == null) {
            AndroidRemoteDataBaseManager.$$$reportNull$$$0(11);
        }
        this.myState.databases.put(new MyDbKey(deviceId, packageName, databaseName, external), databaseInfo);
    }

    public synchronized State getState() {
        return this.myState;
    }

    public synchronized void loadState(@NotNull State state) {
        if (state == null) {
            AndroidRemoteDataBaseManager.$$$reportNull$$$0(12);
        }
        this.myState = state;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/android/database/AndroidRemoteDataBaseManager";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectBasePath";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usedDatabases";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "keysToRemove";
                break;
            }
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "deviceId";
                break;
            }
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packageName";
                break;
            }
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "databaseName";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "databaseInfo";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "buildLocalDbFileOsPath";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/android/database/AndroidRemoteDataBaseManager";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "updateDbUsagesForProject";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "removeUnusedDatabases";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getDatabaseInfo";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "setDatabaseInfo";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    @Tag(value="db-info")
    public static class MyDatabaseInfo {
        public long modificationTime = 0L;
        public Set<String> referringProjects = new HashSet<String>();
    }

    @Tag(value="db-key")
    public static class MyDbKey {
        public String deviceId;
        public String packageName;
        public String databaseName;
        public boolean external;

        public MyDbKey(@NotNull String deviceId, @NotNull String packageName, @NotNull String databaseName, boolean external) {
            if (deviceId == null) {
                MyDbKey.$$$reportNull$$$0(0);
            }
            if (packageName == null) {
                MyDbKey.$$$reportNull$$$0(1);
            }
            if (databaseName == null) {
                MyDbKey.$$$reportNull$$$0(2);
            }
            this.deviceId = "";
            this.packageName = "";
            this.databaseName = "";
            this.deviceId = deviceId;
            this.packageName = packageName;
            this.databaseName = databaseName;
            this.external = external;
        }

        public MyDbKey() {
            this.deviceId = "";
            this.packageName = "";
            this.databaseName = "";
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            MyDbKey key = (MyDbKey)o;
            if (this.external != key.external) {
                return false;
            }
            if (this.databaseName != null ? !this.databaseName.equals(key.databaseName) : key.databaseName != null) {
                return false;
            }
            if (this.deviceId != null ? !this.deviceId.equals(key.deviceId) : key.deviceId != null) {
                return false;
            }
            return !(this.packageName != null ? !this.packageName.equals(key.packageName) : key.packageName != null);
        }

        public int hashCode() {
            int result = this.deviceId != null ? this.deviceId.hashCode() : 0;
            result = 31 * result + (this.packageName != null ? this.packageName.hashCode() : 0);
            result = 31 * result + (this.databaseName != null ? this.databaseName.hashCode() : 0);
            result = 31 * result + (this.external ? 1 : 0);
            return result;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "deviceId";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "packageName";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "databaseName";
                    break;
                }
            }
            objectArray[1] = "org/jetbrains/android/database/AndroidRemoteDataBaseManager$MyDbKey";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class State {
        @Tag(value="databases")
        @MapAnnotation(surroundWithTag=false)
        public Map<MyDbKey, MyDatabaseInfo> databases = new HashMap<MyDbKey, MyDatabaseInfo>();
    }
}

