/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.client.api;

import com.android.tools.lint.client.api.LintClient;
import com.android.tools.lint.client.api.LintDriver;
import com.android.tools.lint.client.api.ResourceReference;
import com.android.tools.lint.client.api.UElementHandler;
import com.android.tools.lint.client.api.UastParser;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.JavaContext;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.uast.UAnnotation;
import org.jetbrains.uast.UArrayAccessExpression;
import org.jetbrains.uast.UBinaryExpression;
import org.jetbrains.uast.UBinaryExpressionWithType;
import org.jetbrains.uast.UBlockExpression;
import org.jetbrains.uast.UBreakExpression;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UCallableReferenceExpression;
import org.jetbrains.uast.UCatchClause;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.UClassInitializer;
import org.jetbrains.uast.UClassLiteralExpression;
import org.jetbrains.uast.UContinueExpression;
import org.jetbrains.uast.UDeclarationsExpression;
import org.jetbrains.uast.UDoWhileExpression;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UEnumConstant;
import org.jetbrains.uast.UExpressionList;
import org.jetbrains.uast.UField;
import org.jetbrains.uast.UFile;
import org.jetbrains.uast.UForEachExpression;
import org.jetbrains.uast.UForExpression;
import org.jetbrains.uast.UIfExpression;
import org.jetbrains.uast.UImportStatement;
import org.jetbrains.uast.ULabeledExpression;
import org.jetbrains.uast.ULambdaExpression;
import org.jetbrains.uast.ULiteralExpression;
import org.jetbrains.uast.ULocalVariable;
import org.jetbrains.uast.UMethod;
import org.jetbrains.uast.UObjectLiteralExpression;
import org.jetbrains.uast.UParameter;
import org.jetbrains.uast.UParenthesizedExpression;
import org.jetbrains.uast.UPolyadicExpression;
import org.jetbrains.uast.UPostfixExpression;
import org.jetbrains.uast.UPrefixExpression;
import org.jetbrains.uast.UQualifiedReferenceExpression;
import org.jetbrains.uast.UReferenceExpression;
import org.jetbrains.uast.UReturnExpression;
import org.jetbrains.uast.USimpleNameReferenceExpression;
import org.jetbrains.uast.USuperExpression;
import org.jetbrains.uast.USwitchClauseExpression;
import org.jetbrains.uast.USwitchExpression;
import org.jetbrains.uast.UThisExpression;
import org.jetbrains.uast.UThrowExpression;
import org.jetbrains.uast.UTryExpression;
import org.jetbrains.uast.UTypeReferenceExpression;
import org.jetbrains.uast.UUnaryExpression;
import org.jetbrains.uast.UVariable;
import org.jetbrains.uast.UWhileExpression;
import org.jetbrains.uast.util.UastExpressionUtils;
import org.jetbrains.uast.visitor.AbstractUastVisitor;
import org.jetbrains.uast.visitor.UastVisitor;

public class UElementVisitor {
    private static final int SAME_TYPE_COUNT = 8;
    private final Map<String, List<VisitingDetector>> methodDetectors = Maps.newHashMapWithExpectedSize((int)90);
    private final Map<String, List<VisitingDetector>> constructorDetectors = Maps.newHashMapWithExpectedSize((int)12);
    private final Map<String, List<VisitingDetector>> referenceDetectors = Maps.newHashMapWithExpectedSize((int)10);
    private final List<VisitingDetector> resourceFieldDetectors = new ArrayList<VisitingDetector>();
    private final List<VisitingDetector> allDetectors;
    private final Map<Class<? extends UElement>, List<VisitingDetector>> nodePsiTypeDetectors = Maps.newHashMapWithExpectedSize((int)25);
    private final UastParser parser;
    private final Map<String, List<VisitingDetector>> superClassDetectors = new HashMap<String, List<VisitingDetector>>();

    UElementVisitor(UastParser parser, List<Detector> detectors) {
        this.parser = parser;
        this.allDetectors = new ArrayList<VisitingDetector>(detectors.size());
        for (Detector detector : detectors) {
            List<String> list;
            List<String> types;
            List<Class<? extends UElement>> list2;
            List<String> applicableSuperClasses;
            Detector.UastScanner uastScanner = (Detector.UastScanner)((Object)detector);
            VisitingDetector v = new VisitingDetector(detector, uastScanner);
            this.allDetectors.add(v);
            List<String> names = detector.getApplicableMethodNames();
            if (names != null) {
                assert (names != Detector.XmlScanner.ALL);
                for (String string : names) {
                    List list3 = this.methodDetectors.computeIfAbsent(string, k -> new ArrayList(8));
                    list3.add(v);
                }
            }
            if ((applicableSuperClasses = detector.applicableSuperClasses()) != null) {
                for (Object fqn : applicableSuperClasses) {
                    List list4 = this.superClassDetectors.computeIfAbsent((String)fqn, k -> new ArrayList(8));
                    list4.add(v);
                }
            }
            if ((list2 = detector.getApplicableUastTypes()) != null) {
                Object fqn;
                fqn = list2.iterator();
                while (fqn.hasNext()) {
                    Class clazz = (Class)fqn.next();
                    List list5 = this.nodePsiTypeDetectors.computeIfAbsent(clazz, k -> new ArrayList(8));
                    list5.add(v);
                }
            }
            if ((types = detector.getApplicableConstructorTypes()) != null) {
                assert (types != Detector.XmlScanner.ALL);
                for (String type2 : types) {
                    List<VisitingDetector> list6 = this.constructorDetectors.get(type2);
                    if (list6 == null) {
                        list6 = new ArrayList<VisitingDetector>(8);
                        this.constructorDetectors.put(type2, list6);
                    }
                    list6.add(v);
                }
            }
            if ((list = detector.getApplicableReferenceNames()) != null) {
                assert (list != Detector.XmlScanner.ALL);
                for (String name : list) {
                    List list7 = this.referenceDetectors.computeIfAbsent(name, k -> new ArrayList(8));
                    list7.add(v);
                }
            }
            if (!detector.appliesToResourceRefs()) continue;
            this.resourceFieldDetectors.add(v);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void visitFile(JavaContext context) {
        try {
            UastParser uastParser = context.getUastParser();
            if (uastParser == null) {
                return;
            }
            UFile uFile = uastParser.parse(context);
            if (uFile == null) {
                return;
            }
            LintClient client = context.getClient();
            try {
                context.setJavaFile(uFile.getPsi());
                context.setUastFile(uFile);
                client.runReadAction(() -> {
                    for (VisitingDetector v : this.allDetectors) {
                        v.setContext(context);
                        v.getDetector().beforeCheckFile(context);
                    }
                });
                if (!this.superClassDetectors.isEmpty()) {
                    client.runReadAction(() -> {
                        SuperclassPsiVisitor visitor = new SuperclassPsiVisitor(context);
                        uFile.accept((UastVisitor)visitor);
                    });
                }
                if (!(this.methodDetectors.isEmpty() && this.resourceFieldDetectors.isEmpty() && this.constructorDetectors.isEmpty() && this.referenceDetectors.isEmpty())) {
                    client.runReadAction(() -> {
                        DelegatingPsiVisitor visitor = new DelegatingPsiVisitor(context);
                        uFile.accept((UastVisitor)visitor);
                    });
                } else if (!this.nodePsiTypeDetectors.isEmpty()) {
                    client.runReadAction(() -> {
                        DispatchPsiVisitor visitor = new DispatchPsiVisitor();
                        uFile.accept((UastVisitor)visitor);
                    });
                }
                client.runReadAction(() -> {
                    for (VisitingDetector v : this.allDetectors) {
                        ProgressManager.checkCanceled();
                        v.getDetector().afterCheckFile(context);
                    }
                });
            }
            finally {
                this.parser.dispose(context, uFile);
                context.setJavaFile(null);
                context.setUastFile(null);
            }
        }
        catch (ProcessCanceledException uastParser) {
        }
        catch (RuntimeException e) {
            LintDriver.handleDetectorError(context, context.getDriver(), e);
        }
    }

    public boolean prepare(List<JavaContext> contexts) {
        return this.parser.prepare(contexts);
    }

    public void dispose() {
        this.parser.dispose();
    }

    private static Set<String> getInterfaceNames(Set<String> addTo, PsiClass cls) {
        for (PsiClass resolvedInterface : cls.getInterfaces()) {
            String name = resolvedInterface.getQualifiedName();
            if (addTo == null) {
                addTo = Sets.newHashSet();
            } else if (addTo.contains(name)) continue;
            addTo.add(name);
            UElementVisitor.getInterfaceNames(addTo, resolvedInterface);
        }
        return addTo;
    }

    private class DelegatingPsiVisitor
    extends DispatchPsiVisitor {
        private final JavaContext mContext;
        private final boolean mVisitResources;
        private final boolean mVisitMethods;
        private final boolean mVisitConstructors;
        private final boolean mVisitReferences;

        DelegatingPsiVisitor(JavaContext context) {
            this.mContext = context;
            this.mVisitMethods = !UElementVisitor.this.methodDetectors.isEmpty();
            this.mVisitConstructors = !UElementVisitor.this.constructorDetectors.isEmpty();
            this.mVisitResources = !UElementVisitor.this.resourceFieldDetectors.isEmpty();
            this.mVisitReferences = !UElementVisitor.this.referenceDetectors.isEmpty();
        }

        @Override
        public boolean visitSimpleNameReferenceExpression(USimpleNameReferenceExpression node) {
            ResourceReference reference;
            PsiElement referenced;
            List list;
            if (this.mVisitReferences || this.mVisitResources) {
                ProgressManager.checkCanceled();
            }
            if (this.mVisitReferences && (list = (List)UElementVisitor.this.referenceDetectors.get(node.getIdentifier())) != null && (referenced = node.resolve()) != null) {
                for (VisitingDetector v : list) {
                    Detector.UastScanner uastScanner = v.getUastScanner();
                    if (uastScanner == null) continue;
                    uastScanner.visitReference(this.mContext, (UReferenceExpression)node, referenced);
                }
            }
            if (this.mVisitResources && (reference = ResourceReference.get((UElement)node)) != null) {
                for (VisitingDetector v : UElementVisitor.this.resourceFieldDetectors) {
                    Detector.UastScanner uastScanner = v.getUastScanner();
                    if (uastScanner == null) continue;
                    uastScanner.visitResourceReference(this.mContext, (UElement)reference.node, reference.getType(), reference.getName(), reference.getPackage().equals("android"));
                }
            }
            return super.visitSimpleNameReferenceExpression(node);
        }

        @Override
        public boolean visitCallExpression(UCallExpression node) {
            boolean result = super.visitCallExpression(node);
            ProgressManager.checkCanceled();
            if (UastExpressionUtils.isMethodCall((UElement)node)) {
                this.visitMethodCallExpression(node);
            } else if (UastExpressionUtils.isConstructorCall((UElement)node)) {
                this.visitNewExpression(node);
            }
            return result;
        }

        private void visitMethodCallExpression(UCallExpression node) {
            PsiMethod function;
            List list;
            String methodName;
            if (this.mVisitMethods && (methodName = node.getMethodName()) != null && (list = (List)UElementVisitor.this.methodDetectors.get(methodName)) != null && (function = node.resolve()) != null) {
                for (VisitingDetector v : list) {
                    Detector.UastScanner scanner = v.getUastScanner();
                    if (scanner == null) continue;
                    scanner.visitMethod(this.mContext, node, function);
                }
            }
        }

        private void visitNewExpression(UCallExpression node) {
            if (this.mVisitConstructors) {
                List list;
                PsiMethod method = node.resolve();
                if (method == null) {
                    return;
                }
                PsiClass resolvedClass = method.getContainingClass();
                if (resolvedClass != null && (list = (List)UElementVisitor.this.constructorDetectors.get(resolvedClass.getQualifiedName())) != null) {
                    for (VisitingDetector v : list) {
                        Detector.UastScanner javaPsiScanner = v.getUastScanner();
                        if (javaPsiScanner == null) continue;
                        javaPsiScanner.visitConstructor(this.mContext, node, method);
                    }
                }
            }
        }
    }

    private class DispatchPsiVisitor
    extends AbstractUastVisitor {
        private DispatchPsiVisitor() {
        }

        public boolean visitAnnotation(UAnnotation node) {
            List list = (List)UElementVisitor.this.nodePsiTypeDetectors.get(UAnnotation.class);
            if (list != null) {
                for (VisitingDetector v : list) {
                    v.getVisitor().visitAnnotation(node);
                }
            }
            return super.visitAnnotation(node);
        }

        public boolean visitArrayAccessExpression(UArrayAccessExpression node) {
            List list = (List)UElementVisitor.this.nodePsiTypeDetectors.get(UArrayAccessExpression.class);
            if (list != null) {
                for (VisitingDetector v : list) {
                    v.getVisitor().visitArrayAccessExpression(node);
                }
            }
            return super.visitArrayAccessExpression(node);
        }

        public boolean visitBinaryExpression(UBinaryExpression node) {
            List list = (List)UElementVisitor.this.nodePsiTypeDetectors.get(UBinaryExpression.class);
            if (list != null) {
                for (VisitingDetector v : list) {
                    v.getVisitor().visitBinaryExpression(node);
                }
            }
            return super.visitBinaryExpression(node);
        }

        public boolean visitBinaryExpressionWithType(UBinaryExpressionWithType node) {
            List list = (List)UElementVisitor.this.nodePsiTypeDetectors.get(UBinaryExpressionWithType.class);
            if (list != null) {
                for (VisitingDetector v : list) {
                    v.getVisitor().visitBinaryExpressionWithType(node);
                }
            }
            return super.visitBinaryExpressionWithType(node);
        }

        public boolean visitBlockExpression(UBlockExpression node) {
            List list = (List)UElementVisitor.this.nodePsiTypeDetectors.get(UBlockExpression.class);
            if (list != null) {
                for (VisitingDetector v : list) {
                    v.getVisitor().visitBlockExpression(node);
                }
            }
            return super.visitBlockExpression(node);
        }

        public boolean visitBreakExpression(UBreakExpression node) {
            List list = (List)UElementVisitor.this.nodePsiTypeDetectors.get(UBreakExpression.class);
            if (list != null) {
                for (VisitingDetector v : list) {
                    v.getVisitor().visitBreakExpression(node);
                }
            }
            return super.visitBreakExpression(node);
        }

        public boolean visitCallExpression(UCallExpression node) {
            List list = (List)UElementVisitor.this.nodePsiTypeDetectors.get(UCallExpression.class);
            if (list != null) {
                for (VisitingDetector v : list) {
                    v.getVisitor().visitCallExpression(node);
                }
            }
            return super.visitCallExpression(node);
        }

        public boolean visitCallableReferenceExpression(UCallableReferenceExpression node) {
            List list = (List)UElementVisitor.this.nodePsiTypeDetectors.get(UCallableReferenceExpression.class);
            if (list != null) {
                for (VisitingDetector v : list) {
                    v.getVisitor().visitCallableReferenceExpression(node);
                }
            }
            return super.visitCallableReferenceExpression(node);
        }

        public boolean visitCatchClause(UCatchClause node) {
            List list = (List)UElementVisitor.this.nodePsiTypeDetectors.get(UCatchClause.class);
            if (list != null) {
                for (VisitingDetector v : list) {
                    v.getVisitor().visitCatchClause(node);
                }
            }
            return super.visitCatchClause(node);
        }

        public boolean visitClass(UClass node) {
            List list = (List)UElementVisitor.this.nodePsiTypeDetectors.get(UClass.class);
            if (list != null) {
                for (VisitingDetector v : list) {
                    v.getVisitor().visitClass(node);
                }
            }
            return super.visitClass(node);
        }

        public boolean visitClassLiteralExpression(UClassLiteralExpression node) {
            List list = (List)UElementVisitor.this.nodePsiTypeDetectors.get(UClassLiteralExpression.class);
            if (list != null) {
                for (VisitingDetector v : list) {
                    v.getVisitor().visitClassLiteralExpression(node);
                }
            }
            return super.visitClassLiteralExpression(node);
        }

        public boolean visitContinueExpression(UContinueExpression node) {
            List list = (List)UElementVisitor.this.nodePsiTypeDetectors.get(UContinueExpression.class);
            if (list != null) {
                for (VisitingDetector v : list) {
                    v.getVisitor().visitContinueExpression(node);
                }
            }
            return super.visitContinueExpression(node);
        }

        public boolean visitDeclarationsExpression(UDeclarationsExpression node) {
            List list = (List)UElementVisitor.this.nodePsiTypeDetectors.get(UDeclarationsExpression.class);
            if (list != null) {
                for (VisitingDetector v : list) {
                    v.getVisitor().visitDeclarationsExpression(node);
                }
            }
            return super.visitDeclarationsExpression(node);
        }

        public boolean visitDoWhileExpression(UDoWhileExpression node) {
            List list = (List)UElementVisitor.this.nodePsiTypeDetectors.get(UDoWhileExpression.class);
            if (list != null) {
                for (VisitingDetector v : list) {
                    v.getVisitor().visitDoWhileExpression(node);
                }
            }
            return super.visitDoWhileExpression(node);
        }

        public boolean visitElement(UElement node) {
            List list = (List)UElementVisitor.this.nodePsiTypeDetectors.get(UElement.class);
            if (list != null) {
                for (VisitingDetector v : list) {
                    v.getVisitor().visitElement(node);
                }
            }
            return super.visitElement(node);
        }

        public boolean visitEnumConstant(UEnumConstant node) {
            List list = (List)UElementVisitor.this.nodePsiTypeDetectors.get(UEnumConstant.class);
            if (list != null) {
                for (VisitingDetector v : list) {
                    v.getVisitor().visitEnumConstant(node);
                }
            }
            return super.visitEnumConstant(node);
        }

        public boolean visitExpressionList(UExpressionList node) {
            List list = (List)UElementVisitor.this.nodePsiTypeDetectors.get(UExpressionList.class);
            if (list != null) {
                for (VisitingDetector v : list) {
                    v.getVisitor().visitExpressionList(node);
                }
            }
            return super.visitExpressionList(node);
        }

        public boolean visitField(UField node) {
            List list = (List)UElementVisitor.this.nodePsiTypeDetectors.get(UField.class);
            if (list != null) {
                for (VisitingDetector v : list) {
                    v.getVisitor().visitField(node);
                }
            }
            return super.visitField(node);
        }

        public boolean visitFile(UFile node) {
            List list = (List)UElementVisitor.this.nodePsiTypeDetectors.get(UFile.class);
            if (list != null) {
                for (VisitingDetector v : list) {
                    v.getVisitor().visitFile(node);
                }
            }
            return super.visitFile(node);
        }

        public boolean visitForEachExpression(UForEachExpression node) {
            List list = (List)UElementVisitor.this.nodePsiTypeDetectors.get(UForEachExpression.class);
            if (list != null) {
                for (VisitingDetector v : list) {
                    v.getVisitor().visitForEachExpression(node);
                }
            }
            return super.visitForEachExpression(node);
        }

        public boolean visitForExpression(UForExpression node) {
            List list = (List)UElementVisitor.this.nodePsiTypeDetectors.get(UForExpression.class);
            if (list != null) {
                for (VisitingDetector v : list) {
                    v.getVisitor().visitForExpression(node);
                }
            }
            return super.visitForExpression(node);
        }

        public boolean visitIfExpression(UIfExpression node) {
            List list = (List)UElementVisitor.this.nodePsiTypeDetectors.get(UIfExpression.class);
            if (list != null) {
                for (VisitingDetector v : list) {
                    v.getVisitor().visitIfExpression(node);
                }
            }
            return super.visitIfExpression(node);
        }

        public boolean visitImportStatement(UImportStatement node) {
            List list = (List)UElementVisitor.this.nodePsiTypeDetectors.get(UImportStatement.class);
            if (list != null) {
                for (VisitingDetector v : list) {
                    v.getVisitor().visitImportStatement(node);
                }
            }
            return super.visitImportStatement(node);
        }

        public boolean visitInitializer(UClassInitializer node) {
            List list = (List)UElementVisitor.this.nodePsiTypeDetectors.get(UClassInitializer.class);
            if (list != null) {
                for (VisitingDetector v : list) {
                    v.getVisitor().visitInitializer(node);
                }
            }
            return super.visitInitializer(node);
        }

        public boolean visitLabeledExpression(ULabeledExpression node) {
            List list = (List)UElementVisitor.this.nodePsiTypeDetectors.get(ULabeledExpression.class);
            if (list != null) {
                for (VisitingDetector v : list) {
                    v.getVisitor().visitLabeledExpression(node);
                }
            }
            return super.visitLabeledExpression(node);
        }

        public boolean visitLambdaExpression(ULambdaExpression node) {
            List list = (List)UElementVisitor.this.nodePsiTypeDetectors.get(ULambdaExpression.class);
            if (list != null) {
                for (VisitingDetector v : list) {
                    v.getVisitor().visitLambdaExpression(node);
                }
            }
            return super.visitLambdaExpression(node);
        }

        public boolean visitLiteralExpression(ULiteralExpression node) {
            List list = (List)UElementVisitor.this.nodePsiTypeDetectors.get(ULiteralExpression.class);
            if (list != null) {
                for (VisitingDetector v : list) {
                    v.getVisitor().visitLiteralExpression(node);
                }
            }
            return super.visitLiteralExpression(node);
        }

        public boolean visitLocalVariable(ULocalVariable node) {
            List list = (List)UElementVisitor.this.nodePsiTypeDetectors.get(ULocalVariable.class);
            if (list != null) {
                for (VisitingDetector v : list) {
                    v.getVisitor().visitLocalVariable(node);
                }
            }
            return super.visitLocalVariable(node);
        }

        public boolean visitMethod(UMethod node) {
            List list = (List)UElementVisitor.this.nodePsiTypeDetectors.get(UMethod.class);
            if (list != null) {
                for (VisitingDetector v : list) {
                    v.getVisitor().visitMethod(node);
                }
            }
            return super.visitMethod(node);
        }

        public boolean visitObjectLiteralExpression(UObjectLiteralExpression node) {
            List list = (List)UElementVisitor.this.nodePsiTypeDetectors.get(UObjectLiteralExpression.class);
            if (list != null) {
                for (VisitingDetector v : list) {
                    v.getVisitor().visitObjectLiteralExpression(node);
                }
            }
            return super.visitObjectLiteralExpression(node);
        }

        public boolean visitParameter(UParameter node) {
            List list = (List)UElementVisitor.this.nodePsiTypeDetectors.get(UParameter.class);
            if (list != null) {
                for (VisitingDetector v : list) {
                    v.getVisitor().visitParameter(node);
                }
            }
            return super.visitParameter(node);
        }

        public boolean visitParenthesizedExpression(UParenthesizedExpression node) {
            List list = (List)UElementVisitor.this.nodePsiTypeDetectors.get(UParenthesizedExpression.class);
            if (list != null) {
                for (VisitingDetector v : list) {
                    v.getVisitor().visitParenthesizedExpression(node);
                }
            }
            return super.visitParenthesizedExpression(node);
        }

        public boolean visitPolyadicExpression(UPolyadicExpression node) {
            List list = (List)UElementVisitor.this.nodePsiTypeDetectors.get(UPolyadicExpression.class);
            if (list != null) {
                for (VisitingDetector v : list) {
                    v.getVisitor().visitPolyadicExpression(node);
                }
            }
            return super.visitPolyadicExpression(node);
        }

        public boolean visitPostfixExpression(UPostfixExpression node) {
            List list = (List)UElementVisitor.this.nodePsiTypeDetectors.get(UPostfixExpression.class);
            if (list != null) {
                for (VisitingDetector v : list) {
                    v.getVisitor().visitPostfixExpression(node);
                }
            }
            return super.visitPostfixExpression(node);
        }

        public boolean visitPrefixExpression(UPrefixExpression node) {
            List list = (List)UElementVisitor.this.nodePsiTypeDetectors.get(UPrefixExpression.class);
            if (list != null) {
                for (VisitingDetector v : list) {
                    v.getVisitor().visitPrefixExpression(node);
                }
            }
            return super.visitPrefixExpression(node);
        }

        public boolean visitQualifiedReferenceExpression(UQualifiedReferenceExpression node) {
            List list = (List)UElementVisitor.this.nodePsiTypeDetectors.get(UQualifiedReferenceExpression.class);
            if (list != null) {
                for (VisitingDetector v : list) {
                    v.getVisitor().visitQualifiedReferenceExpression(node);
                }
            }
            return super.visitQualifiedReferenceExpression(node);
        }

        public boolean visitReturnExpression(UReturnExpression node) {
            List list = (List)UElementVisitor.this.nodePsiTypeDetectors.get(UReturnExpression.class);
            if (list != null) {
                for (VisitingDetector v : list) {
                    v.getVisitor().visitReturnExpression(node);
                }
            }
            return super.visitReturnExpression(node);
        }

        public boolean visitSimpleNameReferenceExpression(USimpleNameReferenceExpression node) {
            List list = (List)UElementVisitor.this.nodePsiTypeDetectors.get(USimpleNameReferenceExpression.class);
            if (list != null) {
                for (VisitingDetector v : list) {
                    v.getVisitor().visitSimpleNameReferenceExpression(node);
                }
            }
            return super.visitSimpleNameReferenceExpression(node);
        }

        public boolean visitSuperExpression(USuperExpression node) {
            List list = (List)UElementVisitor.this.nodePsiTypeDetectors.get(USuperExpression.class);
            if (list != null) {
                for (VisitingDetector v : list) {
                    v.getVisitor().visitSuperExpression(node);
                }
            }
            return super.visitSuperExpression(node);
        }

        public boolean visitSwitchClauseExpression(USwitchClauseExpression node) {
            List list = (List)UElementVisitor.this.nodePsiTypeDetectors.get(USwitchClauseExpression.class);
            if (list != null) {
                for (VisitingDetector v : list) {
                    v.getVisitor().visitSwitchClauseExpression(node);
                }
            }
            return super.visitSwitchClauseExpression(node);
        }

        public boolean visitSwitchExpression(USwitchExpression node) {
            List list = (List)UElementVisitor.this.nodePsiTypeDetectors.get(USwitchExpression.class);
            if (list != null) {
                for (VisitingDetector v : list) {
                    v.getVisitor().visitSwitchExpression(node);
                }
            }
            return super.visitSwitchExpression(node);
        }

        public boolean visitThisExpression(UThisExpression node) {
            List list = (List)UElementVisitor.this.nodePsiTypeDetectors.get(UThisExpression.class);
            if (list != null) {
                for (VisitingDetector v : list) {
                    v.getVisitor().visitThisExpression(node);
                }
            }
            return super.visitThisExpression(node);
        }

        public boolean visitThrowExpression(UThrowExpression node) {
            List list = (List)UElementVisitor.this.nodePsiTypeDetectors.get(UThrowExpression.class);
            if (list != null) {
                for (VisitingDetector v : list) {
                    v.getVisitor().visitThrowExpression(node);
                }
            }
            return super.visitThrowExpression(node);
        }

        public boolean visitTryExpression(UTryExpression node) {
            List list = (List)UElementVisitor.this.nodePsiTypeDetectors.get(UTryExpression.class);
            if (list != null) {
                for (VisitingDetector v : list) {
                    v.getVisitor().visitTryExpression(node);
                }
            }
            return super.visitTryExpression(node);
        }

        public boolean visitTypeReferenceExpression(UTypeReferenceExpression node) {
            List list = (List)UElementVisitor.this.nodePsiTypeDetectors.get(UTypeReferenceExpression.class);
            if (list != null) {
                for (VisitingDetector v : list) {
                    v.getVisitor().visitTypeReferenceExpression(node);
                }
            }
            return super.visitTypeReferenceExpression(node);
        }

        public boolean visitUnaryExpression(UUnaryExpression node) {
            List list = (List)UElementVisitor.this.nodePsiTypeDetectors.get(UUnaryExpression.class);
            if (list != null) {
                for (VisitingDetector v : list) {
                    v.getVisitor().visitUnaryExpression(node);
                }
            }
            return super.visitUnaryExpression(node);
        }

        public boolean visitVariable(UVariable node) {
            List list = (List)UElementVisitor.this.nodePsiTypeDetectors.get(UVariable.class);
            if (list != null) {
                for (VisitingDetector v : list) {
                    v.getVisitor().visitVariable(node);
                }
            }
            return super.visitVariable(node);
        }

        public boolean visitWhileExpression(UWhileExpression node) {
            List list = (List)UElementVisitor.this.nodePsiTypeDetectors.get(UWhileExpression.class);
            if (list != null) {
                for (VisitingDetector v : list) {
                    v.getVisitor().visitWhileExpression(node);
                }
            }
            return super.visitWhileExpression(node);
        }
    }

    private class SuperclassPsiVisitor
    extends AbstractUastVisitor {
        private final JavaContext context;

        public SuperclassPsiVisitor(JavaContext context) {
            this.context = context;
        }

        public boolean visitLambdaExpression(ULambdaExpression node) {
            PsiClass resolved;
            PsiType type;
            PsiElement psi = node.getPsi();
            if (psi instanceof PsiLambdaExpression && (type = ((PsiLambdaExpression)psi).getFunctionalInterfaceType()) instanceof PsiClassType && (resolved = ((PsiClassType)type).resolve()) != null) {
                this.checkClass(node, null, resolved);
            }
            return super.visitLambdaExpression(node);
        }

        public boolean visitClass(UClass node) {
            boolean result = super.visitClass(node);
            this.checkClass(null, node, (PsiClass)node);
            return result;
        }

        private void checkClass(ULambdaExpression lambda, UClass uClass, PsiClass node) {
            ProgressManager.checkCanceled();
            if (node instanceof PsiTypeParameter) {
                return;
            }
            int depth = 0;
            for (PsiClass cls = node; cls != null; cls = cls.getSuperClass()) {
                Set interfaceNames;
                List list = (List)UElementVisitor.this.superClassDetectors.get(cls.getQualifiedName());
                if (list != null) {
                    for (VisitingDetector v : list) {
                        Detector.UastScanner uastScanner = v.getUastScanner();
                        if (uastScanner == null) continue;
                        if (uClass != null) {
                            uastScanner.visitClass(this.context, uClass);
                            continue;
                        }
                        assert (lambda != null);
                        uastScanner.visitClass(this.context, lambda);
                    }
                }
                if ((interfaceNames = UElementVisitor.getInterfaceNames(null, cls)) == null) continue;
                for (String name : interfaceNames) {
                    list = (List)UElementVisitor.this.superClassDetectors.get(name);
                    if (list == null) continue;
                    for (VisitingDetector v : list) {
                        Detector.UastScanner uastScanner = v.getUastScanner();
                        if (uastScanner == null) continue;
                        if (uClass != null) {
                            uastScanner.visitClass(this.context, uClass);
                            continue;
                        }
                        assert (lambda != null);
                        uastScanner.visitClass(this.context, lambda);
                    }
                }
                if (++depth != 500) continue;
                break;
            }
        }
    }

    private static class VisitingDetector {
        private UElementHandler mVisitor;
        private JavaContext mContext;
        public final Detector mDetector;
        public final Detector.UastScanner mUastScanner;

        public VisitingDetector(Detector detector, Detector.UastScanner uastScanner) {
            this.mDetector = detector;
            this.mUastScanner = uastScanner;
        }

        public Detector getDetector() {
            return this.mDetector;
        }

        public Detector.UastScanner getUastScanner() {
            return this.mUastScanner;
        }

        public void setContext(JavaContext context) {
            this.mContext = context;
            this.mVisitor = null;
        }

        UElementHandler getVisitor() {
            if (this.mVisitor == null) {
                this.mVisitor = this.mDetector.createUastHandler(this.mContext);
                if (this.mVisitor == null) {
                    this.mVisitor = UElementHandler.NONE;
                }
            }
            return this.mVisitor;
        }
    }
}

