/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.dom.intentions;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.intention.LowPriorityAction;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomUtil;
import java.util.List;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.dom.MavenDomBundle;
import org.jetbrains.idea.maven.dom.MavenDomUtil;
import org.jetbrains.idea.maven.dom.model.MavenDomDependency;
import org.jetbrains.idea.maven.dom.model.MavenDomProjectModel;
import org.jetbrains.idea.maven.indices.MavenArtifactSearchDialog;
import org.jetbrains.idea.maven.model.MavenId;
import org.jetbrains.idea.maven.project.MavenProject;

public class AddMavenDependencyQuickFix
implements IntentionAction,
LowPriorityAction {
    private static final Pattern CLASSNAME_PATTERN = Pattern.compile("(\\p{javaJavaIdentifierStart}\\p{javaJavaIdentifierPart}*\\.)*\\p{Lu}\\p{javaJavaIdentifierPart}+");
    private final PsiJavaCodeReferenceElement myRef;

    public AddMavenDependencyQuickFix(PsiJavaCodeReferenceElement ref) {
        this.myRef = ref;
    }

    @NotNull
    public String getText() {
        if ("Add Maven Dependency..." == null) {
            AddMavenDependencyQuickFix.$$$reportNull$$$0(0);
        }
        return "Add Maven Dependency...";
    }

    @NotNull
    public String getFamilyName() {
        String string = MavenDomBundle.message("inspection.group", new Object[0]);
        if (string == null) {
            AddMavenDependencyQuickFix.$$$reportNull$$$0(1);
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        if (project == null) {
            AddMavenDependencyQuickFix.$$$reportNull$$$0(2);
        }
        return this.myRef.isValid() && MavenDomUtil.findContainingProject((PsiElement)file) != null && AddMavenDependencyQuickFix.looksLikeClassName(this.getReferenceText());
    }

    private static boolean looksLikeClassName(@Nullable String text) {
        if (text == null) {
            return false;
        }
        return CLASSNAME_PATTERN.matcher(text).matches();
    }

    public void invoke(final @NotNull Project project, Editor editor, final PsiFile file) throws IncorrectOperationException {
        if (project == null) {
            AddMavenDependencyQuickFix.$$$reportNull$$$0(3);
        }
        if (!this.myRef.isValid()) {
            return;
        }
        MavenProject mavenProject = MavenDomUtil.findContainingProject((PsiElement)file);
        if (mavenProject == null) {
            return;
        }
        final List<MavenId> ids = MavenArtifactSearchDialog.searchForClass(project, this.getReferenceText());
        if (ids.isEmpty()) {
            return;
        }
        final MavenDomProjectModel model = MavenDomUtil.getMavenDomProjectModel(project, mavenProject.getFile());
        if (model == null) {
            return;
        }
        new WriteCommandAction(project, "Add Maven Dependency", new PsiFile[]{DomUtil.getFile((DomElement)model)}){

            protected void run(@NotNull Result result) throws Throwable {
                if (result == null) {
                    1.$$$reportNull$$$0(0);
                }
                boolean isTestSource = false;
                VirtualFile virtualFile = file.getOriginalFile().getVirtualFile();
                if (virtualFile != null) {
                    isTestSource = ProjectRootManager.getInstance((Project)project).getFileIndex().isInTestSourceContent(virtualFile);
                }
                for (MavenId each : ids) {
                    MavenDomDependency dependency = MavenDomUtil.createDomDependency(model, null, each);
                    if (!isTestSource) continue;
                    dependency.getScope().setStringValue("test");
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "org/jetbrains/idea/maven/dom/intentions/AddMavenDependencyQuickFix$1", "run"));
            }
        }.execute();
    }

    public String getReferenceText() {
        PsiElement parent;
        PsiJavaCodeReferenceElement result = this.myRef;
        while ((parent = result.getParent()) instanceof PsiJavaCodeReferenceElement) {
            result = (PsiJavaCodeReferenceElement)parent;
        }
        return result.getQualifiedName();
    }

    public boolean startInWriteAction() {
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/maven/dom/intentions/AddMavenDependencyQuickFix";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/maven/dom/intentions/AddMavenDependencyQuickFix";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

