/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.importing;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.externalSystem.model.project.ProjectCoordinate;
import com.intellij.openapi.externalSystem.model.project.ProjectId;
import com.intellij.openapi.externalSystem.service.project.IdeModifiableModelsProvider;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.roots.DependencyScope;
import com.intellij.openapi.roots.JavadocOrderRootType;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryTable;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.java.LanguageLevel;
import gnu.trove.THashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.importing.MavenFoldersImporter;
import org.jetbrains.idea.maven.importing.MavenImporter;
import org.jetbrains.idea.maven.importing.MavenPomPathModuleService;
import org.jetbrains.idea.maven.importing.MavenRootModelAdapter;
import org.jetbrains.idea.maven.model.MavenArtifact;
import org.jetbrains.idea.maven.project.MavenImportingSettings;
import org.jetbrains.idea.maven.project.MavenProject;
import org.jetbrains.idea.maven.project.MavenProjectChanges;
import org.jetbrains.idea.maven.project.MavenProjectsManager;
import org.jetbrains.idea.maven.project.MavenProjectsProcessorTask;
import org.jetbrains.idea.maven.project.MavenProjectsTree;
import org.jetbrains.idea.maven.project.SupportedRequestType;
import org.jetbrains.idea.maven.utils.MavenUtil;

public class MavenModuleImporter {
    public static final String SUREFIRE_PLUGIN_LIBRARY_NAME = "maven-surefire-plugin urls";
    private static final Set<String> IMPORTED_CLASSIFIERS = ImmutableSet.of((Object)"client");
    private static final Map<String, LanguageLevel> MAVEN_IDEA_PLUGIN_LEVELS = ImmutableMap.of((Object)"JDK_1_3", (Object)LanguageLevel.JDK_1_3, (Object)"JDK_1_4", (Object)LanguageLevel.JDK_1_4, (Object)"JDK_1_5", (Object)LanguageLevel.JDK_1_5, (Object)"JDK_1_6", (Object)LanguageLevel.JDK_1_6, (Object)"JDK_1_7", (Object)LanguageLevel.JDK_1_7);
    private final Module myModule;
    private final MavenProjectsTree myMavenTree;
    private final MavenProject myMavenProject;
    @Nullable
    private final MavenProjectChanges myMavenProjectChanges;
    private final Map<MavenProject, String> myMavenProjectToModuleName;
    private final MavenImportingSettings mySettings;
    private final IdeModifiableModelsProvider myModifiableModelsProvider;
    private MavenRootModelAdapter myRootModelAdapter;

    public MavenModuleImporter(Module module, MavenProjectsTree mavenTree, MavenProject mavenProject, @Nullable MavenProjectChanges changes, Map<MavenProject, String> mavenProjectToModuleName, MavenImportingSettings settings, IdeModifiableModelsProvider modifiableModelsProvider) {
        this.myModule = module;
        this.myMavenTree = mavenTree;
        this.myMavenProject = mavenProject;
        this.myMavenProjectChanges = changes;
        this.myMavenProjectToModuleName = mavenProjectToModuleName;
        this.mySettings = settings;
        this.myModifiableModelsProvider = modifiableModelsProvider;
        VirtualFile pomFile = mavenProject.getFile();
        if (!FileUtil.namesEqual((String)"pom", (String)pomFile.getNameWithoutExtension())) {
            MavenPomPathModuleService.getInstance(module).setPomFileUrl(pomFile.getUrl());
        }
    }

    public ModifiableRootModel getRootModel() {
        return this.myRootModelAdapter.getRootModel();
    }

    public void config(boolean isNewlyCreatedModule) {
        this.myRootModelAdapter = new MavenRootModelAdapter(this.myMavenProject, this.myModule, this.myModifiableModelsProvider);
        this.myRootModelAdapter.init(isNewlyCreatedModule);
        this.configFolders();
        this.configDependencies();
        this.configLanguageLevel();
    }

    public void preConfigFacets() {
        MavenUtil.invokeAndWaitWriteAction(this.myModule.getProject(), () -> {
            if (this.myModule.isDisposed()) {
                return;
            }
            ModuleType moduleType = ModuleType.get((Module)this.myModule);
            for (MavenImporter importer : this.getSuitableImporters()) {
                MavenProjectChanges changes;
                if (this.myMavenProjectChanges == null) {
                    if (importer.processChangedModulesOnly()) continue;
                    changes = MavenProjectChanges.NONE;
                } else {
                    changes = this.myMavenProjectChanges;
                }
                if (importer.getModuleType() != moduleType) continue;
                importer.preProcess(this.myModule, this.myMavenProject, changes, this.myModifiableModelsProvider);
            }
        });
    }

    public void configFacets(List<MavenProjectsProcessorTask> postTasks) {
        MavenUtil.smartInvokeAndWait(this.myModule.getProject(), ModalityState.defaultModalityState(), () -> {
            if (this.myModule.isDisposed()) {
                return;
            }
            ModuleType moduleType = ModuleType.get((Module)this.myModule);
            ApplicationManager.getApplication().runWriteAction(() -> {
                for (MavenImporter importer : this.getSuitableImporters()) {
                    MavenProjectChanges changes;
                    if (this.myMavenProjectChanges == null) {
                        if (importer.processChangedModulesOnly()) continue;
                        changes = MavenProjectChanges.NONE;
                    } else {
                        changes = this.myMavenProjectChanges;
                    }
                    if (importer.getModuleType() != moduleType) continue;
                    importer.process(this.myModifiableModelsProvider, this.myModule, this.myRootModelAdapter, this.myMavenTree, this.myMavenProject, changes, this.myMavenProjectToModuleName, postTasks);
                }
            });
        });
    }

    public void postConfigFacets() {
        MavenUtil.invokeAndWaitWriteAction(this.myModule.getProject(), () -> {
            if (this.myModule.isDisposed()) {
                return;
            }
            ModuleType moduleType = ModuleType.get((Module)this.myModule);
            for (MavenImporter importer : this.getSuitableImporters()) {
                MavenProjectChanges changes;
                if (this.myMavenProjectChanges == null) {
                    if (importer.processChangedModulesOnly()) continue;
                    changes = MavenProjectChanges.NONE;
                } else {
                    changes = this.myMavenProjectChanges;
                }
                if (importer.getModuleType() != moduleType) continue;
                importer.postProcess(this.myModule, this.myMavenProject, changes, this.myModifiableModelsProvider);
            }
        });
    }

    private List<MavenImporter> getSuitableImporters() {
        return this.myMavenProject.getSuitableImporters();
    }

    private void configFolders() {
        new MavenFoldersImporter(this.myMavenProject, this.mySettings, this.myRootModelAdapter).config();
    }

    private void configDependencies() {
        THashSet dependencyTypesFromSettings = new THashSet();
        if (!((Boolean)ReadAction.compute(() -> {
            if (this.myModule.getProject().isDisposed()) {
                return false;
            }
            dependencyTypesFromSettings.addAll(MavenProjectsManager.getInstance(this.myModule.getProject()).getImportingSettings().getDependencyTypesAsSet());
            return true;
        })).booleanValue()) {
            return;
        }
        for (MavenArtifact artifact : this.myMavenProject.getDependencies()) {
            String dependencyType = artifact.getType();
            if (!dependencyTypesFromSettings.contains((Object)dependencyType) && !this.myMavenProject.getDependencyTypesFromImporters(SupportedRequestType.FOR_IMPORT).contains(dependencyType)) continue;
            DependencyScope scope = MavenModuleImporter.selectScope(artifact.getScope());
            MavenProject depProject = this.myMavenTree.findProject(artifact.getMavenId());
            if (depProject != null) {
                if (depProject == this.myMavenProject) continue;
                String moduleName = this.myMavenProjectToModuleName.get(depProject);
                if (moduleName == null || this.myMavenTree.isIgnored(depProject)) {
                    MavenArtifact projectsArtifactInRepository = new MavenArtifact(artifact.getGroupId(), artifact.getArtifactId(), artifact.getVersion(), artifact.getBaseVersion(), dependencyType, artifact.getClassifier(), artifact.getScope(), artifact.isOptional(), artifact.getExtension(), null, this.myMavenProject.getLocalRepository(), false, false);
                    this.myRootModelAdapter.addLibraryDependency(projectsArtifactInRepository, scope, this.myModifiableModelsProvider, this.myMavenProject);
                    continue;
                }
                boolean isTestJar = "test-jar".equals(dependencyType) || "tests".equals(artifact.getClassifier());
                this.myRootModelAdapter.addModuleDependency(moduleName, scope, isTestJar);
                Element buildHelperCfg = depProject.getPluginGoalConfiguration("org.codehaus.mojo", "build-helper-maven-plugin", "attach-artifact");
                if (buildHelperCfg != null) {
                    this.addAttachArtifactDependency(buildHelperCfg, scope, depProject, artifact);
                }
                if (!IMPORTED_CLASSIFIERS.contains(artifact.getClassifier()) || isTestJar || "system".equals(artifact.getScope()) || "false".equals(System.getProperty("idea.maven.classifier.dep"))) continue;
                MavenArtifact a = new MavenArtifact(artifact.getGroupId(), artifact.getArtifactId(), artifact.getVersion(), artifact.getBaseVersion(), dependencyType, artifact.getClassifier(), artifact.getScope(), artifact.isOptional(), artifact.getExtension(), null, this.myMavenProject.getLocalRepository(), false, false);
                this.myRootModelAdapter.addLibraryDependency(a, scope, this.myModifiableModelsProvider, this.myMavenProject);
                continue;
            }
            if ("system".equals(artifact.getScope())) {
                this.myRootModelAdapter.addSystemDependency(artifact, scope);
                continue;
            }
            if ("bundle".equals(dependencyType)) {
                artifact = new MavenArtifact(artifact.getGroupId(), artifact.getArtifactId(), artifact.getVersion(), artifact.getBaseVersion(), "jar", artifact.getClassifier(), artifact.getScope(), artifact.isOptional(), "jar", null, this.myMavenProject.getLocalRepository(), false, false);
            }
            LibraryOrderEntry libraryOrderEntry = this.myRootModelAdapter.addLibraryDependency(artifact, scope, this.myModifiableModelsProvider, this.myMavenProject);
            this.myModifiableModelsProvider.trySubstitute(this.myModule, libraryOrderEntry, (ProjectCoordinate)new ProjectId(artifact.getGroupId(), artifact.getArtifactId(), artifact.getVersion()));
        }
        this.configSurefirePlugin();
    }

    private void configSurefirePlugin() {
        LibraryTable moduleLibraryTable = this.myRootModelAdapter.getRootModel().getModuleLibraryTable();
        Library library = moduleLibraryTable.getLibraryByName(SUREFIRE_PLUGIN_LIBRARY_NAME);
        if (library != null) {
            moduleLibraryTable.removeLibrary(library);
        }
    }

    private void addAttachArtifactDependency(@NotNull Element buildHelperCfg, @NotNull DependencyScope scope, @NotNull MavenProject mavenProject, @NotNull MavenArtifact artifact) {
        if (buildHelperCfg == null) {
            MavenModuleImporter.$$$reportNull$$$0(0);
        }
        if (scope == null) {
            MavenModuleImporter.$$$reportNull$$$0(1);
        }
        if (mavenProject == null) {
            MavenModuleImporter.$$$reportNull$$$0(2);
        }
        if (artifact == null) {
            MavenModuleImporter.$$$reportNull$$$0(3);
        }
        Library.ModifiableModel libraryModel = null;
        for (Element artifactsElement : buildHelperCfg.getChildren("artifacts")) {
            for (Element artifactElement : artifactsElement.getChildren("artifact")) {
                VirtualFile file;
                String filePath;
                String typeString = artifactElement.getChildTextTrim("type");
                if (typeString != null && !typeString.equals("jar")) continue;
                OrderRootType rootType = OrderRootType.CLASSES;
                String classifier = artifactElement.getChildTextTrim("classifier");
                if ("sources".equals(classifier)) {
                    rootType = OrderRootType.SOURCES;
                } else if ("javadoc".equals(classifier)) {
                    rootType = JavadocOrderRootType.getInstance();
                }
                if (StringUtil.isEmpty((String)(filePath = artifactElement.getChildTextTrim("file"))) || (file = VfsUtil.findRelativeFile((String)filePath, (VirtualFile)mavenProject.getDirectoryFile())) == null || (file = JarFileSystem.getInstance().getJarRootForLocalFile(file)) == null) continue;
                if (libraryModel == null) {
                    String libraryName = MavenModuleImporter.getAttachedJarsLibName(artifact);
                    Library library = this.myModifiableModelsProvider.getLibraryByName(libraryName);
                    if (library == null) {
                        library = this.myModifiableModelsProvider.createLibrary(libraryName, MavenRootModelAdapter.getMavenExternalSource());
                    }
                    libraryModel = this.myModifiableModelsProvider.getModifiableLibraryModel(library);
                    LibraryOrderEntry entry = this.myRootModelAdapter.getRootModel().addLibraryEntry(library);
                    entry.setScope(scope);
                }
                libraryModel.addRoot(file, rootType);
            }
        }
    }

    @NotNull
    public static String getAttachedJarsLibName(@NotNull MavenArtifact artifact) {
        if (artifact == null) {
            MavenModuleImporter.$$$reportNull$$$0(4);
        }
        String libraryName = artifact.getLibraryName();
        assert (libraryName.startsWith("Maven: "));
        String string = libraryName = "Maven: ATTACHED-JAR: " + libraryName.substring("Maven: ".length());
        if (string == null) {
            MavenModuleImporter.$$$reportNull$$$0(5);
        }
        return string;
    }

    @NotNull
    public static DependencyScope selectScope(String mavenScope) {
        if ("runtime".equals(mavenScope)) {
            DependencyScope dependencyScope = DependencyScope.RUNTIME;
            if (dependencyScope == null) {
                MavenModuleImporter.$$$reportNull$$$0(6);
            }
            return dependencyScope;
        }
        if ("test".equals(mavenScope)) {
            DependencyScope dependencyScope = DependencyScope.TEST;
            if (dependencyScope == null) {
                MavenModuleImporter.$$$reportNull$$$0(7);
            }
            return dependencyScope;
        }
        if ("provided".equals(mavenScope)) {
            DependencyScope dependencyScope = DependencyScope.PROVIDED;
            if (dependencyScope == null) {
                MavenModuleImporter.$$$reportNull$$$0(8);
            }
            return dependencyScope;
        }
        DependencyScope dependencyScope = DependencyScope.COMPILE;
        if (dependencyScope == null) {
            MavenModuleImporter.$$$reportNull$$$0(9);
        }
        return dependencyScope;
    }

    private void configLanguageLevel() {
        String mavenProjectSourceLevel;
        if ("false".equalsIgnoreCase(System.getProperty("idea.maven.configure.language.level"))) {
            return;
        }
        LanguageLevel level = null;
        Element cfg = this.myMavenProject.getPluginConfiguration("com.googlecode", "maven-idea-plugin");
        if (cfg != null) {
            level = MAVEN_IDEA_PLUGIN_LEVELS.get(cfg.getChildTextTrim("jdkLevel"));
        }
        if (level == null && (level = LanguageLevel.parse((String)(mavenProjectSourceLevel = this.myMavenProject.getSourceLevel()))) == null && StringUtil.isNotEmpty((String)mavenProjectSourceLevel)) {
            level = LanguageLevel.JDK_X;
        }
        if (level == null) {
            level = LanguageLevel.JDK_1_5;
        }
        this.myRootModelAdapter.setLanguageLevel(level);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buildHelperCfg";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mavenProject";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "artifact";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/maven/importing/MavenModuleImporter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/maven/importing/MavenModuleImporter";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getAttachedJarsLibName";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "selectScope";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "addAttachArtifactDependency";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getAttachedJarsLibName";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

