/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.gwt.inspections;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.gwt.GwtBundle;
import com.intellij.gwt.i18n.GwtI18nManager;
import com.intellij.gwt.i18n.GwtI18nUtil;
import com.intellij.gwt.inspections.BaseGwtInspection;
import com.intellij.gwt.inspections.BaseGwtLocalQuickFix;
import com.intellij.lang.properties.IProperty;
import com.intellij.lang.properties.psi.PropertiesFile;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiReferenceList;
import com.intellij.util.IncorrectOperationException;
import java.util.ArrayList;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GwtMethodWithParametersInConstantsInterfaceInspection
extends BaseGwtInspection {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.gwt.inspections.GwtMethodWithParametersInConstantsInterfaceInspection");

    @Nls
    @NotNull
    public String getDisplayName() {
        String string = GwtBundle.message("inspection.name.method.with.parameters.in.interface.extending.constants", new Object[0]);
        if (string == null) {
            GwtMethodWithParametersInConstantsInterfaceInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NonNls
    @NotNull
    public String getShortName() {
        if ("GwtMethodWithParametersInConstantsInterface" == null) {
            GwtMethodWithParametersInConstantsInterfaceInspection.$$$reportNull$$$0(1);
        }
        return "GwtMethodWithParametersInConstantsInterface";
    }

    @Nullable
    public ProblemDescriptor[] checkClass(@NotNull PsiClass aClass, @NotNull InspectionManager manager, boolean isOnTheFly) {
        if (aClass == null) {
            GwtMethodWithParametersInConstantsInterfaceInspection.$$$reportNull$$$0(2);
        }
        if (manager == null) {
            GwtMethodWithParametersInConstantsInterfaceInspection.$$$reportNull$$$0(3);
        }
        if (!GwtMethodWithParametersInConstantsInterfaceInspection.shouldCheck((PsiElement)aClass)) {
            return null;
        }
        GwtI18nManager i18nManager = GwtI18nManager.getInstance(manager.getProject());
        PropertiesFile[] files = i18nManager.getPropertiesFiles(aClass);
        if (files.length == 0 || !i18nManager.isConstantsInterface(aClass)) {
            return null;
        }
        PsiJavaCodeReferenceElement extendsConstantsElement = GwtMethodWithParametersInConstantsInterfaceInspection.findExtendsConstantsElement(aClass);
        ArrayList<ProblemDescriptor> problems = new ArrayList<ProblemDescriptor>();
        for (PsiMethod psiMethod : aClass.getMethods()) {
            if (psiMethod.getParameterList().getParametersCount() <= 0) continue;
            ReplaceConstantsByMessagesInExtendsListQuickFix quickFix = null;
            if (extendsConstantsElement != null) {
                quickFix = new ReplaceConstantsByMessagesInExtendsListQuickFix(aClass, extendsConstantsElement);
            }
            problems.add(manager.createProblemDescriptor(GwtMethodWithParametersInConstantsInterfaceInspection.getElementToHighlight(psiMethod), GwtBundle.message("problem.description.methods.with.parameters.are.not.allowed.in.an.interface.extending.constants", new Object[0]), (LocalQuickFix)quickFix, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, isOnTheFly));
        }
        return problems.toArray(ProblemDescriptor.EMPTY_ARRAY);
    }

    public ProblemDescriptor[] checkFile(@NotNull PsiFile file, @NotNull InspectionManager manager, boolean isOnTheFly) {
        if (file == null) {
            GwtMethodWithParametersInConstantsInterfaceInspection.$$$reportNull$$$0(4);
        }
        if (manager == null) {
            GwtMethodWithParametersInConstantsInterfaceInspection.$$$reportNull$$$0(5);
        }
        if (!GwtMethodWithParametersInConstantsInterfaceInspection.shouldCheck((PsiElement)file) || !(file instanceof PropertiesFile)) {
            return null;
        }
        PropertiesFile propertiesFile = (PropertiesFile)file;
        GwtI18nManager i18nManager = GwtI18nManager.getInstance(manager.getProject());
        PsiClass propertiesInterface = i18nManager.getPropertiesInterface(propertiesFile);
        if (propertiesInterface == null || !i18nManager.isConstantsInterface(propertiesInterface)) {
            return null;
        }
        ArrayList<ProblemDescriptor> problems = new ArrayList<ProblemDescriptor>();
        PsiJavaCodeReferenceElement extendsConstantsElement = GwtMethodWithParametersInConstantsInterfaceInspection.findExtendsConstantsElement(propertiesInterface);
        for (IProperty property : propertiesFile.getProperties()) {
            if (GwtI18nUtil.getParametersCount(property.getValue()) <= 0) continue;
            ReplaceConstantsByMessagesInExtendsListQuickFix quickFix = null;
            if (extendsConstantsElement != null) {
                quickFix = new ReplaceConstantsByMessagesInExtendsListQuickFix(propertiesInterface, extendsConstantsElement);
            }
            String message = GwtBundle.message("problem.description.properties.with.parameters.are.not.allowed.if.the.associated.interface.extends.constants", new Object[0]);
            problems.add(manager.createProblemDescriptor(property.getPsiElement(), message, (LocalQuickFix)quickFix, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, isOnTheFly));
        }
        return problems.toArray(ProblemDescriptor.EMPTY_ARRAY);
    }

    @Nullable
    private static PsiJavaCodeReferenceElement findExtendsConstantsElement(PsiClass aClass) {
        PsiJavaCodeReferenceElement extendsConstantsElement = null;
        PsiReferenceList list = aClass.getExtendsList();
        if (list != null) {
            for (PsiJavaCodeReferenceElement element : list.getReferenceElements()) {
                PsiElement anInterface = element.resolve();
                if (!(anInterface instanceof PsiClass) || !"com.google.gwt.i18n.client.Constants".equals(((PsiClass)anInterface).getQualifiedName())) continue;
                extendsConstantsElement = element;
                break;
            }
        }
        return extendsConstantsElement;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/gwt/inspections/GwtMethodWithParametersInConstantsInterfaceInspection";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getShortName";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/gwt/inspections/GwtMethodWithParametersInConstantsInterfaceInspection";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "checkClass";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "checkFile";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class ReplaceConstantsByMessagesInExtendsListQuickFix
    extends BaseGwtLocalQuickFix {
        private static final String FAMILY_NAME = GwtBundle.message("quickfix.family.name.inherit.from.messages.instead.of.constants", new Object[0]);
        private final PsiClass myInterface;
        private final PsiJavaCodeReferenceElement myExtendsConstantsElement;

        private ReplaceConstantsByMessagesInExtendsListQuickFix(PsiClass anInterface, PsiJavaCodeReferenceElement extendsConstantsElement) {
            super(GwtBundle.message("quickfix.name.inherit.0.from.messages.instead.of.constants", anInterface.getName()));
            this.myInterface = anInterface;
            this.myExtendsConstantsElement = extendsConstantsElement;
        }

        @Override
        @Nls
        @NotNull
        public String getFamilyName() {
            String string = FAMILY_NAME;
            if (string == null) {
                ReplaceConstantsByMessagesInExtendsListQuickFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            if (project == null) {
                ReplaceConstantsByMessagesInExtendsListQuickFix.$$$reportNull$$$0(1);
            }
            if (descriptor == null) {
                ReplaceConstantsByMessagesInExtendsListQuickFix.$$$reportNull$$$0(2);
            }
            if (!FileModificationService.getInstance().preparePsiElementForWrite((PsiElement)this.myInterface.getContainingFile())) {
                return;
            }
            try {
                this.myExtendsConstantsElement.delete();
                PsiElementFactory factory = JavaPsiFacade.getInstance((Project)this.myInterface.getProject()).getElementFactory();
                PsiClassType messagesType = factory.createTypeByFQClassName("com.google.gwt.i18n.client.Messages", this.myInterface.getResolveScope());
                PsiReferenceList extendsList = this.myInterface.getExtendsList();
                LOG.assertTrue(extendsList != null);
                extendsList.add((PsiElement)factory.createReferenceElementByType(messagesType));
            }
            catch (IncorrectOperationException e) {
                LOG.error((Throwable)e);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/gwt/inspections/GwtMethodWithParametersInConstantsInterfaceInspection$ReplaceConstantsByMessagesInExtendsListQuickFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/gwt/inspections/GwtMethodWithParametersInConstantsInterfaceInspection$ReplaceConstantsByMessagesInExtendsListQuickFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

