/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.gwt.uiBinder;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.gwt.uiBinder.CreateSetterQuickFix;
import com.intellij.gwt.uiBinder.GwtUiChildElementDescriptor;
import com.intellij.gwt.uiBinder.GwtUiComponentsNSDescriptor;
import com.intellij.gwt.uiBinder.GwtUiParameterAttributeDescriptor;
import com.intellij.gwt.uiBinder.GwtUiPropertyAttributeDescriptor;
import com.intellij.gwt.uiBinder.GwtXmlElementDescriptorBase;
import com.intellij.gwt.uiBinder.UiBinderUtil;
import com.intellij.gwt.uiBinder.mapping.UiBinderMappingService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PropertyUtilBase;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.SmartList;
import com.intellij.xml.XmlAttributeDescriptor;
import com.intellij.xml.XmlElementDescriptor;
import com.intellij.xml.XmlNSDescriptor;
import com.intellij.xml.impl.schema.AnyXmlAttributeDescriptor;
import com.intellij.xml.impl.schema.AnyXmlElementDescriptor;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GwtUiComponentDescriptor
extends GwtXmlElementDescriptorBase {
    private static final Key<CachedValue<Pair<Boolean, Map<String, XmlAttributeDescriptor>>>> GWT_UI_TAG_ADDITIONAL_ATTRIBUTES_KEY = Key.create((String)"GWT_UI_TAG_ADDITIONAL_ATTRIBUTES");
    private static final Set<String> IGNORED_PROPERTIES = Collections.singleton("HTML");
    private static final String[] ADDITIONAL_ATTRIBUTES = new String[]{"addStyleNames", "addStyleDependentNames", "debugId"};
    private final PsiClass myClass;
    private final String myNamespacePackage;
    private Map<String, XmlAttributeDescriptor> myAttributesMap;
    private XmlAttributeDescriptor[] myAttributes;
    private GwtUiChildElementDescriptor[] myElementDescriptors;

    public GwtUiComponentDescriptor(@NotNull PsiClass aClass, @NotNull GwtUiComponentsNSDescriptor xmlNSDescriptor, @NotNull String namespacePackage, @NotNull String namespacePrefix) {
        if (aClass == null) {
            GwtUiComponentDescriptor.$$$reportNull$$$0(0);
        }
        if (xmlNSDescriptor == null) {
            GwtUiComponentDescriptor.$$$reportNull$$$0(1);
        }
        if (namespacePackage == null) {
            GwtUiComponentDescriptor.$$$reportNull$$$0(2);
        }
        if (namespacePrefix == null) {
            GwtUiComponentDescriptor.$$$reportNull$$$0(3);
        }
        super(xmlNSDescriptor, namespacePrefix);
        this.myClass = aClass;
        this.myNamespacePackage = namespacePackage;
    }

    public PsiNamedElement getDeclaration() {
        return this.myClass;
    }

    public String getDefaultName() {
        String qualifiedName = this.myClass.getQualifiedName();
        if (qualifiedName != null && qualifiedName.startsWith(this.myNamespacePackage)) {
            return this.myNamespacePrefix + ":" + qualifiedName.substring(this.myNamespacePackage.length() + 1);
        }
        return this.myNamespacePrefix + ":";
    }

    public GwtUiChildElementDescriptor[] getElementsDescriptors(XmlTag context) {
        if (this.myElementDescriptors == null) {
            SmartList uiChildDescriptors = new SmartList();
            for (PsiMethod method : this.myClass.getAllMethods()) {
                PsiAnnotation annotation = method.getModifierList().findAnnotation("com.google.gwt.uibinder.client.UiChild");
                if (annotation == null) continue;
                uiChildDescriptors.add(new GwtUiChildElementDescriptor(this.myXmlNSDescriptor, this.myNamespacePrefix, method, annotation));
            }
            this.myElementDescriptors = uiChildDescriptors.isEmpty() ? GwtUiChildElementDescriptor.EMPTY_ARRAY : uiChildDescriptors.toArray(GwtUiChildElementDescriptor.EMPTY_ARRAY);
        }
        return this.myElementDescriptors;
    }

    public XmlElementDescriptor[] getComponentDescriptors(XmlTag context) {
        return this.myXmlNSDescriptor.getComponentDescriptors(context);
    }

    public XmlElementDescriptor getElementDescriptor(XmlTag childTag, XmlTag contextTag) {
        for (GwtUiChildElementDescriptor descriptor : this.getElementsDescriptors(contextTag)) {
            if (!descriptor.getTagName().equals(childTag.getLocalName())) continue;
            return descriptor;
        }
        return new AnyXmlElementDescriptor((XmlElementDescriptor)this, (XmlNSDescriptor)this.myXmlNSDescriptor);
    }

    public XmlAttributeDescriptor[] getAttributesDescriptors(@Nullable XmlTag context) {
        this.loadAttributes(context);
        Map additionalAttributes = (Map)this.getAdditionalAttributes(context).getSecond();
        if (!additionalAttributes.isEmpty()) {
            XmlAttributeDescriptor[] result = new XmlAttributeDescriptor[this.myAttributes.length + additionalAttributes.size()];
            System.arraycopy(this.myAttributes, 0, result, 0, this.myAttributes.length);
            int i = this.myAttributes.length;
            for (XmlAttributeDescriptor descriptor : additionalAttributes.values()) {
                result[i++] = descriptor;
            }
            return result;
        }
        return this.myAttributes;
    }

    public XmlAttributeDescriptor getAttributeDescriptor(@NonNls String attributeName, @Nullable XmlTag context) {
        XmlAttributeDescriptor descriptor = (XmlAttributeDescriptor)((Map)this.getAdditionalAttributes(context).getSecond()).get(attributeName);
        if (descriptor != null) {
            return descriptor;
        }
        this.loadAttributes(context);
        return this.myAttributesMap.get(attributeName);
    }

    private Pair<Boolean, Map<String, XmlAttributeDescriptor>> getAdditionalAttributes(XmlTag context) {
        if (context == null) {
            return Pair.pair((Object)true, Collections.emptyMap());
        }
        CachedValue cachedValue = (CachedValue)context.getUserData(GWT_UI_TAG_ADDITIONAL_ATTRIBUTES_KEY);
        if (cachedValue == null) {
            cachedValue = CachedValuesManager.getManager((Project)this.myClass.getProject()).createCachedValue(() -> {
                XmlFile xmlFile;
                PsiFile file = context.getContainingFile().getOriginalFile();
                if (file instanceof XmlFile && UiBinderUtil.isUiXmlFile(xmlFile = (XmlFile)file)) {
                    List<PsiClass> uiClasses = UiBinderMappingService.getBoundClassesForFile((PsiFile)xmlFile);
                    boolean uiConstructorParametersRequired = uiClasses.isEmpty();
                    HashMap<String, GwtUiParameterAttributeDescriptor> result = new HashMap<String, GwtUiParameterAttributeDescriptor>();
                    for (PsiClass uiClass : uiClasses) {
                        PsiMethod factoryMethod = this.findUiFactoryMethod(uiClass);
                        if (factoryMethod != null) {
                            for (PsiParameter parameter : factoryMethod.getParameterList().getParameters()) {
                                result.put(parameter.getName(), new GwtUiParameterAttributeDescriptor(parameter, true));
                            }
                            continue;
                        }
                        uiConstructorParametersRequired = true;
                    }
                    return CachedValueProvider.Result.create((Object)Pair.pair((Object)uiConstructorParametersRequired, result), (Object[])new Object[]{PsiModificationTracker.OUT_OF_CODE_BLOCK_MODIFICATION_COUNT});
                }
                return CachedValueProvider.Result.create((Object)Pair.pair((Object)true, Collections.emptyMap()), (Object[])new Object[]{PsiModificationTracker.JAVA_STRUCTURE_MODIFICATION_COUNT});
            }, false);
            context.putUserData(GWT_UI_TAG_ADDITIONAL_ATTRIBUTES_KEY, (Object)cachedValue);
        }
        return (Pair)cachedValue.getValue();
    }

    @Nullable
    private PsiMethod findUiFactoryMethod(@Nullable PsiClass uiClass) {
        if (uiClass == null) {
            return null;
        }
        for (PsiMethod psiMethod : uiClass.getMethods()) {
            PsiType returnType;
            if (psiMethod.getModifierList().findAnnotation("com.google.gwt.uibinder.client.UiFactory") == null || (returnType = psiMethod.getReturnType()) == null || !returnType.getCanonicalText().equals(this.myClass.getQualifiedName())) continue;
            return psiMethod;
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private void loadAttributes(@Nullable XmlTag context) {
        String[] uiPrefix;
        if (this.myAttributesMap != null && this.myAttributes != null) {
            return;
        }
        HashMap<String, XmlAttributeDescriptor> attributesMap = new HashMap<String, XmlAttributeDescriptor>();
        if (context != null && (uiPrefix = context.getPrefixByNamespace("urn:ui:com.google.gwt.uibinder")) != null) {
            String qualifiedName = (String)uiPrefix + ":" + "field";
            attributesMap.put(qualifiedName, (XmlAttributeDescriptor)new AnyXmlAttributeDescriptor(qualifiedName));
        }
        if (InheritanceUtil.isInheritor((PsiClass)this.myClass, (boolean)true, (String)"com.google.gwt.user.client.ui.IsWidget")) {
            for (String string : ADDITIONAL_ATTRIBUTES) {
                attributesMap.put(string, (XmlAttributeDescriptor)new AnyXmlAttributeDescriptor(string));
            }
        }
        for (String string : this.myClass.getAllMethods()) {
            PsiParameter[] parameters;
            String propertyName;
            if (!GwtUiComponentDescriptor.canBePropertySetter((PsiMethod)string) || (propertyName = GwtUiComponentDescriptor.getPropertyName((PsiMethod)string)) == null || IGNORED_PROPERTIES.contains(propertyName) || (parameters = string.getParameterList().getParameters()).length == 0) continue;
            PsiType type = parameters.length == 1 ? parameters[0].getType() : null;
            attributesMap.put(propertyName, (XmlAttributeDescriptor)new GwtUiPropertyAttributeDescriptor((PsiMethod)string, type, propertyName));
            if (!Character.isUpperCase(propertyName.charAt(0))) continue;
            propertyName = GwtUiComponentDescriptor.decapitalizeFirstChar(propertyName);
            attributesMap.put(propertyName, (XmlAttributeDescriptor)new GwtUiPropertyAttributeDescriptor((PsiMethod)string, type, propertyName));
        }
        boolean uiConstructorParametersRequired = (Boolean)this.getAdditionalAttributes(context).getFirst();
        if (uiConstructorParametersRequired) {
            void var6_15;
            PsiMethod[] qualifiedName = this.myClass.getConstructors();
            int n = qualifiedName.length;
            boolean bl = false;
            while (var6_15 < n) {
                PsiMethod constructor = qualifiedName[var6_15];
                if (constructor.getModifierList().findAnnotation("com.google.gwt.uibinder.client.UiConstructor") != null) {
                    for (PsiParameter parameter : constructor.getParameterList().getParameters()) {
                        attributesMap.put(parameter.getName(), (XmlAttributeDescriptor)new GwtUiParameterAttributeDescriptor(parameter, true));
                    }
                }
                ++var6_15;
            }
        }
        Collection attributesSet = attributesMap.values();
        this.myAttributes = attributesSet.toArray(XmlAttributeDescriptor.EMPTY);
        this.myAttributesMap = attributesMap;
    }

    @Nullable
    private static String getPropertyName(@NotNull PsiMethod method) {
        String methodName;
        if (method == null) {
            GwtUiComponentDescriptor.$$$reportNull$$$0(4);
        }
        if (!(methodName = method.getName()).startsWith("set")) {
            return null;
        }
        String propertyName = methodName.substring(3);
        if (propertyName.isEmpty() || Character.isLowerCase(propertyName.charAt(0))) {
            return null;
        }
        return StringUtil.decapitalize((String)propertyName);
    }

    private static String decapitalizeFirstChar(@NotNull String propertyName) {
        if (propertyName == null) {
            GwtUiComponentDescriptor.$$$reportNull$$$0(5);
        }
        char[] chars = propertyName.toCharArray();
        chars[0] = Character.toLowerCase(chars[0]);
        return new String(chars);
    }

    private static boolean canBePropertySetter(@NotNull PsiMethod method) {
        if (method == null) {
            GwtUiComponentDescriptor.$$$reportNull$$$0(6);
        }
        return !method.hasModifierProperty("static") && method.hasModifierProperty("public") && !method.isConstructor() && PsiType.VOID.equals((Object)method.getReturnType());
    }

    @Nullable
    public IntentionAction getCreateSetterQuickFix(XmlAttribute attribute) {
        String propertyName = attribute.getLocalName();
        String setterName = PropertyUtilBase.suggestSetterName((String)propertyName);
        if (this.myClass.findMethodsByName(setterName, true).length > 0) {
            return null;
        }
        return new CreateSetterQuickFix(this.myClass, setterName, propertyName);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "xmlNSDescriptor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "namespacePackage";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "namespacePrefix";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "propertyName";
                break;
            }
        }
        objectArray2[1] = "com/intellij/gwt/uiBinder/GwtUiComponentDescriptor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "getPropertyName";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "decapitalizeFirstChar";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "canBePropertySetter";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

