/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jsf.highlighting;

import com.intellij.javaee.web.WebUtil;
import com.intellij.javaee.web.facet.WebFacet;
import com.intellij.jsf.model.xml.FacesConfig;
import com.intellij.jsf.model.xml.FacesDomModel;
import com.intellij.jsf.model.xml.FacesDomModelManager;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.util.xml.ExtendClass;
import com.intellij.util.xml.GenericDomValue;
import java.util.List;

public class FacesHighlightingUtil {
    private FacesHighlightingUtil() {
    }

    public static boolean hasCustomViewHandler(PsiElement psiElement) {
        WebFacet webFacet = WebUtil.getWebFacet((PsiElement)psiElement);
        if (webFacet != null) {
            Project project = webFacet.getModule().getProject();
            List<FacesDomModel> models = FacesDomModelManager.getInstance(project).getAllModels(webFacet);
            for (FacesDomModel facesDomModel : models) {
                FacesConfig facesConfig = facesDomModel.getFacesConfig();
                GenericDomValue<PsiClass> viewHandler = facesConfig.getApplication().getViewHandler();
                ExtendClass extend = (ExtendClass)viewHandler.getAnnotation(ExtendClass.class);
                if (extend == null || viewHandler.getStringValue() == null) continue;
                return !viewHandler.getStringValue().equals(extend.value());
            }
        }
        return false;
    }
}

