/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jsf.highlighting.xml;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.jsf.highlighting.xml.ManagedBeanBaseInspection;
import com.intellij.jsf.model.xml.FacesConfig;
import com.intellij.jsf.model.xml.managedBeans.ManagedBean;
import com.intellij.jsf.model.xml.managedBeans.ManagedProperty;
import com.intellij.jsf.model.xml.managedBeans.PropertyBean;
import com.intellij.jsf.model.xml.managedBeans.propertyValue.ValuableProperty;
import com.intellij.jsf.resources.FacesInspectionsBundle;
import com.intellij.psi.PsiType;
import com.intellij.psi.impl.beanProperties.BeanProperty;
import com.intellij.util.xml.highlighting.DomElementAnnotationHolder;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class JsfManagedBeansInconsistencyInspection
extends ManagedBeanBaseInspection {
    @Override
    protected void checkManagedBean(ManagedBean managedBean, FacesConfig facesConfig, DomElementAnnotationHolder holder) {
        if (managedBean instanceof PropertyBean) {
            for (ManagedProperty managedProperty : ((PropertyBean)managedBean).getManagedProperties()) {
                JsfManagedBeansInconsistencyInspection.checkManagedProperties((PropertyBean)managedBean, managedProperty, holder);
            }
        }
    }

    private static void checkManagedProperties(PropertyBean bean, ManagedProperty property, DomElementAnnotationHolder holder) {
        if (property instanceof ValuableProperty) {
            JsfManagedBeansInconsistencyInspection.checkManagedPropertyClass(bean, (ValuableProperty)property, holder);
        }
    }

    private static void checkManagedPropertyClass(PropertyBean bean, ValuableProperty property, DomElementAnnotationHolder holder) {
        PsiType propertyType;
        PsiType type;
        Set beanProperty = (Set)property.getPropertyName().getValue();
        if (beanProperty != null && beanProperty.size() == 1 && (type = (PsiType)property.getPropertyClass().getValue()) != null && !(propertyType = ((BeanProperty)beanProperty.iterator().next()).getPropertyType()).isAssignableFrom(type)) {
            holder.createProblem(property.getPropertyName(), FacesInspectionsBundle.message("JsfManagedBeansInconsistencyInspection.incorrect.property.type", type.getPresentableText()), new LocalQuickFix[0]);
        }
    }

    @NotNull
    public String getDisplayName() {
        String string = FacesInspectionsBundle.message("JsfManagedBeansInconsistencyInspection.name", new Object[0]);
        if (string == null) {
            JsfManagedBeansInconsistencyInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    @NonNls
    public String getShortName() {
        if ("JsfManagedBeansInconsistencyInspection" == null) {
            JsfManagedBeansInconsistencyInspection.$$$reportNull$$$0(1);
        }
        return "JsfManagedBeansInconsistencyInspection";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/jsf/highlighting/xml/JsfManagedBeansInconsistencyInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getShortName";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

